/*
 * VecToArray.java
 *
 * Created on July 10, 2003, 11:04 AM
 * @author  wliang
 * @version
 */

package org.tigr.midas.util;

import java.io.*;
import java.util.*;
import java.math.*;
import java.lang.*;
import org.tigr.midas.util.*;
import org.tigr.midas.util.mevFileParser.*;

public class VecToArray {
    
    
    public static float[] toFloat(Vector v){
        float[] d = new float[v.size()];
        for (int i = 0; i < v.size(); i++){
            try{
                d[i] = Float.parseFloat(v.elementAt(i).toString());
            }catch(NumberFormatException ex){
                System.out.println("******* " + (i+1) + "th element in the vector is an invalid float number ********");
                ex.printStackTrace();
                break;
            }
        }
        return d;
    }
    
    public static String[] toString(Vector v){
        String[] s = new String[v.size()];
        for (int i = 0; i < v.size(); i++){
            s[i] = v.elementAt(i).toString();
        }
        return s;
    }
    
    public static int[] toInt(Vector v){
        int[] n = new int[v.size()];
        for (int i = 0; i < v.size(); i++){
            try{
                n[i] = Integer.parseInt(v.elementAt(i).toString());
            }catch(NumberFormatException ex){
                System.out.println("******* " + (i+1) + "th element in the vector is an invalid integer number ********");
                ex.printStackTrace();
                break;
            }
        }
        return n;
    }
    
    public static void main(String args[]) {
        MevFileParser mfp = new MevFileParser();
        File thisFile = new File("C:\\DataFiles0\\mev\\cortex.mev");
        try{
            if (MevFileParser.validate(thisFile) == MevFileParser.MEV_FILE){
                mfp.loadFile(thisFile);
                Vector aVec = mfp.getColumnNamed("IA");
                Vector bVec = mfp.getColumnNamed("IB");
                float[] a = VecToArray.toFloat(aVec);
                float[] b = VecToArray.toFloat(bVec);
                logger.log("**** a.length = " + a.length + ", b.length = " + b.length);
                for (int i = 0; i < 20; i++){
                    logger.log(" i = " + i + ", a = " + a[i] + ", b = " + b[i]);
                }
            }else{
                logger.log("Invalid MEV file!");
            }
        }catch(FieldNotFoundException ex){
            logger.log("Field not found!");
        }
    }
    
}
