/*
/*
 * Copyright @ 2001-2003, The Institute for Genomic Research (TIGR).
 * All rights reserved.
 *
 * LogRatioToCy.java
 *
 * Created on August 27, 2002, 5:38 PM
 * @author  wliang
 * @version 
 */

package org.tigr.midas.util;

import java.io.*;
import java.util.*;
import java.math.*;
import java.lang.*;
import org.tigr.midas.math.*;
import org.tigr.midas.util.*;

public class LogRatioToCy {

    private float[] cy3Column;
    private float[] cy5Column;
    
    public LogRatioToCy(float[] cy3, float[] cy5, float[] logRatio, int[] origNdx, String ref) {
        
        cy3Column = cy3;
        cy5Column = cy5;

        for (int rawRowIndex = 0; rawRowIndex < cy3Column.length; rawRowIndex++){
            KEEP_SEARCH:
                for (int i = 0; i < origNdx.length; i++){
                    float expValue = 1.0f;
                    if (origNdx[i] == rawRowIndex){
                        if (ref.equalsIgnoreCase("Cy3")){       //We will change cy5 column
                            expValue = (float)Math.pow(2.0, logRatio[i]);
                            cy5Column[rawRowIndex] = new Float(cy3Column[rawRowIndex] * expValue).longValue();
                            break KEEP_SEARCH;
                        }else{                                  //We will change cy3 column
                            //expValue = -Math.pow(2.0, logRatio[i]);
                            expValue = (float)Math.pow(2.0, (-1)*logRatio[i]);
                            cy3Column[rawRowIndex] = new Float(cy5Column[rawRowIndex] * expValue).longValue();
                            break KEEP_SEARCH;
                        }
                    }
                }
        }
    }

    
    public LogRatioToCy(float[] cy3Column, float[] cy5Column, float logRatio, int[] origNdx, String ref) {
        
        this.cy3Column = cy3Column;
        this.cy5Column = cy5Column;

        for (int rawRowIndex = 0; rawRowIndex < cy3Column.length; rawRowIndex++){
            KEEP_SEARCH:
                for (int i = 0; i < origNdx.length; i++){
                    float expValue = 1.0f;
                    if (origNdx[i] == rawRowIndex){
                        if (ref.equalsIgnoreCase("Cy3")){       //We will change cy5 column
                            expValue = (float)Math.pow(2.0, logRatio);
                            cy5Column[rawRowIndex] = new Float(cy3Column[rawRowIndex] * expValue).longValue();
                            break KEEP_SEARCH;
                        }else{                                  //We will change cy3 column
                            //expValue = -Math.pow(2.0, logRatio);
                            expValue = (float)Math.pow(2.0, (-1)*logRatio);
                            cy3Column[rawRowIndex] = new Float(cy5Column[rawRowIndex] * expValue).longValue();
                            break KEEP_SEARCH;
                        }
                    }
                }
        }
    }
    
    public final float[] getCy3Column(){
        return cy3Column;
    }
    
    public final float[] getCy5Column(){
        return cy5Column;
    }
    
}
