/*
 * Copyright @ 2001-2002, The Institute for Genomic Research (TIGR).  
 * All rights reserved.
 *
 * This software is provided "AS IS".  TIGR makes no warranties, express
 * or implied, including no representation or warranty with respect to
 * the performance of the software and derivatives or their safety,
 * effectiveness, or commercial viability.  TIGR does not warrant the
 * merchantability or fitness of the software and derivatives for any
 * particular purpose, or that they may be exploited without infringing
 * the copyrights, patent rights or property rights of others. TIGR shall
 * not be liable for any claim, demand or action for any loss, harm,
 * illness or other damage or injury arising from access to or use of the
 * software or associated information, including without limitation any
 * direct, indirect, incidental, exemplary, special or consequential
 * damages.
 *
 * This software program may not be sold, leased, transferred, exported
 * or otherwise disclaimed to anyone, in whole or in part, without the
 * prior written consent of TIGR.
 *
 *
 * IDAssigner.java
 *
 * Created on March 8, 2002, 10:06 AM
 * @author  wliang
 * @version 
 */

package org.tigr.midas.util;

import java.io.*;
import java.util.*;
import java.lang.*;

public class IDAssigner {

    private int id;
    private Vector idVec;
    private Vector keyBank;
    private Vector idRepeatCountVec;    
    
    public IDAssigner() {
        idVec = new Vector();
        idRepeatCountVec = new Vector();
    }

    public void findUniqueID(String key, Vector keyVec){
        int keyPos = keyVec.indexOf(key);
        if ( keyPos < 0){
            id = keyVec.size();
            idVec.add(id, new Integer(id).toString());
            keyVec.addElement(key);
            keyBank = keyVec;
            idRepeatCountVec.add(id, "1");
        }else{
            id = keyPos;
            keyBank = keyVec;
            int lastCountForThisId = Integer.parseInt(idRepeatCountVec.get(id).toString());
            idRepeatCountVec.set(id, new Integer(lastCountForThisId + 1).toString());
        }       
    }
    
    public final int getID(){
        return id;
    }
    
    public final Vector getIDVec(){
        return idVec;
    }
    
    public final Vector getKeyBank(){
        return keyBank;
    }
    
    public final Vector getIDRepeatCount(){
        return idRepeatCountVec;
    }
}
