/*
 * Copyright @ 2001-2003, The Institute for Genomic Research (TIGR).
 * All rights reserved.
 *
 *
 * CyToLogProdRatio.java
 *
 * Created on August 27, 2002, 1:10 PM
 * @author  wliang
 * @version 
 */

package org.tigr.midas.util;

import java.io.*;
import java.util.*;
import java.math.*;
import java.lang.*;
import org.tigr.midas.math.*;
import org.tigr.midas.util.*;

public class CyToLogProdRatio {

    private int goodDataNumber;
    private float[] logX;
    private float[] logY;
    private float[] logProd;
    private float[] logRatio;
    private int[] ndx;    

    public CyToLogProdRatio(float[] x, float[] y, int[] z, boolean[] b){
        
        logX = new float[x.length];
        logY = new float[y.length];
        logProd = new float[x.length];
        logRatio = new float[y.length];
        ndx = new int[z.length];
        
        for (int dataNumber = 0; dataNumber < x.length; dataNumber++){
            if (Float.isInfinite(x[dataNumber]) || Float.isInfinite(y[dataNumber]) || Float.isNaN(x[dataNumber]) || Float.isNaN(y[dataNumber])){
            
            }else if (x[dataNumber] > 1 && y[dataNumber] > 1 && b[z[dataNumber]]){
                logX[goodDataNumber] = MathTools.log10(x[dataNumber]);
                logY[goodDataNumber] = MathTools.log10(y[dataNumber]);
                logProd[goodDataNumber] = MathTools.log10(x[dataNumber] * y[dataNumber]);
                logRatio[goodDataNumber] = MathTools.log2(y[dataNumber] / x[dataNumber]);
                ndx[goodDataNumber] = z[dataNumber];
                goodDataNumber++;
            }else{}
        }
        //System.out.println("dataNumber = " + x.length + ", goodDataNumber = " + goodDataNumber);
        
        logX = new ArrayResizer(logX, goodDataNumber).getFArray();
        logY = new ArrayResizer(logY, goodDataNumber).getFArray();
        logProd = new ArrayResizer(logProd, goodDataNumber).getFArray();
        logRatio = new ArrayResizer(logRatio, goodDataNumber).getFArray();
        ndx = new ArrayResizer(ndx, goodDataNumber).getIArray();
    }

    public CyToLogProdRatio(float[] x, float[] y, boolean[] b){
        
        logX = new float[x.length];
        logY = new float[y.length];
        logProd = new float[x.length];
        logRatio = new float[y.length];
        ndx = new int[x.length];
        
        for (int dataNumber = 0; dataNumber < x.length; dataNumber++){
            if (Float.isInfinite(x[dataNumber]) || Float.isInfinite(y[dataNumber]) || Float.isNaN(x[dataNumber]) || Float.isNaN(y[dataNumber])){
            
            }else if (x[dataNumber] > 1 && y[dataNumber] > 1 && b[dataNumber]){
                logX[goodDataNumber] = MathTools.log10(x[dataNumber]);
                logY[goodDataNumber] = MathTools.log10(y[dataNumber]);
                logProd[goodDataNumber] = MathTools.log10(x[dataNumber] * y[dataNumber]);
                logRatio[goodDataNumber] = MathTools.log2(y[dataNumber] / x[dataNumber]);
                ndx[goodDataNumber] = dataNumber;
                goodDataNumber++;
            }else{}
        }
        //System.out.println("dataNumber = " + x.length + ", goodDataNumber = " + goodDataNumber);
        
        logX = new ArrayResizer(logX, goodDataNumber).getFArray();
        logY = new ArrayResizer(logY, goodDataNumber).getFArray();
        logProd = new ArrayResizer(logProd, goodDataNumber).getFArray();
        logRatio = new ArrayResizer(logRatio, goodDataNumber).getFArray();
        ndx = new ArrayResizer(ndx, goodDataNumber).getIArray();
    }
    
    public CyToLogProdRatio(float[] x, float[] y){
        
        logX = new float[x.length];
        logY = new float[y.length];
        logProd = new float[x.length];
        logRatio = new float[y.length];
        //ndx = new int[x.length];
        
        for (int dataNumber = 0; dataNumber < x.length; dataNumber++){
            if (Float.isInfinite(x[dataNumber]) || Float.isInfinite(y[dataNumber]) || Float.isNaN(x[dataNumber]) || Float.isNaN(y[dataNumber])){
                logX[dataNumber] = MathTools.log10(x[dataNumber]);
                logY[dataNumber] = MathTools.log10(y[dataNumber]);
                logProd[dataNumber] = MathTools.log10(x[dataNumber] * y[dataNumber]);
                logRatio[dataNumber] = MathTools.log2(y[dataNumber] / x[dataNumber]);
            }
        }
        
        //logX = new ArrayResizer(logX, goodDataNumber).getFArray();
        //logY = new ArrayResizer(logY, goodDataNumber).getFArray();
        //logProd = new ArrayResizer(logProd, goodDataNumber).getFArray();
        //logRatio = new ArrayResizer(logRatio, goodDataNumber).getFArray();
        //ndx = new ArrayResizer(ndx, goodDataNumber).getIArray(); 
    }
    
    public final float[] getLogX(){
        return logX;
    }
    
    public final float[] getLogY(){
        return logY;
    }
    
    public final float[] getLogProd(){
        return logProd;
    }
    
    public final float[] getLogRatio(){
        return logRatio;
    }
    
    public final int[] getNdx(){
        return ndx;
    }
    
    public final int getGoodDataNumber(){
        return goodDataNumber;
    }
}
