/*
 * Copyright @ 2001-2003, The Institute for Genomic Research (TIGR).
 * All rights reserved.
 *
 *
 * andFlags.java
 *
 * Created on June 5, 2002, 1:24 PM
 * @author  wliang
 * @version
 */

package org.tigr.midas.util;


public class AndFlags {
    
    private boolean[] c;
    private boolean[] d;
    
    public AndFlags(boolean[] a, boolean[] b) {
        if (a.length != b.length){
            logger.log("Error in andFlags(boolean[] a, boolean[] b), a.length != b.length");
            logger.log("a.length = " + a.length + ", b.length = " + b.length);
        }else{
            c = new boolean[a.length];
            d = new boolean[a.length];
            for (int i = 0; i < a.length; i++){
                c[i] = a[i] && b[i];
                d[i] = !c[i];
            }
        }
    }
    
    public final boolean[] getAndFlag(){
        return c;
    }
    
    public final boolean[] getNandFlag(){
        return d;
    }
}
