/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.helpers.ktree;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Vector;
import org.tigr.microarray.mev.cluster.gui.helpers.ktree.ITreeNode;

public class KNodeImpl
implements ITreeNode,
Serializable {
    protected int x = 0;
    protected int y = 0;
    protected int w = 0;
    protected int h = 0;
    protected Point location;
    protected boolean verboseRendering = true;
    protected ITreeNode[] children;
    protected ITreeNode[] parents;
    protected int level;

    public KNodeImpl() {
        this.children = new ITreeNode[0];
        this.parents = new ITreeNode[0];
    }

    public KNodeImpl(int n, int n2) {
        this.location = new Point(n, n2);
        this.x = n;
        this.y = n2;
        this.children = new ITreeNode[0];
        this.parents = new ITreeNode[0];
    }

    public boolean contains(int n, int n2) {
        return n >= this.x && n <= this.x + this.w && n2 > this.y && n2 <= this.y + this.h;
    }

    public int getLevel() {
        return this.level;
    }

    public Point getTopAnchorPoint() {
        return new Point(this.x + this.w / 2, this.y);
    }

    public Point getBottomAnchorPoint() {
        return new Point(this.x + this.w / 2, this.y + this.h);
    }

    public ITreeNode[] getParents() {
        return this.parents;
    }

    public ITreeNode[] getChildren() {
        return this.children;
    }

    public Point getLocation() {
        return this.location;
    }

    public int getNodeHeight() {
        return this.level;
    }

    public boolean isVerboseRendering() {
        return this.verboseRendering;
    }

    public boolean addChild(ITreeNode iTreeNode) {
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i] != iTreeNode) continue;
            return false;
        }
        ITreeNode[] iTreeNodeArray = new ITreeNode[this.children.length + 1];
        System.arraycopy(this.children, 0, iTreeNodeArray, 0, this.children.length);
        iTreeNodeArray[iTreeNodeArray.length - 1] = iTreeNode;
        this.children = iTreeNodeArray;
        return true;
    }

    public boolean addParent(ITreeNode iTreeNode) {
        for (int i = 0; i < this.parents.length; ++i) {
            if (this.parents[i] != iTreeNode) continue;
            return false;
        }
        ITreeNode[] iTreeNodeArray = new ITreeNode[this.parents.length + 1];
        System.arraycopy(this.parents, 0, iTreeNodeArray, 0, this.parents.length);
        iTreeNodeArray[iTreeNodeArray.length - 1] = iTreeNode;
        this.parents = iTreeNodeArray;
        return true;
    }

    public void clearChildren() {
        this.children = new ITreeNode[0];
    }

    public void clearParents() {
        this.parents = new ITreeNode[0];
    }

    public void setParents(Vector vector) {
        this.parents = new ITreeNode[vector.size()];
        for (int i = 0; i < this.parents.length; ++i) {
            this.parents[i] = (ITreeNode)vector.elementAt(i);
        }
    }

    public void setChildren(Vector vector) {
        this.children = new ITreeNode[vector.size()];
        for (int i = 0; i < this.children.length; ++i) {
            this.children[i] = (ITreeNode)vector.elementAt(i);
        }
    }

    public int getMaxPathLengthToRoot() {
        int n = 0;
        if (this.parents == null) {
            return 0;
        }
        for (int i = 0; i < this.parents.length; ++i) {
            n = Math.max(n, this.parents[i].getMaxPathLengthToRoot());
        }
        return n + 1;
    }

    public int getMinPathLengthToRoot() {
        int n = Integer.MAX_VALUE;
        if (this.parents == null) {
            return 0;
        }
        for (int i = 0; i < this.parents.length; ++i) {
            n = Math.min(n, this.parents[i].getMinPathLengthToRoot());
        }
        return n;
    }

    public Dimension getSize() {
        return new Dimension(this.w, this.h);
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public boolean hasChildren() {
        return this.children.length > 0;
    }

    public boolean hasParents() {
        return this.parents.length > 0;
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public void getAncestors(Vector vector) {
        int n;
        if (this.parents.length == 0) {
            return;
        }
        for (n = 0; n < this.parents.length; ++n) {
            if (vector.contains(this.parents[n])) continue;
            vector.addElement(this.parents[n]);
        }
        for (n = 0; n < this.parents.length; ++n) {
            this.parents[n].getAncestors(vector);
        }
    }

    public void getSuccessors(Vector vector) {
        int n;
        if (this.children.length == 0) {
            return;
        }
        for (n = 0; n < this.children.length; ++n) {
            if (vector.contains(this.children[n])) continue;
            vector.addElement(this.children[n]);
        }
        for (n = 0; n < this.children.length; ++n) {
            this.children[n].getSuccessors(vector);
        }
    }

    public boolean contains(Rectangle rectangle) {
        return rectangle.contains(this.x, this.y, this.w, this.h);
    }
}

