/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.helpers;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;

public class TableViewer
extends JPanel
implements IViewer,
Serializable {
    public static final long serialVersionUID = 201100001L;
    protected JTable table;
    protected TableModel model;
    protected JScrollPane pane;
    protected IFramework framework;

    public TableViewer() {
    }

    public TableViewer(String[] stringArray, Object[][] objectArray) {
        this.model = new DefaultViewerTableModel(stringArray, objectArray);
        this.table = new JTable(this.model);
        this.table.getTableHeader().addMouseListener(new TableHeaderMouseListener());
        this.pane = new JScrollPane(this.table);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.pane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.model);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.model = (TableModel)objectInputStream.readObject();
        this.table = new JTable(this.model);
        this.table.getTableHeader().addMouseListener(new TableHeaderMouseListener());
        this.pane = new JScrollPane(this.table);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.pane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setTableModel(TableModel tableModel) {
        this.model = tableModel;
        this.table.setModel(tableModel);
    }

    public JTable getTable() {
        return this.table;
    }

    public TableModel getTableModel() {
        return this.table.getModel();
    }

    public JTableHeader getTableHeader() {
        return this.table.getTableHeader();
    }

    public void setNumerical(int n, boolean bl) {
        if (this.model instanceof DefaultViewerTableModel) {
            ((DefaultViewerTableModel)this.model).setNumerical(n, bl);
        }
    }

    public int getSelectedRow() {
        int n = this.table.getSelectedRow();
        n = n < 0 ? -1 : ((DefaultViewerTableModel)this.model).getRow(n);
        return n;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"Gene", "GenBank #", "Common Name"};
        Object[][] objectArray = new Object[3][3];
        for (int i = 0; i < objectArray.length; ++i) {
            for (int j = 0; j < objectArray[0].length; ++j) {
                objectArray[i][j] = i == 1 ? "1000" : Integer.toString(i * j + j);
            }
        }
        TableViewer tableViewer = new TableViewer(stringArray2, objectArray);
        tableViewer.setNumerical(0, true);
        tableViewer.setNumerical(1, true);
        tableViewer.setNumerical(2, false);
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add(tableViewer);
        jFrame.setSize(100, 100);
        jFrame.setDefaultCloseOperation(2);
        jFrame.setVisible(true);
    }

    public JComponent getContentComponent() {
        return this.table;
    }

    public JComponent getHeaderComponent() {
        return this.table.getTableHeader();
    }

    public BufferedImage getImage() {
        return null;
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public void onClosed() {
    }

    public void onDataChanged(IData iData) {
    }

    public void onDeselected() {
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
    }

    public void onSelected(IFramework iFramework) {
        this.framework = iFramework;
    }

    public JComponent getCornerComponent(int n) {
        return null;
    }

    public int[][] getClusters() {
        return null;
    }

    public Experiment getExperiment() {
        return null;
    }

    public int getViewerType() {
        return -1;
    }

    public class TableHeaderMouseListener
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getModifiers() == 16 && mouseEvent.getClickCount() > 1 && TableViewer.this.model instanceof DefaultViewerTableModel) {
                JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
                int n = jTableHeader.columnAtPoint(mouseEvent.getPoint());
                int n2 = TableViewer.this.table.convertColumnIndexToModel(n);
                ((DefaultViewerTableModel)TableViewer.this.model).sort(n2);
            }
        }
    }

    public class CellRenderer
    extends DefaultTableCellRenderer {
        JPanel colorPanel = new JPanel();
        JLabel label;
        JTextArea textArea;

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof Color) {
                this.colorPanel.setBackground((Color)object);
                return this.colorPanel;
            }
            if (object instanceof JLabel) {
                this.label = (JLabel)object;
                this.label.setOpaque(true);
                this.label.setFont(new Font("Arial", 0, 12));
                this.label.setBackground(new Color(225, 225, 225));
                this.label.setForeground(Color.black);
                this.label.setHorizontalAlignment(0);
                if (TableViewer.this.table.isRowSelected(n)) {
                    this.label.setBackground(TableViewer.this.table.getSelectionBackground());
                }
                return this.label;
            }
            if (object instanceof JTextArea) {
                this.textArea = (JTextArea)object;
                if (TableViewer.this.table.isRowSelected(n)) {
                    this.textArea.setBackground(TableViewer.this.table.getSelectionBackground());
                }
                return this.textArea;
            }
            this.colorPanel.setBackground(Color.white);
            return this.colorPanel;
        }
    }

    public class DefaultViewerTableModel
    extends AbstractTableModel
    implements Serializable {
        String[] columnNames;
        Object[][] tableData;
        boolean[] numerical;
        Row[] rows;
        int colToSort = 0;
        boolean ascending = false;

        public DefaultViewerTableModel(String[] stringArray, Object[][] objectArray) {
            this.columnNames = stringArray;
            this.tableData = objectArray;
            this.numerical = new boolean[stringArray.length];
            this.rows = new Row[objectArray.length];
            for (int i = 0; i < this.rows.length; ++i) {
                this.rows[i] = new Row();
                this.rows[i].index = i;
            }
        }

        public void setNumerical(int n, boolean bl) {
            if (n > -1 && n < this.numerical.length) {
                this.numerical[n] = bl;
            }
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            if (this.tableData == null) {
                return 0;
            }
            return this.tableData.length;
        }

        public Object getValueAt(int n, int n2) {
            if (this.tableData != null && n < this.tableData.length && n2 < this.tableData[n].length) {
                return this.tableData[this.rows[n].index][n2];
            }
            return null;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        private boolean isNumerical(int n) {
            return this.numerical[n];
        }

        public void sort(int n) {
            this.ascending = !this.ascending;
            this.colToSort = n;
            Arrays.sort(this.rows);
            this.fireTableDataChanged();
        }

        public int getRow(int n) {
            return this.rows[n].index;
        }

        private class Row
        implements Comparable,
        Serializable {
            public int index;
            private String myString;
            private String otherString;

            private Row() {
            }

            public int compareTo(Object object) {
                if (DefaultViewerTableModel.this.ascending) {
                    return this.compareToOther(object);
                }
                return this.compareToOther(object) * -1;
            }

            public int compareToOther(Object object) {
                Row row = (Row)object;
                Object object2 = DefaultViewerTableModel.this.tableData[this.index][DefaultViewerTableModel.this.colToSort];
                Object object3 = DefaultViewerTableModel.this.tableData[row.index][DefaultViewerTableModel.this.colToSort];
                if (object2 instanceof Comparable) {
                    if (DefaultViewerTableModel.this.isNumerical(DefaultViewerTableModel.this.colToSort) && object2 instanceof String) {
                        Float f = new Float((String)object2);
                        Float f2 = new Float((String)object3);
                        return f.compareTo(f2);
                    }
                    return ((Comparable)object2).compareTo(object3);
                }
                if (object2 instanceof JLabel) {
                    this.myString = ((JLabel)object2).getText();
                    this.otherString = ((JLabel)object3).getText();
                    return this.myString.compareTo(this.otherString);
                }
                return this.index - row.index;
            }
        }
    }
}

