/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.helpers;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;

public class ClusterTableSearchDialog
extends JDialog {
    JTable table;
    String searchStr;
    int numRows;
    int numCols;
    int numClasses;
    Vector foundRowIndices;
    ButtonGroup searchButtonGroup;
    private JCheckBox matchCaseChkBox;
    private JRadioButton selectIncrButton;
    private JLabel jLabel2;
    private JLabel geneBarContainerLabel;
    private JButton findButton;
    private JPanel geneBarPanel;
    private JButton findNextButton;
    private ButtonGroup buttonGroup1;
    private JPanel buttonPanel;
    private JRadioButton selectAllButton;
    private JComboBox jComboBox1;
    private JButton closeButton;
    private ColumnNamesPanel colPanel;

    public ClusterTableSearchDialog(Frame frame, JTable jTable, boolean bl) {
        super(frame, bl);
        this.table = jTable;
        this.numRows = jTable.getRowCount();
        this.numCols = jTable.getColumnCount();
        this.foundRowIndices = new Vector();
        this.initComponents();
        this.geneBarContainerLabel.setIcon(GUIFactory.getIcon((String)"dialog_banner2.gif"));
        this.searchButtonGroup = new ButtonGroup();
        this.searchButtonGroup.add(this.selectAllButton);
        this.searchButtonGroup.add(this.selectIncrButton);
        this.setSize(300, 500);
        this.jComboBox1.setMaximumRowCount(10);
        this.searchStr = null;
        this.jComboBox1.setEditable(true);
        this.jComboBox1.insertItemAt(new String(""), 0);
        this.findButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClusterTableSearchDialog.this.updateRowCount();
                ClusterTableSearchDialog.this.findNextButton.setEnabled(false);
                ClusterTableSearchDialog.this.runSearch();
                if (ClusterTableSearchDialog.this.foundRowIndices.size() > 0 && ClusterTableSearchDialog.this.selectIncrButton.isSelected()) {
                    ClusterTableSearchDialog.this.findNextButton.setEnabled(true);
                } else {
                    ClusterTableSearchDialog.this.findNextButton.setEnabled(false);
                }
            }
        });
        this.findNextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClusterTableSearchDialog.this.updateRowCount();
                ClusterTableSearchDialog.this.findNext();
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClusterTableSearchDialog.this.foundRowIndices.removeAllElements();
                ClusterTableSearchDialog.this.findNextButton.setEnabled(false);
                ClusterTableSearchDialog.this.selectAllButton.setSelected(true);
                ClusterTableSearchDialog.this.matchCaseChkBox.setSelected(true);
                ClusterTableSearchDialog.this.setVisible(false);
            }
        });
        this.jComboBox1.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                ClusterTableSearchDialog.this.findNextButton.setEnabled(false);
                ClusterTableSearchDialog.this.findNextButton.repaint();
                ClusterTableSearchDialog.this.foundRowIndices.removeAllElements();
            }

            public void focusLost(FocusEvent focusEvent) {
            }
        });
    }

    private void updateRowCount() {
        this.numRows = this.table.getRowCount();
    }

    private boolean runSearch() {
        int[] nArray = this.colPanel.getSelectedCols();
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        this.foundRowIndices = new Vector();
        boolean bl = this.selectAllButton.isSelected();
        boolean bl2 = false;
        this.table.clearSelection();
        this.searchStr = (String)this.jComboBox1.getSelectedItem();
        if (this.searchStr == null || nArray.length == 0 || this.searchStr.equals("")) {
            return bl2;
        }
        this.jComboBox1.insertItemAt(this.searchStr, 0);
        if (this.matchCaseChkBox.isSelected()) {
            block0: for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < nArray.length; ++j) {
                    if (((String)this.table.getModel().getValueAt(i, nArray[j])).indexOf(this.searchStr) == -1) continue;
                    if (bl || !bl2) {
                        this.table.addRowSelectionInterval(i, i);
                        if (bl2) continue block0;
                        this.table.scrollRectToVisible(this.table.getCellRect(i, 0, true));
                        bl2 = true;
                        continue block0;
                    }
                    this.foundRowIndices.add(new Integer(i));
                    continue block0;
                }
            }
        } else {
            String string = this.searchStr.toUpperCase();
            block2: for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < nArray.length; ++j) {
                    if (((String)this.table.getModel().getValueAt(i, nArray[j])).toUpperCase().indexOf(string) == -1) continue;
                    if (bl || !bl2) {
                        this.table.addRowSelectionInterval(i, i);
                        if (bl2) continue block2;
                        this.table.scrollRectToVisible(this.table.getCellRect(i, 0, true));
                        bl2 = true;
                        continue block2;
                    }
                    this.foundRowIndices.add(new Integer(i));
                    continue block2;
                }
            }
        }
        return bl2;
    }

    public void findNext() {
        if (this.foundRowIndices.isEmpty()) {
            return;
        }
        int n = (Integer)this.foundRowIndices.remove(0);
        this.table.clearSelection();
        this.table.addRowSelectionInterval(n, n);
        this.table.scrollRectToVisible(this.table.getCellRect(n, 0, true));
        if (this.foundRowIndices.size() == 0) {
            this.findNextButton.setEnabled(false);
        }
    }

    private void initComponents() {
        this.colPanel = new ColumnNamesPanel();
        this.buttonGroup1 = new ButtonGroup();
        this.jComboBox1 = new JComboBox();
        this.jLabel2 = new JLabel();
        this.matchCaseChkBox = new JCheckBox();
        this.selectAllButton = new JRadioButton();
        this.selectIncrButton = new JRadioButton();
        this.buttonPanel = new JPanel();
        this.findButton = new JButton();
        this.findNextButton = new JButton();
        this.closeButton = new JButton();
        this.geneBarPanel = new JPanel();
        this.geneBarContainerLabel = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Table Search");
        this.setName("Table Search");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ClusterTableSearchDialog.this.closeDialog(windowEvent);
            }
        });
        this.jComboBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClusterTableSearchDialog.this.jComboBox1ActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weighty = 80.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.colPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 4.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.jComboBox1, gridBagConstraints);
        this.jLabel2.setForeground(Color.black);
        this.jLabel2.setText("Find what:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.matchCaseChkBox.setText("Match Case");
        this.matchCaseChkBox.setFocusPainted(false);
        this.matchCaseChkBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClusterTableSearchDialog.this.matchCaseChkBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 4.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.getContentPane().add((Component)this.matchCaseChkBox, gridBagConstraints);
        this.selectAllButton.setSelected(true);
        this.selectAllButton.setText("Select All Rows Found");
        this.selectAllButton.setToolTipText("Select all finds at once.");
        this.selectAllButton.setFocusPainted(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 4.0;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.selectAllButton, gridBagConstraints);
        this.selectIncrButton.setText("Select Incrementally");
        this.selectIncrButton.setToolTipText("Move throgh finds sequentially.");
        this.selectIncrButton.setFocusPainted(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.selectIncrButton, gridBagConstraints);
        this.findButton.setText("Find");
        this.buttonPanel.add(this.findButton);
        this.findNextButton.setText("Find Next");
        this.findNextButton.setEnabled(false);
        this.buttonPanel.add(this.findNextButton);
        this.closeButton.setText("Close");
        this.buttonPanel.add(this.closeButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weighty = 4.0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.geneBarContainerLabel.setToolTipText("The Institute for Genomic Research");
        this.geneBarContainerLabel.setIconTextGap(0);
        this.geneBarContainerLabel.setIcon(GUIFactory.getIcon((String)"genebar2.gif"));
        this.geneBarPanel.add(this.geneBarContainerLabel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 4.0;
        this.getContentPane().add((Component)this.geneBarPanel, gridBagConstraints);
    }

    private void jComboBox1ActionPerformed(ActionEvent actionEvent) {
        this.foundRowIndices.removeAllElements();
        this.findNextButton.setEnabled(false);
    }

    private void matchCaseChkBoxActionPerformed(ActionEvent actionEvent) {
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
    }

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    public static void main(String[] stringArray) {
        ClusterTableSearchDialog clusterTableSearchDialog = new ClusterTableSearchDialog(new Frame(), new JTable(), false);
        clusterTableSearchDialog.show();
    }

    private class ColumnNamesPanel
    extends JPanel {
        JCheckBox[] columnNameBoxes;
        JButton selectAllButton;
        JButton clearAllButton;

        ColumnNamesPanel() {
            int n;
            this.setBorder(new TitledBorder("Select fields to search"));
            this.setBackground(Color.white);
            String[] stringArray = new String[ClusterTableSearchDialog.this.table.getColumnCount() - 1];
            for (n = 0; n < stringArray.length; ++n) {
                stringArray[n] = ClusterTableSearchDialog.this.table.getColumnName(n + 1);
            }
            this.columnNameBoxes = new JCheckBox[stringArray.length];
            for (n = 0; n < this.columnNameBoxes.length; ++n) {
                this.columnNameBoxes[n] = new JCheckBox(stringArray[n], true);
                this.columnNameBoxes[n].setBackground(Color.white);
            }
            JPanel jPanel = this.createCheckBoxPanel();
            JScrollPane jScrollPane = new JScrollPane(jPanel);
            jScrollPane.setVerticalScrollBarPolicy(22);
            jScrollPane.setHorizontalScrollBarPolicy(32);
            JButton jButton = new JButton("Select All");
            JButton jButton2 = new JButton("Clear All");
            jButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ ColumnNamesPanel this$1;
                {
                    this.this$1 = columnNamesPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    for (int i = 0; i < this.this$1.columnNameBoxes.length; ++i) {
                        this.this$1.columnNameBoxes[i].setSelected(true);
                    }
                }
            });
            jButton2.addActionListener(new ActionListener(this){
                private final /* synthetic */ ColumnNamesPanel this$1;
                {
                    this.this$1 = columnNamesPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    for (int i = 0; i < this.this$1.columnNameBoxes.length; ++i) {
                        this.this$1.columnNameBoxes[i].setSelected(false);
                    }
                }
            });
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            ClusterTableSearchDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 50, 10);
            gridBagLayout.setConstraints(jButton, gridBagConstraints);
            this.add(jButton);
            ClusterTableSearchDialog.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 50, 0);
            gridBagLayout.setConstraints(jButton2, gridBagConstraints);
            this.add(jButton2);
            ClusterTableSearchDialog.this.buildConstraints(gridBagConstraints, 0, 1, 2, 1, 100, 90);
            gridBagConstraints.fill = 1;
            gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
            this.add(jScrollPane);
        }

        private JPanel createCheckBoxPanel() {
            JPanel jPanel = new JPanel();
            jPanel.setBackground(Color.white);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            GridBagLayout gridBagLayout = new GridBagLayout();
            jPanel.setLayout(gridBagLayout);
            gridBagConstraints.anchor = 17;
            for (int i = 0; i < this.columnNameBoxes.length; ++i) {
                ClusterTableSearchDialog.this.buildConstraints(gridBagConstraints, 0, i, 1, 1, 100, 0);
                gridBagLayout.setConstraints(this.columnNameBoxes[i], gridBagConstraints);
                jPanel.add(this.columnNameBoxes[i]);
            }
            return jPanel;
        }

        public int[] getSelectedCols() {
            Vector<Integer> vector = new Vector<Integer>();
            for (int i = 0; i < this.columnNameBoxes.length; ++i) {
                if (!this.columnNameBoxes[i].isSelected()) continue;
                vector.add(new Integer(i + 1));
            }
            int[] nArray = new int[vector.size()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = (Integer)vector.get(i);
            }
            return nArray;
        }

        public String[] getSelectedColNames() {
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < this.columnNameBoxes.length; ++i) {
                if (!this.columnNameBoxes[i].isSelected()) continue;
                vector.add(ClusterTableSearchDialog.this.table.getColumnName(i + 1));
            }
            String[] stringArray = new String[vector.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)vector.get(i);
            }
            return stringArray;
        }
    }
}

