/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.helpers;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.util.BrowserLauncher;
import org.tigr.util.StringSplitter;

public class AnnotationURLLinkDialog
extends AlgorithmDialog {
    File file;
    JComboBox annotationFieldsBox;
    JComboBox urlTypesBox;
    String[] urlTemplates;
    String[] urlKeys;
    IData data;
    Experiment experiment;
    int row;
    private int[] lastSelectedIndices;
    boolean okPressed = false;
    String annotationKey;

    public AnnotationURLLinkDialog(JFrame jFrame, boolean bl, String[] stringArray, String[] stringArray2) {
        super(jFrame, "Link annotation to URL", bl);
        this.setBounds(0, 0, 500, 300);
        this.setBackground(Color.white);
        this.setDefaultCloseOperation(2);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(Color.white);
        jPanel2.setBorder(new TitledBorder("Select annotation to link out from"));
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout2);
        this.annotationFieldsBox = new JComboBox<String>(stringArray);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 100);
        gridBagLayout2.setConstraints(this.annotationFieldsBox, gridBagConstraints);
        jPanel2.add(this.annotationFieldsBox);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBackground(Color.white);
        jPanel3.setBorder(new TitledBorder("Select internet resource to link to"));
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        jPanel3.setLayout(gridBagLayout3);
        this.urlTypesBox = new JComboBox<String>(stringArray2);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 100);
        gridBagLayout3.setConstraints(this.urlTypesBox, gridBagConstraints);
        jPanel3.add(this.urlTypesBox);
        gridBagConstraints.fill = 1;
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 50);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 0, 50);
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel.add(jPanel3);
        this.addContent(jPanel);
        EventListener eventListener = new EventListener();
        this.setActionListeners(eventListener);
        this.addWindowListener(eventListener);
    }

    public AnnotationURLLinkDialog(JFrame jFrame, boolean bl, Experiment experiment, IData iData, int n, File file) {
        super(jFrame, "Link annotation to URL", bl);
        this.data = iData;
        this.experiment = experiment;
        this.file = file;
        this.row = n;
        this.setBounds(0, 0, 500, 300);
        this.setBackground(Color.white);
        this.setDefaultCloseOperation(2);
        this.populateFields();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(Color.white);
        jPanel2.setBorder(new TitledBorder("Select annotation to link out from"));
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout2);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 100);
        gridBagLayout2.setConstraints(this.annotationFieldsBox, gridBagConstraints);
        jPanel2.add(this.annotationFieldsBox);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBackground(Color.white);
        jPanel3.setBorder(new TitledBorder("Select internet resource to link to"));
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        jPanel3.setLayout(gridBagLayout3);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 100);
        gridBagLayout3.setConstraints(this.urlTypesBox, gridBagConstraints);
        jPanel3.add(this.urlTypesBox);
        gridBagConstraints.fill = 1;
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 50);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 0, 50);
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel.add(jPanel3);
        this.addContent(jPanel);
        EventListener eventListener = new EventListener();
        this.setActionListeners(eventListener);
        this.addWindowListener(eventListener);
    }

    public AnnotationURLLinkDialog(JFrame jFrame, boolean bl, Experiment experiment, IData iData, int n, File file, int[] nArray) {
        super(jFrame, "Link annotation to URL", bl);
        this.data = iData;
        this.experiment = experiment;
        this.file = file;
        this.row = n;
        this.lastSelectedIndices = nArray;
        this.setBounds(0, 0, 500, 300);
        this.setBackground(Color.white);
        this.setDefaultCloseOperation(2);
        this.populateFields();
        this.annotationFieldsBox.setSelectedIndex(nArray[0]);
        this.urlTypesBox.setSelectedIndex(nArray[1]);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(Color.white);
        jPanel2.setBorder(new TitledBorder("Select annotation to link out from"));
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout2);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 100);
        gridBagLayout2.setConstraints(this.annotationFieldsBox, gridBagConstraints);
        jPanel2.add(this.annotationFieldsBox);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBackground(Color.white);
        jPanel3.setBorder(new TitledBorder("Select internet resource to link to"));
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        jPanel3.setLayout(gridBagLayout3);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 100);
        gridBagLayout3.setConstraints(this.urlTypesBox, gridBagConstraints);
        jPanel3.add(this.urlTypesBox);
        gridBagConstraints.fill = 1;
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 50);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 0, 50);
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel.add(jPanel3);
        this.addContent(jPanel);
        EventListener eventListener = new EventListener();
        this.setActionListeners(eventListener);
        this.addWindowListener(eventListener);
    }

    public void setVisible(boolean bl) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        super.setVisible(bl);
        if (bl) {
            // empty if block
        }
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    private void populateFields() {
        Vector vector = new Vector();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        try {
            int n;
            String[] stringArray;
            FileReader fileReader = new FileReader(this.file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            StringSplitter stringSplitter = new StringSplitter('\t');
            boolean bl = false;
            while (!bl) {
                stringArray = bufferedReader.readLine();
                if (stringArray == null) {
                    bl = true;
                    continue;
                }
                stringSplitter.init((String)stringArray);
                vector2.add(stringSplitter.nextToken());
                vector3.add(stringSplitter.nextToken());
                vector4.add(stringSplitter.nextToken());
            }
            bufferedReader.close();
            stringArray = new String[vector4.size()];
            for (n = 0; n < stringArray.length; ++n) {
                stringArray[n] = (String)vector4.get(n);
            }
            this.urlTypesBox = new JComboBox<String>(stringArray);
            this.annotationFieldsBox = new JComboBox<String>(this.data.getFieldNames());
            this.urlTemplates = new String[vector3.size()];
            this.urlKeys = new String[vector2.size()];
            for (n = 0; n < this.urlTemplates.length; ++n) {
                this.urlTemplates[n] = (String)vector3.get(n);
            }
            for (n = 0; n < this.urlKeys.length; ++n) {
                this.urlKeys[n] = (String)vector2.get(n);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(new JFrame(), "Could not find \"annotation_URLs.txt\" file in \"config\" directory", "Error", 0);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(new JFrame(), "Incompatible \"annotation_URLs.txt\" file in \"config\" directory! Possible issues: extra newline characters, too many or too few tabs per line", "Error", 0);
        }
    }

    private void launchBrowser() {
        try {
            String string = this.getCurrentURL();
            BrowserLauncher.openURL((String)string);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(new JFrame(), iOException.toString(), "Error", 0);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(new JFrame(), "Browser could not be launched! Possible problem: the annotation format may not be appropriate for this URL type!", "Error", 0);
        }
    }

    private String getCurrentURL() {
        int n = this.annotationFieldsBox.getSelectedIndex();
        int n2 = this.urlTypesBox.getSelectedIndex();
        String string = this.urlTemplates[n2];
        String string2 = this.urlKeys[n2];
        String string3 = "";
        String string4 = this.data.getElementAttribute(this.row, n);
        if (string2.equals("UniGene")) {
            String[] stringArray = string4.split("\\.");
            String string5 = string.replaceAll("FIELD1", stringArray[1]);
            string3 = string5.replaceAll("FIELD2", stringArray[0]);
        } else {
            string3 = string.replaceAll("FIELD1", string4);
        }
        return string3;
    }

    public int[] getLastSelectedIndices() {
        return this.lastSelectedIndices;
    }

    public void setLastSelectedIndices() {
        this.lastSelectedIndices[0] = this.annotationFieldsBox.getSelectedIndex();
        this.lastSelectedIndices[1] = this.urlTypesBox.getSelectedIndex();
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"User-defined field 1", "User-defined field 2", "User-defined field 3", "User-defined field 4"};
        String[] stringArray3 = new String[]{"GenBank", "TC#", "LocusLink", "Unigene"};
        AnnotationURLLinkDialog annotationURLLinkDialog = new AnnotationURLLinkDialog(new JFrame(), false, stringArray2, stringArray3);
        annotationURLLinkDialog.setVisible(true);
    }

    public class EventListener
    extends WindowAdapter
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                AnnotationURLLinkDialog.this.okPressed = true;
                AnnotationURLLinkDialog.this.setLastSelectedIndices();
                ExperimentUtil.lastSelectedAnnotationIndices = AnnotationURLLinkDialog.this.getLastSelectedIndices();
                AnnotationURLLinkDialog.this.launchBrowser();
                AnnotationURLLinkDialog.this.dispose();
            } else if (string.equals("reset-command")) {
                AnnotationURLLinkDialog.this.annotationFieldsBox.setSelectedIndex(0);
                AnnotationURLLinkDialog.this.urlTypesBox.setSelectedIndex(0);
                AnnotationURLLinkDialog.this.setLastSelectedIndices();
                ExperimentUtil.lastSelectedAnnotationIndices = AnnotationURLLinkDialog.this.getLastSelectedIndices();
            } else if (string.equals("cancel-command")) {
                AnnotationURLLinkDialog.this.okPressed = false;
                AnnotationURLLinkDialog.this.dispose();
            } else if (string.equals("info-command")) {
                // empty if block
            }
        }
    }
}

