/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui;

import java.io.Serializable;
import org.tigr.util.FloatMatrix;

public class Experiment
implements Serializable {
    public static final long serialVersionUID = 2010001L;
    private FloatMatrix matrix;
    private int[] columns;
    private int[] rowMapping;

    public Experiment(FloatMatrix floatMatrix, int[] nArray) {
        this(floatMatrix, nArray, Experiment.makeDefaultRowMapping(floatMatrix.getRowDimension()));
    }

    public Experiment(FloatMatrix floatMatrix, int[] nArray, int[] nArray2) {
        this.matrix = floatMatrix;
        this.columns = nArray;
        this.rowMapping = nArray2;
    }

    private static int[] makeDefaultRowMapping(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    public int[] getRowMappingArrayCopy() {
        int[] nArray = new int[this.rowMapping.length];
        System.arraycopy(this.rowMapping, 0, nArray, 0, nArray.length);
        return nArray;
    }

    public int[] getColumnIndicesCopy() {
        int[] nArray = new int[this.columns.length];
        System.arraycopy(this.columns, 0, nArray, 0, nArray.length);
        return nArray;
    }

    public Experiment copy() {
        int[] nArray = new int[this.columns.length];
        System.arraycopy(this.columns, 0, nArray, 0, this.columns.length);
        return new Experiment(this.matrix.copy(), nArray, this.getRowMappingArrayCopy());
    }

    public float get(int n, int n2) {
        return this.matrix.get(n, n2);
    }

    public float[][] getValues() {
        return this.matrix.A;
    }

    public FloatMatrix getMatrix() {
        return this.matrix;
    }

    public int getSampleIndex(int n) {
        return this.columns[n];
    }

    public int getGeneIndexMappedToData(int n) {
        if (n >= 0 && n < this.rowMapping.length) {
            return this.rowMapping[n];
        }
        return -1;
    }

    public int getNumberOfGenes() {
        return this.matrix.getRowDimension();
    }

    public int getNumberOfSamples() {
        return this.matrix.getColumnDimension();
    }

    public float[] getMinAndMax() {
        float f = 0.0f;
        int n = this.matrix.getRowDimension();
        int n2 = this.matrix.getColumnDimension();
        float[] fArray = new float[]{Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY};
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                f = this.matrix.get(i, j);
                if (Float.isNaN(f)) continue;
                if (f < fArray[0]) {
                    fArray[0] = f;
                }
                if (!(f > fArray[1])) continue;
                fArray[1] = f;
            }
        }
        return fArray;
    }

    public float getMaxAbsValue() {
        float[] fArray = this.getMinAndMax();
        return Math.max(Math.abs(fArray[0]), Math.abs(fArray[1]));
    }
}

