/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.picking;

import com.sun.j3d.utils.picking.PickResult;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.IndexedGeometryArray;
import javax.vecmath.Color3b;
import javax.vecmath.Color3f;
import javax.vecmath.Color4b;
import javax.vecmath.Color4f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord2f;
import javax.vecmath.TexCoord3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class PickIntersection {
    PickResult pickResult = null;
    double distance = -1.0;
    int geomIndex;
    int[] primitiveVertexIndices = null;
    Point3d[] primitiveCoordinatesVW = null;
    Point3d pointCoordinatesVW = null;
    GeometryArray geom = null;
    IndexedGeometryArray iGeom = null;
    boolean hasNormals = false;
    boolean hasColors = false;
    boolean hasTexCoords = false;
    int[] primitiveCoordinateIndices;
    int[] primitiveNormalIndices;
    int[] primitiveColorIndices;
    int[] primitiveTexCoordIndices;
    Point3d[] primitiveCoordinates = null;
    Vector3f[] primitiveNormals = null;
    Color4f[] primitiveColors = null;
    TexCoord3f[] primitiveTexCoords = null;
    Point3d pointCoordinates = null;
    Vector3f pointNormal = null;
    Color4f pointColor = null;
    TexCoord3f pointTexCoord = null;
    int closestVertexIndex = -1;
    Point3d closestVertexCoordinates = null;
    Point3d closestVertexCoordinatesVW = null;
    double[] interpWeights;
    static final boolean debug = false;
    static final int X_AXIS = 1;
    static final int Y_AXIS = 2;
    static final int Z_AXIS = 3;
    static final double TOL = 1.0E-5;

    PickIntersection(PickResult pickResult, GeometryArray geometryArray) {
        this.pickResult = pickResult;
        this.geom = geometryArray;
    }

    double abs(double d) {
        if (d < 0.0) {
            return -d;
        }
        return d;
    }

    public boolean geometryIsIndexed() {
        GeometryArray geometryArray = this.getGeometryArray();
        return this.iGeom != null;
    }

    public Point3d getClosestVertexCoordinates() {
        if (this.closestVertexCoordinates == null) {
            int n = this.getClosestVertexIndex();
            int n2 = this.geom.getVertexFormat();
            int[] nArray = this.getPrimitiveCoordinateIndices();
            if ((n2 & 0x80) == 0) {
                this.closestVertexCoordinates = new Point3d();
                this.geom.getCoordinate(nArray[n], this.closestVertexCoordinates);
            } else if ((n2 & 0x100) == 0) {
                double[] dArray = this.geom.getCoordRefDouble();
                if (dArray == null) {
                    float[] fArray = this.geom.getCoordRefFloat();
                    if (fArray == null) {
                        Point3f[] point3fArray = this.geom.getCoordRef3f();
                        if (point3fArray == null) {
                            Point3d[] point3dArray = this.geom.getCoordRef3d();
                            this.closestVertexCoordinates = new Point3d(point3dArray[nArray[n]].x, point3dArray[nArray[n]].y, point3dArray[nArray[n]].z);
                        } else {
                            this.closestVertexCoordinates = new Point3d((double)point3fArray[nArray[n]].x, (double)point3fArray[nArray[n]].y, (double)point3fArray[nArray[n]].z);
                        }
                    } else {
                        int n3 = nArray[n] * 3;
                        this.closestVertexCoordinates = new Point3d((double)fArray[n3], (double)fArray[n3 + 1], (double)fArray[n3 + 2]);
                    }
                } else {
                    int n4 = nArray[n] * 3;
                    this.closestVertexCoordinates = new Point3d(dArray[n4], dArray[n4 + 1], dArray[n4 + 2]);
                }
            } else {
                float[] fArray = this.geom.getInterleavedVertices();
                int n5 = this.getInterleavedVertexOffset(this.geom);
                int n6 = n5 + 3;
                int n7 = n6 * nArray[n] + n5;
                this.closestVertexCoordinates = new Point3d((double)fArray[n7], (double)fArray[n7 + 1], (double)fArray[n7 + 2]);
            }
        }
        return this.closestVertexCoordinates;
    }

    public Point3d getClosestVertexCoordinatesVW() {
        if (this.closestVertexCoordinatesVW == null) {
            int n = this.getClosestVertexIndex();
            Point3d[] point3dArray = this.getPrimitiveCoordinatesVW();
            this.closestVertexCoordinatesVW = point3dArray[n];
        }
        return this.closestVertexCoordinatesVW;
    }

    public int getClosestVertexIndex() {
        if (this.closestVertexIndex == -1) {
            this.storeClosestVertex();
        }
        return this.closestVertexIndex;
    }

    public double getDistance() {
        return this.distance;
    }

    public GeometryArray getGeometryArray() {
        if (this.geom == null) {
            if (this.geom instanceof IndexedGeometryArray) {
                this.iGeom = (IndexedGeometryArray)this.geom;
            }
            GeometryArray[] geometryArrayArray = this.pickResult.getGeometryArrays();
            this.geom = geometryArrayArray[this.geomIndex];
            int n = this.geom.getVertexFormat();
            this.hasColors = (n & 0xC) != 0;
            this.hasNormals = (n & 2) != 0;
            this.hasTexCoords = (n & 0x60) != 0;
        }
        return this.geom;
    }

    public int getGeometryArrayIndex() {
        return this.geomIndex;
    }

    int getInterleavedColorOffset(GeometryArray geometryArray) {
        int n = 0;
        int n2 = geometryArray.getVertexFormat();
        if ((n2 & 0x20) == 32) {
            n += 2 * geometryArray.getTexCoordSetCount();
        } else if ((n2 & 0x40) == 64) {
            n += 3 * geometryArray.getTexCoordSetCount();
        }
        return n;
    }

    int getInterleavedNormalOffset(GeometryArray geometryArray) {
        int n = 0;
        int n2 = geometryArray.getVertexFormat();
        if ((n2 & 0x20) == 32) {
            n += 2 * geometryArray.getTexCoordSetCount();
        } else if ((n2 & 0x40) == 64) {
            n += 3 * geometryArray.getTexCoordSetCount();
        }
        if ((n2 & 4) == 4) {
            n += 3;
        } else if ((n2 & 0xC) == 12) {
            n += 4;
        }
        return n;
    }

    int getInterleavedStride(GeometryArray geometryArray) {
        int n = 3;
        int n2 = geometryArray.getVertexFormat();
        if ((n2 & 4) == 4) {
            n += 3;
        } else if ((n2 & 0xC) == 12) {
            n += 4;
        }
        if ((n2 & 2) != 0) {
            n += 3;
        }
        if ((n2 & 0x20) == 32) {
            n += 2 * geometryArray.getTexCoordSetCount();
        } else if ((n2 & 0x40) == 64) {
            n += 3 * geometryArray.getTexCoordSetCount();
        }
        return n;
    }

    int getInterleavedVertexOffset(GeometryArray geometryArray) {
        int n = 0;
        int n2 = geometryArray.getVertexFormat();
        if ((n2 & 4) == 4) {
            n += 3;
        } else if ((n2 & 0xC) == 12) {
            n += 4;
        }
        if ((n2 & 2) != 0) {
            n += 3;
        }
        if ((n2 & 0x20) == 32) {
            n += 2 * geometryArray.getTexCoordSetCount();
        } else if ((n2 & 0x40) == 64) {
            n += 3 * geometryArray.getTexCoordSetCount();
        }
        return n;
    }

    private static float getInterpFactor(Point3d point3d, Point3d point3d2, Point3d point3d3, int n) {
        float f;
        switch (n) {
            case 1: {
                if (point3d2.x == point3d3.x) {
                    f = 0.0f;
                    break;
                }
                f = (float)((point3d2.x - point3d.x) / (point3d2.x - point3d3.x));
                break;
            }
            case 2: {
                if (point3d2.y == point3d3.y) {
                    f = 0.0f;
                    break;
                }
                f = (float)((point3d2.y - point3d.y) / (point3d2.y - point3d3.y));
                break;
            }
            case 3: {
                if (point3d2.z == point3d3.z) {
                    f = 0.0f;
                    break;
                }
                f = (float)((point3d2.z - point3d.z) / (point3d2.z - point3d3.z));
                break;
            }
            default: {
                throw new RuntimeException("invalid axis parameter " + n + " (must be 0-2)");
            }
        }
        return f;
    }

    private static float getInterpFactorForBase(Point3d point3d, Point3d point3d2, Point3d point3d3, int n) {
        float f;
        switch (n) {
            case 1: {
                if (point3d2.x == point3d3.x) {
                    f = Float.MAX_VALUE;
                    break;
                }
                f = (float)((point3d2.x - point3d.x) / (point3d2.x - point3d3.x));
                break;
            }
            case 2: {
                if (point3d2.y == point3d3.y) {
                    f = Float.MAX_VALUE;
                    break;
                }
                f = (float)((point3d2.y - point3d.y) / (point3d2.y - point3d3.y));
                break;
            }
            case 3: {
                if (point3d2.z == point3d3.z) {
                    f = Float.MAX_VALUE;
                    break;
                }
                f = (float)((point3d2.z - point3d.z) / (point3d2.z - point3d3.z));
                break;
            }
            default: {
                throw new RuntimeException("invalid axis parameter " + n + " (must be 0-2)");
            }
        }
        return f;
    }

    double[] getInterpWeights() {
        Point3d point3d = this.getPointCoordinatesVW();
        Point3d[] point3dArray = this.getPrimitiveCoordinatesVW();
        if (this.interpWeights != null) {
            return this.interpWeights;
        }
        this.interpWeights = new double[point3dArray.length];
        switch (point3dArray.length) {
            case 1: {
                this.interpWeights[0] = 1.0;
                break;
            }
            case 2: {
                double d;
                Vector3d vector3d = new Vector3d();
                vector3d.sub((Tuple3d)point3dArray[1], (Tuple3d)point3dArray[0]);
                int n = this.maxAxis(vector3d);
                this.interpWeights[0] = d = (double)PickIntersection.getInterpFactor(point3d, point3dArray[1], point3dArray[0], n);
                this.interpWeights[1] = 1.0 - d;
                break;
            }
            case 3: {
                if (this.interpTriangle(0, 1, 2, point3dArray, point3d)) break;
                throw new RuntimeException("Interp point outside triangle");
            }
            case 4: {
                if (this.interpTriangle(0, 1, 2, point3dArray, point3d) || this.interpTriangle(0, 2, 3, point3dArray, point3d)) break;
                throw new RuntimeException("Interp point outside quad");
            }
            default: {
                throw new RuntimeException("Unexpected number of points.");
            }
        }
        return this.interpWeights;
    }

    PickResult getPickResult() {
        return this.pickResult;
    }

    public Color4f getPointColor() {
        if (this.hasColors && this.pointColor == null) {
            double[] dArray = this.getInterpWeights();
            Color4f[] color4fArray = this.getPrimitiveColors();
            this.pointColor = new Color4f();
            int n = 0;
            while (n < dArray.length) {
                this.pointColor.x += (float)dArray[n] * color4fArray[n].x;
                this.pointColor.y += (float)dArray[n] * color4fArray[n].y;
                this.pointColor.z += (float)dArray[n] * color4fArray[n].z;
                this.pointColor.w += (float)dArray[n] * color4fArray[n].w;
                ++n;
            }
        }
        return this.pointColor;
    }

    public Point3d getPointCoordinates() {
        if (this.pointCoordinates == null) {
            double[] dArray = this.getInterpWeights();
            Point3d[] point3dArray = this.getPrimitiveCoordinates();
            this.pointCoordinates = new Point3d();
            int n = 0;
            while (n < dArray.length) {
                this.pointCoordinates.x += dArray[n] * point3dArray[n].x;
                this.pointCoordinates.y += dArray[n] * point3dArray[n].y;
                this.pointCoordinates.z += dArray[n] * point3dArray[n].z;
                ++n;
            }
        }
        return this.pointCoordinates;
    }

    public Point3d getPointCoordinatesVW() {
        return this.pointCoordinatesVW;
    }

    public Vector3f getPointNormal() {
        if (this.hasNormals && this.pointNormal == null) {
            double[] dArray = this.getInterpWeights();
            Vector3f[] vector3fArray = this.getPrimitiveNormals();
            this.pointNormal = new Vector3f();
            int n = 0;
            while (n < dArray.length) {
                this.pointNormal.x += (float)dArray[n] * vector3fArray[n].x;
                this.pointNormal.y += (float)dArray[n] * vector3fArray[n].y;
                this.pointNormal.z += (float)dArray[n] * vector3fArray[n].z;
                ++n;
            }
        }
        return this.pointNormal;
    }

    public TexCoord3f getPointTextureCoordinate(int n) {
        if (this.hasColors && this.pointTexCoord == null) {
            double[] dArray = this.getInterpWeights();
            TexCoord3f[] texCoord3fArray = this.getPrimitiveTexCoords(n);
            this.pointTexCoord = new TexCoord3f();
            int n2 = 0;
            while (n2 < dArray.length) {
                this.pointTexCoord.x += (float)dArray[n2] * texCoord3fArray[n2].x;
                this.pointTexCoord.y += (float)dArray[n2] * texCoord3fArray[n2].y;
                this.pointTexCoord.z += (float)dArray[n2] * texCoord3fArray[n2].z;
                ++n2;
            }
        }
        return this.pointTexCoord;
    }

    public int[] getPrimitiveColorIndices() {
        if (this.hasColors && this.primitiveColorIndices == null) {
            if (this.geometryIsIndexed()) {
                this.primitiveColorIndices = new int[this.primitiveVertexIndices.length];
                int n = 0;
                while (n < this.primitiveVertexIndices.length) {
                    this.primitiveColorIndices[n] = this.iGeom.getColorIndex(this.primitiveVertexIndices[n]);
                    ++n;
                }
            } else {
                this.primitiveColorIndices = this.primitiveVertexIndices;
            }
        }
        return this.primitiveColorIndices;
    }

    public Color4f[] getPrimitiveColors() {
        block31: {
            if (!this.hasColors || this.primitiveColors != null) break block31;
            this.primitiveColors = new Color4f[this.primitiveVertexIndices.length];
            int[] nArray = this.getPrimitiveColorIndices();
            int n = this.geom.getVertexFormat();
            if ((n & 0x80) == 0) {
                if ((n & 0xC) == 12) {
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        this.primitiveColors[n2] = new Color4f();
                        this.geom.getColor(nArray[n2], this.primitiveColors[n2]);
                        ++n2;
                    }
                } else {
                    Color3f color3f = new Color3f();
                    int n3 = 0;
                    while (n3 < nArray.length) {
                        this.primitiveColors[n3] = new Color4f();
                        this.geom.getColor(nArray[n3], color3f);
                        this.primitiveColors[n3].x = color3f.x;
                        this.primitiveColors[n3].y = color3f.y;
                        this.primitiveColors[n3].z = color3f.z;
                        this.primitiveColors[n3].w = 1.0f;
                        ++n3;
                    }
                }
            } else if ((n & 0x100) == 0) {
                float[] fArray = this.geom.getColorRefFloat();
                if (fArray == null) {
                    byte[] byArray = this.geom.getColorRefByte();
                    if (byArray == null) {
                        Color3f[] color3fArray = this.geom.getColorRef3f();
                        if (color3fArray == null) {
                            Color4f[] color4fArray = this.geom.getColorRef4f();
                            if (color4fArray == null) {
                                Color3b[] color3bArray = this.geom.getColorRef3b();
                                if (color3bArray == null) {
                                    Color4b[] color4bArray = this.geom.getColorRef4b();
                                    int n4 = 0;
                                    while (n4 < nArray.length) {
                                        this.primitiveColors[n4] = new Color4f((float)color4bArray[nArray[n4]].x, (float)color4bArray[nArray[n4]].y, (float)color4bArray[nArray[n4]].z, (float)color4bArray[nArray[n4]].w);
                                        ++n4;
                                    }
                                } else {
                                    int n5 = 0;
                                    while (n5 < nArray.length) {
                                        this.primitiveColors[n5] = new Color4f((float)color3bArray[nArray[n5]].x, (float)color3bArray[nArray[n5]].y, (float)color3bArray[nArray[n5]].z, 1.0f);
                                        ++n5;
                                    }
                                }
                            } else {
                                int n6 = 0;
                                while (n6 < nArray.length) {
                                    this.primitiveColors[n6] = new Color4f(color4fArray[nArray[n6]].x, color4fArray[nArray[n6]].y, color4fArray[nArray[n6]].z, color4fArray[nArray[n6]].w);
                                    ++n6;
                                }
                            }
                        } else {
                            int n7 = 0;
                            while (n7 < nArray.length) {
                                this.primitiveColors[n7] = new Color4f(color3fArray[nArray[n7]].x, color3fArray[nArray[n7]].y, color3fArray[nArray[n7]].z, 1.0f);
                                ++n7;
                            }
                        }
                    } else if ((n & 0xC) == 12) {
                        int n8 = 0;
                        while (n8 < nArray.length) {
                            int n9 = nArray[n8] << 2;
                            this.primitiveColors[n8] = new Color4f((float)byArray[n9], (float)byArray[n9 + 1], (float)byArray[n9 + 2], (float)byArray[n9 + 3]);
                            ++n8;
                        }
                    } else {
                        int n10 = 0;
                        while (n10 < nArray.length) {
                            int n11 = nArray[n10] * 3;
                            this.primitiveColors[n10] = new Color4f((float)byArray[n11], (float)byArray[n11 + 1], (float)byArray[n11 + 2], 1.0f);
                            ++n10;
                        }
                    }
                } else if ((n & 0xC) == 12) {
                    int n12 = 0;
                    while (n12 < nArray.length) {
                        int n13 = nArray[n12] << 2;
                        this.primitiveColors[n12] = new Color4f(fArray[n13], fArray[n13 + 1], fArray[n13 + 2], fArray[n13 + 3]);
                        ++n12;
                    }
                } else {
                    int n14 = 0;
                    while (n14 < nArray.length) {
                        int n15 = nArray[n14] * 3;
                        this.primitiveColors[n14] = new Color4f(fArray[n15], fArray[n15 + 1], fArray[n15 + 2], 1.0f);
                        ++n14;
                    }
                }
            } else {
                float[] fArray = this.geom.getInterleavedVertices();
                int n16 = this.getInterleavedColorOffset(this.geom);
                int n17 = this.getInterleavedStride(this.geom);
                int n18 = 0;
                while (n18 < nArray.length) {
                    int n19 = n17 * nArray[n18] + n16;
                    this.primitiveColors[n18] = (n & 0xC) == 12 ? new Color4f(fArray[n19], fArray[n19 + 1], fArray[n19 + 2], fArray[n19 + 3]) : new Color4f(fArray[n19], fArray[n19 + 1], fArray[n19 + 2], 1.0f);
                    ++n18;
                }
            }
        }
        return this.primitiveColors;
    }

    public int[] getPrimitiveCoordinateIndices() {
        if (this.primitiveCoordinateIndices == null) {
            if (this.geometryIsIndexed()) {
                this.primitiveCoordinateIndices = new int[this.primitiveVertexIndices.length];
                int n = 0;
                while (n < this.primitiveVertexIndices.length) {
                    this.primitiveCoordinateIndices[n] = this.iGeom.getCoordinateIndex(this.primitiveVertexIndices[n]);
                    ++n;
                }
            } else {
                this.primitiveCoordinateIndices = this.primitiveVertexIndices;
            }
        }
        return this.primitiveCoordinateIndices;
    }

    public Point3d[] getPrimitiveCoordinates() {
        block16: {
            if (this.primitiveCoordinates != null) break block16;
            this.primitiveCoordinates = new Point3d[this.primitiveVertexIndices.length];
            int[] nArray = this.getPrimitiveCoordinateIndices();
            int n = this.geom.getVertexFormat();
            if ((n & 0x80) == 0) {
                int n2 = 0;
                while (n2 < nArray.length) {
                    this.primitiveCoordinates[n2] = new Point3d();
                    this.geom.getCoordinate(nArray[n2], this.primitiveCoordinates[n2]);
                    ++n2;
                }
            } else if ((n & 0x100) == 0) {
                double[] dArray = this.geom.getCoordRefDouble();
                if (dArray == null) {
                    float[] fArray = this.geom.getCoordRefFloat();
                    if (fArray == null) {
                        Point3f[] point3fArray = this.geom.getCoordRef3f();
                        if (point3fArray == null) {
                            Point3d[] point3dArray = this.geom.getCoordRef3d();
                            int n3 = 0;
                            while (n3 < nArray.length) {
                                this.primitiveCoordinates[n3] = new Point3d(point3dArray[nArray[n3]].x, point3dArray[nArray[n3]].y, point3dArray[nArray[n3]].z);
                                ++n3;
                            }
                        } else {
                            int n4 = 0;
                            while (n4 < nArray.length) {
                                this.primitiveCoordinates[n4] = new Point3d((double)point3fArray[nArray[n4]].x, (double)point3fArray[nArray[n4]].y, (double)point3fArray[nArray[n4]].z);
                                ++n4;
                            }
                        }
                    } else {
                        int n5 = 0;
                        while (n5 < nArray.length) {
                            int n6 = nArray[n5] * 3;
                            this.primitiveCoordinates[n5] = new Point3d((double)fArray[n6], (double)fArray[n6 + 1], (double)fArray[n6 + 2]);
                            ++n5;
                        }
                    }
                } else {
                    int n7 = 0;
                    while (n7 < nArray.length) {
                        int n8 = nArray[n7] * 3;
                        this.primitiveCoordinates[n7] = new Point3d(dArray[n8], dArray[n8 + 1], dArray[n8 + 2]);
                        ++n7;
                    }
                }
            } else {
                float[] fArray = this.geom.getInterleavedVertices();
                int n9 = this.getInterleavedVertexOffset(this.geom);
                int n10 = n9 + 3;
                int n11 = 0;
                while (n11 < nArray.length) {
                    int n12 = n10 * nArray[n11] + n9;
                    this.primitiveCoordinates[n11] = new Point3d((double)fArray[n12], (double)fArray[n12 + 1], (double)fArray[n12 + 2]);
                    ++n11;
                }
            }
        }
        return this.primitiveCoordinates;
    }

    public Point3d[] getPrimitiveCoordinatesVW() {
        return this.primitiveCoordinatesVW;
    }

    public int[] getPrimitiveNormalIndices() {
        if (this.hasNormals && this.primitiveNormalIndices == null) {
            if (this.geometryIsIndexed()) {
                this.primitiveNormalIndices = new int[this.primitiveVertexIndices.length];
                int n = 0;
                while (n < this.primitiveVertexIndices.length) {
                    this.primitiveNormalIndices[n] = this.iGeom.getNormalIndex(this.primitiveVertexIndices[n]);
                    ++n;
                }
            } else {
                this.primitiveNormalIndices = this.primitiveVertexIndices;
            }
        }
        return this.primitiveNormalIndices;
    }

    public Vector3f[] getPrimitiveNormals() {
        block10: {
            if (!this.hasNormals || this.primitiveNormals != null) break block10;
            this.primitiveNormals = new Vector3f[this.primitiveVertexIndices.length];
            int[] nArray = this.getPrimitiveNormalIndices();
            int n = this.geom.getVertexFormat();
            if ((n & 0x80) == 0) {
                int n2 = 0;
                while (n2 < nArray.length) {
                    this.primitiveNormals[n2] = new Vector3f();
                    this.geom.getNormal(nArray[n2], this.primitiveNormals[n2]);
                    ++n2;
                }
            } else if ((n & 0x100) == 0) {
                float[] fArray = this.geom.getNormalRefFloat();
                if (fArray != null) {
                    int n3 = 0;
                    while (n3 < nArray.length) {
                        int n4 = nArray[n3] * 3;
                        this.primitiveNormals[n3] = new Vector3f(fArray[n4], fArray[n4 + 1], fArray[n4 + 2]);
                        ++n3;
                    }
                } else {
                    Vector3f[] vector3fArray = this.geom.getNormalRef3f();
                    int n5 = 0;
                    while (n5 < nArray.length) {
                        this.primitiveNormals[n5] = new Vector3f(vector3fArray[nArray[n5]].x, vector3fArray[nArray[n5]].y, vector3fArray[nArray[n5]].z);
                        ++n5;
                    }
                }
            } else {
                float[] fArray = this.geom.getInterleavedVertices();
                int n6 = this.getInterleavedColorOffset(this.geom);
                int n7 = this.getInterleavedStride(this.geom);
                int n8 = 0;
                while (n8 < nArray.length) {
                    int n9 = n7 * nArray[n8] + n6;
                    this.primitiveNormals[n8] = new Vector3f(fArray[n9], fArray[n9 + 1], fArray[n9 + 2]);
                    ++n8;
                }
            }
        }
        return this.primitiveNormals;
    }

    public int[] getPrimitiveTexCoordIndices(int n) {
        if (this.hasTexCoords && this.primitiveTexCoordIndices == null) {
            if (this.geometryIsIndexed()) {
                this.primitiveTexCoordIndices = new int[this.primitiveVertexIndices.length];
                int n2 = 0;
                while (n2 < this.primitiveVertexIndices.length) {
                    this.primitiveTexCoordIndices[n2] = this.iGeom.getTextureCoordinateIndex(n, this.primitiveVertexIndices[n2]);
                    ++n2;
                }
            } else {
                this.primitiveTexCoordIndices = this.primitiveVertexIndices;
            }
        }
        return this.primitiveTexCoordIndices;
    }

    public TexCoord3f[] getPrimitiveTexCoords(int n) {
        block16: {
            if (this.primitiveTexCoords != null) break block16;
            this.primitiveTexCoords = new TexCoord3f[this.primitiveVertexIndices.length];
            int[] nArray = this.getPrimitiveTexCoordIndices(n);
            int n2 = this.geom.getVertexFormat();
            if ((n2 & 0x80) == 0) {
                int n3 = 0;
                while (n3 < nArray.length) {
                    this.primitiveTexCoords[n3] = new TexCoord3f();
                    this.geom.getTextureCoordinate(n, nArray[n3], this.primitiveTexCoords[n3]);
                    ++n3;
                }
            } else if ((n2 & 0x100) == 0) {
                float[] fArray = this.geom.getTexCoordRefFloat(n);
                if (fArray != null) {
                    if ((n2 & 0x20) == 32) {
                        int n4 = 0;
                        while (n4 < nArray.length) {
                            int n5 = nArray[n4] << 1;
                            this.primitiveTexCoords[n4] = new TexCoord3f(fArray[n5], fArray[n5 + 1], 0.0f);
                            ++n4;
                        }
                    } else {
                        int n6 = 0;
                        while (n6 < nArray.length) {
                            int n7 = nArray[n6] * 3;
                            this.primitiveTexCoords[n6] = new TexCoord3f(fArray[n7], fArray[n7 + 1], fArray[n7 + 2]);
                            ++n6;
                        }
                    }
                } else {
                    TexCoord2f[] texCoord2fArray = this.geom.getTexCoordRef2f(n);
                    if (texCoord2fArray != null) {
                        int n8 = 0;
                        while (n8 < nArray.length) {
                            this.primitiveTexCoords[n8] = new TexCoord3f(texCoord2fArray[nArray[n8]].x, texCoord2fArray[nArray[n8]].y, 0.0f);
                            ++n8;
                        }
                    } else {
                        TexCoord3f[] texCoord3fArray = this.geom.getTexCoordRef3f(n);
                        int n9 = 0;
                        while (n9 < nArray.length) {
                            this.primitiveTexCoords[n9] = new TexCoord3f(texCoord3fArray[nArray[n9]].x, texCoord3fArray[nArray[n9]].y, texCoord3fArray[nArray[n9]].z);
                            ++n9;
                        }
                    }
                }
            } else {
                float[] fArray = this.geom.getInterleavedVertices();
                int n10 = this.getInterleavedStride(this.geom);
                int n11 = (n2 & 0x20) == 32 ? n << 1 : n * 3;
                int n12 = 0;
                while (n12 < nArray.length) {
                    int n13 = n10 * nArray[n12];
                    this.primitiveTexCoords[n12] = (n2 & 0x20) == 32 ? new TexCoord3f(fArray[n13 + n11], fArray[n13 + 1 + n11], 0.0f) : new TexCoord3f(fArray[n13 + n11], fArray[n13 + 1 + n11], fArray[n13 + 2 + n11]);
                    ++n12;
                }
            }
        }
        return this.primitiveTexCoords;
    }

    public int[] getPrimitiveVertexIndices() {
        return this.primitiveVertexIndices;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean interpTriangle(int n, int n2, int n3, Point3d[] point3dArray, Point3d point3d) {
        double d;
        double d2;
        int n4;
        int n5;
        int n6;
        int n7;
        double[] dArray;
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        vector3d.sub((Tuple3d)point3dArray[n2], (Tuple3d)point3dArray[n]);
        vector3d2.sub((Tuple3d)point3dArray[n3], (Tuple3d)point3dArray[n]);
        vector3d3.sub((Tuple3d)point3dArray[n3], (Tuple3d)point3dArray[n2]);
        double d3 = vector3d.lengthSquared();
        double d4 = vector3d2.lengthSquared();
        double d5 = vector3d3.lengthSquared();
        Vector3d vector3d4 = vector3d;
        double d6 = d3;
        if (d4 > d6) {
            vector3d4 = vector3d2;
            d6 = d4;
        }
        if (d5 > d6) {
            vector3d4 = vector3d3;
        }
        if ((dArray = new double[]{PickIntersection.getInterpFactorForBase(point3d, point3dArray[n2], point3dArray[n3], n7 = this.maxAxis(vector3d4)), PickIntersection.getInterpFactorForBase(point3d, point3dArray[n3], point3dArray[n], n7), PickIntersection.getInterpFactorForBase(point3d, point3dArray[n], point3dArray[n2], n7)})[0] < 0.0 || dArray[0] > 1.0) {
            n6 = n;
            n5 = n2;
            n4 = n3;
            d2 = dArray[2];
            d = 1.0 - dArray[1];
        } else if (dArray[1] < 0.0 || dArray[1] > 1.0) {
            n6 = n2;
            n5 = n3;
            n4 = n;
            d2 = dArray[0];
            d = 1.0 - dArray[2];
        } else {
            n6 = n3;
            n5 = n;
            n4 = n2;
            d2 = dArray[1];
            d = 1.0 - dArray[0];
        }
        Point3d point3d2 = new Point3d(d * point3dArray[n4].x + (1.0 - d) * point3dArray[n6].x, d * point3dArray[n4].y + (1.0 - d) * point3dArray[n6].y, d * point3dArray[n4].z + (1.0 - d) * point3dArray[n6].z);
        Point3d point3d3 = new Point3d(d2 * point3dArray[n5].x + (1.0 - d2) * point3dArray[n6].x, d2 * point3dArray[n5].y + (1.0 - d2) * point3dArray[n6].y, d2 * point3dArray[n5].z + (1.0 - d2) * point3dArray[n6].z);
        vector3d.sub((Tuple3d)point3d2, (Tuple3d)point3d3);
        int n8 = this.maxAxis(vector3d);
        double d7 = PickIntersection.getInterpFactor(point3d, point3d3, point3d2, n8);
        if (d7 < 0.0) {
            if (!(d7 + 1.0E-5 >= 0.0)) return false;
            d7 = 0.0;
        } else if (d7 > 1.0) {
            if (!(d7 - 1.0E-5 <= 1.0)) return false;
            d7 = 1.0;
        }
        this.interpWeights[n6] = 1.0 - d7 * d - d2 + d7 * d2;
        this.interpWeights[n4] = d7 * d;
        this.interpWeights[n5] = d2 - d7 * d2;
        return true;
    }

    int maxAxis(Vector3d vector3d) {
        int n = 1;
        double d = this.abs(vector3d.x);
        if (this.abs(vector3d.y) > d) {
            n = 2;
            d = this.abs(vector3d.y);
        }
        if (this.abs(vector3d.z) > d) {
            n = 3;
        }
        return n;
    }

    void setDistance(double d) {
        this.distance = d;
    }

    void setGeomIndex(int n) {
        this.geomIndex = n;
    }

    void setPointCoordinatesVW(Point3d point3d) {
        if (this.pointCoordinatesVW == null) {
            this.pointCoordinatesVW = new Point3d();
        }
        this.pointCoordinatesVW.x = point3d.x;
        this.pointCoordinatesVW.y = point3d.y;
        this.pointCoordinatesVW.z = point3d.z;
    }

    void setPrimitiveCoordinatesVW(Point3d[] point3dArray) {
        this.primitiveCoordinatesVW = new Point3d[point3dArray.length];
        System.arraycopy(point3dArray, 0, this.primitiveCoordinatesVW, 0, point3dArray.length);
    }

    void setVertexIndices(int[] nArray) {
        this.primitiveVertexIndices = new int[nArray.length];
        System.arraycopy(nArray, 0, this.primitiveVertexIndices, 0, nArray.length);
    }

    void storeClosestVertex() {
        if (this.closestVertexIndex == -1) {
            double d = Double.MAX_VALUE;
            double d2 = Double.MAX_VALUE;
            int n = -1;
            int n2 = 0;
            while (n2 < this.primitiveCoordinatesVW.length) {
                d2 = this.pointCoordinatesVW.distance(this.primitiveCoordinatesVW[n2]);
                if (d2 < d) {
                    n = n2;
                    d = d2;
                }
                ++n2;
            }
            this.closestVertexIndex = n;
        }
    }

    public String toString() {
        int n;
        String string = new String("PickIntersection: ");
        string = String.valueOf(string) + " pickResult = " + this.pickResult + "\n";
        string = String.valueOf(string) + " geomIndex = " + this.geomIndex + "\n";
        if (this.distance != -1.0) {
            string = String.valueOf(string) + " dist:" + this.distance + "\n";
        }
        if (this.pointCoordinates != null) {
            string = String.valueOf(string) + " pt:" + this.pointCoordinates + "\n";
        }
        if (this.pointCoordinatesVW != null) {
            string = String.valueOf(string) + " ptVW:" + this.pointCoordinatesVW + "\n";
        }
        if (this.primitiveCoordinateIndices != null) {
            string = String.valueOf(string) + " prim coordinate ind:\n";
            n = 0;
            while (n < this.primitiveCoordinateIndices.length) {
                string = String.valueOf(string) + " " + this.primitiveCoordinateIndices[n] + "\n";
                ++n;
            }
        }
        if (this.primitiveColorIndices != null) {
            string = String.valueOf(string) + " prim color ind:\n";
            n = 0;
            while (n < this.primitiveColorIndices.length) {
                string = String.valueOf(string) + " " + this.primitiveColorIndices[n] + "\n";
                ++n;
            }
        }
        if (this.primitiveNormalIndices != null) {
            string = String.valueOf(string) + " prim normal ind:\n";
            n = 0;
            while (n < this.primitiveNormalIndices.length) {
                string = String.valueOf(string) + " " + this.primitiveNormalIndices[n] + "\n";
                ++n;
            }
        }
        if (this.primitiveTexCoordIndices != null) {
            string = String.valueOf(string) + " prim texture ind:\n";
            n = 0;
            while (n < this.primitiveTexCoordIndices.length) {
                string = String.valueOf(string) + " " + this.primitiveTexCoordIndices[n] + "\n";
                ++n;
            }
        }
        if (this.closestVertexCoordinates != null) {
            string = String.valueOf(string) + " clos. vert:" + this.closestVertexCoordinates + "\n";
        }
        if (this.closestVertexCoordinatesVW != null) {
            string = String.valueOf(string) + " clos. vert:" + this.closestVertexCoordinatesVW + "\n";
        }
        if (this.closestVertexIndex != -1) {
            string = String.valueOf(string) + " clos. vert. ind.:" + this.closestVertexIndex + "\n";
        }
        return string;
    }

    String toString2() {
        int n;
        String string = new String("PickIntersection: ");
        string = String.valueOf(string) + " geomIndex = " + this.geomIndex + "\n";
        if (this.distance != -1.0) {
            string = String.valueOf(string) + " dist:" + this.distance + "\n";
        }
        if (this.pointCoordinates != null) {
            string = String.valueOf(string) + " pt:" + this.pointCoordinates + "\n";
        }
        if (this.pointCoordinatesVW != null) {
            string = String.valueOf(string) + " ptVW:" + this.pointCoordinatesVW + "\n";
        }
        if (this.primitiveCoordinateIndices != null) {
            string = String.valueOf(string) + " prim coordinate ind:\n";
            n = 0;
            while (n < this.primitiveCoordinateIndices.length) {
                string = String.valueOf(string) + " " + this.primitiveCoordinateIndices[n] + "\n";
                ++n;
            }
        }
        if (this.primitiveColorIndices != null) {
            string = String.valueOf(string) + " prim color ind:\n";
            n = 0;
            while (n < this.primitiveColorIndices.length) {
                string = String.valueOf(string) + " " + this.primitiveColorIndices[n] + "\n";
                ++n;
            }
        }
        if (this.primitiveNormalIndices != null) {
            string = String.valueOf(string) + " prim normal ind:\n";
            n = 0;
            while (n < this.primitiveNormalIndices.length) {
                string = String.valueOf(string) + " " + this.primitiveNormalIndices[n] + "\n";
                ++n;
            }
        }
        if (this.primitiveTexCoordIndices != null) {
            string = String.valueOf(string) + " prim texture ind:\n";
            n = 0;
            while (n < this.primitiveTexCoordIndices.length) {
                string = String.valueOf(string) + " " + this.primitiveTexCoordIndices[n] + "\n";
                ++n;
            }
        }
        if (this.closestVertexCoordinates != null) {
            string = String.valueOf(string) + " clos. vert:" + this.closestVertexCoordinates + "\n";
        }
        if (this.closestVertexCoordinatesVW != null) {
            string = String.valueOf(string) + " clos. vert:" + this.closestVertexCoordinatesVW + "\n";
        }
        if (this.closestVertexIndex != -1) {
            string = String.valueOf(string) + " clos. vert. ind.:" + this.closestVertexIndex + "\n";
        }
        return string;
    }
}

