/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import com.sun.j3d.utils.geometry.GeomBuffer;
import com.sun.j3d.utils.geometry.Primitive;
import com.sun.j3d.utils.geometry.Quadrics;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;

public class Cylinder
extends Primitive {
    float radius;
    float height;
    int xdivisions;
    int ydivisions;
    static final int MID_REZ_DIV_X = 15;
    static final int MID_REZ_DIV_Y = 1;
    public static final int BODY = 0;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;

    public Cylinder() {
        this(1.0f, 2.0f, 1, 15, 1, null);
    }

    public Cylinder(float f, float f2) {
        this(f, f2, 1, 15, 1, null);
    }

    public Cylinder(float f, float f2, int n, int n2, int n3, Appearance appearance) {
        this.radius = f;
        this.height = f2;
        this.xdivisions = n2;
        this.ydivisions = n3;
        this.flags = n;
        boolean bl = (this.flags & 4) == 0;
        Quadrics quadrics = new Quadrics();
        GeomBuffer geomBuffer = null;
        Shape3D[] shape3DArray = new Shape3D[3];
        GeomBuffer geomBuffer2 = this.getCachedGeometry(2, f, f, f2, n2, n3, n);
        if (geomBuffer2 != null) {
            shape3DArray[0] = new Shape3D((Geometry)geomBuffer2.getComputedGeometry());
            this.numVerts += geomBuffer2.getNumVerts();
            this.numTris += geomBuffer2.getNumTris();
        } else {
            geomBuffer = quadrics.cylinder(f, f, f2, n2, n3, bl);
            shape3DArray[0] = new Shape3D((Geometry)geomBuffer.getGeom(this.flags));
            this.numVerts += geomBuffer.getNumVerts();
            this.numTris += geomBuffer.getNumTris();
            if ((n & 0x10) == 0) {
                this.cacheGeometry(2, f, f, f2, n2, n3, n, geomBuffer);
            }
        }
        if ((this.flags & 0x40) != 0) {
            shape3DArray[0].setCapability(14);
            shape3DArray[0].setCapability(15);
        }
        Matrix4d matrix4d = new Matrix4d();
        Matrix4d matrix4d2 = new Matrix4d();
        matrix4d.setIdentity();
        matrix4d2.setIdentity();
        Transform3D transform3D = new Transform3D();
        matrix4d.rotX(-1.5707963267948966);
        matrix4d2.mul(matrix4d2, matrix4d);
        transform3D.set(matrix4d2);
        TransformGroup transformGroup = new TransformGroup();
        transformGroup.setCapability(12);
        transformGroup.setTransform(transform3D);
        transformGroup.addChild((Node)shape3DArray[0]);
        this.addChild((Node)transformGroup);
        geomBuffer = quadrics.disk(f, n2, bl);
        shape3DArray[1] = new Shape3D((Geometry)geomBuffer.getGeom(this.flags));
        if ((this.flags & 0x40) != 0) {
            shape3DArray[1].setCapability(14);
            shape3DArray[1].setCapability(15);
        }
        this.numVerts += geomBuffer.getNumVerts();
        this.numTris += geomBuffer.getNumTris();
        Transform3D transform3D2 = new Transform3D();
        Vector3d vector3d = new Vector3d(0.0, 0.0, (double)f2 / 2.0);
        transform3D2.setTranslation(vector3d);
        TransformGroup transformGroup2 = new TransformGroup();
        transformGroup2.setCapability(12);
        transformGroup2.setTransform(transform3D2);
        transformGroup2.addChild((Node)shape3DArray[1]);
        transformGroup.addChild((Node)transformGroup2);
        geomBuffer = quadrics.disk(f, n2, bl ^ true);
        shape3DArray[2] = new Shape3D((Geometry)geomBuffer.getGeom(this.flags));
        if ((this.flags & 0x40) != 0) {
            shape3DArray[2].setCapability(14);
            shape3DArray[2].setCapability(15);
        }
        this.numVerts += geomBuffer.getNumVerts();
        this.numTris += geomBuffer.getNumTris();
        Transform3D transform3D3 = new Transform3D();
        matrix4d = new Matrix4d();
        matrix4d2 = new Matrix4d();
        matrix4d.setIdentity();
        matrix4d2.setIdentity();
        matrix4d2.mul(matrix4d2, matrix4d);
        transform3D3.set(matrix4d2);
        vector3d = new Vector3d(0.0, 0.0, -1.0 * (double)f2 / 2.0);
        transform3D3.setTranslation(vector3d);
        TransformGroup transformGroup3 = new TransformGroup();
        transformGroup3.setCapability(12);
        transformGroup3.setTransform(transform3D3);
        transformGroup3.addChild((Node)shape3DArray[2]);
        transformGroup.addChild((Node)transformGroup3);
        if (appearance == null) {
            this.setAppearance();
        } else {
            this.setAppearance(appearance);
        }
    }

    public Cylinder(float f, float f2, int n, Appearance appearance) {
        this(f, f2, n, 15, 1, appearance);
    }

    public Cylinder(float f, float f2, Appearance appearance) {
        this(f, f2, 1, 15, 1, appearance);
    }

    public Node cloneNode(boolean bl) {
        Cylinder cylinder = new Cylinder(this.radius, this.height, this.flags, this.xdivisions, this.ydivisions, this.getAppearance());
        cylinder.duplicateNode((Node)this, bl);
        return cylinder;
    }

    public void duplicateNode(Node node, boolean bl) {
        super.duplicateNode(node, bl);
    }

    public Shape3D getShape(int n) {
        if (n == 0) {
            return (Shape3D)((Group)this.getChild(0)).getChild(0);
        }
        if (n == 1) {
            return (Shape3D)((Group)((Group)this.getChild(0)).getChild(1)).getChild(0);
        }
        if (n == 2) {
            return (Shape3D)((Group)((Group)this.getChild(0)).getChild(2)).getChild(0);
        }
        return null;
    }

    public void setAppearance(Appearance appearance) {
        ((Shape3D)((Group)this.getChild(0)).getChild(0)).setAppearance(appearance);
        ((Shape3D)((Group)((Group)this.getChild(0)).getChild(1)).getChild(0)).setAppearance(appearance);
        ((Shape3D)((Group)((Group)this.getChild(0)).getChild(2)).getChild(0)).setAppearance(appearance);
    }
}

