/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.compression;

import com.sun.j3d.utils.compression.CompressionStreamElement;

class CommandStream {
    static final int SET_NORM = 192;
    static final int SET_COLOR = 128;
    static final int VERTEX = 64;
    static final int MESH_B_R = 32;
    static final int SET_STATE = 24;
    static final int SET_TABLE = 16;
    static final int V_NO_OP = 1;
    static final int POSITION_TABLE = 0;
    static final int COLOR_TABLE = 1;
    static final int NORMAL_TABLE = 2;
    private byte[] bytes;
    private int byteOffset;
    private int bitOffset;
    private long lastBody;
    private int lastBodyLength;

    CommandStream() {
        this(65536);
    }

    CommandStream(int n) {
        this.bytes = new byte[n];
        this.clear();
    }

    private void addByte(int n, int n2) {
        int n3 = 8 - this.bitOffset;
        n &= (int)CompressionStreamElement.lengthMask[n2];
        if (n2 <= n3) {
            int n4 = this.byteOffset;
            this.bytes[n4] = (byte)(this.bytes[n4] | n << n3 - n2);
            this.bitOffset += n2;
            return;
        }
        if (this.bytes.length == this.byteOffset + 1) {
            byte[] byArray = new byte[this.bytes.length * 2];
            System.arraycopy(this.bytes, 0, byArray, 0, this.bytes.length);
            this.bytes = byArray;
        }
        this.bitOffset = n2 - n3;
        int n5 = this.byteOffset++;
        this.bytes[n5] = (byte)(this.bytes[n5] | n >>> this.bitOffset);
        this.bytes[this.byteOffset] = (byte)(n << 8 - this.bitOffset);
    }

    void addCommand(int n, int n2, long l, int n3) {
        this.addByte(n, n2);
        this.addLong(this.lastBody, this.lastBodyLength);
        this.lastBody = l;
        this.lastBodyLength = n3;
    }

    private void addLong(long l, int n) {
        int n2 = n / 8;
        int n3 = n - n2 * 8;
        if (n3 > 0) {
            this.addByte((int)(l >>> n2 * 8), n3);
        }
        while (n2 > 0) {
            this.addByte((int)(l >>> (n2 - 1) * 8 & 0xFFL), 8);
            --n2;
        }
    }

    void clear() {
        this.bytes[0] = 0;
        this.bitOffset = 0;
        this.byteOffset = 0;
        this.lastBody = 0L;
        this.lastBodyLength = 5;
    }

    void end() {
        int n;
        this.addByte(1, 8);
        this.addLong(this.lastBody, this.lastBodyLength);
        int n2 = (this.byteOffset + 1) % 8;
        if (n2 == 0 && this.bitOffset == 8) {
            return;
        }
        this.addByte(1, 8);
        n2 = (this.byteOffset + 1) % 8;
        if (n2 == 0) {
            n = 8 - this.bitOffset;
        } else {
            int n3 = 8 - n2;
            n = 8 * n3 + (8 - this.bitOffset);
        }
        if (n < 5) {
            n += 64;
        }
        if (n < 37) {
            this.addLong(n - 5 << n - 5, n);
            return;
        }
        this.addLong(0x980000L, 24);
        n -= 24;
        this.addByte(1, 8);
        this.addLong((n -= 8) - 5 << n - 5, n);
    }

    int getByteCount() {
        if (this.byteOffset + this.bitOffset == 0) {
            return 0;
        }
        return this.byteOffset + 1;
    }

    byte[] getBytes() {
        return this.bytes;
    }
}

