/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.behaviors.interpolators;

import com.sun.j3d.utils.behaviors.interpolators.CubicSplineCurve;
import com.sun.j3d.utils.behaviors.interpolators.CubicSplineSegment;
import com.sun.j3d.utils.behaviors.interpolators.TCBKeyFrame;
import com.sun.j3d.utils.behaviors.interpolators.TCBSplinePathInterpolator;
import java.util.Enumeration;
import javax.media.j3d.Alpha;
import javax.media.j3d.Node;
import javax.media.j3d.NodeReferenceTable;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;

public class RotPosScaleTCBSplinePathInterpolator
extends TCBSplinePathInterpolator {
    TransformGroup target;
    Transform3D axis = new Transform3D();
    Transform3D axisInverse = new Transform3D();
    Transform3D rotation = new Transform3D();
    Transform3D temp = new Transform3D();
    Matrix4d tMat = new Matrix4d();
    Matrix4d sMat = new Matrix4d();
    Quat4f iQuat = new Quat4f();
    Vector3f iPos = new Vector3f();
    Point3f iScale = new Point3f();
    CubicSplineCurve cubicSplineCurve = new CubicSplineCurve();
    CubicSplineSegment[] cubicSplineSegments;
    int numSegments;
    int currentSegmentIndex;
    CubicSplineSegment currentSegment;

    RotPosScaleTCBSplinePathInterpolator() {
    }

    public RotPosScaleTCBSplinePathInterpolator(Alpha alpha, TransformGroup transformGroup, Transform3D transform3D, TCBKeyFrame[] tCBKeyFrameArray) {
        super(alpha, tCBKeyFrameArray);
        this.target = transformGroup;
        this.axis.set(transform3D);
        this.axisInverse.invert(this.axis);
        this.cubicSplineCurve = new CubicSplineCurve(this.keyFrames);
        this.numSegments = this.cubicSplineCurve.numSegments;
    }

    public Node cloneNode(boolean bl) {
        RotPosScaleTCBSplinePathInterpolator rotPosScaleTCBSplinePathInterpolator = new RotPosScaleTCBSplinePathInterpolator();
        rotPosScaleTCBSplinePathInterpolator.duplicateNode((Node)this, bl);
        return rotPosScaleTCBSplinePathInterpolator;
    }

    public void duplicateNode(Node node, boolean bl) {
        super.duplicateNode(node, bl);
        RotPosScaleTCBSplinePathInterpolator rotPosScaleTCBSplinePathInterpolator = (RotPosScaleTCBSplinePathInterpolator)node;
        this.setAxisOfRotPosScale(rotPosScaleTCBSplinePathInterpolator.axis);
        this.target = rotPosScaleTCBSplinePathInterpolator.target;
        this.cubicSplineCurve = new CubicSplineCurve(rotPosScaleTCBSplinePathInterpolator.keyFrames);
        this.numSegments = this.cubicSplineCurve.numSegments;
    }

    public Transform3D getAxisOfRotPosScale() {
        return new Transform3D(this.axis);
    }

    public TransformGroup getTarget() {
        return this.target;
    }

    public void processStimulus(Enumeration enumeration) {
        if (this.getAlpha() != null) {
            this.computePathInterpolation();
            this.currentSegmentIndex = this.lowerKnot - 1;
            if (this.currentSegmentIndex == 0 && this.currentU == 0.0f) {
                this.iQuat.set((Tuple4f)this.keyFrames[1].quat);
                this.iPos.set((Tuple3f)this.keyFrames[1].position);
                this.iScale.set((Tuple3f)this.keyFrames[1].scale);
            } else if (this.currentSegmentIndex == this.numSegments - 1 && (double)this.currentU == 1.0) {
                this.iQuat.set((Tuple4f)this.keyFrames[this.upperKnot].quat);
                this.iPos.set((Tuple3f)this.keyFrames[this.upperKnot].position);
                this.iScale.set((Tuple3f)this.keyFrames[this.upperKnot].scale);
            } else {
                this.currentSegment = this.cubicSplineCurve.getSegment(this.currentSegmentIndex);
                this.currentSegment.getInterpolatedQuaternion(this.currentU, this.iQuat);
                this.currentSegment.getInterpolatedPositionVector(this.currentU, this.iPos);
                this.currentSegment.getInterpolatedScale(this.currentU, this.iScale);
            }
            this.iQuat.normalize();
            this.sMat.set((double)this.iScale.x);
            this.tMat.set(this.iQuat);
            this.tMat.mul(this.sMat);
            this.tMat.m03 = this.iPos.x;
            this.tMat.m13 = this.iPos.y;
            this.tMat.m23 = this.iPos.z;
            this.rotation.set(this.tMat);
            this.temp.mul(this.axis, this.rotation);
            this.temp.mul(this.temp, this.axisInverse);
            this.target.setTransform(this.temp);
        }
        this.wakeupOn((WakeupCondition)this.defaultWakeupCriterion);
    }

    public void setAxisOfRotPosScale(Transform3D transform3D) {
        this.axis.set(transform3D);
        this.axisInverse.invert(this.axis);
    }

    public void setTarget(TransformGroup transformGroup) {
        this.target = transformGroup;
    }

    public void updateNodeReferences(NodeReferenceTable nodeReferenceTable) {
        TransformGroup transformGroup = (TransformGroup)nodeReferenceTable.getNewObjectReference((SceneGraphObject)this.target);
        this.setTarget(transformGroup);
    }
}

