/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.audioengines;

import com.sun.j3d.audioengines.AuralParameters;
import javax.media.j3d.MediaContainer;
import javax.media.j3d.Transform3D;
import javax.media.j3d.View;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class Sample {
    protected static final boolean debugFlag = false;
    protected static final boolean internalErrors = false;
    protected static final int NULL_SAMPLE = -1;
    protected MediaContainer soundData = null;
    protected int soundType = -1;
    protected float gain = 1.0f;
    protected int loopCount = 0;
    protected long duration = 0L;
    protected int numberOfChannels = 0;
    protected boolean mute = false;
    protected Transform3D vworldXfrm = new Transform3D();
    protected boolean vwXfrmFlag = false;
    protected Point3f position = new Point3f(0.0f, 0.0f, 0.0f);
    protected double[] attenuationDistance = null;
    protected float[] attenuationGain = null;
    protected int dirtyFlags = 65535;
    protected Vector3f direction = new Vector3f(0.0f, 0.0f, 1.0f);
    protected double[] backAttenuationDistance = null;
    protected float[] backAttenuationGain = null;
    protected double[] angularDistance;
    protected float[] angularGain;
    protected static final int NO_FILTERING = -1;
    protected static final int LOW_PASS = 1;
    protected int angularFilterType;
    protected float[] angularFilterCutoff;

    public Sample() {
        double[] dArray = new double[2];
        dArray[1] = 1.5707963267948966;
        this.angularDistance = dArray;
        float[] fArray = new float[2];
        fArray[0] = 1.0f;
        this.angularGain = fArray;
        this.angularFilterType = -1;
        this.angularFilterCutoff = new float[]{-1.0f, -1.0f};
    }

    public void clear() {
        this.soundData = null;
        this.soundType = -1;
        this.gain = 1.0f;
        this.loopCount = 0;
        this.duration = 0L;
        this.numberOfChannels = 0;
        this.vworldXfrm.setIdentity();
        this.vwXfrmFlag = false;
        this.position.set(0.0f, 0.0f, 0.0f);
        this.attenuationDistance = null;
        this.attenuationGain = null;
        this.direction.set(0.0f, 0.0f, 1.0f);
        this.backAttenuationDistance = null;
        this.backAttenuationGain = null;
        this.angularDistance[0] = 0.0;
        this.angularDistance[1] = 1.5707963705062866;
        this.angularGain[0] = 1.0f;
        this.angularGain[1] = 0.0f;
        this.angularFilterType = -1;
        this.angularFilterCutoff[0] = -1.0f;
        this.angularFilterCutoff[1] = -1.0f;
    }

    protected void debugPrint(String string) {
    }

    protected void debugPrintln(String string) {
    }

    public int getDirtyFlags() {
        return this.dirtyFlags;
    }

    public long getDuration() {
        return 0L;
    }

    public int getLoopCount() {
        return this.loopCount;
    }

    public boolean getMuteFlag() {
        return this.mute;
    }

    public int getNumberOfChannelsUsed() {
        return 0;
    }

    public MediaContainer getSoundData() {
        return this.soundData;
    }

    public int getSoundType() {
        return this.soundType;
    }

    public long getStartTime() {
        return 0L;
    }

    public boolean getVWrldXfrmFlag() {
        return this.vwXfrmFlag;
    }

    public void render(int n, View view, AuralParameters auralParameters) {
    }

    public void setAngularAttenuation(int n, double[] dArray, float[] fArray, float[] fArray2) {
        if (dArray != null) {
            int n2 = dArray.length;
            this.angularDistance = new double[n2];
            this.angularGain = new float[n2];
            this.angularFilterCutoff = (float[])(n != -1 && fArray2 != null ? new float[n2] : null);
            int n3 = 0;
            while (n3 < n2) {
                this.angularDistance[n3] = dArray[n3];
                this.angularGain[n3] = fArray[n3];
                if (n != -1) {
                    this.angularFilterCutoff[n3] = fArray2[n3];
                }
                ++n3;
            }
            this.angularFilterType = n;
        } else {
            this.angularDistance = null;
            this.angularGain = null;
            this.angularFilterCutoff = null;
            this.angularFilterType = -1;
        }
    }

    public void setDirection(Vector3d vector3d) {
        this.direction.set((Tuple3d)vector3d);
    }

    public void setDirtyFlags(int n) {
        this.dirtyFlags = n;
    }

    public void setDistanceGain(double[] dArray, float[] fArray, double[] dArray2, float[] fArray2) {
        int n;
        int n2;
        if (dArray != null) {
            n2 = dArray.length;
            this.attenuationDistance = new double[n2];
            this.attenuationGain = new float[n2];
            n = 0;
            while (n < n2) {
                this.attenuationDistance[n] = dArray[n];
                this.attenuationGain[n] = fArray[n];
                ++n;
            }
        } else {
            this.attenuationDistance = null;
            this.attenuationGain = null;
        }
        if (dArray2 != null && dArray != null) {
            n2 = dArray2.length;
            this.backAttenuationDistance = new double[n2];
            this.backAttenuationGain = new float[n2];
            n = 0;
            while (n < n2) {
                this.backAttenuationDistance[n] = dArray2[n];
                this.backAttenuationGain[n] = fArray2[n];
                ++n;
            }
        } else {
            this.backAttenuationDistance = null;
            this.backAttenuationGain = null;
        }
    }

    public void setGain(float f) {
        this.gain = f;
    }

    public void setLoopCount(int n) {
        this.loopCount = n;
    }

    public void setMuteFlag(boolean bl) {
        this.mute = bl;
    }

    public void setPosition(Point3d point3d) {
        this.position.set((Tuple3d)point3d);
    }

    public void setSoundData(MediaContainer mediaContainer) {
        this.soundData = mediaContainer;
    }

    public void setSoundType(int n) {
        this.soundType = n;
    }

    public void setVWrldXfrmFlag(boolean bl) {
        this.vwXfrmFlag = bl;
    }

    public void stop() {
    }
}

