/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ttest;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.HCLSigOnlyPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.util.StringSplitter;

public class TtestInitDialog
extends AlgorithmDialog {
    GroupExperimentsPanel gPanel;
    OneClassPanel oPanel;
    TwoClassPairedMainPanel tcpmPanel;
    PValuePanel pPanel;
    SignificancePanel sPanel;
    HCLSigOnlyPanel hclOpsPanel;
    Vector exptNames;
    JTabbedPane chooseDesignPane;
    DfCalcPanel dPanel;
    public static final int GROUP_A = 1;
    public static final int GROUP_B = 2;
    public static final int NEITHER_GROUP = 3;
    public static final int JUST_ALPHA = 4;
    public static final int STD_BONFERRONI = 5;
    public static final int ADJ_BONFERRONI = 6;
    public static final int BETWEEN_SUBJECTS = 7;
    public static final int ONE_CLASS = 8;
    public static final int MAX_T = 9;
    public static final int MIN_P = 10;
    public static final int PAIRED = 11;
    public static final int FALSE_NUM = 12;
    public static final int FALSE_PROP = 13;
    boolean okPressed = false;
    boolean permParamOkPressed = false;
    private int userNumCombs = 0;
    private boolean allCombsUsed = false;
    private int allPossCombs;
    private Color LABEL_COLOR = UIManager.getColor("Label.foreground");
    boolean tooMany = false;
    int count;

    public TtestInitDialog(JFrame jFrame, boolean bl, Vector vector) {
        super(jFrame, "TTEST: T-test", bl);
        this.exptNames = vector;
        this.setBounds(0, 0, 800, 850);
        this.setDefaultCloseOperation(2);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        this.chooseDesignPane = new JTabbedPane();
        this.sPanel = new SignificancePanel();
        this.pPanel = new PValuePanel();
        this.gPanel = new GroupExperimentsPanel(vector);
        this.count = 0;
        while (this.count < this.gPanel.groupARadioButtons.length) {
            this.gPanel.groupARadioButtons[this.count].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TtestInitDialog.this.pPanel.tDistButton.setSelected(true);
                    TtestInitDialog.this.sPanel.justAlphaButton.setSelected(true);
                    TtestInitDialog.this.sPanel.maxTButton.setSelected(false);
                    TtestInitDialog.this.sPanel.maxTButton.setEnabled(false);
                    TtestInitDialog.this.sPanel.minPButton.setSelected(false);
                    TtestInitDialog.this.sPanel.minPButton.setEnabled(false);
                    TtestInitDialog.this.pPanel.randomGroupsButton.setEnabled(false);
                    TtestInitDialog.this.pPanel.allCombsButton.setEnabled(false);
                    TtestInitDialog.this.pPanel.timesField.setEnabled(false);
                    TtestInitDialog.this.pPanel.numCombsLabel.setText("                                                                            ");
                }
            });
            ++this.count;
        }
        this.count = 0;
        while (this.count < this.gPanel.groupBRadioButtons.length) {
            this.gPanel.groupBRadioButtons[this.count].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TtestInitDialog.this.pPanel.tDistButton.setSelected(true);
                    TtestInitDialog.this.sPanel.justAlphaButton.setSelected(true);
                    TtestInitDialog.this.sPanel.maxTButton.setSelected(false);
                    TtestInitDialog.this.sPanel.maxTButton.setEnabled(false);
                    TtestInitDialog.this.sPanel.minPButton.setSelected(false);
                    TtestInitDialog.this.sPanel.minPButton.setEnabled(false);
                    TtestInitDialog.this.pPanel.randomGroupsButton.setEnabled(false);
                    TtestInitDialog.this.pPanel.allCombsButton.setEnabled(false);
                    TtestInitDialog.this.pPanel.timesField.setEnabled(false);
                    TtestInitDialog.this.pPanel.numCombsLabel.setText("                                                                            ");
                }
            });
            ++this.count;
        }
        this.count = 0;
        while (this.count < this.gPanel.neitherGroupRadioButtons.length) {
            this.gPanel.neitherGroupRadioButtons[this.count].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TtestInitDialog.this.pPanel.tDistButton.setSelected(true);
                    TtestInitDialog.this.sPanel.justAlphaButton.setSelected(true);
                    TtestInitDialog.this.sPanel.maxTButton.setSelected(false);
                    TtestInitDialog.this.sPanel.maxTButton.setEnabled(false);
                    TtestInitDialog.this.sPanel.minPButton.setSelected(false);
                    TtestInitDialog.this.sPanel.minPButton.setEnabled(false);
                    TtestInitDialog.this.pPanel.randomGroupsButton.setEnabled(false);
                    TtestInitDialog.this.pPanel.allCombsButton.setEnabled(false);
                    TtestInitDialog.this.pPanel.timesField.setEnabled(false);
                    TtestInitDialog.this.pPanel.numCombsLabel.setText("                                                                            ");
                }
            });
            ++this.count;
        }
        this.count = 0;
        this.oPanel = new OneClassPanel();
        for (int i = 0; i < this.oPanel.includeExpts.length; ++i) {
            this.oPanel.includeExpts[i].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TtestInitDialog.this.pPanel.tDistButton.setSelected(true);
                    TtestInitDialog.this.sPanel.justAlphaButton.setSelected(true);
                    TtestInitDialog.this.sPanel.maxTButton.setSelected(false);
                    TtestInitDialog.this.sPanel.maxTButton.setEnabled(false);
                    TtestInitDialog.this.sPanel.minPButton.setSelected(false);
                    TtestInitDialog.this.sPanel.minPButton.setEnabled(false);
                    TtestInitDialog.this.pPanel.randomGroupsButton.setEnabled(false);
                    TtestInitDialog.this.pPanel.allCombsButton.setEnabled(false);
                    TtestInitDialog.this.pPanel.timesField.setEnabled(false);
                    TtestInitDialog.this.pPanel.numCombsLabel.setText("                                                                            ");
                }
            });
        }
        this.chooseDesignPane.add("One-class", this.oPanel);
        this.chooseDesignPane.add("Between subjects", this.gPanel);
        this.tcpmPanel = new TwoClassPairedMainPanel();
        this.chooseDesignPane.add("Paired", this.tcpmPanel);
        this.pPanel.tDistButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TtestInitDialog.this.sPanel.justAlphaButton.setSelected(true);
                TtestInitDialog.this.sPanel.maxTButton.setSelected(false);
                TtestInitDialog.this.sPanel.maxTButton.setEnabled(false);
                TtestInitDialog.this.sPanel.minPButton.setSelected(false);
                TtestInitDialog.this.sPanel.minPButton.setEnabled(false);
                TtestInitDialog.this.sPanel.falseNumButton.setEnabled(false);
                TtestInitDialog.this.sPanel.falsePropButton.setEnabled(false);
                TtestInitDialog.this.sPanel.calcFDRPVals.setEnabled(false);
                TtestInitDialog.this.sPanel.fastFDRButton.setEnabled(false);
                TtestInitDialog.this.sPanel.slowFDRButton.setEnabled(false);
                TtestInitDialog.this.sPanel.falseNumField.setEnabled(false);
                TtestInitDialog.this.sPanel.falsePropField.setEnabled(false);
            }
        });
        this.pPanel.permutButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == TtestInitDialog.this.pPanel.permutButton) {
                    TtestInitDialog.this.sPanel.maxTButton.setEnabled(true);
                    TtestInitDialog.this.sPanel.falseNumButton.setEnabled(true);
                    TtestInitDialog.this.sPanel.falsePropButton.setEnabled(true);
                    TtestInitDialog.this.sPanel.fastFDRButton.setEnabled(true);
                    TtestInitDialog.this.sPanel.falseNumField.setEnabled(true);
                    TtestInitDialog.this.sPanel.falsePropField.setEnabled(true);
                    if (TtestInitDialog.this.getTestDesign() == 7) {
                        int n;
                        int[] nArray = TtestInitDialog.this.getGroupAssignments();
                        int n2 = 0;
                        int n3 = 0;
                        for (n = 0; n < nArray.length; ++n) {
                            if (nArray[n] == 1) {
                                ++n2;
                                continue;
                            }
                            if (nArray[n] != 2) continue;
                            ++n3;
                        }
                        if (n2 < 2 || n3 < 2) {
                            TtestInitDialog.this.pPanel.numCombsLabel.setForeground(Color.red);
                            TtestInitDialog.this.pPanel.numCombsLabel.setText("Error! Group A and Group B must each contain more than one sample");
                        } else {
                            n = 0;
                            TtestInitDialog.this.pPanel.numCombsLabel.setForeground(Color.black);
                            TtestInitDialog.this.pPanel.numCombsLabel.setText("There are too many unique permutations                                  ");
                            TtestInitDialog.this.pPanel.allCombsButton.setEnabled(false);
                            TtestInitDialog.this.pPanel.randomGroupsButton.setEnabled(true);
                            TtestInitDialog.this.pPanel.randomGroupsButton.setSelected(true);
                            TtestInitDialog.this.pPanel.timesField.setEnabled(true);
                            TtestInitDialog.this.pPanel.timesField.setBackground(Color.white);
                            TtestInitDialog.this.pPanel.timesField.setText("100");
                            if (n2 + n3 <= 20) {
                                n = TtestInitDialog.this.getNumCombs(n2 + n3, n2);
                                TtestInitDialog.this.pPanel.numCombsLabel.setForeground(Color.black);
                                TtestInitDialog.this.pPanel.numCombsLabel.setText("There are " + n + " unique permutations                                ");
                                TtestInitDialog.this.allPossCombs = n;
                                TtestInitDialog.this.pPanel.allCombsButton.setEnabled(true);
                                TtestInitDialog.this.pPanel.randomGroupsButton.setEnabled(true);
                            }
                        }
                    } else if (TtestInitDialog.this.getTestDesign() == 8) {
                        TtestInitDialog.this.pPanel.numCombsLabel.setForeground(Color.black);
                        int n = TtestInitDialog.this.getNumValidOneClassExpts();
                        if (n <= 1) {
                            TtestInitDialog.this.pPanel.numCombsLabel.setForeground(Color.red);
                            TtestInitDialog.this.pPanel.numCombsLabel.setText("Error! Choose at least two samples");
                            TtestInitDialog.this.pPanel.randomGroupsButton.setEnabled(false);
                            TtestInitDialog.this.pPanel.timesField.setBackground(Color.gray);
                            TtestInitDialog.this.pPanel.timesField.setEnabled(false);
                        } else if (n <= 29) {
                            TtestInitDialog.this.pPanel.numCombsLabel.setText("There are " + (int)Math.pow(2.0, n) + " possible combinations                    ");
                            TtestInitDialog.this.pPanel.randomGroupsButton.setEnabled(true);
                            TtestInitDialog.this.pPanel.allCombsButton.setEnabled(true);
                            TtestInitDialog.this.pPanel.timesField.setBackground(Color.white);
                            TtestInitDialog.this.pPanel.timesField.setEnabled(true);
                        } else {
                            TtestInitDialog.this.pPanel.numCombsLabel.setText("There are too many unique combinations                                       ");
                            TtestInitDialog.this.pPanel.timesField.setBackground(Color.white);
                            TtestInitDialog.this.pPanel.timesField.setEnabled(true);
                            TtestInitDialog.this.pPanel.randomGroupsButton.setEnabled(true);
                            TtestInitDialog.this.pPanel.randomGroupsButton.setSelected(true);
                        }
                    } else if (TtestInitDialog.this.getTestDesign() == 11) {
                        if (TtestInitDialog.this.tcpmPanel.tcpPanel.pairedListModel.size() < 2) {
                            JOptionPane.showMessageDialog(null, "Need at least two pairs of samples!", "Error", 0);
                        } else if (TtestInitDialog.this.tcpmPanel.tcpPanel.pairedListModel.size() <= 29) {
                            TtestInitDialog.this.pPanel.numCombsLabel.setText("There are " + (int)Math.pow(2.0, TtestInitDialog.this.tcpmPanel.tcpPanel.pairedListModel.size()) + " possible combinations                    ");
                            TtestInitDialog.this.pPanel.randomGroupsButton.setEnabled(true);
                            TtestInitDialog.this.pPanel.allCombsButton.setEnabled(true);
                            TtestInitDialog.this.pPanel.timesField.setBackground(Color.white);
                            TtestInitDialog.this.pPanel.timesField.setEnabled(true);
                        } else {
                            TtestInitDialog.this.pPanel.numCombsLabel.setText("There are too many unique combinations                                       ");
                            TtestInitDialog.this.pPanel.timesField.setBackground(Color.white);
                            TtestInitDialog.this.pPanel.timesField.setEnabled(true);
                            TtestInitDialog.this.pPanel.randomGroupsButton.setEnabled(true);
                            TtestInitDialog.this.pPanel.randomGroupsButton.setSelected(true);
                        }
                    }
                }
            }
        });
        this.chooseDesignPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                TtestInitDialog.this.pPanel.tDistButton.setSelected(true);
                TtestInitDialog.this.sPanel.justAlphaButton.setSelected(true);
                TtestInitDialog.this.sPanel.maxTButton.setSelected(false);
                TtestInitDialog.this.sPanel.maxTButton.setEnabled(false);
                TtestInitDialog.this.sPanel.minPButton.setSelected(false);
                TtestInitDialog.this.sPanel.minPButton.setEnabled(false);
                TtestInitDialog.this.pPanel.allCombsButton.setEnabled(false);
                TtestInitDialog.this.pPanel.randomGroupsButton.setEnabled(false);
                TtestInitDialog.this.pPanel.numCombsLabel.setForeground(Color.black);
                TtestInitDialog.this.pPanel.numCombsLabel.setText("");
                TtestInitDialog.this.pPanel.timesField.setEnabled(false);
                if (TtestInitDialog.this.getTestDesign() == 8) {
                    TtestInitDialog.this.pPanel.numCombsLabel.setForeground(Color.black);
                    TtestInitDialog.this.pPanel.numCombsLabel.setText("");
                }
            }
        });
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 45);
        gridBagLayout.setConstraints(this.chooseDesignPane, gridBagConstraints);
        jPanel.add(this.chooseDesignPane);
        this.dPanel = new DfCalcPanel();
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 0, 5);
        gridBagLayout.setConstraints(this.dPanel, gridBagConstraints);
        jPanel.add(this.dPanel);
        this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 0, 20);
        gridBagLayout.setConstraints(this.pPanel, gridBagConstraints);
        jPanel.add(this.pPanel);
        this.buildConstraints(gridBagConstraints, 0, 3, 1, 1, 0, 25);
        gridBagLayout.setConstraints(this.sPanel, gridBagConstraints);
        jPanel.add(this.sPanel);
        this.hclOpsPanel = new HCLSigOnlyPanel();
        this.buildConstraints(gridBagConstraints, 0, 4, 1, 1, 0, 5);
        gridBagLayout.setConstraints(this.hclOpsPanel, gridBagConstraints);
        jPanel.add(this.hclOpsPanel);
        this.addContent(jPanel);
        this.setActionListeners(new EventListener());
        this.pack();
    }

    public void setVisible(boolean bl) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        super.setVisible(bl);
    }

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    private long factorial(int n) {
        if (n == 1 || n == 0) {
            return 1L;
        }
        return this.factorial(n - 1) * (long)n;
    }

    private int getNumCombs(int n, int n2) {
        return Math.round(this.factorial(n) / (this.factorial(n2) * this.factorial(n - n2)));
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public boolean isDrawTrees() {
        return this.hclOpsPanel.isHCLSelected();
    }

    public boolean drawSigTreesOnly() {
        return this.hclOpsPanel.drawSigTreesOnly();
    }

    public int getTestDesign() {
        int n = -1;
        if (this.chooseDesignPane.getSelectedIndex() == 0) {
            n = 8;
        } else if (this.chooseDesignPane.getSelectedIndex() == 1) {
            n = 7;
        } else if (this.chooseDesignPane.getSelectedIndex() == 2) {
            n = 11;
        }
        return n;
    }

    public int[] getGroupAssignments() {
        int[] nArray = new int[this.exptNames.size()];
        for (int i = 0; i < this.exptNames.size(); ++i) {
            nArray[i] = this.gPanel.groupARadioButtons[i].isSelected() ? 1 : (this.gPanel.groupBRadioButtons[i].isSelected() ? 2 : 3);
        }
        return nArray;
    }

    public boolean isPermut() {
        return this.pPanel.permutButton.isSelected();
    }

    public int getUserNumCombs() {
        String string = this.pPanel.timesField.getText();
        int n = 0;
        if (!this.useAllCombs()) {
            n = Integer.parseInt(string);
        } else if (this.getTestDesign() == 7) {
            n = this.allPossCombs;
        } else if (this.getTestDesign() == 8) {
            n = (int)Math.pow(2.0, this.getNumValidOneClassExpts());
        } else if (this.getTestDesign() == 11) {
            n = (int)Math.pow(2.0, this.tcpmPanel.tcpPanel.pairedListModel.size());
        }
        return n;
    }

    public double getAlphaValue() {
        String string = this.pPanel.alphaInputField.getText();
        return Double.parseDouble(string);
    }

    public int[] getOneClassAssignments() {
        int[] nArray = new int[this.oPanel.includeExpts.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.oPanel.includeExpts[i].isSelected() ? 1 : 0;
        }
        return nArray;
    }

    public int getNumValidOneClassExpts() {
        int n = 0;
        int[] nArray = this.getOneClassAssignments();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != 1) continue;
            ++n;
        }
        return n;
    }

    public double getOneClassMean() {
        return Double.parseDouble(this.oPanel.meanField.getText());
    }

    public int getFalseNum() {
        return Integer.parseInt(this.sPanel.falseNumField.getText());
    }

    public double getFalseProp() {
        return Double.parseDouble(this.sPanel.falsePropField.getText());
    }

    public boolean validateAlpha(String string) {
        float f;
        try {
            f = Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Alpha value is not a valid input value.", "Input Error", 2);
            this.pPanel.alphaInputField.requestFocus();
            this.pPanel.alphaInputField.selectAll();
            return false;
        }
        if (f <= 0.0f || f >= 1.0f) {
            JOptionPane.showMessageDialog(this, "Alpha value must be > 0 and < 1.0", "Input Error", 2);
            this.pPanel.alphaInputField.requestFocus();
            this.pPanel.alphaInputField.selectAll();
            return false;
        }
        return true;
    }

    public boolean validateFalseNum() {
        int n;
        try {
            String string = this.sPanel.falseNumField.getText();
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "False number must be an integer >= 0", "Input Error", 2);
            this.sPanel.falseNumField.requestFocus();
            this.sPanel.falseNumField.selectAll();
            return false;
        }
        if (n < 0) {
            JOptionPane.showMessageDialog(this, "False number must be an integer >= 0", "Input Error", 2);
            this.sPanel.falseNumField.requestFocus();
            this.sPanel.falseNumField.selectAll();
            return false;
        }
        return true;
    }

    public boolean validateFalseProp() {
        float f;
        try {
            String string = this.sPanel.falsePropField.getText();
            f = Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "False proportion must be between 0 and 1", "Input Error", 2);
            this.sPanel.falsePropField.requestFocus();
            this.sPanel.falsePropField.selectAll();
            return false;
        }
        if (f <= 0.0f || f > 1.0f) {
            JOptionPane.showMessageDialog(this, "False proportion must be between 0 and 1", "Input Error", 2);
            this.sPanel.falsePropField.requestFocus();
            this.sPanel.falsePropField.selectAll();
            return false;
        }
        return true;
    }

    public boolean validatePermutations(String string) {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Number of Permutations is not a valid input value.", "Input Error", 2);
            this.pPanel.timesField.requestFocus();
            this.pPanel.timesField.selectAll();
            return false;
        }
        if (n <= 0) {
            JOptionPane.showMessageDialog(this, "Number of Permutations must be > 0", "Input Error", 2);
            this.pPanel.timesField.requestFocus();
            this.pPanel.timesField.selectAll();
            return false;
        }
        return true;
    }

    public Vector getPairedAExpts() {
        return this.tcpmPanel.tcpPanel.pairedAExpts;
    }

    public Vector getPairedBExpts() {
        return this.tcpmPanel.tcpPanel.pairedBExpts;
    }

    public int getSignificanceMethod() {
        if (this.sPanel.justAlphaButton.isSelected()) {
            return 4;
        }
        if (this.sPanel.stdBonfButton.isSelected()) {
            return 5;
        }
        if (this.sPanel.adjBonfButton.isSelected()) {
            return 6;
        }
        if (this.sPanel.maxTButton.isSelected()) {
            return 9;
        }
        if (this.sPanel.minPButton.isSelected()) {
            return 10;
        }
        if (this.sPanel.falseNumButton.isSelected()) {
            return 12;
        }
        if (this.sPanel.falsePropButton.isSelected()) {
            return 13;
        }
        return -1;
    }

    public boolean calculateFDRPVals() {
        return this.sPanel.calcFDRPVals.isSelected();
    }

    public boolean doFastFDRApprox() {
        return this.sPanel.fastFDRButton.isSelected();
    }

    public boolean useWelchDf() {
        return this.dPanel.welchButton.isSelected();
    }

    public boolean useAllCombs() {
        return this.pPanel.allCombsButton.isSelected();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < 10; ++i) {
            vector.add("Exp " + i);
        }
        TtestInitDialog ttestInitDialog = new TtestInitDialog(jFrame, true, vector);
        for (int i = 0; i < 50; ++i) {
            System.out.println("2^" + i + " = " + (int)Math.pow(2.0, i));
        }
        ttestInitDialog.setVisible(true);
        System.exit(0);
    }

    public class EventListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                if (TtestInitDialog.this.getTestDesign() == 7) {
                    int[] nArray = TtestInitDialog.this.getGroupAssignments();
                    int n = 0;
                    int n2 = 0;
                    for (int i = 0; i < nArray.length; ++i) {
                        if (nArray[i] == 1) {
                            ++n;
                            continue;
                        }
                        if (nArray[i] != 2) continue;
                        ++n2;
                    }
                    if (n < 2 || n2 < 2) {
                        JOptionPane.showMessageDialog(TtestInitDialog.this.gPanel, "Group A and Group B must each contain more than one sample", "Error", 2);
                    } else {
                        String string2;
                        String string3 = TtestInitDialog.this.pPanel.alphaInputField.getText();
                        if (TtestInitDialog.this.pPanel.permutButton.isSelected() && TtestInitDialog.this.pPanel.randomGroupsButton.isSelected() && !TtestInitDialog.this.validatePermutations(string2 = TtestInitDialog.this.pPanel.timesField.getText())) {
                            TtestInitDialog.this.okPressed = false;
                            return;
                        }
                        if (!TtestInitDialog.this.validateAlpha(string3)) {
                            TtestInitDialog.this.okPressed = false;
                            return;
                        }
                        if (TtestInitDialog.this.sPanel.falseNumButton.isSelected() && !TtestInitDialog.this.validateFalseNum()) {
                            TtestInitDialog.this.okPressed = false;
                            return;
                        }
                        if (TtestInitDialog.this.sPanel.falsePropButton.isSelected() && !TtestInitDialog.this.validateFalseProp()) {
                            TtestInitDialog.this.okPressed = false;
                            return;
                        }
                        TtestInitDialog.this.okPressed = true;
                        TtestInitDialog.this.hide();
                        TtestInitDialog.this.dispose();
                    }
                } else if (TtestInitDialog.this.getTestDesign() == 8) {
                    String string4;
                    try {
                        float f = Float.parseFloat(TtestInitDialog.this.oPanel.meanField.getText());
                    }
                    catch (NumberFormatException numberFormatException) {
                        JOptionPane.showMessageDialog(TtestInitDialog.this.oPanel, "Invalid value entered for mean", "Error", 2);
                        TtestInitDialog.this.okPressed = false;
                        return;
                    }
                    if (TtestInitDialog.this.getNumValidOneClassExpts() < 2) {
                        JOptionPane.showMessageDialog(TtestInitDialog.this.oPanel, "Select at least two samples", "Error", 2);
                        TtestInitDialog.this.okPressed = false;
                        return;
                    }
                    String string5 = TtestInitDialog.this.pPanel.alphaInputField.getText();
                    if (TtestInitDialog.this.pPanel.permutButton.isSelected() && TtestInitDialog.this.pPanel.randomGroupsButton.isSelected() && !TtestInitDialog.this.validatePermutations(string4 = TtestInitDialog.this.pPanel.timesField.getText())) {
                        TtestInitDialog.this.okPressed = false;
                        return;
                    }
                    if (!TtestInitDialog.this.validateAlpha(string5)) {
                        TtestInitDialog.this.okPressed = false;
                        return;
                    }
                    if (TtestInitDialog.this.sPanel.falseNumButton.isSelected() && !TtestInitDialog.this.validateFalseNum()) {
                        TtestInitDialog.this.okPressed = false;
                        return;
                    }
                    if (TtestInitDialog.this.sPanel.falsePropButton.isSelected() && !TtestInitDialog.this.validateFalseProp()) {
                        TtestInitDialog.this.okPressed = false;
                        return;
                    }
                    TtestInitDialog.this.okPressed = true;
                    TtestInitDialog.this.hide();
                    TtestInitDialog.this.dispose();
                } else if (TtestInitDialog.this.getTestDesign() == 11) {
                    if (TtestInitDialog.this.tcpmPanel.tcpPanel.pairedListModel.size() < 2) {
                        JOptionPane.showMessageDialog(null, "Need at least two pairs of samples!", "Error", 0);
                    } else {
                        String string6;
                        if (TtestInitDialog.this.tcpmPanel.tcpPanel.pairedListModel.size() <= 29) {
                            int n = TtestInitDialog.this.getUserNumCombs();
                            int n3 = (int)Math.pow(2.0, TtestInitDialog.this.tcpmPanel.tcpPanel.pairedListModel.size());
                        }
                        String string7 = TtestInitDialog.this.pPanel.alphaInputField.getText();
                        if (TtestInitDialog.this.pPanel.permutButton.isSelected() && TtestInitDialog.this.pPanel.randomGroupsButton.isSelected() && !TtestInitDialog.this.validatePermutations(string6 = TtestInitDialog.this.pPanel.timesField.getText())) {
                            TtestInitDialog.this.okPressed = false;
                            return;
                        }
                        if (!TtestInitDialog.this.validateAlpha(string7)) {
                            TtestInitDialog.this.okPressed = false;
                            return;
                        }
                        if (TtestInitDialog.this.sPanel.falseNumButton.isSelected() && !TtestInitDialog.this.validateFalseNum()) {
                            TtestInitDialog.this.okPressed = false;
                            return;
                        }
                        if (TtestInitDialog.this.sPanel.falsePropButton.isSelected() && !TtestInitDialog.this.validateFalseProp()) {
                            TtestInitDialog.this.okPressed = false;
                            return;
                        }
                        TtestInitDialog.this.okPressed = true;
                        UIManager.put("TabbedPane.selected", Color.lightGray);
                        TtestInitDialog.this.dispose();
                    }
                }
            } else if (string.equals("reset-command")) {
                if (TtestInitDialog.this.getTestDesign() == 7) {
                    TtestInitDialog.this.gPanel.reset();
                } else if (TtestInitDialog.this.getTestDesign() == 8) {
                    TtestInitDialog.this.oPanel.reset();
                } else if (TtestInitDialog.this.getTestDesign() == 11) {
                    TtestInitDialog.this.tcpmPanel.tcpPanel.reset();
                }
                TtestInitDialog.this.pPanel.tDistButton.setSelected(true);
                TtestInitDialog.this.pPanel.randomGroupsButton.setEnabled(false);
                TtestInitDialog.this.pPanel.allCombsButton.setEnabled(false);
                TtestInitDialog.this.pPanel.timesField.setEnabled(false);
                TtestInitDialog.this.pPanel.timesField.setBackground(Color.white);
                TtestInitDialog.this.pPanel.timesField.setText("100");
                TtestInitDialog.this.pPanel.numCombsLabel.setText("                                                                            ");
                TtestInitDialog.this.pPanel.alphaInputField.setText("0.01");
                TtestInitDialog.this.sPanel.justAlphaButton.setSelected(true);
                TtestInitDialog.this.sPanel.falseNumField.setText("10");
                TtestInitDialog.this.sPanel.falsePropField.setText("0.05");
                TtestInitDialog.this.hclOpsPanel.setHCLSelected(false);
                TtestInitDialog.this.dPanel.reset();
            } else if (string.equals("cancel-command")) {
                TtestInitDialog.this.okPressed = false;
                TtestInitDialog.this.setVisible(false);
                TtestInitDialog.this.dispose();
            } else if (string.equals("info-command")) {
                HelpWindow helpWindow = new HelpWindow(TtestInitDialog.this, "TTEST Initialization Dialog");
                if (helpWindow.getWindowContent()) {
                    helpWindow.setSize(450, 600);
                    helpWindow.setLocation();
                    helpWindow.show();
                } else {
                    helpWindow.dispose();
                }
            }
        }
    }

    class DfCalcPanel
    extends JPanel {
        JRadioButton welchButton;
        JRadioButton eqVarButton;

        DfCalcPanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(), "Variance assumption (for between subjects t-test only)"));
            this.setBackground(Color.white);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            this.welchButton = new JRadioButton("Welch approximation (unequal group variances)", true);
            this.welchButton.setBackground(Color.white);
            this.eqVarButton = new JRadioButton("Assume equal group variances", false);
            this.eqVarButton.setBackground(Color.white);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.welchButton);
            buttonGroup.add(this.eqVarButton);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 50, 100);
            gridBagLayout.setConstraints(this.welchButton, gridBagConstraints);
            this.add(this.welchButton);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 50, 0);
            gridBagLayout.setConstraints(this.eqVarButton, gridBagConstraints);
            this.add(this.eqVarButton);
        }

        public void reset() {
            this.welchButton.setSelected(true);
        }
    }

    class OkCancelPanel
    extends JPanel {
        JButton okButton;
        JButton cancelButton;
        JCheckBox drawTreesBox;

        OkCancelPanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(), "General"));
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            this.drawTreesBox = new JCheckBox("Draw hierarchical trees", false);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 2, 1, 100, 50);
            gridBagLayout.setConstraints(this.drawTreesBox, gridBagConstraints);
            this.add(this.drawTreesBox);
            this.okButton = new JButton("OK");
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 50, 50);
            gridBagLayout.setConstraints(this.okButton, gridBagConstraints);
            this.add(this.okButton);
            this.cancelButton = new JButton("Cancel");
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 1, 1, 1, 1, 50, 0);
            gridBagLayout.setConstraints(this.cancelButton, gridBagConstraints);
            this.add(this.cancelButton);
        }
    }

    class SignificancePanel
    extends JPanel {
        JRadioButton minPButton;
        JRadioButton maxTButton;
        JRadioButton justAlphaButton;
        JRadioButton stdBonfButton;
        JRadioButton adjBonfButton;
        JRadioButton falseNumButton;
        JRadioButton falsePropButton;
        JRadioButton fastFDRButton;
        JRadioButton slowFDRButton;
        JTextField falseNumField;
        JTextField falsePropField;
        JCheckBox calcFDRPVals;

        SignificancePanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(1), "p-value / false discovery corrections", 0, 0, new Font("Dialog", 1, 12), Color.black));
            this.setBackground(Color.white);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            ButtonGroup buttonGroup = new ButtonGroup();
            this.justAlphaButton = new JRadioButton("just alpha (no correction)", true);
            this.justAlphaButton.setFocusPainted(false);
            this.justAlphaButton.setForeground(UIManager.getColor("Label.foreground"));
            this.justAlphaButton.setBackground(Color.white);
            buttonGroup.add(this.justAlphaButton);
            this.stdBonfButton = new JRadioButton("standard Bonferroni correction", false);
            this.stdBonfButton.setFocusPainted(false);
            this.stdBonfButton.setForeground(UIManager.getColor("Label.foreground"));
            this.stdBonfButton.setBackground(Color.white);
            buttonGroup.add(this.stdBonfButton);
            this.adjBonfButton = new JRadioButton("adjusted Bonferroni correction", false);
            this.adjBonfButton.setFocusPainted(false);
            this.adjBonfButton.setForeground(UIManager.getColor("Label.foreground"));
            this.adjBonfButton.setBackground(Color.white);
            buttonGroup.add(this.adjBonfButton);
            this.minPButton = new JRadioButton("minP", false);
            this.minPButton.setEnabled(false);
            this.minPButton.setFocusPainted(false);
            this.minPButton.setForeground(UIManager.getColor("Label.foreground"));
            this.minPButton.setBackground(Color.white);
            buttonGroup.add(this.minPButton);
            this.maxTButton = new JRadioButton("maxT", false);
            this.maxTButton.setEnabled(false);
            this.maxTButton.setFocusPainted(false);
            this.maxTButton.setForeground(UIManager.getColor("Label.foreground"));
            this.maxTButton.setBackground(Color.white);
            buttonGroup.add(this.maxTButton);
            this.falseNumButton = new JRadioButton("EITHER, The number of false significant genes should not exceed", false);
            this.falseNumButton.setEnabled(false);
            this.falseNumButton.setFocusPainted(false);
            this.falseNumButton.setForeground(UIManager.getColor("Label.foreground"));
            this.falseNumButton.setBackground(Color.white);
            buttonGroup.add(this.falseNumButton);
            this.falsePropButton = new JRadioButton("OR, The proportion of false significant genes should not exceed", false);
            this.falsePropButton.setEnabled(false);
            this.falsePropButton.setFocusPainted(false);
            this.falsePropButton.setForeground(UIManager.getColor("Label.foreground"));
            this.falsePropButton.setBackground(Color.white);
            buttonGroup.add(this.falsePropButton);
            this.falseNumField = new JTextField(10);
            this.falseNumField.setText("10");
            this.falseNumField.setEnabled(false);
            this.falsePropField = new JTextField(10);
            this.falsePropField.setText("0.05");
            this.falsePropField.setEnabled(false);
            this.calcFDRPVals = new JCheckBox("Calculate adjusted p values for false discovery control", false);
            this.calcFDRPVals.setEnabled(false);
            this.calcFDRPVals.setBackground(Color.white);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 33, 33);
            gridBagLayout.setConstraints(this.justAlphaButton, gridBagConstraints);
            this.add(this.justAlphaButton);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 33, 0);
            gridBagLayout.setConstraints(this.stdBonfButton, gridBagConstraints);
            this.add(this.stdBonfButton);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 2, 0, 1, 1, 34, 0);
            gridBagLayout.setConstraints(this.adjBonfButton, gridBagConstraints);
            this.add(this.adjBonfButton);
            JPanel jPanel = new JPanel();
            jPanel.setBackground(Color.white);
            jPanel.setBorder(new EtchedBorder());
            GridBagLayout gridBagLayout2 = new GridBagLayout();
            jPanel.setLayout(gridBagLayout2);
            JLabel jLabel = new JLabel("Step-down Westfall and Young methods (for permutations only): ");
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 34, 100);
            gridBagLayout2.setConstraints(jLabel, gridBagConstraints);
            jPanel.add(jLabel);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 33, 0);
            gridBagLayout2.setConstraints(this.minPButton, gridBagConstraints);
            jPanel.add(this.minPButton);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 2, 0, 1, 1, 33, 0);
            gridBagLayout2.setConstraints(this.maxTButton, gridBagConstraints);
            jPanel.add(this.maxTButton);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, 1, 3, 1, 100, 33);
            gridBagLayout.setConstraints(jPanel, gridBagConstraints);
            this.add(jPanel);
            ButtonGroup buttonGroup2 = new ButtonGroup();
            this.fastFDRButton = new JRadioButton("Fast approximation (but possibly conservative)", true);
            this.fastFDRButton.setSelected(true);
            this.fastFDRButton.setEnabled(false);
            this.fastFDRButton.setBackground(Color.white);
            buttonGroup2.add(this.fastFDRButton);
            this.slowFDRButton = new JRadioButton("Complete computation (possibly slow)");
            this.slowFDRButton.setEnabled(false);
            this.slowFDRButton.setBackground(Color.white);
            buttonGroup2.add(this.slowFDRButton);
            JPanel jPanel2 = new JPanel();
            jPanel2.setBackground(Color.white);
            jPanel2.setBorder(new TitledBorder(new EtchedBorder(1), "False discovery control (permutations only)", 0, 0, new Font("Dialog", 1, 12), Color.black));
            GridBagLayout gridBagLayout3 = new GridBagLayout();
            jPanel2.setLayout(gridBagLayout3);
            JLabel jLabel2 = new JLabel("With confidence of [1 - alpha] : ");
            gridBagConstraints.anchor = 17;
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 2, 1, 100, 20);
            gridBagLayout3.setConstraints(jLabel2, gridBagConstraints);
            jPanel2.add(jLabel2);
            gridBagConstraints.anchor = 10;
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 50, 20);
            gridBagConstraints.anchor = 13;
            gridBagLayout3.setConstraints(this.falseNumButton, gridBagConstraints);
            jPanel2.add(this.falseNumButton);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 1, 1, 1, 1, 50, 0);
            gridBagConstraints.anchor = 17;
            gridBagLayout3.setConstraints(this.falseNumField, gridBagConstraints);
            jPanel2.add(this.falseNumField);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 50, 20);
            gridBagConstraints.anchor = 13;
            gridBagLayout3.setConstraints(this.falsePropButton, gridBagConstraints);
            jPanel2.add(this.falsePropButton);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 1, 2, 1, 1, 50, 0);
            gridBagConstraints.anchor = 17;
            gridBagLayout3.setConstraints(this.falsePropField, gridBagConstraints);
            jPanel2.add(this.falsePropField);
            gridBagConstraints.anchor = 10;
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, 3, 1, 1, 50, 20);
            gridBagLayout3.setConstraints(this.fastFDRButton, gridBagConstraints);
            jPanel2.add(this.fastFDRButton);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 1, 3, 1, 1, 50, 0);
            gridBagLayout3.setConstraints(this.slowFDRButton, gridBagConstraints);
            jPanel2.add(this.slowFDRButton);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, 4, 2, 1, 100, 20);
            gridBagLayout3.setConstraints(this.calcFDRPVals, gridBagConstraints);
            jPanel2.add(this.calcFDRPVals);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, 2, 3, 1, 100, 34);
            gridBagConstraints.fill = 2;
            gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
            this.add(jPanel2);
            gridBagConstraints.fill = 0;
        }
    }

    class PValuePanel
    extends JPanel {
        JRadioButton tDistButton;
        JRadioButton permutButton;
        JRadioButton randomGroupsButton;
        JRadioButton allCombsButton;
        JLabel numCombsLabel;
        JTextField timesField;
        JTextField alphaInputField;

        PValuePanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(1), "P-Value Parameters", 0, 0, new Font("Dialog", 1, 12), Color.black));
            this.setBackground(Color.white);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            this.setLayout(gridBagLayout);
            ButtonGroup buttonGroup = new ButtonGroup();
            this.tDistButton = new JRadioButton("p-values based on t-distribution", true);
            this.tDistButton.setFocusPainted(false);
            this.tDistButton.setForeground(UIManager.getColor("Label.foreground"));
            this.tDistButton.setBackground(Color.white);
            buttonGroup.add(this.tDistButton);
            this.permutButton = new JRadioButton("p-values based on permutation:  ", false);
            this.permutButton.setFocusPainted(false);
            this.permutButton.setForeground(UIManager.getColor("Label.foreground"));
            this.permutButton.setBackground(Color.white);
            buttonGroup.add(this.permutButton);
            this.numCombsLabel = new JLabel("                                       ");
            this.numCombsLabel.setOpaque(false);
            JPanel jPanel = new JPanel();
            jPanel.setBackground(Color.white);
            GridBagLayout gridBagLayout2 = new GridBagLayout();
            jPanel.setLayout(gridBagLayout2);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 30, 50);
            gridBagLayout2.setConstraints(this.tDistButton, gridBagConstraints);
            jPanel.add(this.tDistButton);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 30, 50);
            gridBagConstraints.anchor = 17;
            gridBagLayout2.setConstraints(this.permutButton, gridBagConstraints);
            jPanel.add(this.permutButton);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 1, 1, 1, 1, 70, 0);
            gridBagConstraints.ipadx = 50;
            gridBagConstraints.anchor = 17;
            gridBagLayout2.setConstraints(this.numCombsLabel, gridBagConstraints);
            jPanel.add(this.numCombsLabel);
            gridBagConstraints.ipadx = 100;
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 20);
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(jPanel, gridBagConstraints);
            this.add(jPanel);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            JPanel jPanel2 = new JPanel();
            jPanel2.setBackground(Color.white);
            GridBagLayout gridBagLayout3 = new GridBagLayout();
            jPanel2.setLayout(gridBagLayout3);
            jPanel2.setBorder(new EtchedBorder());
            this.randomGroupsButton = new JRadioButton("Randomly group samples ", true);
            this.randomGroupsButton.setFocusPainted(false);
            this.randomGroupsButton.setForeground(UIManager.getColor("Label.foreground"));
            this.randomGroupsButton.setBackground(Color.white);
            this.randomGroupsButton.setEnabled(false);
            this.allCombsButton = new JRadioButton("Use all permutations                 ", false);
            this.allCombsButton.setFocusPainted(false);
            this.allCombsButton.setForeground(UIManager.getColor("Label.foreground"));
            this.allCombsButton.setBackground(Color.white);
            this.allCombsButton.setEnabled(false);
            ButtonGroup buttonGroup2 = new ButtonGroup();
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 60, 50);
            gridBagLayout3.setConstraints(this.randomGroupsButton, gridBagConstraints);
            jPanel2.add(this.randomGroupsButton);
            this.timesField = new JTextField("100", 7);
            this.timesField.setEnabled(false);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 20, 0);
            gridBagConstraints.anchor = 17;
            gridBagLayout3.setConstraints(this.timesField, gridBagConstraints);
            jPanel2.add(this.timesField);
            JLabel jLabel = new JLabel("times");
            jLabel.setOpaque(false);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 2, 0, 1, 1, 20, 0);
            gridBagLayout3.setConstraints(jLabel, gridBagConstraints);
            jPanel2.add(jLabel);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 60, 0);
            gridBagConstraints.anchor = 13;
            gridBagLayout3.setConstraints(this.allCombsButton, gridBagConstraints);
            jPanel2.add(this.allCombsButton);
            buttonGroup2.add(this.randomGroupsButton);
            buttonGroup2.add(this.allCombsButton);
            this.allCombsButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ PValuePanel this$1;
                {
                    this.this$1 = pValuePanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource() == this.this$1.allCombsButton) {
                        this.this$1.timesField.setText("");
                        this.this$1.timesField.setBackground(Color.gray);
                        this.this$1.timesField.setEnabled(false);
                    }
                }
            });
            this.randomGroupsButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ PValuePanel this$1;
                {
                    this.this$1 = pValuePanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource() == this.this$1.randomGroupsButton) {
                        this.this$1.timesField.setText("100");
                        this.this$1.timesField.setBackground(Color.white);
                        this.this$1.timesField.setEnabled(true);
                    }
                }
            });
            this.tDistButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ PValuePanel this$1;
                {
                    this.this$1 = pValuePanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource() == this.this$1.tDistButton) {
                        this.this$1.randomGroupsButton.setEnabled(false);
                        this.this$1.allCombsButton.setEnabled(false);
                        this.this$1.timesField.setEnabled(false);
                        this.this$1.numCombsLabel.setText("                                                                            ");
                    }
                }
            });
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 100, 60);
            gridBagConstraints.anchor = 11;
            gridBagConstraints.fill = 3;
            gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
            this.add(jPanel2);
            gridBagConstraints.fill = 0;
            JPanel jPanel3 = new JPanel();
            jPanel3.setBackground(Color.white);
            GridBagLayout gridBagLayout4 = new GridBagLayout();
            jPanel3.setLayout(gridBagLayout4);
            JLabel jLabel2 = new JLabel("Overall alpha (critical p-value):                   ");
            jLabel2.setOpaque(false);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 75, 100);
            gridBagConstraints.anchor = 17;
            gridBagLayout4.setConstraints(jLabel2, gridBagConstraints);
            jPanel3.add(jLabel2);
            this.alphaInputField = new JTextField("0.01", 7);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 25, 0);
            gridBagConstraints.anchor = 17;
            gridBagLayout4.setConstraints(this.alphaInputField, gridBagConstraints);
            jPanel3.add(this.alphaInputField);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 0, 20);
            gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
            this.add(jPanel3);
        }
    }

    class GroupExperimentsPanel
    extends JPanel {
        JLabel[] expLabels;
        JRadioButton[] groupARadioButtons;
        JRadioButton[] groupBRadioButtons;
        JRadioButton[] neitherGroupRadioButtons;

        GroupExperimentsPanel(Vector vector) {
            Object object;
            this.setBorder(new TitledBorder(new EtchedBorder(1), "Group Assignments", 0, 0, new Font("Dialog", 1, 12), Color.black));
            this.setBackground(Color.white);
            JPanel jPanel = new JPanel();
            this.expLabels = new JLabel[vector.size()];
            this.groupARadioButtons = new JRadioButton[vector.size()];
            this.groupBRadioButtons = new JRadioButton[vector.size()];
            this.neitherGroupRadioButtons = new JRadioButton[vector.size()];
            ButtonGroup[] buttonGroupArray = new ButtonGroup[vector.size()];
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagLayout gridBagLayout2 = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout2);
            jPanel.setLayout(gridBagLayout);
            for (int i = 0; i < vector.size(); ++i) {
                object = (String)vector.get(i);
                this.expLabels[i] = new JLabel((String)object);
                this.expLabels[i].setForeground(Color.black);
                buttonGroupArray[i] = new ButtonGroup();
                this.groupARadioButtons[i] = new JRadioButton("Group A", true);
                buttonGroupArray[i].add(this.groupARadioButtons[i]);
                this.groupBRadioButtons[i] = new JRadioButton("Group B", false);
                buttonGroupArray[i].add(this.groupBRadioButtons[i]);
                this.neitherGroupRadioButtons[i] = new JRadioButton("Neither group", false);
                buttonGroupArray[i].add(this.neitherGroupRadioButtons[i]);
                TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, i, 1, 1, 25, 100);
                gridBagLayout.setConstraints(this.expLabels[i], gridBagConstraints);
                jPanel.add(this.expLabels[i]);
                TtestInitDialog.this.buildConstraints(gridBagConstraints, 1, i, 1, 1, 25, 100);
                gridBagLayout.setConstraints(this.groupARadioButtons[i], gridBagConstraints);
                jPanel.add(this.groupARadioButtons[i]);
                TtestInitDialog.this.buildConstraints(gridBagConstraints, 2, i, 1, 1, 25, 100);
                gridBagLayout.setConstraints(this.groupBRadioButtons[i], gridBagConstraints);
                jPanel.add(this.groupBRadioButtons[i]);
                TtestInitDialog.this.buildConstraints(gridBagConstraints, 3, i, 1, 1, 25, 100);
                gridBagLayout.setConstraints(this.neitherGroupRadioButtons[i], gridBagConstraints);
                jPanel.add(this.neitherGroupRadioButtons[i]);
            }
            JScrollPane jScrollPane = new JScrollPane(jPanel);
            jScrollPane.setHorizontalScrollBarPolicy(32);
            jScrollPane.setVerticalScrollBarPolicy(22);
            jScrollPane.setBorder(BorderFactory.createLineBorder(Color.black, 2));
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 90);
            gridBagConstraints.fill = 1;
            gridBagLayout2.setConstraints(jScrollPane, gridBagConstraints);
            this.add(jScrollPane);
            object = new JLabel("                                                Note: Group A and Group B  MUST each contain more than one sample.");
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 0, 5);
            gridBagConstraints.anchor = 13;
            gridBagLayout2.setConstraints((Component)object, gridBagConstraints);
            this.add((Component)object);
            JPanel jPanel2 = new JPanel();
            jPanel2.setBackground(Color.white);
            GridBagLayout gridBagLayout3 = new GridBagLayout();
            jPanel2.setLayout(gridBagLayout3);
            JButton jButton = new JButton(" Save grouping ");
            jButton.setBorder(BorderFactory.createBevelBorder(0, Color.gray, new Color(185, 185, 185), Color.darkGray, Color.darkGray));
            jButton.setFocusPainted(false);
            jButton.setPreferredSize(new Dimension(100, 30));
            JButton jButton2 = new JButton(" Load grouping ");
            jButton2.setBorder(BorderFactory.createBevelBorder(0, Color.gray, new Color(185, 185, 185), Color.darkGray, Color.darkGray));
            jButton2.setFocusPainted(false);
            jButton2.setPreferredSize(new Dimension(100, 30));
            JButton jButton3 = new JButton(" Reset ");
            jButton3.setBorder(BorderFactory.createBevelBorder(0, Color.gray, new Color(185, 185, 185), Color.darkGray, Color.darkGray));
            jButton3.setFocusPainted(false);
            jButton3.setPreferredSize(new Dimension(55, 30));
            int n = vector.size();
            jButton3.addActionListener(new ActionListener(this, n){
                private final /* synthetic */ int val$finNum;
                private final /* synthetic */ GroupExperimentsPanel this$1;
                {
                    this.this$1 = groupExperimentsPanel;
                    this.val$finNum = n;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    for (int i = 0; i < this.val$finNum; ++i) {
                        this.this$1.groupARadioButtons[i].setSelected(true);
                    }
                    GroupExperimentsPanel.access$600((GroupExperimentsPanel)this.this$1).pPanel.tDistButton.setSelected(true);
                    GroupExperimentsPanel.access$600((GroupExperimentsPanel)this.this$1).sPanel.justAlphaButton.setSelected(true);
                    GroupExperimentsPanel.access$600((GroupExperimentsPanel)this.this$1).sPanel.maxTButton.setSelected(false);
                    GroupExperimentsPanel.access$600((GroupExperimentsPanel)this.this$1).sPanel.maxTButton.setEnabled(false);
                    GroupExperimentsPanel.access$600((GroupExperimentsPanel)this.this$1).sPanel.minPButton.setSelected(false);
                    GroupExperimentsPanel.access$600((GroupExperimentsPanel)this.this$1).sPanel.minPButton.setEnabled(false);
                    GroupExperimentsPanel.access$600((GroupExperimentsPanel)this.this$1).pPanel.randomGroupsButton.setEnabled(false);
                    GroupExperimentsPanel.access$600((GroupExperimentsPanel)this.this$1).pPanel.allCombsButton.setEnabled(false);
                    GroupExperimentsPanel.access$600((GroupExperimentsPanel)this.this$1).pPanel.timesField.setEnabled(false);
                    GroupExperimentsPanel.access$600((GroupExperimentsPanel)this.this$1).pPanel.numCombsLabel.setText("                                                                            ");
                }
            });
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setCurrentDirectory(new File("Data"));
            jButton.addActionListener(new ActionListener(this, jFileChooser, TtestInitDialog.this){
                private final /* synthetic */ JFileChooser val$fc;
                private final /* synthetic */ TtestInitDialog val$this$0;
                private final /* synthetic */ GroupExperimentsPanel this$1;
                {
                    this.this$1 = groupExperimentsPanel;
                    this.val$fc = jFileChooser;
                    this.val$this$0 = ttestInitDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = this.val$fc.showSaveDialog(this.this$1);
                    if (n == 0) {
                        File file = this.val$fc.getSelectedFile();
                        try {
                            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
                            int[] nArray = GroupExperimentsPanel.access$600(this.this$1).getGroupAssignments();
                            for (int i = 0; i < nArray.length; ++i) {
                                printWriter.print(nArray[i]);
                                if (i >= nArray.length - 1) continue;
                                printWriter.print("\t");
                            }
                            printWriter.println();
                            printWriter.flush();
                            printWriter.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
            jButton2.addActionListener(new ActionListener(this, jFileChooser, TtestInitDialog.this, n){
                private final /* synthetic */ JFileChooser val$fc;
                private final /* synthetic */ TtestInitDialog val$this$0;
                private final /* synthetic */ int val$finNum;
                private final /* synthetic */ GroupExperimentsPanel this$1;
                {
                    this.this$1 = groupExperimentsPanel;
                    this.val$fc = jFileChooser;
                    this.val$this$0 = ttestInitDialog;
                    this.val$finNum = n;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = this.val$fc.showOpenDialog(this.this$1);
                    if (n == 0) {
                        try {
                            Object object;
                            FileReader fileReader = new FileReader(this.val$fc.getSelectedFile());
                            BufferedReader bufferedReader = new BufferedReader(fileReader);
                            String string = bufferedReader.readLine();
                            StringSplitter stringSplitter = new StringSplitter('\t');
                            stringSplitter.init(string);
                            Vector<Integer> vector = new Vector<Integer>();
                            while (stringSplitter.hasMoreTokens()) {
                                object = stringSplitter.nextToken();
                                vector.add(new Integer((String)object));
                            }
                            bufferedReader.close();
                            object = GroupExperimentsPanel.access$600(this.this$1).getGroupAssignments();
                            if (vector.size() != ((Object)object).length) {
                                JOptionPane.showMessageDialog(GroupExperimentsPanel.access$600((GroupExperimentsPanel)this.this$1).gPanel, "Incompatible file!", "Error", 2);
                            } else {
                                for (int i = 0; i < vector.size(); ++i) {
                                    int n2 = (Integer)vector.get(i);
                                    if (n2 == 1) {
                                        this.this$1.groupARadioButtons[i].setSelected(true);
                                        continue;
                                    }
                                    if (n2 == 2) {
                                        this.this$1.groupBRadioButtons[i].setSelected(true);
                                        continue;
                                    }
                                    if (n2 == 3) {
                                        this.this$1.neitherGroupRadioButtons[i].setSelected(true);
                                        continue;
                                    }
                                    for (int j = 0; j < this.val$finNum; ++j) {
                                        this.this$1.groupARadioButtons[j].setSelected(true);
                                    }
                                    JOptionPane.showMessageDialog(GroupExperimentsPanel.access$600((GroupExperimentsPanel)this.this$1).gPanel, "Incompatible file!", "Error", 2);
                                    break;
                                }
                            }
                            GroupExperimentsPanel.access$600((GroupExperimentsPanel)this.this$1).pPanel.tDistButton.setSelected(true);
                            GroupExperimentsPanel.access$600((GroupExperimentsPanel)this.this$1).sPanel.justAlphaButton.setSelected(true);
                            GroupExperimentsPanel.access$600((GroupExperimentsPanel)this.this$1).sPanel.maxTButton.setSelected(false);
                            GroupExperimentsPanel.access$600((GroupExperimentsPanel)this.this$1).sPanel.maxTButton.setEnabled(false);
                            GroupExperimentsPanel.access$600((GroupExperimentsPanel)this.this$1).sPanel.minPButton.setSelected(false);
                            GroupExperimentsPanel.access$600((GroupExperimentsPanel)this.this$1).sPanel.minPButton.setEnabled(false);
                            GroupExperimentsPanel.access$600((GroupExperimentsPanel)this.this$1).pPanel.randomGroupsButton.setEnabled(false);
                            GroupExperimentsPanel.access$600((GroupExperimentsPanel)this.this$1).pPanel.allCombsButton.setEnabled(false);
                            GroupExperimentsPanel.access$600((GroupExperimentsPanel)this.this$1).pPanel.timesField.setEnabled(false);
                            GroupExperimentsPanel.access$600((GroupExperimentsPanel)this.this$1).pPanel.numCombsLabel.setText("                                                                            ");
                        }
                        catch (Exception exception) {
                            JOptionPane.showMessageDialog(GroupExperimentsPanel.access$600((GroupExperimentsPanel)this.this$1).gPanel, "Incompatible file!", "Error", 2);
                        }
                    }
                }
            });
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 5, 0, 5);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 33, 100);
            gridBagLayout3.setConstraints(jButton, gridBagConstraints);
            jPanel2.add(jButton);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 33, 0);
            gridBagLayout3.setConstraints(jButton2, gridBagConstraints);
            jPanel2.add(jButton2);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 2, 0, 1, 1, 34, 0);
            gridBagLayout3.setConstraints(jButton3, gridBagConstraints);
            jPanel2.add(jButton3);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 0, 5);
            gridBagConstraints.anchor = 10;
            gridBagLayout2.setConstraints(jPanel2, gridBagConstraints);
            this.add(jPanel2);
        }

        public void reset() {
            int n = TtestInitDialog.this.exptNames.size();
            for (int i = 0; i < n; ++i) {
                this.groupARadioButtons[i].setSelected(true);
            }
        }

        static /* synthetic */ TtestInitDialog access$600(GroupExperimentsPanel groupExperimentsPanel) {
            return groupExperimentsPanel.TtestInitDialog.this;
        }
    }

    class OneClassPanel
    extends JPanel {
        JTextField meanField;
        JCheckBox[] includeExpts;
        JButton saveButton;
        JButton loadButton;
        JButton resetButton;

        OneClassPanel() {
            this.setBackground(Color.white);
            JLabel jLabel = new JLabel("Enter the mean value to be tested against: ");
            this.meanField = new JTextField("0", 7);
            this.includeExpts = new JCheckBox[TtestInitDialog.this.exptNames.size()];
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            JPanel jPanel = new JPanel();
            GridBagLayout gridBagLayout2 = new GridBagLayout();
            jPanel.setLayout(gridBagLayout2);
            for (int i = 0; i < TtestInitDialog.this.exptNames.size(); ++i) {
                this.includeExpts[i] = new JCheckBox((String)TtestInitDialog.this.exptNames.get(i), true);
                TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, i, 1, 1, 100, 100);
                gridBagLayout2.setConstraints(this.includeExpts[i], gridBagConstraints);
                jPanel.add(this.includeExpts[i]);
            }
            JScrollPane jScrollPane = new JScrollPane(jPanel);
            jScrollPane.setVerticalScrollBarPolicy(22);
            JPanel jPanel2 = new JPanel();
            GridBagLayout gridBagLayout3 = new GridBagLayout();
            jPanel2.setLayout(gridBagLayout3);
            gridBagConstraints.fill = 0;
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 50, 100);
            gridBagConstraints.anchor = 13;
            gridBagLayout3.setConstraints(jLabel, gridBagConstraints);
            jPanel2.add(jLabel);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 50, 0);
            gridBagConstraints.anchor = 17;
            gridBagLayout3.setConstraints(this.meanField, gridBagConstraints);
            jPanel2.add(this.meanField);
            JScrollPane jScrollPane2 = new JScrollPane(jPanel2);
            JSplitPane jSplitPane = new JSplitPane(1, jScrollPane, jScrollPane2);
            jSplitPane.setOneTouchExpandable(true);
            jSplitPane.setDividerLocation(150);
            gridBagConstraints.fill = 1;
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 80);
            gridBagLayout.setConstraints(jSplitPane, gridBagConstraints);
            this.add(jSplitPane);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 10;
            JPanel jPanel3 = new JPanel();
            this.loadButton = new JButton("Load settings");
            this.saveButton = new JButton("Save settings");
            this.resetButton = new JButton("Reset");
            this.resetButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ OneClassPanel this$1;
                {
                    this.this$1 = oneClassPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    for (int i = 0; i < this.this$1.includeExpts.length; ++i) {
                        this.this$1.includeExpts[i].setSelected(true);
                    }
                    OneClassPanel.access$500((OneClassPanel)this.this$1).pPanel.tDistButton.setSelected(true);
                    OneClassPanel.access$500((OneClassPanel)this.this$1).sPanel.justAlphaButton.setSelected(true);
                    OneClassPanel.access$500((OneClassPanel)this.this$1).sPanel.maxTButton.setSelected(false);
                    OneClassPanel.access$500((OneClassPanel)this.this$1).sPanel.maxTButton.setEnabled(false);
                    OneClassPanel.access$500((OneClassPanel)this.this$1).sPanel.minPButton.setSelected(false);
                    OneClassPanel.access$500((OneClassPanel)this.this$1).sPanel.minPButton.setEnabled(false);
                    OneClassPanel.access$500((OneClassPanel)this.this$1).pPanel.randomGroupsButton.setEnabled(false);
                    OneClassPanel.access$500((OneClassPanel)this.this$1).pPanel.allCombsButton.setEnabled(false);
                    OneClassPanel.access$500((OneClassPanel)this.this$1).pPanel.timesField.setEnabled(false);
                    OneClassPanel.access$500((OneClassPanel)this.this$1).pPanel.numCombsLabel.setText("                                                                            ");
                }
            });
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setCurrentDirectory(new File("Data"));
            this.saveButton.addActionListener(new ActionListener(this, jFileChooser, TtestInitDialog.this){
                private final /* synthetic */ JFileChooser val$fc;
                private final /* synthetic */ TtestInitDialog val$this$0;
                private final /* synthetic */ OneClassPanel this$1;
                {
                    this.this$1 = oneClassPanel;
                    this.val$fc = jFileChooser;
                    this.val$this$0 = ttestInitDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = this.val$fc.showSaveDialog(this.this$1);
                    if (n == 0) {
                        File file = this.val$fc.getSelectedFile();
                        try {
                            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
                            for (int i = 0; i < this.this$1.includeExpts.length; ++i) {
                                if (this.this$1.includeExpts[i].isSelected()) {
                                    printWriter.print(1);
                                } else {
                                    printWriter.print(0);
                                }
                                if (i >= this.this$1.includeExpts.length - 1) continue;
                                printWriter.print("\t");
                            }
                            printWriter.println();
                            printWriter.flush();
                            printWriter.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
            this.loadButton.addActionListener(new ActionListener(this, jFileChooser, TtestInitDialog.this){
                private final /* synthetic */ JFileChooser val$fc;
                private final /* synthetic */ TtestInitDialog val$this$0;
                private final /* synthetic */ OneClassPanel this$1;
                {
                    this.this$1 = oneClassPanel;
                    this.val$fc = jFileChooser;
                    this.val$this$0 = ttestInitDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    block9: {
                        int n = this.val$fc.showOpenDialog(this.this$1);
                        if (n == 0) {
                            OneClassPanel.access$500((OneClassPanel)this.this$1).pPanel.tDistButton.setSelected(true);
                            OneClassPanel.access$500((OneClassPanel)this.this$1).sPanel.justAlphaButton.setSelected(true);
                            OneClassPanel.access$500((OneClassPanel)this.this$1).sPanel.maxTButton.setSelected(false);
                            OneClassPanel.access$500((OneClassPanel)this.this$1).sPanel.maxTButton.setEnabled(false);
                            OneClassPanel.access$500((OneClassPanel)this.this$1).sPanel.minPButton.setSelected(false);
                            OneClassPanel.access$500((OneClassPanel)this.this$1).sPanel.minPButton.setEnabled(false);
                            OneClassPanel.access$500((OneClassPanel)this.this$1).pPanel.randomGroupsButton.setEnabled(false);
                            OneClassPanel.access$500((OneClassPanel)this.this$1).pPanel.allCombsButton.setEnabled(false);
                            OneClassPanel.access$500((OneClassPanel)this.this$1).pPanel.timesField.setEnabled(false);
                            OneClassPanel.access$500((OneClassPanel)this.this$1).pPanel.numCombsLabel.setText("                                                                            ");
                            try {
                                FileReader fileReader = new FileReader(this.val$fc.getSelectedFile());
                                BufferedReader bufferedReader = new BufferedReader(fileReader);
                                String string = bufferedReader.readLine();
                                StringSplitter stringSplitter = new StringSplitter('\t');
                                stringSplitter.init(string);
                                Vector<Integer> vector = new Vector<Integer>();
                                while (stringSplitter.hasMoreTokens()) {
                                    String string2 = stringSplitter.nextToken();
                                    vector.add(new Integer(string2));
                                }
                                bufferedReader.close();
                                if (vector.size() != this.this$1.includeExpts.length) {
                                    JOptionPane.showMessageDialog(OneClassPanel.access$500((OneClassPanel)this.this$1).gPanel, "Incompatible file!", "Error", 2);
                                    break block9;
                                }
                                for (int i = 0; i < this.this$1.includeExpts.length; ++i) {
                                    int n2 = (Integer)vector.get(i);
                                    if (n2 == 0) {
                                        this.this$1.includeExpts[i].setSelected(false);
                                        continue;
                                    }
                                    if (n2 == 1) {
                                        this.this$1.includeExpts[i].setSelected(true);
                                        continue;
                                    }
                                    for (int j = 0; j < this.this$1.includeExpts.length; ++j) {
                                        this.this$1.includeExpts[j].setSelected(true);
                                    }
                                    JOptionPane.showMessageDialog(OneClassPanel.access$500((OneClassPanel)this.this$1).gPanel, "Incompatible file!", "Error", 2);
                                    break;
                                }
                            }
                            catch (Exception exception) {
                                JOptionPane.showMessageDialog(OneClassPanel.access$500((OneClassPanel)this.this$1).gPanel, "Incompatible file!", "Error", 2);
                            }
                        }
                    }
                }
            });
            GridBagLayout gridBagLayout4 = new GridBagLayout();
            jPanel3.setLayout(gridBagLayout4);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 33, 100);
            gridBagLayout4.setConstraints(this.saveButton, gridBagConstraints);
            jPanel3.add(this.saveButton);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 33, 0);
            gridBagLayout4.setConstraints(this.loadButton, gridBagConstraints);
            jPanel3.add(this.loadButton);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 2, 0, 1, 1, 33, 0);
            gridBagLayout4.setConstraints(this.resetButton, gridBagConstraints);
            jPanel3.add(this.resetButton);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 0, 20);
            gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
            this.add(jPanel3);
        }

        public void reset() {
            for (int i = 0; i < this.includeExpts.length; ++i) {
                this.includeExpts[i].setSelected(true);
            }
            this.meanField.setText("0");
        }

        static /* synthetic */ TtestInitDialog access$500(OneClassPanel oneClassPanel) {
            return oneClassPanel.TtestInitDialog.this;
        }
    }

    class TwoClassPairedPanel
    extends JPanel {
        ExperimentButton[] exptButtons;
        GridBagConstraints constraints;
        GridBagLayout gridbag;
        JTextField currentATextField;
        JTextField currentBTextField;
        JButton removeCurrentAButton;
        JButton removeCurrentBButton;
        JButton loadABPairButton;
        JButton removeABPairButton;
        PairedExperimentsPanel pairPanel;
        JList pairedExptsList;
        DefaultListModel pairedListModel;
        boolean currentAFilled = false;
        boolean currentBFilled = false;
        int currentAExpt = -1;
        int currentBExpt = -1;
        Vector pairedAExpts = new Vector();
        Vector pairedBExpts = new Vector();

        public TwoClassPairedPanel() {
            Object object;
            this.constraints = new GridBagConstraints();
            this.gridbag = new GridBagLayout();
            this.setLayout(this.gridbag);
            this.pairedListModel = new DefaultListModel();
            this.pairedExptsList = new JList(this.pairedListModel);
            JPanel jPanel = new JPanel();
            GridBagLayout gridBagLayout = new GridBagLayout();
            jPanel.setLayout(gridBagLayout);
            this.exptButtons = new ExperimentButton[TtestInitDialog.this.exptNames.size()];
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < TtestInitDialog.this.exptNames.size(); ++i) {
                int n3;
                this.exptButtons[i] = new ExperimentButton(i);
                if (this.exptButtons[i].getPreferredSize().getWidth() > (double)n) {
                    n = (int)Math.ceil(this.exptButtons[i].getPreferredSize().getWidth());
                }
                if ((n3 = ((String)(object = (String)TtestInitDialog.this.exptNames.get(i))).length()) > n2) {
                    n2 = n3;
                }
                TtestInitDialog.this.buildConstraints(this.constraints, 0, i, 1, 1, 100, 100);
                gridBagLayout.setConstraints(this.exptButtons[i], this.constraints);
                jPanel.add(this.exptButtons[i]);
            }
            this.currentATextField = new JTextField("", n2 + 2);
            this.currentBTextField = new JTextField("", n2 + 2);
            this.currentATextField.setBackground(Color.white);
            this.currentBTextField.setBackground(Color.white);
            this.currentATextField.setEditable(false);
            this.currentBTextField.setEditable(false);
            JScrollPane jScrollPane = new JScrollPane(jPanel);
            jScrollPane.setHorizontalScrollBarPolicy(32);
            jScrollPane.setVerticalScrollBarPolicy(22);
            TtestInitDialog.this.buildConstraints(this.constraints, 0, 0, 1, 1, 40, 100);
            this.constraints.fill = 1;
            this.gridbag.setConstraints(jScrollPane, this.constraints);
            this.add(jScrollPane);
            this.constraints.fill = 0;
            object = new JPanel();
            GridBagLayout gridBagLayout2 = new GridBagLayout();
            ((Container)object).setLayout(gridBagLayout2);
            this.removeCurrentAButton = new JButton("< Remove A");
            this.removeCurrentBButton = new JButton("< Remove B");
            this.loadABPairButton = new JButton("   Load Pair >>   ");
            this.removeABPairButton = new JButton("<< Remove Pair");
            this.removeCurrentAButton.setEnabled(false);
            this.removeCurrentBButton.setEnabled(false);
            this.loadABPairButton.setEnabled(false);
            this.removeABPairButton.setEnabled(false);
            this.removeCurrentAButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ TwoClassPairedPanel this$1;
                {
                    this.this$1 = twoClassPairedPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.exptButtons[this.this$1.currentAExpt].setEnabled(true);
                    this.this$1.currentAExpt = -1;
                    this.this$1.currentATextField.setText("");
                    this.this$1.currentAFilled = false;
                    this.this$1.removeCurrentAButton.setEnabled(false);
                    this.this$1.loadABPairButton.setEnabled(false);
                }
            });
            this.removeCurrentBButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ TwoClassPairedPanel this$1;
                {
                    this.this$1 = twoClassPairedPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.exptButtons[this.this$1.currentBExpt].setEnabled(true);
                    this.this$1.currentBExpt = -1;
                    this.this$1.currentBTextField.setText("");
                    this.this$1.currentBFilled = false;
                    this.this$1.removeCurrentBButton.setEnabled(false);
                    this.this$1.loadABPairButton.setEnabled(false);
                }
            });
            this.loadABPairButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ TwoClassPairedPanel this$1;
                {
                    this.this$1 = twoClassPairedPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = "A: " + (String)TwoClassPairedPanel.access$300((TwoClassPairedPanel)this.this$1).exptNames.get(this.this$1.currentAExpt) + " - B: " + (String)TwoClassPairedPanel.access$300((TwoClassPairedPanel)this.this$1).exptNames.get(this.this$1.currentBExpt);
                    this.this$1.pairedListModel.addElement(string);
                    this.this$1.pairedAExpts.add(new Integer(this.this$1.currentAExpt));
                    this.this$1.pairedBExpts.add(new Integer(this.this$1.currentBExpt));
                    this.this$1.currentAExpt = -1;
                    this.this$1.currentBExpt = -1;
                    this.this$1.currentATextField.setText("");
                    this.this$1.currentBTextField.setText("");
                    this.this$1.currentAFilled = false;
                    this.this$1.currentBFilled = false;
                    this.this$1.removeCurrentAButton.setEnabled(false);
                    this.this$1.removeCurrentBButton.setEnabled(false);
                    this.this$1.loadABPairButton.setEnabled(false);
                    this.this$1.removeABPairButton.setEnabled(true);
                    this.this$1.pairedExptsList.setSelectedIndex(this.this$1.pairedListModel.size() - 1);
                    TwoClassPairedPanel.access$300((TwoClassPairedPanel)this.this$1).pPanel.tDistButton.setSelected(true);
                    TwoClassPairedPanel.access$300((TwoClassPairedPanel)this.this$1).sPanel.justAlphaButton.setSelected(true);
                    TwoClassPairedPanel.access$300((TwoClassPairedPanel)this.this$1).sPanel.maxTButton.setSelected(false);
                    TwoClassPairedPanel.access$300((TwoClassPairedPanel)this.this$1).sPanel.maxTButton.setEnabled(false);
                    TwoClassPairedPanel.access$300((TwoClassPairedPanel)this.this$1).sPanel.minPButton.setSelected(false);
                    TwoClassPairedPanel.access$300((TwoClassPairedPanel)this.this$1).sPanel.minPButton.setEnabled(false);
                    TwoClassPairedPanel.access$300((TwoClassPairedPanel)this.this$1).pPanel.randomGroupsButton.setEnabled(false);
                    TwoClassPairedPanel.access$300((TwoClassPairedPanel)this.this$1).pPanel.allCombsButton.setEnabled(false);
                    TwoClassPairedPanel.access$300((TwoClassPairedPanel)this.this$1).pPanel.timesField.setEnabled(false);
                    TwoClassPairedPanel.access$300((TwoClassPairedPanel)this.this$1).pPanel.numCombsLabel.setText("                                                                            ");
                }
            });
            this.removeABPairButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ TwoClassPairedPanel this$1;
                {
                    this.this$1 = twoClassPairedPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = this.this$1.pairedExptsList.getSelectedIndex();
                    this.this$1.pairedListModel.removeElementAt(n);
                    int n2 = (Integer)this.this$1.pairedAExpts.remove(n);
                    int n3 = (Integer)this.this$1.pairedBExpts.remove(n);
                    this.this$1.exptButtons[n2].setEnabled(true);
                    this.this$1.exptButtons[n3].setEnabled(true);
                    if (this.this$1.pairedListModel.isEmpty()) {
                        this.this$1.removeABPairButton.setEnabled(false);
                    } else {
                        this.this$1.pairedExptsList.setSelectedIndex(this.this$1.pairedListModel.size() - 1);
                    }
                    TwoClassPairedPanel.access$300((TwoClassPairedPanel)this.this$1).pPanel.tDistButton.setSelected(true);
                    TwoClassPairedPanel.access$300((TwoClassPairedPanel)this.this$1).sPanel.justAlphaButton.setSelected(true);
                    TwoClassPairedPanel.access$300((TwoClassPairedPanel)this.this$1).sPanel.maxTButton.setSelected(false);
                    TwoClassPairedPanel.access$300((TwoClassPairedPanel)this.this$1).sPanel.maxTButton.setEnabled(false);
                    TwoClassPairedPanel.access$300((TwoClassPairedPanel)this.this$1).sPanel.minPButton.setSelected(false);
                    TwoClassPairedPanel.access$300((TwoClassPairedPanel)this.this$1).sPanel.minPButton.setEnabled(false);
                    TwoClassPairedPanel.access$300((TwoClassPairedPanel)this.this$1).pPanel.randomGroupsButton.setEnabled(false);
                    TwoClassPairedPanel.access$300((TwoClassPairedPanel)this.this$1).pPanel.allCombsButton.setEnabled(false);
                    TwoClassPairedPanel.access$300((TwoClassPairedPanel)this.this$1).pPanel.timesField.setEnabled(false);
                    TwoClassPairedPanel.access$300((TwoClassPairedPanel)this.this$1).pPanel.numCombsLabel.setText("                                                                            ");
                }
            });
            JScrollPane jScrollPane2 = new JScrollPane(this.currentATextField);
            jScrollPane2.setMinimumSize(new Dimension(90, 50));
            JScrollPane jScrollPane3 = new JScrollPane(this.currentBTextField);
            jScrollPane3.setMinimumSize(new Dimension(90, 50));
            jScrollPane2.setHorizontalScrollBarPolicy(32);
            jScrollPane2.setVerticalScrollBarPolicy(21);
            jScrollPane3.setHorizontalScrollBarPolicy(32);
            jScrollPane3.setVerticalScrollBarPolicy(21);
            TtestInitDialog.this.buildConstraints(this.constraints, 0, 0, 1, 1, 20, 50);
            gridBagLayout2.setConstraints(this.removeCurrentAButton, this.constraints);
            ((Container)object).add(this.removeCurrentAButton);
            JLabel jLabel = new JLabel(" Current A: ");
            TtestInitDialog.this.buildConstraints(this.constraints, 1, 0, 1, 1, 20, 0);
            gridBagLayout2.setConstraints(jLabel, this.constraints);
            ((Container)object).add(jLabel);
            TtestInitDialog.this.buildConstraints(this.constraints, 2, 0, 1, 1, 60, 0);
            this.constraints.fill = 1;
            gridBagLayout2.setConstraints(jScrollPane2, this.constraints);
            ((Container)object).add(jScrollPane2);
            this.constraints.fill = 0;
            TtestInitDialog.this.buildConstraints(this.constraints, 0, 1, 1, 1, 20, 50);
            gridBagLayout2.setConstraints(this.removeCurrentBButton, this.constraints);
            ((Container)object).add(this.removeCurrentBButton);
            JLabel jLabel2 = new JLabel("Current B: ");
            TtestInitDialog.this.buildConstraints(this.constraints, 1, 1, 1, 1, 20, 0);
            gridBagLayout2.setConstraints(jLabel2, this.constraints);
            ((Container)object).add(jLabel2);
            TtestInitDialog.this.buildConstraints(this.constraints, 2, 1, 1, 1, 60, 0);
            this.constraints.fill = 1;
            gridBagLayout2.setConstraints(jScrollPane3, this.constraints);
            ((Container)object).add(jScrollPane3);
            this.constraints.fill = 0;
            TtestInitDialog.this.buildConstraints(this.constraints, 1, 0, 1, 1, 10, 0);
            this.gridbag.setConstraints((Component)object, this.constraints);
            this.add((Component)object);
            this.constraints.fill = 0;
            JPanel jPanel2 = new JPanel();
            GridBagLayout gridBagLayout3 = new GridBagLayout();
            jPanel2.setLayout(gridBagLayout3);
            TtestInitDialog.this.buildConstraints(this.constraints, 0, 0, 1, 1, 100, 50);
            gridBagLayout3.setConstraints(this.loadABPairButton, this.constraints);
            jPanel2.add(this.loadABPairButton);
            TtestInitDialog.this.buildConstraints(this.constraints, 0, 1, 1, 1, 0, 50);
            gridBagLayout3.setConstraints(this.removeABPairButton, this.constraints);
            jPanel2.add(this.removeABPairButton);
            TtestInitDialog.this.buildConstraints(this.constraints, 2, 0, 1, 1, 5, 0);
            this.gridbag.setConstraints(jPanel2, this.constraints);
            this.add(jPanel2);
            TtestInitDialog.this.buildConstraints(this.constraints, 3, 0, 1, 1, 45, 0);
            this.constraints.fill = 1;
            JScrollPane jScrollPane4 = new JScrollPane(this.pairedExptsList);
            jScrollPane4.setBorder(new TitledBorder("Paired Samples"));
            this.gridbag.setConstraints(jScrollPane4, this.constraints);
            this.add(jScrollPane4);
        }

        public void reset() {
            for (int i = 0; i < this.exptButtons.length; ++i) {
                this.exptButtons[i].setEnabled(true);
                this.currentATextField.setText("");
                this.currentBTextField.setText("");
                this.removeCurrentAButton.setEnabled(false);
                this.removeCurrentBButton.setEnabled(false);
                this.loadABPairButton.setEnabled(false);
                this.removeABPairButton.setEnabled(false);
                this.pairedListModel.clear();
                this.currentAFilled = false;
                this.currentBFilled = false;
                this.currentAExpt = -1;
                this.currentBExpt = -1;
                this.pairedAExpts.clear();
                this.pairedBExpts.clear();
            }
        }

        class PairedExperimentsPanel
        extends JPanel {
        }

        class ExperimentButton
        extends JButton {
            String s;
            int index;

            public ExperimentButton(int n) {
                this.index = n;
                this.s = (String)((TwoClassPairedPanel)TwoClassPairedPanel.this).TtestInitDialog.this.exptNames.get(n);
                this.setText(this.s);
                this.addActionListener(new ActionListener(this, TwoClassPairedPanel.this){
                    private final /* synthetic */ TwoClassPairedPanel val$this$1;
                    private final /* synthetic */ ExperimentButton this$2;
                    {
                        this.this$2 = experimentButton;
                        this.val$this$1 = twoClassPairedPanel;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (ExperimentButton.access$400((ExperimentButton)this.this$2).currentAFilled && ExperimentButton.access$400((ExperimentButton)this.this$2).currentBFilled) {
                            JOptionPane.showMessageDialog(null, "Clear at least one current field first!", "Error", 0);
                        } else if (!ExperimentButton.access$400((ExperimentButton)this.this$2).currentAFilled) {
                            ExperimentButton.access$400((ExperimentButton)this.this$2).currentAExpt = this.this$2.index;
                            ExperimentButton.access$400((ExperimentButton)this.this$2).currentATextField.setText(this.this$2.s);
                            ExperimentButton.access$400((ExperimentButton)this.this$2).currentAFilled = true;
                            this.this$2.setEnabled(false);
                            ExperimentButton.access$400((ExperimentButton)this.this$2).removeCurrentAButton.setEnabled(true);
                        } else if (!ExperimentButton.access$400((ExperimentButton)this.this$2).currentBFilled) {
                            ExperimentButton.access$400((ExperimentButton)this.this$2).currentBExpt = this.this$2.index;
                            ExperimentButton.access$400((ExperimentButton)this.this$2).currentBTextField.setText(this.this$2.s);
                            ExperimentButton.access$400((ExperimentButton)this.this$2).currentBFilled = true;
                            this.this$2.setEnabled(false);
                            ExperimentButton.access$400((ExperimentButton)this.this$2).removeCurrentBButton.setEnabled(true);
                        }
                        if (ExperimentButton.access$400((ExperimentButton)this.this$2).currentAFilled && ExperimentButton.access$400((ExperimentButton)this.this$2).currentBFilled) {
                            ExperimentButton.access$400((ExperimentButton)this.this$2).loadABPairButton.setEnabled(true);
                        } else {
                            ExperimentButton.access$400((ExperimentButton)this.this$2).loadABPairButton.setEnabled(false);
                        }
                    }
                });
            }

            static /* synthetic */ TwoClassPairedPanel access$400(ExperimentButton experimentButton) {
                return experimentButton.TwoClassPairedPanel.this;
            }
        }
    }

    class TwoClassPairedMainPanel
    extends JPanel {
        TwoClassPairedPanel tcpPanel;
        JButton saveButton;
        JButton resetButton;
        JButton loadButton;
        GridBagConstraints constraints;
        GridBagLayout gridbag;

        public TwoClassPairedMainPanel() {
            this.tcpPanel = new TwoClassPairedPanel();
            JPanel jPanel = new JPanel();
            jPanel.setBackground(Color.white);
            this.constraints = new GridBagConstraints();
            this.gridbag = new GridBagLayout();
            this.setLayout(this.gridbag);
            TtestInitDialog.this.buildConstraints(this.constraints, 0, 0, 1, 1, 100, 90);
            this.constraints.fill = 1;
            this.gridbag.setConstraints(this.tcpPanel, this.constraints);
            this.add(this.tcpPanel);
            GridBagLayout gridBagLayout = new GridBagLayout();
            jPanel.setLayout(gridBagLayout);
            this.saveButton = new JButton("Save pairings");
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setCurrentDirectory(new File("Data"));
            this.saveButton.addActionListener(new ActionListener(this, jFileChooser, TtestInitDialog.this){
                private final /* synthetic */ JFileChooser val$fc;
                private final /* synthetic */ TtestInitDialog val$this$0;
                private final /* synthetic */ TwoClassPairedMainPanel this$1;
                {
                    this.this$1 = twoClassPairedMainPanel;
                    this.val$fc = jFileChooser;
                    this.val$this$0 = ttestInitDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = this.val$fc.showSaveDialog(this.this$1);
                    if (n == 0) {
                        File file = this.val$fc.getSelectedFile();
                        try {
                            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
                            for (int i = 0; i < this.this$1.tcpPanel.pairedAExpts.size(); ++i) {
                                int n2 = (Integer)this.this$1.tcpPanel.pairedAExpts.get(i);
                                int n3 = (Integer)this.this$1.tcpPanel.pairedBExpts.get(i);
                                printWriter.print(n2);
                                printWriter.print("\t");
                                printWriter.print(n3);
                                printWriter.print("\t");
                                printWriter.println();
                            }
                            printWriter.flush();
                            printWriter.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
            this.constraints.fill = 0;
            TtestInitDialog.this.buildConstraints(this.constraints, 0, 0, 1, 1, 33, 100);
            gridBagLayout.setConstraints(this.saveButton, this.constraints);
            jPanel.add(this.saveButton);
            this.loadButton = new JButton("Load pairings");
            this.loadButton.addActionListener(new ActionListener(this, jFileChooser, TtestInitDialog.this){
                private final /* synthetic */ JFileChooser val$fc;
                private final /* synthetic */ TtestInitDialog val$this$0;
                private final /* synthetic */ TwoClassPairedMainPanel this$1;
                {
                    this.this$1 = twoClassPairedMainPanel;
                    this.val$fc = jFileChooser;
                    this.val$this$0 = ttestInitDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = this.val$fc.showOpenDialog(this.this$1);
                    if (n == 0) {
                        this.this$1.tcpPanel.reset();
                        try {
                            int n2;
                            String string;
                            FileReader fileReader = new FileReader(this.val$fc.getSelectedFile());
                            BufferedReader bufferedReader = new BufferedReader(fileReader);
                            while ((string = bufferedReader.readLine()) != null) {
                                StringSplitter stringSplitter = new StringSplitter('\t');
                                stringSplitter.init(string);
                                for (n2 = 0; n2 < 2; ++n2) {
                                    String string2 = stringSplitter.nextToken();
                                    if (n2 == 0) {
                                        this.this$1.tcpPanel.pairedAExpts.add(new Integer(string2));
                                        continue;
                                    }
                                    if (n2 != 1) continue;
                                    this.this$1.tcpPanel.pairedBExpts.add(new Integer(string2));
                                }
                            }
                            bufferedReader.close();
                            for (int i = 0; i < this.this$1.tcpPanel.pairedAExpts.size(); ++i) {
                                n2 = (Integer)this.this$1.tcpPanel.pairedAExpts.get(i);
                                int n3 = (Integer)this.this$1.tcpPanel.pairedBExpts.get(i);
                                String string3 = "A: " + (String)TwoClassPairedMainPanel.access$200((TwoClassPairedMainPanel)this.this$1).exptNames.get(n2) + " - B: " + (String)TwoClassPairedMainPanel.access$200((TwoClassPairedMainPanel)this.this$1).exptNames.get(n3);
                                this.this$1.tcpPanel.exptButtons[n2].setEnabled(false);
                                this.this$1.tcpPanel.exptButtons[n3].setEnabled(false);
                                this.this$1.tcpPanel.pairedListModel.addElement(string3);
                            }
                            if (this.this$1.tcpPanel.pairedAExpts.size() > 0) {
                                this.this$1.tcpPanel.removeABPairButton.setEnabled(true);
                                this.this$1.tcpPanel.pairedExptsList.setSelectedIndex(this.this$1.tcpPanel.pairedListModel.size() - 1);
                            }
                            TwoClassPairedMainPanel.access$200((TwoClassPairedMainPanel)this.this$1).pPanel.tDistButton.setSelected(true);
                            TwoClassPairedMainPanel.access$200((TwoClassPairedMainPanel)this.this$1).sPanel.justAlphaButton.setSelected(true);
                            TwoClassPairedMainPanel.access$200((TwoClassPairedMainPanel)this.this$1).sPanel.maxTButton.setSelected(false);
                            TwoClassPairedMainPanel.access$200((TwoClassPairedMainPanel)this.this$1).sPanel.maxTButton.setEnabled(false);
                            TwoClassPairedMainPanel.access$200((TwoClassPairedMainPanel)this.this$1).sPanel.minPButton.setSelected(false);
                            TwoClassPairedMainPanel.access$200((TwoClassPairedMainPanel)this.this$1).sPanel.minPButton.setEnabled(false);
                            TwoClassPairedMainPanel.access$200((TwoClassPairedMainPanel)this.this$1).pPanel.randomGroupsButton.setEnabled(false);
                            TwoClassPairedMainPanel.access$200((TwoClassPairedMainPanel)this.this$1).pPanel.allCombsButton.setEnabled(false);
                            TwoClassPairedMainPanel.access$200((TwoClassPairedMainPanel)this.this$1).pPanel.timesField.setEnabled(false);
                            TwoClassPairedMainPanel.access$200((TwoClassPairedMainPanel)this.this$1).pPanel.numCombsLabel.setText("                                                                            ");
                        }
                        catch (Exception exception) {
                            JOptionPane.showMessageDialog(this.this$1.tcpPanel, "Incompatible file!", "Error", 2);
                        }
                    }
                }
            });
            TtestInitDialog.this.buildConstraints(this.constraints, 1, 0, 1, 1, 33, 100);
            gridBagLayout.setConstraints(this.loadButton, this.constraints);
            jPanel.add(this.loadButton);
            this.resetButton = new JButton("Reset");
            this.resetButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ TwoClassPairedMainPanel this$1;
                {
                    this.this$1 = twoClassPairedMainPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.tcpPanel.reset();
                    TwoClassPairedMainPanel.access$200((TwoClassPairedMainPanel)this.this$1).pPanel.tDistButton.setSelected(true);
                    TwoClassPairedMainPanel.access$200((TwoClassPairedMainPanel)this.this$1).sPanel.justAlphaButton.setSelected(true);
                    TwoClassPairedMainPanel.access$200((TwoClassPairedMainPanel)this.this$1).sPanel.maxTButton.setSelected(false);
                    TwoClassPairedMainPanel.access$200((TwoClassPairedMainPanel)this.this$1).sPanel.maxTButton.setEnabled(false);
                    TwoClassPairedMainPanel.access$200((TwoClassPairedMainPanel)this.this$1).sPanel.minPButton.setSelected(false);
                    TwoClassPairedMainPanel.access$200((TwoClassPairedMainPanel)this.this$1).sPanel.minPButton.setEnabled(false);
                    TwoClassPairedMainPanel.access$200((TwoClassPairedMainPanel)this.this$1).pPanel.randomGroupsButton.setEnabled(false);
                    TwoClassPairedMainPanel.access$200((TwoClassPairedMainPanel)this.this$1).pPanel.allCombsButton.setEnabled(false);
                    TwoClassPairedMainPanel.access$200((TwoClassPairedMainPanel)this.this$1).pPanel.timesField.setEnabled(false);
                    TwoClassPairedMainPanel.access$200((TwoClassPairedMainPanel)this.this$1).pPanel.numCombsLabel.setText("                                                                            ");
                }
            });
            TtestInitDialog.this.buildConstraints(this.constraints, 2, 0, 1, 1, 34, 100);
            gridBagLayout.setConstraints(this.resetButton, this.constraints);
            jPanel.add(this.resetButton);
            TtestInitDialog.this.buildConstraints(this.constraints, 0, 1, 1, 1, 0, 10);
            this.gridbag.setConstraints(jPanel, this.constraints);
            this.add(jPanel);
        }

        static /* synthetic */ TtestInitDialog access$200(TwoClassPairedMainPanel twoClassPairedMainPanel) {
            return twoClassPairedMainPanel.TtestInitDialog.this;
        }
    }
}

