/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ttest;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLGUI;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ttest.TTestVolcanoPlotViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ttest.TtestCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ttest.TtestCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ttest.TtestExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ttest.TtestInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ttest.TtestInitDialog;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;
import org.tigr.util.FloatMatrix;

public class TtestGUI
implements IClusterGUI,
IScriptGUI {
    private Algorithm algorithm;
    private Progress progress;
    private Experiment experiment;
    private int[][] clusters;
    private FloatMatrix means;
    private FloatMatrix variances;
    private String[] auxTitles;
    private Object[][] auxData;
    private Vector tValues;
    private Vector rawPValues;
    private Vector adjPValues;
    private Vector dfValues;
    private Vector meansA;
    private Vector meansB;
    private Vector sdA;
    private Vector sdB;
    private Vector oneClassMeans;
    private Vector oneClassSDs;
    private Vector pairedGroupAExpts;
    private Vector pairedGroupBExpts;
    private IData data;
    Vector exptNamesVector;
    int[] groupAssignments;
    int tTestDesign;
    int falseNum;
    double oneClassMean;
    double falseProp;
    boolean isPermutations;
    boolean useWelchDf;
    boolean drawSigTreesOnly;
    boolean doFastFDRApprox;
    boolean calculateAdjFDRPVals;
    boolean[] isSig;
    double[] diffMeansBA;
    double[] negLog10PValues;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework iFramework) throws AlgorithmException {
        DefaultMutableTreeNode defaultMutableTreeNode;
        block55: {
            Object object;
            boolean bl;
            this.experiment = iFramework.getData().getExperiment();
            this.exptNamesVector = new Vector();
            this.data = iFramework.getData();
            int n = this.experiment.getNumberOfSamples();
            int n2 = this.experiment.getNumberOfGenes();
            for (int i = 0; i < n; ++i) {
                this.exptNamesVector.add(iFramework.getData().getSampleName(this.experiment.getSampleIndex(i)));
            }
            TtestInitDialog ttestInitDialog = new TtestInitDialog((JFrame)iFramework.getFrame(), true, this.exptNamesVector);
            ttestInitDialog.setVisible(true);
            if (!ttestInitDialog.isOkPressed()) {
                return null;
            }
            double d = 0.01;
            try {
                d = ttestInitDialog.getAlphaValue();
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(iFramework.getFrame(), "Invalid alpha value!", "Error", 0);
                return null;
            }
            this.tTestDesign = ttestInitDialog.getTestDesign();
            this.oneClassMean = 0.0;
            if (this.tTestDesign == 8) {
                this.groupAssignments = ttestInitDialog.getOneClassAssignments();
                this.oneClassMean = ttestInitDialog.getOneClassMean();
            } else if (this.tTestDesign == 7) {
                this.groupAssignments = ttestInitDialog.getGroupAssignments();
            } else if (this.tTestDesign == 11) {
                this.pairedGroupAExpts = ttestInitDialog.getPairedAExpts();
                this.pairedGroupBExpts = ttestInitDialog.getPairedBExpts();
            }
            int n3 = ttestInitDialog.getSignificanceMethod();
            if (n3 == 12) {
                this.falseNum = ttestInitDialog.getFalseNum();
                this.calculateAdjFDRPVals = ttestInitDialog.calculateFDRPVals();
                this.doFastFDRApprox = ttestInitDialog.doFastFDRApprox();
            }
            if (n3 == 13) {
                this.falseProp = ttestInitDialog.getFalseProp();
                this.calculateAdjFDRPVals = ttestInitDialog.calculateFDRPVals();
                this.doFastFDRApprox = ttestInitDialog.doFastFDRApprox();
            }
            boolean bl2 = ttestInitDialog.isDrawTrees();
            this.drawSigTreesOnly = true;
            if (bl2) {
                this.drawSigTreesOnly = ttestInitDialog.drawSigTreesOnly();
            }
            this.isPermutations = bl = ttestInitDialog.isPermut();
            int n4 = ttestInitDialog.getUserNumCombs();
            boolean bl3 = ttestInitDialog.useAllCombs();
            this.useWelchDf = ttestInitDialog.useWelchDf();
            int n5 = 0;
            boolean bl4 = false;
            boolean bl5 = false;
            IDistanceMenu iDistanceMenu = iFramework.getDistanceMenu();
            int n6 = iDistanceMenu.getDistanceFunction();
            if (n6 == 0) {
                n6 = 4;
            }
            int n7 = 4;
            boolean bl6 = false;
            if (bl2) {
                object = new HCLInitDialog(iFramework.getFrame(), iDistanceMenu.getFunctionName(n6), iDistanceMenu.isAbsoluteDistance(), true);
                if (((HCLInitDialog)object).showModal() != 0) {
                    return null;
                }
                n5 = ((HCLInitDialog)object).getMethod();
                bl4 = ((HCLInitDialog)object).isClusterExperiments();
                bl5 = ((HCLInitDialog)object).isClusterGenes();
                n7 = ((HCLInitDialog)object).getDistanceMetric();
                bl6 = ((HCLInitDialog)object).getAbsoluteSelection();
            }
            object = new Listener();
            try {
                double d2;
                int n8;
                int n9;
                this.algorithm = iFramework.getAlgorithmFactory().getAlgorithm("TTEST");
                this.algorithm.addAlgorithmListener((AlgorithmListener)object);
                int n10 = this.experiment.getNumberOfGenes();
                this.progress = new Progress(iFramework.getFrame(), "Finding significant genes", (DialogListener)object);
                this.progress.show();
                AlgorithmData algorithmData = new AlgorithmData();
                algorithmData.addMatrix("experiment", this.experiment.getMatrix());
                algorithmData.addParam("distance-factor", String.valueOf(1.0f));
                algorithmData.addParam("distance-absolute", String.valueOf(iDistanceMenu.isAbsoluteDistance()));
                algorithmData.addParam("distance-function", String.valueOf(n6));
                algorithmData.addParam("tTestDesign", String.valueOf(this.tTestDesign));
                if (this.tTestDesign == 8 || this.tTestDesign == 7) {
                    algorithmData.addIntArray("group-assignments", this.groupAssignments);
                }
                if (this.tTestDesign == 8) {
                    algorithmData.addParam("oneClassMean", String.valueOf(this.oneClassMean));
                }
                if (this.tTestDesign == 11) {
                    FloatMatrix floatMatrix = new FloatMatrix(this.pairedGroupAExpts.size(), 1);
                    FloatMatrix floatMatrix2 = new FloatMatrix(this.pairedGroupBExpts.size(), 1);
                    for (int i = 0; i < this.pairedGroupAExpts.size(); ++i) {
                        floatMatrix.A[i][0] = ((Integer)this.pairedGroupAExpts.get(i)).floatValue();
                        floatMatrix2.A[i][0] = ((Integer)this.pairedGroupBExpts.get(i)).floatValue();
                    }
                    algorithmData.addMatrix("pairedAExptsMatrix", floatMatrix);
                    algorithmData.addMatrix("pairedBExptsMatrix", floatMatrix2);
                }
                algorithmData.addParam("alpha", String.valueOf(d));
                algorithmData.addParam("significance-method", String.valueOf(n3));
                if (n3 == 12) {
                    algorithmData.addParam("falseNum", String.valueOf(this.falseNum));
                    algorithmData.addParam("calculateAdjFDRPVals", String.valueOf(this.calculateAdjFDRPVals));
                    algorithmData.addParam("useFastFDRApprox", String.valueOf(this.doFastFDRApprox));
                }
                if (n3 == 13) {
                    algorithmData.addParam("falseProp", String.valueOf((float)this.falseProp));
                    algorithmData.addParam("calculateAdjFDRPVals", String.valueOf(this.calculateAdjFDRPVals));
                    algorithmData.addParam("useFastFDRApprox", String.valueOf(this.doFastFDRApprox));
                }
                algorithmData.addParam("is-permut", String.valueOf(bl));
                algorithmData.addParam("num-combs", String.valueOf(n4));
                algorithmData.addParam("use-all-combs", String.valueOf(bl3));
                algorithmData.addParam("useWelchDf", String.valueOf(this.useWelchDf));
                if (bl2) {
                    algorithmData.addParam("hierarchical-tree", String.valueOf(true));
                    algorithmData.addParam("draw-sig-trees-only", String.valueOf(this.drawSigTreesOnly));
                    algorithmData.addParam("method-linkage", String.valueOf(n5));
                    algorithmData.addParam("calculate-genes", String.valueOf(bl5));
                    algorithmData.addParam("calculate-experiments", String.valueOf(bl4));
                    algorithmData.addParam("hcl-distance-function", String.valueOf(n7));
                    algorithmData.addParam("hcl-distance-absolute", String.valueOf(bl6));
                }
                long l = System.currentTimeMillis();
                AlgorithmData algorithmData2 = this.algorithm.execute(algorithmData);
                long l2 = System.currentTimeMillis() - l;
                Cluster cluster = algorithmData2.getCluster("cluster");
                NodeList nodeList = cluster.getNodeList();
                AlgorithmParameters algorithmParameters = algorithmData2.getParams();
                int n11 = 2;
                this.clusters = new int[n11][];
                for (int i = 0; i < n11; ++i) {
                    this.clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
                }
                this.means = algorithmData2.getMatrix("clusters_means");
                this.variances = algorithmData2.getMatrix("clusters_variances");
                FloatMatrix floatMatrix = algorithmData2.getMatrix("sigPValues");
                FloatMatrix floatMatrix3 = algorithmData2.getMatrix("sigTValues");
                FloatMatrix floatMatrix4 = algorithmData2.getMatrix("nonSigPValues");
                FloatMatrix floatMatrix5 = algorithmData2.getMatrix("nonSigTValues");
                FloatMatrix floatMatrix6 = algorithmData2.getMatrix("rawPValues");
                FloatMatrix floatMatrix7 = algorithmData2.getMatrix("adjPValues");
                FloatMatrix floatMatrix8 = algorithmData2.getMatrix("tValues");
                FloatMatrix floatMatrix9 = algorithmData2.getMatrix("dfValues");
                FloatMatrix floatMatrix10 = algorithmData2.getMatrix("meansAMatrix");
                FloatMatrix floatMatrix11 = algorithmData2.getMatrix("meansBMatrix");
                FloatMatrix floatMatrix12 = algorithmData2.getMatrix("sdAMatrix");
                FloatMatrix floatMatrix13 = algorithmData2.getMatrix("sdBMatrix");
                FloatMatrix floatMatrix14 = algorithmData2.getMatrix("isSigMatrix");
                FloatMatrix floatMatrix15 = algorithmData2.getMatrix("oneClassMeansMatrix");
                FloatMatrix floatMatrix16 = algorithmData2.getMatrix("oneClassSDsMatrix");
                this.rawPValues = new Vector();
                this.adjPValues = new Vector();
                this.tValues = new Vector();
                this.dfValues = new Vector();
                this.meansA = new Vector();
                this.meansB = new Vector();
                this.sdA = new Vector();
                this.sdB = new Vector();
                this.oneClassMeans = new Vector();
                this.oneClassSDs = new Vector();
                for (n9 = 0; n9 < floatMatrix6.getRowDimension(); ++n9) {
                    this.rawPValues.add(new Float(floatMatrix6.A[n9][0]));
                    this.adjPValues.add(new Float(floatMatrix7.A[n9][0]));
                }
                for (n9 = 0; n9 < floatMatrix8.getRowDimension(); ++n9) {
                    this.tValues.add(new Float(floatMatrix8.A[n9][0]));
                }
                for (n9 = 0; n9 < floatMatrix9.getRowDimension(); ++n9) {
                    this.dfValues.add(new Float(floatMatrix9.A[n9][0]));
                }
                if (this.tTestDesign == 8) {
                    for (n9 = 0; n9 < floatMatrix15.getRowDimension(); ++n9) {
                        this.oneClassMeans.add(new Float(floatMatrix15.A[n9][0]));
                    }
                    for (n9 = 0; n9 < floatMatrix16.getRowDimension(); ++n9) {
                        this.oneClassSDs.add(new Float(floatMatrix16.A[n9][0]));
                    }
                }
                if (this.tTestDesign == 7 || this.tTestDesign == 11) {
                    for (n9 = 0; n9 < floatMatrix10.getRowDimension(); ++n9) {
                        this.meansA.add(new Float(floatMatrix10.A[n9][0]));
                        this.meansB.add(new Float(floatMatrix11.A[n9][0]));
                        this.sdA.add(new Float(floatMatrix12.A[n9][0]));
                        this.sdB.add(new Float(floatMatrix13.A[n9][0]));
                    }
                    this.isSig = new boolean[floatMatrix14.getRowDimension()];
                    for (n9 = 0; n9 < this.isSig.length; ++n9) {
                        this.isSig[n9] = floatMatrix14.A[n9][0] == 1.0f;
                    }
                    this.diffMeansBA = new double[floatMatrix14.getRowDimension()];
                    for (n9 = 0; n9 < this.diffMeansBA.length; ++n9) {
                        this.diffMeansBA[n9] = (double)floatMatrix11.A[n9][0] - (double)floatMatrix10.A[n9][0];
                    }
                    this.negLog10PValues = new double[floatMatrix14.getRowDimension()];
                    double d3 = Math.log(10.0);
                    for (n8 = 0; n8 < this.negLog10PValues.length; ++n8) {
                        d2 = floatMatrix7.A[n8][0];
                        this.negLog10PValues[n8] = -1.0 * (Math.log(d2) / d3);
                    }
                }
                if (this.tTestDesign == 8) {
                    int n12;
                    this.isSig = new boolean[floatMatrix14.getRowDimension()];
                    for (n12 = 0; n12 < this.isSig.length; ++n12) {
                        this.isSig[n12] = floatMatrix14.A[n12][0] == 1.0f;
                    }
                    this.diffMeansBA = new double[floatMatrix14.getRowDimension()];
                    for (n12 = 0; n12 < this.diffMeansBA.length; ++n12) {
                        this.diffMeansBA[n12] = (double)floatMatrix15.A[n12][0] - this.oneClassMean;
                    }
                    this.negLog10PValues = new double[floatMatrix14.getRowDimension()];
                    double d4 = Math.log(10.0);
                    for (n8 = 0; n8 < this.negLog10PValues.length; ++n8) {
                        d2 = floatMatrix7.A[n8][0];
                        this.negLog10PValues[n8] = -1.0 * (Math.log(d2) / d4);
                    }
                }
                GeneralInfo generalInfo = new GeneralInfo();
                generalInfo.time = l2;
                generalInfo.alpha = d;
                generalInfo.sigMethod = this.getSigMethod(n3);
                generalInfo.pValueBasedOn = this.getPValueBasedOn(bl);
                if (bl) {
                    generalInfo.useAllCombs = bl3;
                    generalInfo.numCombs = n4;
                }
                generalInfo.function = iDistanceMenu.getFunctionName(n6);
                generalInfo.hcl = bl2;
                generalInfo.hcl_genes = bl5;
                generalInfo.hcl_samples = bl4;
                generalInfo.hcl_method = n5;
                Vector<String> vector = new Vector<String>();
                if (this.tTestDesign == 7 || this.tTestDesign == 11) {
                    vector.add("GroupA mean");
                    vector.add("GroupA std.dev.");
                    vector.add("GroupB mean");
                    vector.add("GroupB std.dev.");
                    vector.add("Absolute t value");
                } else if (this.tTestDesign == 8) {
                    vector.add("Gene mean");
                    vector.add("Gene std.dev.");
                    vector.add("t value");
                }
                vector.add("Degrees of freedom");
                vector.add("Raw p value");
                if (n3 == 12 || n3 == 13) {
                    if (this.calculateAdjFDRPVals) {
                        vector.add("Adj p value");
                    }
                } else {
                    vector.add("Adj p value");
                }
                this.auxTitles = new String[vector.size()];
                for (n8 = 0; n8 < this.auxTitles.length; ++n8) {
                    this.auxTitles[n8] = (String)vector.get(n8);
                }
                this.auxData = new Object[this.experiment.getNumberOfGenes()][this.auxTitles.length];
                for (n8 = 0; n8 < this.auxData.length; ++n8) {
                    int n13 = 0;
                    if (this.tTestDesign == 7 || this.tTestDesign == 11) {
                        this.auxData[n8][n13++] = this.meansA.get(n8);
                        this.auxData[n8][n13++] = this.sdA.get(n8);
                        this.auxData[n8][n13++] = this.meansB.get(n8);
                        this.auxData[n8][n13++] = this.sdB.get(n8);
                    } else if (this.tTestDesign == 8) {
                        this.auxData[n8][n13++] = this.oneClassMeans.get(n8);
                        this.auxData[n8][n13++] = this.oneClassSDs.get(n8);
                    }
                    this.auxData[n8][n13++] = this.tValues.get(n8);
                    this.auxData[n8][n13++] = this.dfValues.get(n8);
                    this.auxData[n8][n13++] = this.rawPValues.get(n8);
                    if (n3 == 12 || n3 == 13) {
                        if (!this.calculateAdjFDRPVals) continue;
                        this.auxData[n8][n13++] = this.adjPValues.get(n8);
                        continue;
                    }
                    this.auxData[n8][n13++] = this.adjPValues.get(n8);
                }
                defaultMutableTreeNode = this.createResultTree(cluster, generalInfo);
                Object var52_59 = null;
                if (this.algorithm == null) break block55;
            }
            catch (Throwable throwable) {
                block56: {
                    Object var52_60 = null;
                    if (this.algorithm != null) {
                        this.algorithm.removeAlgorithmListener((AlgorithmListener)object);
                    }
                    if (this.progress == null) break block56;
                    this.progress.dispose();
                }
                throw throwable;
            }
            this.algorithm.removeAlgorithmListener((AlgorithmListener)object);
        }
        if (this.progress != null) {
            this.progress.dispose();
        }
        return defaultMutableTreeNode;
    }

    public AlgorithmData getScriptParameters(IFramework iFramework) {
        String[] stringArray;
        this.experiment = iFramework.getData().getExperiment();
        this.exptNamesVector = new Vector();
        this.data = iFramework.getData();
        int n = this.experiment.getNumberOfSamples();
        int n2 = this.experiment.getNumberOfGenes();
        for (int i = 0; i < n; ++i) {
            this.exptNamesVector.add(iFramework.getData().getSampleName(this.experiment.getSampleIndex(i)));
        }
        TtestInitDialog ttestInitDialog = new TtestInitDialog((JFrame)iFramework.getFrame(), true, this.exptNamesVector);
        ttestInitDialog.setVisible(true);
        if (!ttestInitDialog.isOkPressed()) {
            return null;
        }
        double d = 0.01;
        try {
            d = ttestInitDialog.getAlphaValue();
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(iFramework.getFrame(), "Invalid alpha value!", "Error", 0);
            return null;
        }
        this.tTestDesign = ttestInitDialog.getTestDesign();
        this.oneClassMean = 0.0;
        if (this.tTestDesign == 8) {
            this.groupAssignments = ttestInitDialog.getOneClassAssignments();
            this.oneClassMean = ttestInitDialog.getOneClassMean();
        } else if (this.tTestDesign == 7) {
            this.groupAssignments = ttestInitDialog.getGroupAssignments();
        } else if (this.tTestDesign == 11) {
            this.pairedGroupAExpts = ttestInitDialog.getPairedAExpts();
            this.pairedGroupBExpts = ttestInitDialog.getPairedBExpts();
        }
        int n3 = ttestInitDialog.getSignificanceMethod();
        if (n3 == 12) {
            this.falseNum = ttestInitDialog.getFalseNum();
            System.out.println("getScriptParams: falseNum = " + this.falseNum);
            this.calculateAdjFDRPVals = ttestInitDialog.calculateFDRPVals();
            this.doFastFDRApprox = ttestInitDialog.doFastFDRApprox();
        }
        if (n3 == 13) {
            this.falseProp = ttestInitDialog.getFalseProp();
            System.out.println("getScriptParams: falseProp = " + this.falseProp);
            this.calculateAdjFDRPVals = ttestInitDialog.calculateFDRPVals();
            this.doFastFDRApprox = ttestInitDialog.doFastFDRApprox();
        }
        boolean bl = ttestInitDialog.isDrawTrees();
        this.drawSigTreesOnly = true;
        if (bl) {
            this.drawSigTreesOnly = ttestInitDialog.drawSigTreesOnly();
        }
        boolean bl2 = ttestInitDialog.isPermut();
        this.useWelchDf = ttestInitDialog.useWelchDf();
        this.isPermutations = bl2;
        int n4 = ttestInitDialog.getUserNumCombs();
        boolean bl3 = ttestInitDialog.useAllCombs();
        IDistanceMenu iDistanceMenu = iFramework.getDistanceMenu();
        int n5 = iDistanceMenu.getDistanceFunction();
        if (n5 == 0) {
            n5 = 4;
        }
        int n6 = 0;
        boolean bl4 = false;
        boolean bl5 = false;
        int n7 = 4;
        boolean bl6 = false;
        if (bl) {
            HCLInitDialog hCLInitDialog = new HCLInitDialog(iFramework.getFrame(), iDistanceMenu.getFunctionName(n5), iDistanceMenu.isAbsoluteDistance(), true);
            if (hCLInitDialog.showModal() != 0) {
                return null;
            }
            n6 = hCLInitDialog.getMethod();
            bl4 = hCLInitDialog.isClusterExperiments();
            bl5 = hCLInitDialog.isClusterGenes();
            n7 = hCLInitDialog.getDistanceMetric();
            bl6 = hCLInitDialog.getAbsoluteSelection();
        }
        int n8 = this.experiment.getNumberOfGenes();
        AlgorithmData algorithmData = new AlgorithmData();
        algorithmData.addParam("distance-factor", String.valueOf(1.0f));
        algorithmData.addParam("distance-absolute", String.valueOf(iDistanceMenu.isAbsoluteDistance()));
        algorithmData.addParam("distance-function", String.valueOf(n5));
        algorithmData.addParam("tTestDesign", String.valueOf(this.tTestDesign));
        if (this.tTestDesign == 8 || this.tTestDesign == 7) {
            algorithmData.addIntArray("group-assignments", this.groupAssignments);
        }
        if (this.tTestDesign == 8) {
            algorithmData.addParam("oneClassMean", String.valueOf(this.oneClassMean));
        }
        if (this.tTestDesign == 11) {
            stringArray = new FloatMatrix(this.pairedGroupAExpts.size(), 1);
            FloatMatrix floatMatrix = new FloatMatrix(this.pairedGroupBExpts.size(), 1);
            for (int i = 0; i < this.pairedGroupAExpts.size(); ++i) {
                stringArray.A[i][0] = ((Integer)this.pairedGroupAExpts.get(i)).floatValue();
                floatMatrix.A[i][0] = ((Integer)this.pairedGroupBExpts.get(i)).floatValue();
            }
            algorithmData.addMatrix("pairedAExptsMatrix", (FloatMatrix)stringArray);
            algorithmData.addMatrix("pairedBExptsMatrix", floatMatrix);
        }
        algorithmData.addParam("alpha", String.valueOf(d));
        algorithmData.addParam("significance-method", String.valueOf(n3));
        if (n3 == 12) {
            algorithmData.addParam("falseNum", String.valueOf(this.falseNum));
            algorithmData.addParam("calculateAdjFDRPVals", String.valueOf(this.calculateAdjFDRPVals));
            algorithmData.addParam("useFastFDRApprox", String.valueOf(this.doFastFDRApprox));
        }
        if (n3 == 13) {
            algorithmData.addParam("falseProp", String.valueOf((float)this.falseProp));
            algorithmData.addParam("calculateAdjFDRPVals", String.valueOf(this.calculateAdjFDRPVals));
            algorithmData.addParam("useFastFDRApprox", String.valueOf(this.doFastFDRApprox));
        }
        algorithmData.addParam("is-permut", String.valueOf(bl2));
        algorithmData.addParam("num-combs", String.valueOf(n4));
        algorithmData.addParam("use-all-combs", String.valueOf(bl3));
        algorithmData.addParam("useWelchDf", String.valueOf(this.useWelchDf));
        if (bl) {
            algorithmData.addParam("hierarchical-tree", String.valueOf(true));
            algorithmData.addParam("draw-sig-trees-only", String.valueOf(this.drawSigTreesOnly));
            algorithmData.addParam("method-linkage", String.valueOf(n6));
            algorithmData.addParam("calculate-genes", String.valueOf(bl5));
            algorithmData.addParam("calculate-experiments", String.valueOf(bl4));
            algorithmData.addParam("hcl-distance-function", String.valueOf(n7));
            algorithmData.addParam("hcl-distance-absolute", String.valueOf(bl6));
        }
        algorithmData.addParam("name", "TTEST");
        algorithmData.addParam("alg-type", "cluster-genes");
        algorithmData.addParam("output-class", "partition-output");
        stringArray = new String[]{"Significant Genes", "Non-significant Genes"};
        algorithmData.addStringArray("output-nodes", stringArray);
        return algorithmData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode executeScript(IFramework iFramework, AlgorithmData algorithmData, Experiment experiment) throws AlgorithmException {
        DefaultMutableTreeNode defaultMutableTreeNode;
        block40: {
            Listener listener = new Listener();
            try {
                int n;
                double d;
                int n2;
                int n3;
                int n4;
                this.algorithm = iFramework.getAlgorithmFactory().getAlgorithm("TTEST");
                this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
                this.experiment = experiment;
                this.data = iFramework.getData();
                this.groupAssignments = algorithmData.getIntArray("group-assignments");
                this.isPermutations = algorithmData.getParams().getBoolean("is-permut");
                this.useWelchDf = algorithmData.getParams().getBoolean("useWelchDf");
                this.drawSigTreesOnly = algorithmData.getParams().getBoolean("draw-sig-trees-only");
                this.exptNamesVector = new Vector();
                int n5 = experiment.getNumberOfSamples();
                for (n4 = 0; n4 < n5; ++n4) {
                    this.exptNamesVector.add(this.data.getSampleName(n4));
                }
                n4 = algorithmData.getParams().getInt("significance-method");
                algorithmData.addMatrix("experiment", experiment.getMatrix());
                this.tTestDesign = algorithmData.getParams().getInt("tTestDesign");
                System.out.println("reached upto here");
                if (n4 == 12) {
                    this.falseNum = algorithmData.getParams().getInt("falseNum");
                    System.out.println("executeScript: fasleNum = " + this.falseNum);
                } else if (n4 == 13) {
                    this.falseProp = algorithmData.getParams().getFloat("falseProp");
                    System.out.println("executeScript: falseProp = " + this.falseProp);
                }
                int n6 = experiment.getNumberOfGenes();
                if (this.tTestDesign == 11) {
                    FloatMatrix floatMatrix = algorithmData.getMatrix("pairedAExptsMatrix");
                    FloatMatrix floatMatrix2 = algorithmData.getMatrix("pairedBExptsMatrix");
                    this.pairedGroupAExpts = new Vector();
                    this.pairedGroupBExpts = new Vector();
                    for (int i = 0; i < floatMatrix.A.length; ++i) {
                        this.pairedGroupAExpts.add(new Integer((int)floatMatrix.A[i][0]));
                        this.pairedGroupBExpts.add(new Integer((int)floatMatrix2.A[i][0]));
                    }
                }
                this.progress = new Progress(iFramework.getFrame(), "Finding significant genes", listener);
                this.progress.show();
                long l = System.currentTimeMillis();
                AlgorithmData algorithmData2 = this.algorithm.execute(algorithmData);
                long l2 = System.currentTimeMillis() - l;
                Cluster cluster = algorithmData2.getCluster("cluster");
                NodeList nodeList = cluster.getNodeList();
                AlgorithmParameters algorithmParameters = algorithmData2.getParams();
                int n7 = 2;
                this.clusters = new int[n7][];
                for (int i = 0; i < n7; ++i) {
                    this.clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
                }
                this.means = algorithmData2.getMatrix("clusters_means");
                this.variances = algorithmData2.getMatrix("clusters_variances");
                FloatMatrix floatMatrix = algorithmData2.getMatrix("sigPValues");
                FloatMatrix floatMatrix3 = algorithmData2.getMatrix("sigTValues");
                FloatMatrix floatMatrix4 = algorithmData2.getMatrix("nonSigPValues");
                FloatMatrix floatMatrix5 = algorithmData2.getMatrix("nonSigTValues");
                FloatMatrix floatMatrix6 = algorithmData2.getMatrix("rawPValues");
                FloatMatrix floatMatrix7 = algorithmData2.getMatrix("adjPValues");
                FloatMatrix floatMatrix8 = algorithmData2.getMatrix("tValues");
                FloatMatrix floatMatrix9 = algorithmData2.getMatrix("dfValues");
                FloatMatrix floatMatrix10 = algorithmData2.getMatrix("meansAMatrix");
                FloatMatrix floatMatrix11 = algorithmData2.getMatrix("meansBMatrix");
                FloatMatrix floatMatrix12 = algorithmData2.getMatrix("sdAMatrix");
                FloatMatrix floatMatrix13 = algorithmData2.getMatrix("sdBMatrix");
                FloatMatrix floatMatrix14 = algorithmData2.getMatrix("isSigMatrix");
                FloatMatrix floatMatrix15 = algorithmData2.getMatrix("oneClassMeansMatrix");
                FloatMatrix floatMatrix16 = algorithmData2.getMatrix("oneClassSDsMatrix");
                this.rawPValues = new Vector();
                this.adjPValues = new Vector();
                this.tValues = new Vector();
                this.dfValues = new Vector();
                this.meansA = new Vector();
                this.meansB = new Vector();
                this.sdA = new Vector();
                this.sdB = new Vector();
                this.oneClassMeans = new Vector();
                this.oneClassSDs = new Vector();
                for (n3 = 0; n3 < floatMatrix6.getRowDimension(); ++n3) {
                    this.rawPValues.add(new Float(floatMatrix6.A[n3][0]));
                    this.adjPValues.add(new Float(floatMatrix7.A[n3][0]));
                }
                for (n3 = 0; n3 < floatMatrix8.getRowDimension(); ++n3) {
                    this.tValues.add(new Float(floatMatrix8.A[n3][0]));
                }
                for (n3 = 0; n3 < floatMatrix9.getRowDimension(); ++n3) {
                    this.dfValues.add(new Float(floatMatrix9.A[n3][0]));
                }
                if (this.tTestDesign == 8) {
                    for (n3 = 0; n3 < floatMatrix15.getRowDimension(); ++n3) {
                        this.oneClassMeans.add(new Float(floatMatrix15.A[n3][0]));
                    }
                    for (n3 = 0; n3 < floatMatrix16.getRowDimension(); ++n3) {
                        this.oneClassSDs.add(new Float(floatMatrix16.A[n3][0]));
                    }
                }
                if (this.tTestDesign == 7 || this.tTestDesign == 11) {
                    for (n3 = 0; n3 < floatMatrix10.getRowDimension(); ++n3) {
                        this.meansA.add(new Float(floatMatrix10.A[n3][0]));
                        this.meansB.add(new Float(floatMatrix11.A[n3][0]));
                        this.sdA.add(new Float(floatMatrix12.A[n3][0]));
                        this.sdB.add(new Float(floatMatrix13.A[n3][0]));
                    }
                    this.isSig = new boolean[floatMatrix14.getRowDimension()];
                    for (n3 = 0; n3 < this.isSig.length; ++n3) {
                        this.isSig[n3] = floatMatrix14.A[n3][0] == 1.0f;
                    }
                    this.diffMeansBA = new double[floatMatrix14.getRowDimension()];
                    for (n3 = 0; n3 < this.diffMeansBA.length; ++n3) {
                        this.diffMeansBA[n3] = (double)floatMatrix11.A[n3][0] - (double)floatMatrix10.A[n3][0];
                    }
                    this.negLog10PValues = new double[floatMatrix14.getRowDimension()];
                    double d2 = Math.log(10.0);
                    for (n2 = 0; n2 < this.negLog10PValues.length; ++n2) {
                        d = floatMatrix7.A[n2][0];
                        this.negLog10PValues[n2] = -1.0 * (Math.log(d) / d2);
                    }
                }
                if (this.tTestDesign == 8) {
                    int n8;
                    this.isSig = new boolean[floatMatrix14.getRowDimension()];
                    for (n8 = 0; n8 < this.isSig.length; ++n8) {
                        this.isSig[n8] = floatMatrix14.A[n8][0] == 1.0f;
                    }
                    this.diffMeansBA = new double[floatMatrix14.getRowDimension()];
                    for (n8 = 0; n8 < this.diffMeansBA.length; ++n8) {
                        this.diffMeansBA[n8] = (double)floatMatrix15.A[n8][0] - this.oneClassMean;
                    }
                    this.negLog10PValues = new double[floatMatrix14.getRowDimension()];
                    double d3 = Math.log(10.0);
                    for (n2 = 0; n2 < this.negLog10PValues.length; ++n2) {
                        d = floatMatrix7.A[n2][0];
                        this.negLog10PValues[n2] = -1.0 * (Math.log(d) / d3);
                    }
                }
                GeneralInfo generalInfo = new GeneralInfo();
                generalInfo.time = l2;
                AlgorithmParameters algorithmParameters2 = algorithmData.getParams();
                generalInfo.alpha = algorithmParameters2.getFloat("alpha");
                generalInfo.sigMethod = this.getSigMethod(algorithmParameters2.getInt("significance-method"));
                n2 = algorithmParameters2.getBoolean("is-permut");
                generalInfo.pValueBasedOn = this.getPValueBasedOn(n2 != 0);
                if (n2 != 0) {
                    generalInfo.useAllCombs = algorithmParameters2.getBoolean("use-all-combs");
                    generalInfo.numCombs = algorithmParameters2.getInt("num-combs");
                }
                generalInfo.function = iFramework.getDistanceMenu().getFunctionName(algorithmParameters2.getInt("distance-function"));
                generalInfo.hcl = algorithmParameters2.getBoolean("hierarchical-tree");
                if (generalInfo.hcl) {
                    generalInfo.hcl_genes = algorithmParameters2.getBoolean("calculate-genes");
                    generalInfo.hcl_samples = algorithmParameters2.getBoolean("calculate-experiments");
                    generalInfo.hcl_method = algorithmParameters2.getInt("method-linkage");
                }
                Vector<String> vector = new Vector<String>();
                if (this.tTestDesign == 7 || this.tTestDesign == 11) {
                    vector.add("GroupA mean");
                    vector.add("GroupA std.dev.");
                    vector.add("GroupB mean");
                    vector.add("GroupB std.dev.");
                    vector.add("Absolute t value");
                } else if (this.tTestDesign == 8) {
                    vector.add("Gene mean");
                    vector.add("Gene std.dev.");
                    vector.add("t value");
                }
                vector.add("Degrees of freedom");
                vector.add("Raw p value");
                if (n4 == 12 || n4 == 13) {
                    if (this.calculateAdjFDRPVals) {
                        vector.add("Adj p value");
                    }
                } else {
                    vector.add("Adj p value");
                }
                this.auxTitles = new String[vector.size()];
                for (n = 0; n < this.auxTitles.length; ++n) {
                    this.auxTitles[n] = (String)vector.get(n);
                }
                this.auxData = new Object[experiment.getNumberOfGenes()][this.auxTitles.length];
                for (n = 0; n < this.auxData.length; ++n) {
                    int n9 = 0;
                    if (this.tTestDesign == 7 || this.tTestDesign == 11) {
                        this.auxData[n][n9++] = this.meansA.get(n);
                        this.auxData[n][n9++] = this.sdA.get(n);
                        this.auxData[n][n9++] = this.meansB.get(n);
                        this.auxData[n][n9++] = this.sdB.get(n);
                    } else if (this.tTestDesign == 8) {
                        this.auxData[n][n9++] = this.oneClassMeans.get(n);
                        this.auxData[n][n9++] = this.oneClassSDs.get(n);
                    }
                    this.auxData[n][n9++] = this.tValues.get(n);
                    this.auxData[n][n9++] = this.dfValues.get(n);
                    this.auxData[n][n9++] = this.rawPValues.get(n);
                    if (n4 == 12 || n4 == 13) {
                        if (!this.calculateAdjFDRPVals) continue;
                        this.auxData[n][n9++] = this.adjPValues.get(n);
                        continue;
                    }
                    this.auxData[n][n9++] = this.adjPValues.get(n);
                }
                defaultMutableTreeNode = this.createResultTree(cluster, generalInfo);
                Object var39_46 = null;
                if (this.algorithm == null) break block40;
            }
            catch (Throwable throwable) {
                block41: {
                    Object var39_47 = null;
                    if (this.algorithm != null) {
                        this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
                    }
                    if (this.progress == null) break block41;
                    this.progress.dispose();
                }
                throw throwable;
            }
            this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
        }
        if (this.progress != null) {
            this.progress.dispose();
        }
        return defaultMutableTreeNode;
    }

    private String getPValueBasedOn(boolean bl) {
        String string = "";
        string = bl ? "permutation" : "t-distribution";
        return string;
    }

    private String getSigMethod(int n) {
        String string = "";
        if (n == 4) {
            string = "Just alpha";
        } else if (n == 5) {
            string = "Standard Bonferroni correction";
        } else if (n == 6) {
            string = "Adjusted Bonferroni correction";
        } else if (n == 10) {
            string = "Step-down Westfall Young: Min P";
        } else if (n == 9) {
            string = "Step-down Westfall Young: Max T";
        } else if (n == 12) {
            string = "False significant number: " + this.falseNum + " or less";
        } else if (n == 13) {
            string = "False significant proportion: " + this.falseProp + " or less";
        }
        return string;
    }

    private DefaultMutableTreeNode createResultTree(Cluster cluster, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("T Tests");
        this.addResultNodes(defaultMutableTreeNode, cluster, generalInfo);
        return defaultMutableTreeNode;
    }

    private void addResultNodes(DefaultMutableTreeNode defaultMutableTreeNode, Cluster cluster, GeneralInfo generalInfo) {
        this.addExpressionImages(defaultMutableTreeNode);
        this.addHierarchicalTrees(defaultMutableTreeNode, cluster, generalInfo);
        this.addCentroidViews(defaultMutableTreeNode);
        this.addTableViews(defaultMutableTreeNode);
        this.addClusterInfo(defaultMutableTreeNode);
        this.addVolcanoPlot(defaultMutableTreeNode);
        this.addGeneralInfo(defaultMutableTreeNode, generalInfo);
    }

    private void addTableViews(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Table Views");
        ClusterTableViewer clusterTableViewer = new ClusterTableViewer(this.experiment, this.clusters, this.data, this.auxTitles, this.auxData);
        for (int i = 0; i < this.clusters.length; ++i) {
            if (i < this.clusters.length - 1) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", (IViewer)clusterTableViewer, (Object)new Integer(i))));
                continue;
            }
            if (i != this.clusters.length - 1) continue;
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)clusterTableViewer, (Object)new Integer(i))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addExpressionImages(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Expression Images");
        TtestExperimentViewer ttestExperimentViewer = new TtestExperimentViewer(this.experiment, this.clusters, this.tTestDesign, this.oneClassMeans, this.oneClassSDs, this.meansA, this.meansB, this.sdA, this.sdB, this.rawPValues, this.adjPValues, this.tValues, this.dfValues);
        for (int i = 0; i < this.clusters.length; ++i) {
            if (i < this.clusters.length - 1) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", (IViewer)ttestExperimentViewer, (Object)new Integer(i))));
                continue;
            }
            if (i != this.clusters.length - 1) continue;
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)ttestExperimentViewer, (Object)new Integer(i))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addHierarchicalTrees(DefaultMutableTreeNode defaultMutableTreeNode, Cluster cluster, GeneralInfo generalInfo) {
        if (!generalInfo.hcl) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Hierarchical Trees");
        NodeList nodeList = cluster.getNodeList();
        if (!this.drawSigTreesOnly) {
            for (int i = 0; i < nodeList.getSize(); ++i) {
                if (i < nodeList.getSize() - 1) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", this.createHCLViewer(nodeList.getNode(i), generalInfo))));
                    continue;
                }
                if (i != nodeList.getSize() - 1) continue;
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", this.createHCLViewer(nodeList.getNode(i), generalInfo))));
            }
        } else {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", this.createHCLViewer(nodeList.getNode(0), generalInfo))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private IViewer createHCLViewer(Node node, GeneralInfo generalInfo) {
        HCLTreeData hCLTreeData;
        HCLTreeData hCLTreeData2 = hCLTreeData = generalInfo.hcl_genes ? this.getResult(node, 0) : null;
        HCLTreeData hCLTreeData3 = generalInfo.hcl_samples ? this.getResult(node, generalInfo.hcl_genes ? 4 : 0) : null;
        return new HCLViewer(this.experiment, node.getFeaturesIndexes(), hCLTreeData, hCLTreeData3);
    }

    private HCLTreeData getResult(Node node, int n) {
        HCLTreeData hCLTreeData = new HCLTreeData();
        NodeValueList nodeValueList = node.getValues();
        hCLTreeData.child_1_array = (int[])nodeValueList.getNodeValue((int)n).value;
        hCLTreeData.child_2_array = (int[])nodeValueList.getNodeValue((int)(n + 1)).value;
        hCLTreeData.node_order = (int[])nodeValueList.getNodeValue((int)(n + 2)).value;
        hCLTreeData.height = (float[])nodeValueList.getNodeValue((int)(n + 3)).value;
        return hCLTreeData;
    }

    private void addClusterInfo(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Cluster Information");
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Results (#,%)", (IViewer)new TtestInfoViewer(this.clusters, this.experiment.getNumberOfGenes()))));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addCentroidViews(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Expression Graphs");
        TtestCentroidViewer ttestCentroidViewer = new TtestCentroidViewer(this.experiment, this.clusters, this.tTestDesign, this.oneClassMeans, this.oneClassSDs, this.meansA, this.meansB, this.sdA, this.sdB, this.rawPValues, this.adjPValues, this.tValues, this.dfValues);
        ttestCentroidViewer.setMeans(this.means.A);
        ttestCentroidViewer.setVariances(this.variances.A);
        for (int i = 0; i < this.clusters.length; ++i) {
            if (i == 0) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", (IViewer)ttestCentroidViewer, (Object)new CentroidUserObject(i, 0))));
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", (IViewer)ttestCentroidViewer, (Object)new CentroidUserObject(i, 1))));
                continue;
            }
            if (i != 1) continue;
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)ttestCentroidViewer, (Object)new CentroidUserObject(i, 0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)ttestCentroidViewer, (Object)new CentroidUserObject(i, 1))));
        }
        TtestCentroidsViewer ttestCentroidsViewer = new TtestCentroidsViewer(this.experiment, this.clusters, this.tTestDesign, this.oneClassMeans, this.oneClassSDs, this.meansA, this.meansB, this.sdA, this.sdB, this.rawPValues, this.adjPValues, this.tValues, this.dfValues);
        ttestCentroidsViewer.setMeans(this.means.A);
        ttestCentroidsViewer.setVariances(this.variances.A);
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("All Genes", (IViewer)ttestCentroidsViewer, (Object)new Integer(0))));
        defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("All Genes", (IViewer)ttestCentroidsViewer, (Object)new Integer(1))));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
    }

    private void addVolcanoPlot(DefaultMutableTreeNode defaultMutableTreeNode) {
        TTestVolcanoPlotViewer tTestVolcanoPlotViewer = new TTestVolcanoPlotViewer(this.experiment, this.diffMeansBA, this.negLog10PValues, this.isSig, this.tTestDesign, this.oneClassMean, this.oneClassMeans, this.oneClassSDs, this.meansA, this.meansB, this.sdA, this.sdB, this.rawPValues, this.adjPValues, this.tValues, this.dfValues);
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("Volcano Plot", (IViewer)tTestVolcanoPlotViewer)));
    }

    private void addGeneralInfo(DefaultMutableTreeNode defaultMutableTreeNode, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("General Information");
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Test design: " + generalInfo.getTestDesign()));
        defaultMutableTreeNode2.add(this.getGroupAssignmentInfo());
        if (this.tTestDesign == 8) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Mean tested against: " + this.oneClassMean));
        }
        if (this.tTestDesign == 7) {
            if (this.useWelchDf) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode("used Welch approximation"));
            } else {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode("assumed equal variances"));
            }
        }
        if (generalInfo.sigMethod.startsWith("False")) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Confidence (1 - alpha) : " + (1.0 - generalInfo.alpha) * 100.0 + " %"));
        } else {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Alpha (overall threshold p-value): " + generalInfo.alpha));
        }
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("P-values based on: " + generalInfo.pValueBasedOn));
        if (this.isPermutations) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("All permutations used: " + generalInfo.useAllCombs));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Number of permutations per gene: " + generalInfo.numCombs));
        }
        if (generalInfo.sigMethod.startsWith("False")) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(generalInfo.sigMethod));
        } else {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Significance determined by: " + generalInfo.sigMethod));
        }
        if (generalInfo.sigMethod.startsWith("False")) {
            if (this.doFastFDRApprox) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode("False discovery calculation: fast approximation"));
            } else {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode("False discovery calculation: exhaustive computation"));
            }
        }
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("HCL: " + generalInfo.getMethodName()));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Time: " + String.valueOf(generalInfo.time) + " ms"));
        if (generalInfo.hcl) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(generalInfo.function));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private DefaultMutableTreeNode getGroupAssignmentInfo() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        if (this.tTestDesign == 7) {
            defaultMutableTreeNode = new DefaultMutableTreeNode("Group assigments ");
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Group A ");
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Group B ");
            DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode("Neither group ");
            int n = 0;
            for (int i = 0; i < this.groupAssignments.length; ++i) {
                if (this.groupAssignments[i] == 1) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode((String)this.exptNamesVector.get(i)));
                    continue;
                }
                if (this.groupAssignments[i] == 2) {
                    defaultMutableTreeNode3.add(new DefaultMutableTreeNode((String)this.exptNamesVector.get(i)));
                    continue;
                }
                defaultMutableTreeNode4.add(new DefaultMutableTreeNode((String)this.exptNamesVector.get(i)));
                ++n;
            }
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            defaultMutableTreeNode.add(defaultMutableTreeNode3);
            if (n > 0) {
                defaultMutableTreeNode.add(defaultMutableTreeNode4);
            }
        } else if (this.tTestDesign == 8) {
            defaultMutableTreeNode = new DefaultMutableTreeNode("Sample details");
            DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode("In analysis ");
            DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode("Out of analysis ");
            int n = 0;
            for (int i = 0; i < this.groupAssignments.length; ++i) {
                if (this.groupAssignments[i] == 1) {
                    defaultMutableTreeNode5.add(new DefaultMutableTreeNode((String)this.exptNamesVector.get(i)));
                    continue;
                }
                defaultMutableTreeNode6.add(new DefaultMutableTreeNode((String)this.exptNamesVector.get(i)));
                ++n;
            }
            if (n == 0) {
                defaultMutableTreeNode6.add(new DefaultMutableTreeNode("None"));
            }
            defaultMutableTreeNode.add(defaultMutableTreeNode5);
            defaultMutableTreeNode.add(defaultMutableTreeNode6);
        } else if (this.tTestDesign == 11) {
            int n;
            defaultMutableTreeNode = new DefaultMutableTreeNode("Pairings ");
            boolean[] blArray = new boolean[this.exptNamesVector.size()];
            for (int i = 0; i < blArray.length; ++i) {
                blArray[i] = false;
            }
            DefaultMutableTreeNode defaultMutableTreeNode7 = new DefaultMutableTreeNode("Sample Pairs");
            DefaultMutableTreeNode defaultMutableTreeNode8 = new DefaultMutableTreeNode("Unpaired Samples");
            for (n = 0; n < this.pairedGroupAExpts.size(); ++n) {
                int n2 = (Integer)this.pairedGroupAExpts.get(n);
                int n3 = (Integer)this.pairedGroupBExpts.get(n);
                defaultMutableTreeNode7.add(new DefaultMutableTreeNode("A: " + (String)this.exptNamesVector.get(n2) + " - B: " + (String)this.exptNamesVector.get(n3)));
                blArray[n2] = true;
                blArray[n3] = true;
            }
            for (n = 0; n < blArray.length; ++n) {
                if (blArray[n]) continue;
                defaultMutableTreeNode8.add(new DefaultMutableTreeNode((String)this.exptNamesVector.get(n)));
            }
            defaultMutableTreeNode.add(defaultMutableTreeNode7);
            if (!defaultMutableTreeNode8.isLeaf()) {
                defaultMutableTreeNode.add(defaultMutableTreeNode8);
            }
        }
        return defaultMutableTreeNode;
    }

    private class GeneralInfo {
        public int clusters;
        public String design;
        public String sigMethod;
        public String pValueBasedOn;
        public double alpha;
        public int numCombs;
        public boolean useAllCombs;
        public long time;
        public String function;
        public String fdrFastOrSlow;
        private boolean hcl;
        private int hcl_method;
        private boolean hcl_genes;
        private boolean hcl_samples;

        private GeneralInfo() {
        }

        public String getMethodName() {
            return this.hcl ? HCLGUI.GeneralInfo.getMethodName(this.hcl_method) : "no linkage";
        }

        public String getTestDesign() {
            String string = "";
            if (TtestGUI.this.tTestDesign == 8) {
                string = "One-class";
            } else if (TtestGUI.this.tTestDesign == 7) {
                string = "Between-subjects";
            } else if (TtestGUI.this.tTestDesign == 11) {
                string = "Paired";
            }
            return string;
        }
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent algorithmEvent) {
            switch (algorithmEvent.getId()) {
                case 1: {
                    TtestGUI.this.progress.setUnits(algorithmEvent.getIntValue());
                    TtestGUI.this.progress.setDescription(algorithmEvent.getDescription());
                    break;
                }
                case 2: {
                    TtestGUI.this.progress.setValue(algorithmEvent.getIntValue());
                    TtestGUI.this.progress.setDescription(algorithmEvent.getDescription());
                    break;
                }
                case 3: {
                    int n = algorithmEvent.getIntValue();
                    if (n != -1) break;
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("cancel-command")) {
                TtestGUI.this.algorithm.abort();
                TtestGUI.this.progress.dispose();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            TtestGUI.this.algorithm.abort();
            TtestGUI.this.progress.dispose();
        }
    }
}

