/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.tfa;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;

public class TFAInitBox1
extends AlgorithmDialog {
    boolean okPressed = false;
    JTextField factorANameField;
    JTextField factorBNameField;
    JTextField factorALevelsField;
    JTextField factorBLevelsField;

    public TFAInitBox1(JFrame jFrame, boolean bl) {
        super(jFrame, "TFA - set factor names and levels", bl);
        this.okButton.setText("Next >");
        this.setBounds(0, 0, 600, 200);
        this.setBackground(Color.white);
        this.setDefaultCloseOperation(2);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setBorder(new EtchedBorder());
        jPanel.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel("Factor A name: ");
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 25, 50);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.factorANameField = new JTextField("Factor A", 10);
        this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 25, 0);
        gridBagLayout.setConstraints(this.factorANameField, gridBagConstraints);
        jPanel.add(this.factorANameField);
        JLabel jLabel2 = new JLabel("No. of levels of Factor A: ");
        this.buildConstraints(gridBagConstraints, 2, 0, 1, 1, 25, 0);
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel.add(jLabel2);
        this.factorALevelsField = new JTextField(10);
        this.buildConstraints(gridBagConstraints, 3, 0, 1, 1, 25, 0);
        gridBagLayout.setConstraints(this.factorALevelsField, gridBagConstraints);
        jPanel.add(this.factorALevelsField);
        JLabel jLabel3 = new JLabel("Factor B name: ");
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 25, 50);
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        jPanel.add(jLabel3);
        this.factorBNameField = new JTextField("Factor B", 10);
        this.buildConstraints(gridBagConstraints, 1, 1, 1, 1, 25, 0);
        gridBagLayout.setConstraints(this.factorBNameField, gridBagConstraints);
        jPanel.add(this.factorBNameField);
        JLabel jLabel4 = new JLabel("No. of levels of Factor B: ");
        this.buildConstraints(gridBagConstraints, 2, 1, 1, 1, 25, 0);
        gridBagLayout.setConstraints(jLabel4, gridBagConstraints);
        jPanel.add(jLabel4);
        this.factorBLevelsField = new JTextField(10);
        this.buildConstraints(gridBagConstraints, 3, 1, 1, 1, 25, 0);
        gridBagLayout.setConstraints(this.factorBLevelsField, gridBagConstraints);
        jPanel.add(this.factorBLevelsField);
        this.addContent(jPanel);
        EventListener eventListener = new EventListener();
        this.setActionListeners(eventListener);
        this.addWindowListener(eventListener);
    }

    public void setVisible(boolean bl) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        super.setVisible(bl);
    }

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public String getFactorAName() {
        return this.factorANameField.getText();
    }

    public String getFactorBName() {
        return this.factorBNameField.getText();
    }

    public int getNumFactorALevels() {
        return Integer.parseInt(this.factorALevelsField.getText());
    }

    public int getNumFactorBLevels() {
        return Integer.parseInt(this.factorBLevelsField.getText());
    }

    private boolean isBlank(String string) {
        boolean bl = true;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == ' ') continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        TFAInitBox1 tFAInitBox1 = new TFAInitBox1(new JFrame(), true);
        tFAInitBox1.setVisible(true);
        System.out.println("Factor A = " + tFAInitBox1.getFactorAName().length());
    }

    public class EventListener
    extends WindowAdapter
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                try {
                    if (TFAInitBox1.this.getNumFactorALevels() <= 1 || TFAInitBox1.this.getNumFactorBLevels() <= 1) {
                        JOptionPane.showMessageDialog(null, "Invalid number of levels", "Error", 0);
                        return;
                    }
                    if (TFAInitBox1.this.getFactorAName().length() == 0 || TFAInitBox1.this.getFactorBName().length() == 0 || TFAInitBox1.this.isBlank(TFAInitBox1.this.getFactorAName()) || TFAInitBox1.this.isBlank(TFAInitBox1.this.getFactorBName())) {
                        JOptionPane.showMessageDialog(null, "Enter names for both factors", "Error", 0);
                        return;
                    }
                    TFAInitBox1.this.okPressed = true;
                    TFAInitBox1.this.dispose();
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(null, "Invalid number of levels", "Error", 0);
                }
            } else if (string.equals("reset-command")) {
                TFAInitBox1.this.factorANameField.setText("");
                TFAInitBox1.this.factorBNameField.setText("");
                TFAInitBox1.this.factorALevelsField.setText("");
                TFAInitBox1.this.factorBLevelsField.setText("");
                TFAInitBox1.this.okPressed = false;
            } else if (string.equals("cancel-command")) {
                TFAInitBox1.this.okPressed = false;
                TFAInitBox1.this.dispose();
            } else if (string.equals("info-command")) {
                // empty if block
            }
        }
    }
}

