/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.tfa;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;

public class TFAInfoViewer
extends ViewerAdapter
implements Serializable {
    public static final long serialVersionUID = 202020010001L;
    private JComponent header;
    private JTextArea content;
    String[] factorNames;

    public TFAInfoViewer(int[][] nArray, int n, String[] stringArray) {
        this.factorNames = stringArray;
        this.header = this.createHeader();
        this.content = this.createContent(nArray, n);
        this.setMaxWidth(this.content, this.header);
    }

    public JComponent getContentComponent() {
        return this.content;
    }

    public JComponent getHeaderComponent() {
        return this.header;
    }

    private JComponent createHeader() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(Color.white);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        jPanel.add((Component)new JLabel("<html><body bgcolor='#FFFFFF'><font face='serif' size='5' color='#000080'><b>Cluster Information</b></font></body></html>"), gridBagConstraints);
        return jPanel;
    }

    private JTextArea createContent(int[][] nArray, int n) {
        JTextArea jTextArea = new JTextArea(nArray.length * 3, 20);
        jTextArea.setEditable(false);
        jTextArea.setMargin(new Insets(0, 10, 0, 0));
        StringBuffer stringBuffer = new StringBuffer(nArray.length * 3 * 10);
        String[] stringArray = new String[]{this.factorNames[0] + " significant", this.factorNames[1] + " significant", "Interaction signficant", this.factorNames[0] + " non-significant", this.factorNames[1] + " non-significant", "Interaction non-signficant", "Non-significant for all effects"};
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(stringArray[i] + " ");
            stringBuffer.append("\t");
            stringBuffer.append("# of Genes: " + nArray[i].length);
            stringBuffer.append("\n\t\t");
            stringBuffer.append("% of Genes out of total: " + Math.round((float)nArray[i].length / (float)n * 100.0f) + "%");
            stringBuffer.append("\n\n");
        }
        jTextArea.setText(stringBuffer.toString());
        jTextArea.setCaretPosition(0);
        return jTextArea;
    }

    private void setMaxWidth(JComponent jComponent, JComponent jComponent2) {
        int n = jComponent.getPreferredSize().width;
        int n2 = jComponent2.getPreferredSize().width;
        if (n > n2) {
            jComponent2.setPreferredSize(new Dimension(n, jComponent2.getPreferredSize().height));
        } else {
            jComponent.setPreferredSize(new Dimension(n2, jComponent.getPreferredSize().height));
        }
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }
}

