/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.tfa;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;

public class TFACentroidViewer
extends CentroidViewer {
    private JPopupMenu popup;
    String[] auxTitles;
    Object[][] auxData;

    public TFACentroidViewer(Experiment experiment, int[][] nArray, String[] stringArray, Object[][] objectArray) {
        super(experiment, nArray);
        this.auxTitles = stringArray;
        this.auxData = objectArray;
        Listener listener = new Listener();
        this.popup = this.createJPopupMenu(listener);
        this.getContentComponent().addMouseListener(listener);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Listener listener = new Listener();
        this.popup = this.createJPopupMenu(listener);
        this.getContentComponent().addMouseListener(listener);
    }

    private JPopupMenu createJPopupMenu(Listener listener) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.addMenuItems(jPopupMenu, listener);
        return jPopupMenu;
    }

    private void onSaveClusters() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            ExperimentUtil.saveAllGeneClustersWithAux((Frame)frame, (Experiment)this.getExperiment(), (IData)this.getData(), (int[][])this.getClusters(), (String[])this.auxTitles, (Object[][])this.auxData);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(frame, "Can not save clusters!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    private void onSaveCluster() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            ExperimentUtil.saveGeneClusterWithAux((Frame)frame, (Experiment)this.getExperiment(), (IData)this.getData(), (int[])this.getCluster(), (String[])this.auxTitles, (Object[][])this.auxData);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(frame, "Can not save cluster!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    private void onSetDefaultColor() {
        this.setClusterColor(null);
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("save-cluster-cmd")) {
                TFACentroidViewer.this.onSaveCluster();
            } else if (string.equals("save-all-clusters-cmd")) {
                TFACentroidViewer.this.onSaveClusters();
            } else if (string.equals("store-cluster-cmd")) {
                TFACentroidViewer.this.storeCluster();
            } else if (string.equals("set-def-color-cmd")) {
                TFACentroidViewer.this.onSetDefaultColor();
            } else if (string.equals("set-y-to-exp-max-cmd")) {
                TFACentroidViewer.this.yRangeOption = CentroidViewer.USE_EXPERIMENT_MAX;
                TFACentroidViewer.this.setClusterMaxMenuItem.setEnabled(true);
                TFACentroidViewer.this.setOverallMaxMenuItem.setEnabled(false);
                TFACentroidViewer.this.repaint();
            } else if (string.equals("set-y-to-cluster-max-cmd")) {
                TFACentroidViewer.this.yRangeOption = CentroidViewer.USE_CLUSTER_MAX;
                TFACentroidViewer.this.setClusterMaxMenuItem.setEnabled(false);
                TFACentroidViewer.this.setOverallMaxMenuItem.setEnabled(true);
                TFACentroidViewer.this.repaint();
            } else if (string.equals("launch-new-session-cmd")) {
                TFACentroidViewer.this.launchNewSession();
            } else if (string.equals("toggle-ref-line-cmd")) {
                TFACentroidViewer.this.showRefLine = !TFACentroidViewer.this.showRefLine;
                TFACentroidViewer.this.repaint();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger() || TFACentroidViewer.this.getCluster() == null || TFACentroidViewer.this.getCluster().length == 0) {
                return;
            }
            TFACentroidViewer.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

