/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.terrain;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.impl.terrain.TerrainViewer;

public class SerializedTerrainViewer
extends JPanel
implements IViewer,
Serializable {
    public static final long serialVersionUID = 202019010001L;
    private TerrainViewer trn;
    private boolean isGenes;
    private Experiment experiment;
    private int[][] clusters;
    private float[][] weights;
    private float[][] locations;
    private float sigma;
    private int labelIndex;

    public SerializedTerrainViewer(boolean bl, IFramework iFramework, int[][] nArray, float[][] fArray, float[][] fArray2, float f) {
        this.isGenes = bl;
        this.experiment = iFramework.getData().getExperiment();
        this.clusters = nArray;
        this.weights = fArray;
        this.locations = fArray2;
        this.sigma = f;
        this.labelIndex = iFramework.getDisplayMenu().getLabelIndex();
        this.trn = new TerrainViewer(bl, this.experiment, nArray, fArray, fArray2, f, iFramework.getDisplayMenu().getLabelIndex());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeBoolean(this.isGenes);
        objectOutputStream.writeObject(this.experiment);
        objectOutputStream.writeObject(this.clusters);
        objectOutputStream.writeObject(this.weights);
        objectOutputStream.writeObject(this.locations);
        objectOutputStream.writeFloat(this.sigma);
        objectOutputStream.writeInt(this.labelIndex);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.isGenes = objectInputStream.readBoolean();
        this.experiment = (Experiment)objectInputStream.readObject();
        this.clusters = (int[][])objectInputStream.readObject();
        this.weights = (float[][])objectInputStream.readObject();
        this.locations = (float[][])objectInputStream.readObject();
        this.sigma = objectInputStream.readFloat();
        this.labelIndex = objectInputStream.readInt();
        this.trn = new TerrainViewer(this.isGenes, this.experiment, this.clusters, this.weights, this.locations, this.sigma, this.labelIndex);
    }

    public JComponent getContentComponent() {
        return this.trn.getContentComponent();
    }

    public JComponent getCornerComponent(int n) {
        return this.trn.getCornerComponent(n);
    }

    public JComponent getHeaderComponent() {
        return this.trn.getHeaderComponent();
    }

    public BufferedImage getImage() {
        return this.trn.getImage();
    }

    public JComponent getRowHeaderComponent() {
        return this.trn.getRowHeaderComponent();
    }

    public void onClosed() {
        this.trn.onClosed();
    }

    public void onDataChanged(IData iData) {
        this.trn.onDataChanged(iData);
    }

    public void onDeselected() {
        this.trn.onDeselected();
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
        this.trn.onMenuChanged(iDisplayMenu);
    }

    public void onSelected(IFramework iFramework) {
        this.trn.onSelected(iFramework);
    }

    public int[][] getClusters() {
        return null;
    }

    public Experiment getExperiment() {
        return null;
    }

    public int getViewerType() {
        return -1;
    }
}

