/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.terrain;

import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Material;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Point2f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;

public class SelectionShape
extends Shape3D {
    private Point3d from = new Point3d();
    private Point3d to = new Point3d();
    private static final float[] normals = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f};

    public SelectionShape() {
        this.setCapability(12);
        this.setGeometry(this.createGeometry());
        this.setAppearance(this.createAppearance());
    }

    public void startSelection(Point3d point3d) {
        if (point3d == null) {
            return;
        }
        this.from = point3d;
    }

    public void dragSelection(Point3d point3d) {
        if (point3d == null) {
            return;
        }
        this.to = point3d;
        this.updateCoords((GeometryArray)this.getGeometry(), this.from, this.to);
    }

    public boolean hasSelection() {
        return !this.from.equals((Tuple3d)this.to);
    }

    public Point2f getStartCoords() {
        float f = (float)Math.min(this.from.x, this.to.x);
        float f2 = (float)Math.min(this.from.z, this.to.z);
        return new Point2f(f, f2);
    }

    public Point2f getEndCoords() {
        float f = (float)Math.max(this.from.x, this.to.x);
        float f2 = (float)Math.max(this.from.z, this.to.z);
        return new Point2f(f, f2);
    }

    public void clearSelection() {
        this.from.set(0.0, 0.0, 0.0);
        this.to.set(0.0, 0.0, 0.0);
        this.updateCoords((GeometryArray)this.getGeometry(), this.from, this.to);
    }

    protected Appearance createAppearance() {
        PolygonAttributes polygonAttributes = new PolygonAttributes();
        polygonAttributes.setCullFace(0);
        TransparencyAttributes transparencyAttributes = new TransparencyAttributes();
        transparencyAttributes.setTransparency(0.5f);
        transparencyAttributes.setTransparencyMode(2);
        Material material = new Material();
        material.setDiffuseColor(0.5f, 0.5f, 0.5f);
        Appearance appearance = new Appearance();
        appearance.setTransparencyAttributes(transparencyAttributes);
        appearance.setPolygonAttributes(polygonAttributes);
        appearance.setMaterial(material);
        return appearance;
    }

    protected Geometry createGeometry() {
        QuadArray quadArray = new QuadArray(24, 3);
        quadArray.setCapability(1);
        quadArray.setNormals(0, normals);
        quadArray.setCapability(18);
        quadArray.setCapability(8);
        quadArray.setCapability(17);
        quadArray.setCapability(0);
        return quadArray;
    }

    public void updateData(Geometry geometry) {
        this.updateCoords((GeometryArray)geometry, this.from, this.to);
    }

    protected void updateCoords(GeometryArray geometryArray, Point3d point3d, Point3d point3d2) {
        float f = (float)Math.min(point3d.x, point3d2.x);
        float f2 = (float)Math.min(point3d.z, point3d2.z);
        float f3 = (float)Math.max(point3d.x, point3d2.x);
        float f4 = (float)Math.max(point3d.z, point3d2.z);
        float f5 = 0.0f;
        float f6 = point3d.equals((Tuple3d)point3d2) ? 0.0f : 0.25f;
        Point3f point3f = new Point3f();
        point3f.set(f, f5, f4);
        geometryArray.setCoordinate(0, point3f);
        point3f.set(f3, f5, f4);
        geometryArray.setCoordinate(1, point3f);
        point3f.set(f3, f6, f4);
        geometryArray.setCoordinate(2, point3f);
        point3f.set(f, f6, f4);
        geometryArray.setCoordinate(3, point3f);
        point3f.set(f, f5, f2);
        geometryArray.setCoordinate(4, point3f);
        point3f.set(f, f6, f2);
        geometryArray.setCoordinate(5, point3f);
        point3f.set(f3, f6, f2);
        geometryArray.setCoordinate(6, point3f);
        point3f.set(f3, f5, f2);
        geometryArray.setCoordinate(7, point3f);
        point3f.set(f, f5, f2);
        geometryArray.setCoordinate(8, point3f);
        point3f.set(f, f5, f4);
        geometryArray.setCoordinate(9, point3f);
        point3f.set(f, f6, f4);
        geometryArray.setCoordinate(10, point3f);
        point3f.set(f, f6, f2);
        geometryArray.setCoordinate(11, point3f);
        point3f.set(f3, f5, f4);
        geometryArray.setCoordinate(12, point3f);
        point3f.set(f3, f5, f2);
        geometryArray.setCoordinate(13, point3f);
        point3f.set(f3, f6, f2);
        geometryArray.setCoordinate(14, point3f);
        point3f.set(f3, f6, f4);
        geometryArray.setCoordinate(15, point3f);
        point3f.set(f, f6, f2);
        geometryArray.setCoordinate(16, point3f);
        point3f.set(f, f6, f4);
        geometryArray.setCoordinate(17, point3f);
        point3f.set(f3, f6, f4);
        geometryArray.setCoordinate(18, point3f);
        point3f.set(f3, f6, f2);
        geometryArray.setCoordinate(19, point3f);
        point3f.set(f, f5, f2);
        geometryArray.setCoordinate(20, point3f);
        point3f.set(f3, f5, f2);
        geometryArray.setCoordinate(21, point3f);
        point3f.set(f3, f5, f4);
        geometryArray.setCoordinate(22, point3f);
        point3f.set(f, f5, f4);
        geometryArray.setCoordinate(23, point3f);
    }
}

