/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.terrain;

import java.awt.geom.Rectangle2D;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.Shape3D;
import javax.vecmath.Point2f;
import javax.vecmath.Tuple2f;
import org.tigr.microarray.mev.cluster.gui.impl.util.FloatArray;

public class LinksShape
extends Shape3D {
    private int[][] subnets;
    private float[][] weights;
    private float[][] locations;
    private Point2f left_up = new Point2f(0.0f, 0.0f);
    private Point2f right_bottom = new Point2f(1.0f, 1.0f);
    private float threshold = 0.8f;
    private boolean visible = false;
    private static final float[][] EMPTY_BUF = new float[][]{{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}};

    public LinksShape(int[][] nArray, float[][] fArray, float[][] fArray2) {
        this.setCapability(12);
        this.setCapability(13);
        this.setCapability(14);
        this.subnets = nArray;
        this.weights = fArray;
        this.locations = fArray2;
        this.updateGeometry();
        this.setAppearance(this.createAppearance());
    }

    public void setZoom(Point2f point2f, Point2f point2f2) {
        this.left_up.set((Tuple2f)point2f);
        this.right_bottom.set((Tuple2f)point2f2);
        this.updateGeometry();
    }

    public void setThreshold(float f) {
        this.threshold = f;
        this.updateGeometry();
    }

    public float getThreshold() {
        return this.threshold;
    }

    public void setVisible(boolean bl) {
        if (this.visible == bl) {
            return;
        }
        this.visible = bl;
        this.updateGeometry();
    }

    public void setLinksWidth(float f) {
        Appearance appearance = this.getAppearance();
        LineAttributes lineAttributes = appearance.getLineAttributes();
        lineAttributes.setLineWidth(f);
    }

    public float getLinksWidth() {
        Appearance appearance = this.getAppearance();
        LineAttributes lineAttributes = appearance.getLineAttributes();
        return lineAttributes.getLineWidth();
    }

    private void updateGeometry() {
        this.setGeometry(this.createGeometry());
    }

    private Geometry createGeometry() {
        float[][] fArray = this.createLinksCoordinaties();
        LineArray lineArray = new LineArray(fArray[0].length / 3, 5);
        lineArray.setCoordinates(0, fArray[0]);
        lineArray.setColors(0, fArray[1]);
        lineArray.setCapability(18);
        lineArray.setCapability(8);
        lineArray.setCapability(17);
        lineArray.setCapability(0);
        return lineArray;
    }

    private float[][] createLinksCoordinaties() {
        if (!this.visible) {
            return EMPTY_BUF;
        }
        Point2f point2f = new Point2f();
        Point2f point2f2 = new Point2f();
        Point2f point2f3 = new Point2f();
        Point2f point2f4 = new Point2f();
        Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, 1.0f, 1.0f);
        float f = 1.0f / Math.max(this.right_bottom.x - this.left_up.x, this.right_bottom.y - this.left_up.y);
        boolean bl = false;
        FloatArray floatArray = new FloatArray(100);
        FloatArray floatArray2 = new FloatArray(100);
        for (int i = 0; i < this.subnets.length; ++i) {
            if (this.subnets[i].length <= 1) continue;
            float f2 = (this.locations[i][0] - this.left_up.x) * f;
            float f3 = (this.locations[i][1] - this.left_up.y) * f;
            if (!(f2 >= 0.0f) || !(f2 <= 1.0f) || !(f3 >= 0.0f) || !(f3 <= 1.0f)) continue;
            for (int j = 1; j < this.subnets[i].length; ++j) {
                float f4 = (this.locations[this.subnets[i][j]][0] - this.left_up.x) * f;
                float f5 = (this.locations[this.subnets[i][j]][1] - this.left_up.y) * f;
                point2f.set(f2, f3);
                point2f2.set(f4, f5);
                if (!(Math.abs(this.weights[i][j]) > this.threshold) || !this.isLineIntersects(float_, point2f, point2f2, point2f3, point2f4)) continue;
                floatArray.add(point2f3.x);
                floatArray.add(0.0f);
                floatArray.add(point2f3.y);
                floatArray.add(point2f4.x);
                floatArray.add(0.0f);
                floatArray.add(point2f4.y);
                floatArray2.add(this.weights[i][j]);
                floatArray2.add(0.0f);
                floatArray2.add(1.0f - this.weights[i][j]);
                floatArray2.add(this.weights[i][j]);
                floatArray2.add(0.0f);
                floatArray2.add(1.0f - this.weights[i][j]);
            }
        }
        if (floatArray.getSize() == 0) {
            return EMPTY_BUF;
        }
        float[][] fArrayArray = new float[][]{floatArray.toArray(), floatArray2.toArray()};
        return fArrayArray;
    }

    private final boolean isIntersectVerticalLine(Point2f point2f, Point2f point2f2, float f, float f2, float f3, Point2f point2f3) {
        if (point2f.x < f && point2f2.x < f || point2f.x > f && point2f2.x > f) {
            return false;
        }
        float f4 = (point2f2.y - point2f.y) / (point2f2.x - point2f.x);
        float f5 = f4 * (f - point2f.x);
        point2f3.x = f;
        point2f3.y = point2f.y + f5;
        return point2f3.y > Math.min(f2, f3) && point2f3.y < Math.max(f2, f3);
    }

    private final boolean isIntersectHorizontalLine(Point2f point2f, Point2f point2f2, float f, float f2, float f3, Point2f point2f3) {
        if (point2f.y < f && point2f2.y < f || point2f.y > f && point2f2.y > f) {
            return false;
        }
        float f4 = (point2f2.y - point2f.y) / (point2f2.x - point2f.x);
        float f5 = (f - point2f.y) / f4;
        point2f3.x = point2f.x + f5;
        point2f3.y = f;
        return point2f3.x > Math.min(f2, f3) && point2f3.x < Math.max(f2, f3);
    }

    private final boolean isInternalPoint(Rectangle2D.Float float_, Point2f point2f, Point2f point2f2, Point2f point2f3) {
        boolean bl = float_.contains(point2f.x, point2f.y);
        boolean bl2 = float_.contains(point2f2.x, point2f2.y);
        if (bl) {
            point2f3.set((Tuple2f)point2f);
            return true;
        }
        if (bl2) {
            point2f3.set((Tuple2f)point2f2);
            return true;
        }
        return false;
    }

    private final boolean isLineIntersects(Rectangle2D.Float float_, Point2f point2f, Point2f point2f2, Point2f point2f3, Point2f point2f4) {
        point2f3.set((Tuple2f)point2f);
        point2f4.set((Tuple2f)point2f2);
        if (float_.contains(point2f.x, point2f.y) && float_.contains(point2f2.x, point2f2.y)) {
            return true;
        }
        if (point2f.x < float_.x && point2f2.x < float_.x) {
            return false;
        }
        if (point2f.y < float_.y && point2f2.y < float_.y) {
            return false;
        }
        if (point2f.x > float_.x + float_.width && point2f2.x > float_.x + float_.width) {
            return false;
        }
        if (point2f.y > float_.y + float_.height && point2f2.y > float_.y + float_.height) {
            return false;
        }
        if (point2f.x == point2f2.x) {
            if (point2f.y < float_.y) {
                point2f3.y = float_.y;
            } else if (point2f.y > float_.y + float_.height) {
                point2f3.y = float_.y + float_.height;
            }
            if (point2f2.y < float_.y) {
                point2f4.y = float_.y;
            } else if (point2f2.y > float_.y + float_.height) {
                point2f4.y = float_.y + float_.height;
            }
            return true;
        }
        if (point2f.y == point2f2.y) {
            if (point2f.x < float_.x) {
                point2f3.x = float_.x;
            } else if (point2f.x > float_.x + float_.width) {
                point2f3.x = float_.x + float_.width;
            }
            if (point2f2.x < float_.x) {
                point2f4.x = float_.x;
            } else if (point2f2.x > float_.x + float_.width) {
                point2f4.x = float_.x + float_.width;
            }
            return true;
        }
        if (this.isIntersectVerticalLine(point2f, point2f2, float_.x, float_.y, float_.y + float_.height, point2f3)) {
            return this.isIntersectVerticalLine(point2f, point2f2, float_.x + float_.width, float_.y, float_.y + float_.height, point2f4) || this.isIntersectHorizontalLine(point2f, point2f2, float_.y, float_.x, float_.x + float_.width, point2f4) || this.isIntersectHorizontalLine(point2f, point2f2, float_.y + float_.height, float_.x, float_.x + float_.width, point2f4) || this.isInternalPoint(float_, point2f, point2f2, point2f4);
            {
            }
        }
        if (this.isIntersectVerticalLine(point2f, point2f2, float_.x + float_.width, float_.y, float_.y + float_.height, point2f3)) {
            return this.isIntersectHorizontalLine(point2f, point2f2, float_.y + float_.height, float_.x, float_.x + float_.width, point2f4) || this.isIntersectHorizontalLine(point2f, point2f2, float_.y, float_.x, float_.x + float_.width, point2f4) || this.isInternalPoint(float_, point2f, point2f2, point2f4);
            {
            }
        }
        if (this.isIntersectHorizontalLine(point2f, point2f2, float_.y, float_.x, float_.x + float_.width, point2f3)) {
            return this.isIntersectHorizontalLine(point2f, point2f2, float_.y + float_.height, float_.x, float_.x + float_.width, point2f4) || this.isInternalPoint(float_, point2f, point2f2, point2f4);
            {
            }
        }
        if (this.isIntersectHorizontalLine(point2f, point2f2, float_.y + float_.height, float_.x, float_.x + float_.width, point2f3)) {
            return this.isInternalPoint(float_, point2f, point2f2, point2f4);
            {
            }
        }
        return false;
    }

    protected Appearance createAppearance() {
        LineAttributes lineAttributes = new LineAttributes();
        lineAttributes.setCapability(0);
        lineAttributes.setCapability(1);
        Appearance appearance = new Appearance();
        appearance.setCapability(16);
        appearance.setCapability(17);
        appearance.setLineAttributes(lineAttributes);
        appearance.setMaterial(new Material());
        return appearance;
    }
}

