/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.terrain;

import java.awt.image.BufferedImage;
import java.util.Arrays;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GeometryUpdater;
import javax.media.j3d.Material;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TriangleStripArray;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.tigr.microarray.mev.cluster.gui.impl.terrain.DomainUtil;

public class Landscape
extends Shape3D
implements GeometryUpdater {
    private float[][] heights;
    private float[] coords;
    private float[] colors;
    private float[] normals;

    public Landscape(float[][] fArray) {
        this.heights = fArray;
        this.setCapability(12);
        this.setCapability(13);
        this.setCapability(14);
        this.setCapability(1);
        this.initBuffers(fArray.length);
        Landscape.updateCoords(this.coords, this.heights);
        Landscape.updateColors(this.colors, this.heights);
        Landscape.updateNormals(this.normals, this.heights);
        this.setGeometry(this.createGeometry(fArray.length, this.coords, this.colors, this.normals));
        this.setAppearance(this.createAppearance());
    }

    private void initBuffers(int n) {
        this.coords = new float[(n - 1) * n * 2 * 3];
        this.colors = new float[(n - 1) * n * 2 * 3];
        this.normals = new float[(n - 1) * n * 2 * 3];
    }

    public void setHeights(float[][] fArray) {
        if (this.heights.length != fArray.length) {
            this.initBuffers(fArray.length);
            this.setGeometry(this.createGeometry(fArray.length, this.coords, this.colors, this.normals));
        }
        this.heights = fArray;
        ((GeometryArray)this.getGeometry()).updateData((GeometryUpdater)this);
    }

    public void setPoligonMode(int n) {
        Appearance appearance = this.getAppearance();
        PolygonAttributes polygonAttributes = appearance.getPolygonAttributes();
        polygonAttributes.setPolygonMode(n);
    }

    private Geometry createGeometry(int n, float[] fArray, float[] fArray2, float[] fArray3) {
        int[] nArray = new int[n - 1];
        Arrays.fill(nArray, n * 2);
        TriangleStripArray triangleStripArray = new TriangleStripArray(fArray.length / 3, 135, nArray);
        triangleStripArray.setCapability(8);
        triangleStripArray.setCapability(17);
        triangleStripArray.setCapability(21);
        triangleStripArray.setCapability(19);
        triangleStripArray.setCoordRefFloat(fArray);
        triangleStripArray.setColorRefFloat(fArray2);
        triangleStripArray.setNormalRefFloat(fArray3);
        return triangleStripArray;
    }

    private Appearance createAppearance() {
        PolygonAttributes polygonAttributes = new PolygonAttributes();
        polygonAttributes.setCapability(3);
        polygonAttributes.setCullFace(0);
        Appearance appearance = new Appearance();
        appearance.setCapability(14);
        appearance.setCapability(15);
        appearance.setPolygonAttributes(polygonAttributes);
        appearance.setMaterial(new Material());
        return appearance;
    }

    public void updateData(Geometry geometry) {
        Landscape.updateCoords(this.coords, this.heights);
        Landscape.updateColors(this.colors, this.heights);
        Landscape.updateNormals(this.normals, this.heights);
    }

    public static void updateCoords(float[] fArray, float[][] fArray2) {
        int n = fArray2.length;
        float f = 1.0f / (float)n;
        float f2 = f / 2.0f;
        float f3 = f / 2.0f;
        for (int i = 0; i < n - 1; ++i) {
            for (int j = 0; j < n; ++j) {
                int n2 = (i * n + j) * 6;
                fArray[n2++] = f2;
                fArray[n2++] = fArray2[i][j];
                fArray[n2++] = f3;
                fArray[n2++] = f2;
                fArray[n2++] = fArray2[i + 1][j];
                fArray[n2++] = f3 + f;
                f2 += f;
            }
            f2 = f / 2.0f;
            f3 += f;
        }
    }

    public static void updateColors(float[] fArray, float[][] fArray2) {
        int n = fArray2.length;
        float f = 1.0f / (float)n;
        float f2 = f / 2.0f;
        float f3 = f / 2.0f;
        float f4 = (float)(n - 1) / Landscape.getMaxValue(fArray2);
        BufferedImage bufferedImage = DomainUtil.createGradientImage(n);
        for (int i = 0; i < n - 1; ++i) {
            for (int j = 0; j < n; ++j) {
                int n2 = (i * n + j) * 6;
                int n3 = bufferedImage.getRGB((int)(fArray2[i][j] * f4), 0);
                int n4 = bufferedImage.getRGB((int)(fArray2[i + 1][j] * f4), 0);
                fArray[n2++] = (float)(n3 >> 16 & 0xFF) / 255.0f;
                fArray[n2++] = (float)(n3 >> 8 & 0xFF) / 255.0f;
                fArray[n2++] = (float)(n3 >> 0 & 0xFF) / 255.0f;
                fArray[n2++] = (float)(n4 >> 16 & 0xFF) / 255.0f;
                fArray[n2++] = (float)(n4 >> 8 & 0xFF) / 255.0f;
                fArray[n2++] = (float)(n4 >> 0 & 0xFF) / 255.0f;
                f2 += f;
            }
            f2 = f / 2.0f;
            f3 += f;
        }
    }

    protected static void updateNormals(float[] fArray, float[][] fArray2) {
        int n;
        int n2;
        int n3 = fArray2.length;
        float[][][] fArray3 = new float[n3][n3][3];
        float f = 1.0f / (float)n3;
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        Vector3f vector3f4 = new Vector3f();
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3; ++n) {
                if (n2 == n3 - 1) {
                    vector3f2.set(0.0f, 0.0f, f);
                } else {
                    vector3f2.set(0.0f, fArray2[n2 + 1][n], f);
                }
                if (n == n3 - 1) {
                    vector3f3.set(f, 0.0f, 0.0f);
                } else {
                    vector3f3.set(f, fArray2[n2][n + 1], 0.0f);
                }
                vector3f.set(0.0f, fArray2[n2][n], 0.0f);
                vector3f2.sub((Tuple3f)vector3f);
                vector3f3.sub((Tuple3f)vector3f);
                vector3f4.cross(vector3f2, vector3f3);
                vector3f4.normalize();
                fArray3[n2][n][0] = vector3f4.x;
                fArray3[n2][n][1] = vector3f4.y;
                fArray3[n2][n][2] = vector3f4.z;
            }
        }
        for (n2 = 0; n2 < n3 - 1; ++n2) {
            for (n = 0; n < n3; ++n) {
                int n4 = (n2 * n3 + n) * 6;
                fArray[n4++] = fArray3[n2][n][0];
                fArray[n4++] = fArray3[n2][n][1];
                fArray[n4++] = fArray3[n2][n][2];
                fArray[n4++] = fArray3[n2 + 1][n][0];
                fArray[n4++] = fArray3[n2 + 1][n][1];
                fArray[n4++] = fArray3[n2 + 1][n][2];
            }
        }
    }

    private static float getMaxValue(float[][] fArray) {
        int n = fArray.length;
        float f = -3.4028235E38f;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                f = Math.max(f, fArray[i][j]);
            }
        }
        return f;
    }
}

