/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.terrain;

import com.sun.j3d.utils.geometry.Sphere;
import java.awt.Color;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GeometryUpdater;
import javax.media.j3d.LineArray;
import javax.media.j3d.Material;
import javax.media.j3d.PointArray;
import javax.media.j3d.PointAttributes;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TriangleStripArray;
import javax.vecmath.Color3f;
import javax.vecmath.Point2f;
import javax.vecmath.Tuple2f;
import org.tigr.microarray.mev.cluster.gui.impl.util.IntArray;

public class GenesShape
extends Shape3D
implements GeometryUpdater {
    public static final int POINTS = 0;
    public static final int CUBES = 1;
    public static final int SPHERES = 2;
    private int type = 0;
    private float size = 0.005f;
    private float[] coords;
    private float[] colors;
    private float[] normals;
    private float[][] locations;
    private IntArray shapeIndices;
    private Point2f start = new Point2f();
    private Point2f end = new Point2f();
    private int[] colorIndices;
    private Color3f[] colors_c3f;
    private static final float[] cubeverts = new float[]{1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f};
    private static final float[] cubenormals = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f};
    private static final float[] sphereverts;
    private static final float[] spherenormals;
    private static final int[] spherestrips;

    public GenesShape(int n, float[][] fArray, Point2f point2f, Point2f point2f2) {
        this.type = n;
        this.locations = fArray;
        this.start.set((Tuple2f)point2f);
        this.end.set((Tuple2f)point2f2);
        this.setCapability(1);
        this.setCapability(12);
        this.setCapability(13);
        this.shapeIndices = this.getShapeIndices();
        this.initBuffers();
        this.initData();
        this.setGeometry(this.createGeometry());
        this.setAppearance(this.createAppearance());
        this.setBoundsAutoCompute(false);
    }

    public void setType(int n) {
        this.type = n;
        this.initBuffers();
        this.initData();
        this.setGeometry(this.createGeometry());
    }

    public void setZoom(Point2f point2f, Point2f point2f2) {
        this.start.set((Tuple2f)point2f);
        this.end.set((Tuple2f)point2f2);
        this.shapeIndices = this.getShapeIndices();
        this.initBuffers();
        this.initData();
        this.setGeometry(this.createGeometry());
    }

    public void updateColors(int[] nArray, Color[] colorArray) {
        this.colorIndices = nArray;
        this.colors_c3f = new Color3f[colorArray.length];
        for (int i = 0; i < this.colors_c3f.length; ++i) {
            this.colors_c3f[i] = new Color3f(colorArray[i]);
        }
        ((GeometryArray)this.getGeometry()).updateData((GeometryUpdater)this);
    }

    public int getShapeIndex(int n) {
        if (n < 0 || n >= this.coords.length / 3) {
            return -1;
        }
        switch (this.type) {
            case 0: {
                return this.shapeIndices.get(n);
            }
            case 1: {
                return this.shapeIndices.get(3 * n / cubeverts.length);
            }
            case 2: {
                return this.shapeIndices.get(3 * n / sphereverts.length);
            }
        }
        return -1;
    }

    private void initBuffers() {
        int n = this.shapeIndices.getSize() * GenesShape.getVerticesNumber(this.type) * 3;
        this.coords = new float[n];
        this.colors = new float[n];
        this.normals = new float[n];
    }

    private Geometry createGeometry() {
        GeometryArray geometryArray = null;
        if (this.shapeIndices.getSize() < 1) {
            geometryArray = this.createEmptyGeometry();
            return geometryArray;
        }
        switch (this.type) {
            case 0: {
                geometryArray = this.createPointsGeometry();
                break;
            }
            case 1: {
                geometryArray = this.createCubesGeometry();
                break;
            }
            case 2: {
                geometryArray = this.createSpheresGeometry();
            }
        }
        this.setCapabilities((Geometry)geometryArray);
        geometryArray.setCoordRefFloat(this.coords);
        geometryArray.setColorRefFloat(this.colors);
        geometryArray.setNormalRefFloat(this.normals);
        return geometryArray;
    }

    private void setCapabilities(Geometry geometry) {
        geometry.setCapability(18);
        geometry.setCapability(8);
        geometry.setCapability(17);
        geometry.setCapability(21);
        geometry.setCapability(19);
    }

    private Appearance createAppearance() {
        Appearance appearance = new Appearance();
        appearance.setMaterial(new Material());
        appearance.setPointAttributes(new PointAttributes(this.size * 1000.0f, true));
        return appearance;
    }

    private void initData() {
        this.initCoords();
        this.initColors();
        this.initNormals();
    }

    private void initCoords() {
        int n = 0;
        float f = Math.max(this.end.x - this.start.x, this.end.y - this.start.y);
        for (int i = 0; i < this.locations.length; ++i) {
            float f2 = this.locations[i][0];
            float f3 = this.locations[i][1];
            if (!(f2 >= this.start.x) || !(f2 <= this.start.x + f) || !(f3 >= this.start.y) || !(f3 <= this.start.y + f)) continue;
            this.setCoords(n++, (f2 - this.start.x) / f, 0.0f, (f3 - this.start.y) / f);
        }
    }

    private void setCoords(int n, float f, float f2, float f3) {
        switch (this.type) {
            case 0: {
                this.setPointCoords(n, f, f2, f3);
                break;
            }
            case 1: {
                this.setCubeCoords(n, f, f2, f3);
                break;
            }
            case 2: {
                this.setSphereCoords(n, f, f2, f3);
            }
        }
    }

    private void setPointCoords(int n, float f, float f2, float f3) {
        int n2 = n * 3;
        this.coords[n2++] = f;
        this.coords[n2++] = f2;
        this.coords[n2++] = f3;
    }

    private void setCubeCoords(int n, float f, float f2, float f3) {
        int n2 = n * cubeverts.length;
        for (int i = 0; i < cubeverts.length; i += 3) {
            this.coords[n2++] = cubeverts[i + 0] * this.size + f;
            this.coords[n2++] = cubeverts[i + 1] * this.size + f2;
            this.coords[n2++] = cubeverts[i + 2] * this.size + f3;
        }
    }

    private void setSphereCoords(int n, float f, float f2, float f3) {
        int n2 = n * sphereverts.length;
        for (int i = 0; i < sphereverts.length; i += 3) {
            this.coords[n2++] = sphereverts[i + 0] * this.size + f;
            this.coords[n2++] = sphereverts[i + 1] * this.size + f2;
            this.coords[n2++] = sphereverts[i + 2] * this.size + f3;
        }
    }

    private void initColors() {
        int n;
        for (n = 0; n < this.colors.length; ++n) {
            this.colors[n] = 0.6f;
        }
        if (this.colors_c3f == null || this.colorIndices == null) {
            return;
        }
        for (int i = 0; i < this.shapeIndices.getSize(); ++i) {
            n = this.colorIndices[this.shapeIndices.get(i)];
            if (n < 0) continue;
            this.setShapeColor(i, this.colors_c3f[n]);
        }
    }

    private void setShapeColor(int n, Color3f color3f) {
        int n2 = GenesShape.getVerticesNumber(this.type);
        int n3 = n2 * 3 * n;
        for (int i = 0; i < n2; ++i) {
            this.colors[n3++] = color3f.x;
            this.colors[n3++] = color3f.y;
            this.colors[n3++] = color3f.z;
        }
    }

    private void initNormals() {
        switch (this.type) {
            case 0: {
                this.initPointsNormals();
                break;
            }
            case 1: {
                this.initCubesNormals();
                break;
            }
            case 2: {
                this.initSpheresNormals();
            }
        }
    }

    private void initPointsNormals() {
        for (int i = 0; i < this.normals.length; i += 3) {
            this.normals[i + 0] = 0.0f;
            this.normals[i + 1] = 0.0f;
            this.normals[i + 2] = 1.0f;
        }
    }

    private void initCubesNormals() {
        for (int i = 0; i < this.normals.length; i += cubenormals.length) {
            for (int j = 0; j < cubenormals.length; ++j) {
                this.normals[i + j] = cubenormals[j];
            }
        }
    }

    private void initSpheresNormals() {
        for (int i = 0; i < this.normals.length; i += spherenormals.length) {
            for (int j = 0; j < spherenormals.length; ++j) {
                this.normals[i + j] = spherenormals[j];
            }
        }
    }

    private GeometryArray createEmptyGeometry() {
        LineArray lineArray = new LineArray(2, 1);
        lineArray.setCoordinates(0, new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f});
        lineArray.setCapability(8);
        lineArray.setCapability(17);
        lineArray.setCapability(0);
        return lineArray;
    }

    private GeometryArray createPointsGeometry() {
        PointArray pointArray = new PointArray(this.coords.length / 3, 135);
        return pointArray;
    }

    private GeometryArray createCubesGeometry() {
        QuadArray quadArray = new QuadArray(this.coords.length / 3, 135);
        return quadArray;
    }

    private GeometryArray createSpheresGeometry() {
        int[] nArray = new int[spherestrips.length * this.shapeIndices.getSize()];
        for (int i = 0; i < nArray.length; i += spherestrips.length) {
            for (int j = 0; j < spherestrips.length; ++j) {
                nArray[i + j] = spherestrips[j];
            }
        }
        TriangleStripArray triangleStripArray = new TriangleStripArray(this.coords.length / 3, 135, nArray);
        return triangleStripArray;
    }

    private IntArray getShapeIndices() {
        IntArray intArray = new IntArray();
        float f = Math.max(this.end.x - this.start.x, this.end.y - this.start.y);
        for (int i = 0; i < this.locations.length; ++i) {
            float f2 = this.locations[i][0];
            float f3 = this.locations[i][1];
            if (!(f2 >= this.start.x) || !(f2 <= this.start.x + f) || !(f3 >= this.start.y) || !(f3 <= this.start.y + f)) continue;
            intArray.add(i);
        }
        return intArray;
    }

    public void updateData(Geometry geometry) {
        this.initColors();
    }

    private static int getVerticesNumber(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return cubeverts.length / 3;
            }
            case 2: {
                return sphereverts.length / 3;
            }
        }
        return 0;
    }

    static {
        Sphere sphere = new Sphere(1.0f, 1, 9);
        TriangleStripArray triangleStripArray = (TriangleStripArray)sphere.getShape().getGeometry();
        int n = triangleStripArray.getVertexCount();
        sphereverts = new float[n * 3];
        spherenormals = new float[n * 3];
        spherestrips = new int[triangleStripArray.getNumStrips()];
        triangleStripArray.getCoordinates(0, sphereverts);
        triangleStripArray.getNormals(0, spherenormals);
        triangleStripArray.getStripVertexCounts(spherestrips);
    }
}

