/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.terrain;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.vecmath.Point2f;

public class DomainUtil {
    private static final float MAX_HEIGHT = 0.2f;

    public static float[][] getHeights(float[][] fArray, int n, float f) {
        return DomainUtil.getHeights(fArray, n, f, new Point2f(), new Point2f(1.0f, 1.0f));
    }

    public static float[][] getHeights(float[][] fArray, int n, float f, Point2f point2f, Point2f point2f2) {
        float f2 = Math.max(Math.abs(point2f2.x - point2f.x), Math.abs(point2f2.y - point2f.y));
        float f3 = f2 / (float)n;
        float f4 = point2f.x + f3 / 2.0f;
        float f5 = point2f.y + f3 / 2.0f;
        float[][] fArray2 = new float[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                float f6 = 0.0f;
                for (int k = 0; k < fArray.length; ++k) {
                    float f7 = fArray[k][0];
                    float f8 = fArray[k][1];
                    f6 = (float)((double)f6 + DomainUtil.disperse(f, f4, f5, f7, f8));
                }
                fArray2[i][j] = f6;
                f4 += f3;
            }
            f4 = point2f.x + f3 / 2.0f;
            f5 += f3;
        }
        DomainUtil.normalize(fArray2);
        return fArray2;
    }

    private static void normalize(float[][] fArray) {
        int n;
        int n2 = fArray.length;
        float f = Float.MAX_VALUE;
        float f2 = -3.4028235E38f;
        for (int i = 0; i < n2; ++i) {
            for (n = 0; n < n2; ++n) {
                f = Math.min(f, fArray[i][n]);
                f2 = Math.max(f2, fArray[i][n]);
            }
        }
        float f3 = f2 == f ? 1.0f : 0.2f / (f2 - f);
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n2; ++i) {
                fArray[n][i] = (fArray[n][i] - f) * f3;
            }
        }
    }

    private static double disperse(float f, float f2, float f3, float f4, float f5) {
        float f6 = (f2 - f4) * (f2 - f4) + (f3 - f5) * (f3 - f5);
        float f7 = f * f;
        if (f6 > 4.0f * f7) {
            return 0.0;
        }
        return Math.exp(-f6 / (2.0f * f7));
    }

    public static BufferedImage createGradientImage(int n) {
        BufferedImage bufferedImage = new BufferedImage(n, 1, 5);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, Color.green, n - 1, 0.0f, Color.red);
        graphics2D.setPaint(gradientPaint);
        graphics2D.drawRect(0, 0, n - 1, 1);
        graphics2D.dispose();
        return bufferedImage;
    }
}

