/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.svm;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.svm.GeneralInfo;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMData;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMFileFilter;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMFileView;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMResultViewer;

public class SVMTrainViewer
extends SVMResultViewer
implements Serializable {
    public static final long serialVersionUID = 202018080001L;
    private float[] weights;
    private IData experiment;
    private Experiment analysisExperiment;
    private SVMData data;
    private GeneralInfo info;
    private boolean classifyGenes;

    public SVMTrainViewer(IFramework iFramework, IData iData, Experiment experiment, SVMData sVMData, float[] fArray, GeneralInfo generalInfo, boolean bl) {
        super(iFramework);
        this.analysisExperiment = experiment;
        this.experiment = iData;
        this.data = sVMData;
        this.weights = fArray;
        this.info = generalInfo;
        this.classifyGenes = bl;
        this.resultPanel = new TrainResultPanel();
        this.displayData();
        this.add((Component)this.resultPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.analysisExperiment = (Experiment)objectInputStream.readObject();
        this.weights = (float[])objectInputStream.readObject();
        this.classifyGenes = objectInputStream.readBoolean();
        this.data = (SVMData)objectInputStream.readObject();
        this.info = (GeneralInfo)objectInputStream.readObject();
        SVMResultViewer.MyListener myListener = new SVMResultViewer.MyListener();
        this.getContentComponent().addMouseListener(myListener);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.analysisExperiment);
        objectOutputStream.writeObject(this.weights);
        objectOutputStream.writeBoolean(this.classifyGenes);
        objectOutputStream.writeObject(this.data);
        objectOutputStream.writeObject(this.info);
    }

    public void onSelected(IFramework iFramework) {
        this.framework = iFramework;
        this.experiment = iFramework.getData();
        this.onMenuChanged(iFramework.getDisplayMenu());
    }

    protected void displayData() {
        if (this.weights == null) {
            return;
        }
        this.displayResult(this.classifyGenes);
    }

    private void displayResult(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMaximumFractionDigits(4);
        decimalFormat.setMinimumFractionDigits(4);
        decimalFormat.setGroupingUsed(false);
        if (this.data.classificationFile != null) {
            stringBuffer.append("Classification file: " + this.data.classificationFile.getPath() + "\n");
        } else {
            stringBuffer.append("Classification file: None (SVM classification editor was used)\n");
        }
        stringBuffer.append("Constant : " + Float.toString(this.data.constant) + "\n");
        stringBuffer.append("Coefficient : " + Float.toString(this.data.coefficient) + "\n");
        stringBuffer.append("Power : " + Float.toString(this.data.power) + "\n");
        stringBuffer.append("Diagonal factor : " + Float.toString(this.data.diagonalFactor) + "\n");
        stringBuffer.append("Convergence threshold : " + Float.toString(this.data.convergenceThreshold) + "\n");
        stringBuffer.append("Radial : " + this.data.radial + "\n");
        stringBuffer.append("Width factor : " + Float.toString(this.data.widthFactor) + "\n");
        stringBuffer.append("Use Constraint : " + this.data.constrainWeights + "\n");
        stringBuffer.append("Positive Constraint : " + Float.toString(this.data.positiveConstraint) + "\n");
        stringBuffer.append("Negative Constraint : " + Float.toString(this.data.negativeConstraint) + "\n");
        stringBuffer.append("Seed : " + Float.toString(this.data.seed) + "\n");
        stringBuffer.append("Calculation time : " + Float.toString(this.info.time) + " ms\n");
        stringBuffer.append("Objective : " + Float.toString(this.data.objective1) + "\n\n");
        if (bl) {
            if (this.labelIndex >= 0 && this.labelIndex < this.fieldNames.length) {
                stringBuffer.append(" Weights       " + this.fieldNames[this.labelIndex]);
            } else {
                stringBuffer.append(" Weights");
            }
        } else {
            stringBuffer.append(" Weights       Experiments");
        }
        this.Log.setText(stringBuffer.toString());
        this.Log.setCaretPosition(0);
    }

    protected void onSaveResult() {
        JFileChooser jFileChooser = new JFileChooser(TMEV.getFile((String)"data/"));
        jFileChooser.addChoosableFileFilter(new SVMFileFilter());
        jFileChooser.setFileView(new SVMFileView());
        int n = jFileChooser.showSaveDialog(JOptionPane.getFrameForComponent(this));
        if (n != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            String string = this.Log.getText();
            string = string.substring(0, string.lastIndexOf("Weights"));
            bufferedWriter.write(string);
            if (this.classifyGenes) {
                if (this.labelIndex >= 0 && this.labelIndex < this.fieldNames.length) {
                    bufferedWriter.write("Weights\t" + this.fieldNames[this.labelIndex] + "\t\n");
                } else {
                    bufferedWriter.write("Weights\t\n");
                }
            } else {
                bufferedWriter.write("Weights\tExperiments\t\n");
            }
            for (int i = 0; i < this.weights.length; ++i) {
                if (this.classifyGenes) {
                    bufferedWriter.write(String.valueOf(this.weights[i]) + "\t" + this.experiment.getElementAttribute(this.getMultipleArrayDataRow(i), this.labelIndex) + "\t\n");
                    continue;
                }
                bufferedWriter.write(String.valueOf(this.weights[i]) + "\t" + this.experiment.getFullSampleName(i) + "\t\n");
            }
            bufferedWriter.flush();
            bufferedWriter.close();
            bufferedWriter = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error writing to file " + file.getPath() + "!", "Error", 0);
        }
    }

    protected Dimension updateSize() {
        return ((TrainResultPanel)this.resultPanel).updateSize();
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int n) {
        return null;
    }

    public class TrainResultPanel
    extends JPanel {
        int lineHeight = 20;
        int indexLength = 1;
        DecimalFormat floatFormat = new DecimalFormat();
        String spacerString;

        public TrainResultPanel() {
            this.floatFormat.setMaximumFractionDigits(4);
            this.floatFormat.setMinimumFractionDigits(4);
            this.floatFormat.setGroupingUsed(false);
            this.setBackground(Color.white);
            Dimension dimension = this.updateSize();
            this.setSize(dimension.width, SVMTrainViewer.this.weights.length * this.lineHeight + 10);
            this.setPreferredSize(new Dimension(dimension.width, SVMTrainViewer.this.weights.length * this.lineHeight + 5));
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            graphics.setFont(new Font("monospaced", 0, 14));
            FontMetrics fontMetrics = graphics.getFontMetrics();
            Rectangle rectangle = graphics.getClipBounds();
            int n = this.getTopIndex(rectangle.y);
            int n2 = this.getBottomIndex(rectangle.y + rectangle.height, SVMTrainViewer.this.weights.length + 1);
            for (int i = n; i < n2; ++i) {
                int n3 = i;
                if (!this.isLegalIndex(n3)) continue;
                this.spacerString = this.getSpacerString(this.floatFormat.format(SVMTrainViewer.this.weights[n3]));
                if (SVMTrainViewer.this.classifyGenes) {
                    graphics.drawString(" " + this.floatFormat.format(SVMTrainViewer.this.weights[n3]) + this.spacerString + SVMTrainViewer.this.experiment.getElementAttribute(SVMTrainViewer.this.getMultipleArrayDataRow(n3), SVMTrainViewer.this.labelIndex), 10, (i + 1) * this.lineHeight);
                    continue;
                }
                graphics.drawString(" " + this.floatFormat.format(SVMTrainViewer.this.weights[n3]) + this.spacerString + SVMTrainViewer.this.experiment.getSampleName(SVMTrainViewer.this.analysisExperiment.getSampleIndex(n3)), 10, (i + 1) * this.lineHeight);
            }
        }

        private boolean isLegalIndex(int n) {
            return n >= 0 && n < SVMTrainViewer.this.weights.length;
        }

        private int getTopIndex(int n) {
            if (n < 0) {
                return 0;
            }
            return n / this.lineHeight;
        }

        private int getBottomIndex(int n, int n2) {
            if (n < 0) {
                return 0;
            }
            int n3 = n / this.lineHeight + 1;
            return n3 > n2 ? n2 : n3;
        }

        protected String getSpacerString(String string) {
            String string2 = "";
            for (int i = 0; i < 15 - string.length(); ++i) {
                string2 = string2 + " ";
            }
            return string2;
        }

        protected Dimension updateSize() {
            FontMetrics fontMetrics = this.getFontMetrics(new Font("monospaced", 0, 14));
            int n = 0;
            this.indexLength = String.valueOf(SVMTrainViewer.this.weights.length).length();
            this.floatFormat = new DecimalFormat();
            this.floatFormat.setMaximumFractionDigits(4);
            this.floatFormat.setMinimumFractionDigits(4);
            this.floatFormat.setGroupingUsed(false);
            int n2 = SVMTrainViewer.this.classifyGenes ? SVMTrainViewer.this.analysisExperiment.getNumberOfGenes() : SVMTrainViewer.this.analysisExperiment.getNumberOfSamples();
            for (int i = 0; i < n2; ++i) {
                this.spacerString = this.getSpacerString(this.floatFormat.format(SVMTrainViewer.this.weights[i]));
                String string = SVMTrainViewer.this.classifyGenes ? " " + this.floatFormat.format(SVMTrainViewer.this.weights[i]) + this.spacerString + SVMTrainViewer.this.experiment.getElementAttribute(SVMTrainViewer.this.getMultipleArrayDataRow(i), SVMTrainViewer.this.labelIndex) : " " + this.floatFormat.format(SVMTrainViewer.this.weights[i]) + this.spacerString + SVMTrainViewer.this.experiment.getSampleName(SVMTrainViewer.this.analysisExperiment.getSampleIndex(i));
                n = Math.max(n, fontMetrics.stringWidth(string));
            }
            this.setSize(n + 10, this.getHeight());
            this.setPreferredSize(new Dimension(n + 10, this.getHeight()));
            return new Dimension(n + 10, this.getHeight());
        }
    }
}

