/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.st;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLCluster;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTree;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeListener;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLViewer;
import org.tigr.microarray.mev.cluster.gui.impl.st.HCLSupportTree;

public class HCLSupportViewer
extends HCLViewer {
    protected static final String SET_CLUSTER_CMD = "set-cluster-cmd";
    protected static final String SET_CLUSTER_TEXT_CMD = "set-cluster-text-cmd";
    protected static final String SAVE_CLUSTER_CMD = "save-cluster-cmd";
    protected static final String DELETE_CLUSTER_CMD = "delete-cluster-cmd";
    protected static final String DELETE_ALL_CLUSTERS_CMD = "delete-all-clusters-cmd";
    protected static final String GENE_TREE_PROPERTIES_CMD = "gene-tree-properties-cmd";
    protected static final String SAMPLE_TREE_PROPERTIES_CMD = "sample-tree-properties-cmd";
    protected static final String SUPPORT_LEGEND_CMD = "support-legend-cmd";
    protected static final String SUPPORT_VALUES_CMD = "support-value-cmd";
    Vector geneTreeSupportVector;
    Vector exptTreeSupportVector;

    public HCLSupportViewer(Experiment experiment, int[] nArray, HCLTreeData hCLTreeData, HCLTreeData hCLTreeData2, Vector vector, Vector vector2, DefaultMutableTreeNode defaultMutableTreeNode) {
        super(experiment, nArray, hCLTreeData, hCLTreeData2, defaultMutableTreeNode);
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.white);
        this.geneTreeSupportVector = vector;
        this.exptTreeSupportVector = vector2;
        if (hCLTreeData != null && this.experiment.getNumberOfGenes() > 1) {
            this.genesTree = new HCLSupportTree(hCLTreeData, 0, vector, vector2);
            this.genesTree.addMouseListener(this.listener);
            this.genesTree.setListener(this.listener);
        }
        if (hCLTreeData2 != null && this.experiment.getNumberOfSamples() > 1) {
            this.sampleTree = new HCLSupportTree(hCLTreeData2, 1, vector, vector2);
            if (hCLTreeData == null) {
                this.offset = 10;
                this.sampleTree.setHorizontalOffset(this.offset);
            }
            this.sampleTree.setListener(this.listener);
            this.sampleTree.addMouseListener(this.listener);
        }
        super.removeAll();
        super.validate();
        this.addComponents(this.sampleTree, this.genesTree, this.expViewer.getContentComponent(), this.colorBar, this.annotationBar);
        this.addMouseListener(this.listener);
        this.addSTMenuItems(this.popup);
    }

    private void addSTMenuItems(JPopupMenu jPopupMenu) {
        Listener listener = new Listener();
        boolean bl = true;
        if ((this.geneTreeSupportVector == null || this.geneTreeSupportVector.isEmpty()) && (this.exptTreeSupportVector == null || this.exptTreeSupportVector.isEmpty())) {
            bl = false;
        }
        JMenuItem jMenuItem = new JMenuItem("Support tree legend...");
        jMenuItem.setActionCommand(SUPPORT_LEGEND_CMD);
        jMenuItem.addActionListener(listener);
        if (!bl) {
            jMenuItem.setEnabled(false);
        }
        Component[] componentArray = jPopupMenu.getComponents();
        jPopupMenu.removeAll();
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JCheckBoxMenuItem("Show values...", false);
        jMenuItem.setActionCommand(SUPPORT_VALUES_CMD);
        jMenuItem.addActionListener(listener);
        if (!bl) {
            jMenuItem.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        for (int i = 0; i < componentArray.length; ++i) {
            jPopupMenu.add(componentArray[i]);
        }
    }

    protected void showPopup(MouseEvent mouseEvent) {
        int n = this.selectedCluster == null ? -1 : this.selectedCluster.root;
        this.setEnableMenuItem(SET_CLUSTER_CMD, n >= 0);
        this.setEnableMenuItem(SET_CLUSTER_TEXT_CMD, this.doesClusterExist());
        this.setEnableMenuItem(DELETE_CLUSTER_CMD, this.doesClusterExist());
        this.setEnableMenuItem(DELETE_ALL_CLUSTERS_CMD, this.doesClusterExist());
        this.setEnableMenuItem(SAVE_CLUSTER_CMD, this.selectedCluster != null && this.selectedCluster.root != -1);
        this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    private void onShowSupportTreeLegend() {
        JDialog jDialog = new JDialog(this.framework.getFrame(), "Support Tree Legend");
        JPanel jPanel = HCLSupportTree.getColorLegendPanel();
        jDialog.getContentPane().add(jPanel);
        jDialog.setSize(200, 300);
        jDialog.setLocation(300, 100);
        jDialog.setVisible(true);
    }

    private void onShowSupportValues(boolean bl) {
        if (this.genesTree != null) {
            ((HCLSupportTree)this.genesTree).toggleShowSupportValues(bl);
        }
        if (this.sampleTree != null) {
            ((HCLSupportTree)this.sampleTree).toggleShowSupportValues(bl);
        }
        this.header.updateSize(this.getCommonWidth(), this.elementSize.width);
        this.onSelected(this.framework);
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
        super.onMenuChanged(iDisplayMenu);
        if (this.genesTree != null) {
            ((HCLSupportTree)this.genesTree).adjustPixelHeightsForValueDisplay();
            this.genesTree.onMenuChanged(iDisplayMenu);
        }
        if (this.sampleTree != null) {
            ((HCLSupportTree)this.sampleTree).adjustPixelHeightsForValueDisplay();
            this.sampleTree.onMenuChanged(iDisplayMenu);
        }
        this.onSelected(this.framework);
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener,
    HCLTreeListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(HCLSupportViewer.SET_CLUSTER_CMD)) {
                HCLSupportViewer.this.onSetCluster();
            } else if (string.equals(HCLSupportViewer.SET_CLUSTER_TEXT_CMD)) {
                HCLSupportViewer.this.onSetClusterText();
            } else if (string.equals(HCLSupportViewer.SAVE_CLUSTER_CMD)) {
                HCLSupportViewer.this.onSaveCluster();
            } else if (string.equals(HCLSupportViewer.DELETE_CLUSTER_CMD)) {
                HCLSupportViewer.this.onDeleteCluster();
            } else if (string.equals(HCLSupportViewer.DELETE_ALL_CLUSTERS_CMD)) {
                HCLSupportViewer.this.onDeleteAllClusters();
            } else if (string.equals(HCLSupportViewer.GENE_TREE_PROPERTIES_CMD)) {
                HCLSupportViewer.this.onGeneTreeProperties();
            } else if (string.equals(HCLSupportViewer.SAMPLE_TREE_PROPERTIES_CMD)) {
                HCLSupportViewer.this.onSampleTreeProperties();
            } else if (string.equals(HCLSupportViewer.SUPPORT_LEGEND_CMD)) {
                HCLSupportViewer.this.onShowSupportTreeLegend();
            } else if (string.equals(HCLSupportViewer.SUPPORT_VALUES_CMD)) {
                HCLSupportViewer.this.onShowSupportValues(((JCheckBoxMenuItem)actionEvent.getSource()).isSelected());
            }
        }

        public void valueChanged(HCLTree hCLTree, HCLCluster hCLCluster) {
            HCLSupportViewer.this.valueChanged(hCLTree, hCLCluster);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                return;
            }
            this.deselect(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger()) {
                return;
            }
            HCLSupportViewer.this.showPopup(mouseEvent);
        }

        private void deselect(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object instanceof HCLTree) {
                if (object == HCLSupportViewer.this.genesTree) {
                    ((ExperimentViewer)HCLSupportViewer.this.expViewer).selectColumns(-1, -1);
                    if (HCLSupportViewer.this.sampleTree != null) {
                        HCLSupportViewer.this.sampleTree.deselectAllNodes();
                    }
                    ((ExperimentViewer)HCLSupportViewer.this.expViewer).selectRows(-1, -1);
                    if (HCLSupportViewer.this.genesTree != null) {
                        HCLSupportViewer.this.genesTree.deselectAllNodes();
                    }
                    HCLSupportViewer.this.repaint();
                    return;
                }
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                if (!(object instanceof HCLViewer) && object != HCLSupportViewer.this.expViewer) {
                    this.deselectAllNodes();
                    HCLSupportViewer.this.repaint();
                } else if (object instanceof HCLViewer && HCLSupportViewer.this.sampleTree != null && n2 < HCLSupportViewer.this.sampleTree.getHeight()) {
                    this.deselectAllNodes();
                    HCLSupportViewer.this.repaint();
                } else if (object == HCLSupportViewer.this.expViewer) {
                    int n3 = HCLSupportViewer.this.numberOfSamples;
                    if (n > ((HCLSupportViewer)HCLSupportViewer.this).elementSize.width * n3 + HCLSupportViewer.this.offset || n < HCLSupportViewer.this.offset) {
                        this.deselectAllNodes();
                        HCLSupportViewer.this.repaint();
                    }
                } else if (object == HCLSupportViewer.this.expViewer && n < HCLSupportViewer.this.offset) {
                    this.deselectAllNodes();
                    HCLSupportViewer.this.repaint();
                }
            }
        }

        private void deselectAllNodes() {
            if (HCLSupportViewer.this.genesTree != null) {
                HCLSupportViewer.this.genesTree.deselectAllNodes();
            }
            if (HCLSupportViewer.this.sampleTree != null) {
                HCLSupportViewer.this.sampleTree.deselectAllNodes();
            }
            ((ExperimentViewer)HCLSupportViewer.this.expViewer).selectRows(-1, -1);
            ((ExperimentViewer)HCLSupportViewer.this.expViewer).selectColumns(-1, -1);
        }
    }
}

