/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.sota;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Monitor;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLGUI;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLViewer;
import org.tigr.microarray.mev.cluster.gui.impl.sota.SOTACentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.sota.SOTACentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.sota.SOTADiversityViewer;
import org.tigr.microarray.mev.cluster.gui.impl.sota.SOTAExperimentCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.sota.SOTAExperimentCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.sota.SOTAExperimentTreeViewer;
import org.tigr.microarray.mev.cluster.gui.impl.sota.SOTAExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.sota.SOTAGeneTreeViewer;
import org.tigr.microarray.mev.cluster.gui.impl.sota.SOTAInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.sota.SOTAInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.sota.SOTATreeData;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;
import org.tigr.util.FloatMatrix;

public class SOTAGUI
implements IClusterGUI,
IScriptGUI {
    private Algorithm algorithm;
    private IData frameData;
    private AlgorithmData data;
    private AlgorithmData result;
    private SOTATreeData sotaTreeData;
    private Progress progress;
    private Monitor monitor;
    private Listener listener = new Listener();
    private Experiment experiment;
    private int[][] clusters;
    private FloatMatrix means;
    private FloatMatrix variances;
    private IDistanceMenu menu;
    private boolean clusterGenes;
    private int k = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework iFramework) throws AlgorithmException {
        DefaultMutableTreeNode defaultMutableTreeNode;
        block20: {
            Object object;
            boolean bl;
            boolean bl2;
            float f;
            boolean bl3;
            boolean bl4;
            boolean bl5;
            int n = 10;
            int n2 = 1000;
            float f2 = 1.0E-4f;
            float f3 = 0.01f;
            float f4 = 0.01f;
            float f5 = 0.005f;
            float f6 = 0.001f;
            int n3 = 5;
            float f7 = 0.05f;
            this.frameData = iFramework.getData();
            this.menu = iFramework.getDistanceMenu();
            int n4 = this.menu.getDistanceFunction();
            if (n4 == 0) {
                n4 = 4;
            }
            int n5 = 1;
            n5 = n4 == 1 || n4 == 6 || n4 == 7 || n4 == 2 || n4 == 3 || n4 == 5 || n4 == 9 || n4 == 10 ? -1 : 1;
            SOTAInitDialog sOTAInitDialog = new SOTAInitDialog(iFramework.getFrame(), n5, this.menu.getFunctionName(n4), this.menu.isAbsoluteDistance());
            if (sOTAInitDialog.showModal() != 0) {
                return null;
            }
            try {
                this.clusterGenes = sOTAInitDialog.getBoolean("clusterGenes");
                n = sOTAInitDialog.getInt("maxCycles");
                n2 = sOTAInitDialog.getInt("maxEpochsPerCycle");
                f2 = sOTAInitDialog.getFloat("epochStopCriteria");
                f4 = sOTAInitDialog.getFloat("migFactor_w");
                f5 = sOTAInitDialog.getFloat("migFactor_p");
                f6 = sOTAInitDialog.getFloat("migFactor_s");
                n3 = sOTAInitDialog.getInt("neighborhood-level");
                bl5 = sOTAInitDialog.getBoolean("useVariance");
                if (bl5) {
                    f7 = sOTAInitDialog.getFloat("pValue");
                } else {
                    f3 = sOTAInitDialog.getFloat("maxTreeDiv");
                }
                bl4 = sOTAInitDialog.getBoolean("runToMaxCycles");
                bl3 = sOTAInitDialog.getBoolean("setMaxClusterDiv");
                f = sOTAInitDialog.getFloat("maxClusterDiv");
                bl2 = false;
                bl = sOTAInitDialog.getBoolean("calcClusterHCL");
                if (f4 <= 0.0f || f4 <= 0.0f || f4 <= 0.0f) {
                    JOptionPane.showMessageDialog(iFramework.getFrame(), "Migration weights should be > 0", "Error", 0);
                    return null;
                }
                if (f7 <= 0.0f) {
                    JOptionPane.showMessageDialog(iFramework.getFrame(), "p-value should be > 0", "Error", 0);
                    return null;
                }
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(iFramework.getFrame(), "Invalid input parameters!", "Error", 0);
                return null;
            }
            if (n < 1) {
                JOptionPane.showMessageDialog(iFramework.getFrame(), "Number of cycles (number of clusters) must be greater than 0!", "Error", 0);
                return null;
            }
            if (n2 < 1) {
                JOptionPane.showMessageDialog(iFramework.getFrame(), "Number of epochs per cycle must be greater than 0!", "Error", 0);
                return null;
            }
            int n6 = 0;
            boolean bl6 = false;
            boolean bl7 = false;
            int n7 = sOTAInitDialog.getDistanceMetric();
            boolean bl8 = sOTAInitDialog.isAbsoluteDistance();
            if (bl || bl2) {
                object = new HCLInitDialog(iFramework.getFrame(), this.menu.getFunctionName(sOTAInitDialog.getDistanceMetric()), sOTAInitDialog.isAbsoluteDistance(), true);
                if (((HCLInitDialog)object).showModal() != 0) {
                    return null;
                }
                n6 = ((HCLInitDialog)object).getMethod();
                bl6 = ((HCLInitDialog)object).isClusterExperiments();
                bl7 = ((HCLInitDialog)object).isClusterGenes();
                n7 = ((HCLInitDialog)object).getDistanceMetric();
                bl8 = ((HCLInitDialog)object).getAbsoluteSelection();
            }
            this.experiment = iFramework.getData().getExperiment();
            object = new Listener();
            try {
                this.algorithm = iFramework.getAlgorithmFactory().getAlgorithm("SOTA");
                this.algorithm.addAlgorithmListener((AlgorithmListener)object);
                this.progress = new Progress(iFramework.getFrame(), "Calculating clusters", (DialogListener)object);
                this.progress.show();
                this.data = new AlgorithmData();
                FloatMatrix floatMatrix = this.experiment.getMatrix();
                if (!this.clusterGenes) {
                    floatMatrix = floatMatrix.transpose();
                }
                this.data.addMatrix("experiment", floatMatrix);
                this.data.addParam("distance-absolute", String.valueOf(sOTAInitDialog.isAbsoluteDistance()));
                n4 = sOTAInitDialog.getDistanceMetric();
                this.data.addParam("distance-function", String.valueOf(n4));
                this.data.addParam("sota-cluster-genes", String.valueOf(this.clusterGenes));
                this.data.addParam("max-number-of-cycles", String.valueOf(n));
                this.data.addParam("max-epochs-per-cycle", String.valueOf(n2));
                this.data.addParam("epoch-improvement-cutoff", String.valueOf(f2));
                this.data.addParam("end-training-diversity", String.valueOf(f3));
                this.data.addParam("use-cluster-variance", String.valueOf(bl5));
                this.data.addParam("pValue", String.valueOf(f7));
                this.data.addParam("mig_w", String.valueOf(f4));
                this.data.addParam("mig_p", String.valueOf(f5));
                this.data.addParam("mig_s", String.valueOf(f6));
                this.data.addParam("neighborhood-level", String.valueOf(n3));
                this.data.addParam("run-to-max-cycles", String.valueOf(bl4));
                this.data.addParam("set-max-cluster-div", String.valueOf(bl3));
                this.data.addParam("maxClusterDiv", String.valueOf(f));
                this.data.addParam("calc-full-tree-hcl", String.valueOf(bl2));
                this.data.addParam("calc-cluster-hcl", String.valueOf(bl));
                if (bl || bl2) {
                    this.data.addParam("calcClusterHCL", String.valueOf(bl));
                    this.data.addParam("calcFullTreeHCL", String.valueOf(bl2));
                    this.data.addParam("method-linkage", String.valueOf(n6));
                    this.data.addParam("calculate-genes", String.valueOf(bl7));
                    this.data.addParam("calculate-experiments", String.valueOf(bl6));
                    this.data.addParam("hcl-distance-function", String.valueOf(n7));
                    this.data.addParam("hcl-distance-absolute", String.valueOf(bl8));
                }
                long l = System.currentTimeMillis();
                this.result = this.algorithm.execute(this.data);
                long l2 = System.currentTimeMillis() - l;
                Cluster cluster = this.result.getCluster("cluster");
                Cluster cluster2 = this.result.getCluster("hcl-result-clusters");
                Cluster cluster3 = this.result.getCluster("full-tree-sample-HCL");
                NodeList nodeList = cluster.getNodeList();
                this.k = nodeList.getSize();
                this.clusters = new int[this.k][];
                for (int i = 0; i < this.k; ++i) {
                    this.clusters[i] = nodeList.getNode(i).getProbesIndexes();
                }
                this.means = this.result.getMatrix("centroid-matrix");
                this.variances = this.result.getMatrix("cluster-variances");
                GeneralInfo generalInfo = new GeneralInfo();
                generalInfo.iterations = this.result.getParams().getInt("cycles") - 1;
                generalInfo.clusters = generalInfo.iterations + 1;
                generalInfo.time = l2;
                generalInfo.function = this.menu.getFunctionName(n4);
                generalInfo.maxCycles = n;
                generalInfo.maxEpochsPerCycle = n2;
                generalInfo.diversityCutoff = f3;
                generalInfo.epochStopCriteria = f2;
                generalInfo.runToMaxCycles = bl4;
                generalInfo.migW = f4;
                generalInfo.migP = f5;
                generalInfo.migS = f6;
                generalInfo.neighborhoodLevel = n3;
                generalInfo.useCellDiversity = !bl5;
                generalInfo.useCellVariability = bl5;
                if (bl5) {
                    generalInfo.pValue = f7;
                    generalInfo.computedVarCutoff = this.result.getParams().getFloat("computed-var-cutoff");
                }
                generalInfo.hcl_on_clusters = bl;
                generalInfo.hcl_on_samples_on_all_genes = bl2;
                generalInfo.hcl_genes_in_clusters = bl7;
                generalInfo.hcl_samples_in_clusters = bl6;
                generalInfo.hcl = generalInfo.hcl_on_clusters || generalInfo.hcl_on_samples_on_all_genes;
                generalInfo.hcl_method = n6;
                this.loadSotaTreeData();
                defaultMutableTreeNode = this.createResultTree(cluster2, cluster3, generalInfo);
                Object var38_37 = null;
                if (this.algorithm == null) break block20;
            }
            catch (Throwable throwable) {
                block21: {
                    Object var38_38 = null;
                    if (this.algorithm != null) {
                        this.algorithm.removeAlgorithmListener((AlgorithmListener)object);
                    }
                    if (this.progress == null) break block21;
                    this.progress.dispose();
                }
                throw throwable;
            }
            this.algorithm.removeAlgorithmListener((AlgorithmListener)object);
        }
        if (this.progress != null) {
            this.progress.dispose();
        }
        return defaultMutableTreeNode;
    }

    public AlgorithmData getScriptParameters(IFramework iFramework) {
        Object object;
        boolean bl;
        boolean bl2;
        float f;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        int n = 10;
        int n2 = 1000;
        float f2 = 1.0E-4f;
        float f3 = 0.01f;
        float f4 = 0.01f;
        float f5 = 0.005f;
        float f6 = 0.001f;
        int n3 = 5;
        float f7 = 0.05f;
        this.frameData = iFramework.getData();
        this.menu = iFramework.getDistanceMenu();
        int n4 = this.menu.getDistanceFunction();
        if (n4 == 0) {
            n4 = 4;
        }
        int n5 = 1;
        n5 = n4 == 1 || n4 == 6 || n4 == 7 || n4 == 2 || n4 == 3 || n4 == 5 || n4 == 9 || n4 == 10 ? -1 : 1;
        SOTAInitDialog sOTAInitDialog = new SOTAInitDialog(iFramework.getFrame(), n5, this.menu.getFunctionName(n4), this.menu.isAbsoluteDistance());
        if (sOTAInitDialog.showModal() != 0) {
            return null;
        }
        try {
            this.clusterGenes = sOTAInitDialog.getBoolean("clusterGenes");
            n = sOTAInitDialog.getInt("maxCycles");
            n2 = sOTAInitDialog.getInt("maxEpochsPerCycle");
            f2 = sOTAInitDialog.getFloat("epochStopCriteria");
            f4 = sOTAInitDialog.getFloat("migFactor_w");
            f5 = sOTAInitDialog.getFloat("migFactor_p");
            f6 = sOTAInitDialog.getFloat("migFactor_s");
            n3 = sOTAInitDialog.getInt("neighborhood-level");
            bl5 = sOTAInitDialog.getBoolean("useVariance");
            if (bl5) {
                f7 = sOTAInitDialog.getFloat("pValue");
            } else {
                f3 = sOTAInitDialog.getFloat("maxTreeDiv");
            }
            bl4 = sOTAInitDialog.getBoolean("runToMaxCycles");
            bl3 = sOTAInitDialog.getBoolean("setMaxClusterDiv");
            f = sOTAInitDialog.getFloat("maxClusterDiv");
            bl2 = false;
            bl = sOTAInitDialog.getBoolean("calcClusterHCL");
            if (f4 <= 0.0f || f4 <= 0.0f || f4 <= 0.0f) {
                JOptionPane.showMessageDialog(iFramework.getFrame(), "Migration weights should be > 0", "Error", 0);
                return null;
            }
            if (f7 <= 0.0f) {
                JOptionPane.showMessageDialog(iFramework.getFrame(), "p-value should be > 0", "Error", 0);
                return null;
            }
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(iFramework.getFrame(), "Invalid input parameters!", "Error", 0);
            return null;
        }
        if (n < 1) {
            JOptionPane.showMessageDialog(iFramework.getFrame(), "Number of cycles (number of clusters) must be greater than 0!", "Error", 0);
            return null;
        }
        if (n2 < 1) {
            JOptionPane.showMessageDialog(iFramework.getFrame(), "Number of epochs per cycle must be greater than 0!", "Error", 0);
            return null;
        }
        int n6 = 0;
        boolean bl6 = false;
        boolean bl7 = false;
        int n7 = sOTAInitDialog.getDistanceMetric();
        boolean bl8 = sOTAInitDialog.isAbsoluteDistance();
        if (bl || bl2) {
            object = new HCLInitDialog(iFramework.getFrame(), this.menu.getFunctionName(sOTAInitDialog.getDistanceMetric()), sOTAInitDialog.isAbsoluteDistance(), true);
            if (((HCLInitDialog)object).showModal() != 0) {
                return null;
            }
            n6 = ((HCLInitDialog)object).getMethod();
            bl6 = ((HCLInitDialog)object).isClusterExperiments();
            bl7 = ((HCLInitDialog)object).isClusterGenes();
            n7 = ((HCLInitDialog)object).getDistanceMetric();
            bl8 = ((HCLInitDialog)object).getAbsoluteSelection();
        }
        this.experiment = iFramework.getData().getExperiment();
        object = new Listener();
        try {
            this.algorithm = iFramework.getAlgorithmFactory().getAlgorithm("SOTA");
            this.algorithm.addAlgorithmListener((AlgorithmListener)object);
            this.data = new AlgorithmData();
            this.data.addParam("distance-absolute", String.valueOf(sOTAInitDialog.isAbsoluteDistance()));
            n4 = sOTAInitDialog.getDistanceMetric();
            this.data.addParam("distance-function", String.valueOf(n4));
            this.data.addParam("sota-cluster-genes", String.valueOf(this.clusterGenes));
            this.data.addParam("max-number-of-cycles", String.valueOf(n));
            this.data.addParam("max-epochs-per-cycle", String.valueOf(n2));
            this.data.addParam("epoch-improvement-cutoff", String.valueOf(f2));
            this.data.addParam("end-training-diversity", String.valueOf(f3));
            this.data.addParam("use-cluster-variance", String.valueOf(bl5));
            this.data.addParam("pValue", String.valueOf(f7));
            this.data.addParam("mig_w", String.valueOf(f4));
            this.data.addParam("mig_p", String.valueOf(f5));
            this.data.addParam("mig_s", String.valueOf(f6));
            this.data.addParam("neighborhood-level", String.valueOf(n3));
            this.data.addParam("run-to-max-cycles", String.valueOf(bl4));
            this.data.addParam("set-max-cluster-div", String.valueOf(bl3));
            this.data.addParam("maxClusterDiv", String.valueOf(f));
            this.data.addParam("calc-full-tree-hcl", String.valueOf(bl2));
            this.data.addParam("calc-cluster-hcl", String.valueOf(bl));
            if (bl || bl2) {
                this.data.addParam("calcClusterHCL", String.valueOf(bl));
                this.data.addParam("calcFullTreeHCL", String.valueOf(bl2));
                this.data.addParam("method-linkage", String.valueOf(n6));
                this.data.addParam("calculate-genes", String.valueOf(bl7));
                this.data.addParam("calculate-experiments", String.valueOf(bl6));
                this.data.addParam("hcl-distance-function", String.valueOf(n7));
                this.data.addParam("hcl-distance-absolute", String.valueOf(bl8));
            }
            this.data.addParam("name", "SOTA");
            if (this.clusterGenes) {
                this.data.addParam("alg-type", "cluster-genes");
            } else {
                this.data.addParam("alg-type", "cluster-experiments");
            }
            if (this.clusterGenes) {
                this.data.addParam("output-class", "multi-gene-cluster-output");
            } else {
                this.data.addParam("output-class", "multi-experiment-cluster-output");
            }
            String[] stringArray = new String[]{"Multi-cluster"};
            this.data.addStringArray("output-nodes", stringArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode executeScript(IFramework iFramework, AlgorithmData algorithmData, Experiment experiment) throws AlgorithmException {
        DefaultMutableTreeNode defaultMutableTreeNode;
        block9: {
            this.experiment = experiment;
            this.frameData = iFramework.getData();
            this.clusterGenes = algorithmData.getParams().getBoolean("sota-cluster-genes");
            Listener listener = new Listener();
            try {
                this.algorithm = iFramework.getAlgorithmFactory().getAlgorithm("SOTA");
                this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
                if (this.clusterGenes) {
                    algorithmData.addMatrix("experiment", experiment.getMatrix());
                } else {
                    algorithmData.addMatrix("experiment", experiment.getMatrix().transpose());
                }
                this.progress = new Progress(iFramework.getFrame(), "Calculating clusters", listener);
                this.progress.show();
                long l = System.currentTimeMillis();
                this.result = this.algorithm.execute(algorithmData);
                long l2 = System.currentTimeMillis() - l;
                Cluster cluster = this.result.getCluster("cluster");
                Cluster cluster2 = this.result.getCluster("hcl-result-clusters");
                Cluster cluster3 = this.result.getCluster("full-tree-sample-HCL");
                NodeList nodeList = cluster.getNodeList();
                this.k = nodeList.getSize();
                this.clusters = new int[this.k][];
                for (int i = 0; i < this.k; ++i) {
                    this.clusters[i] = nodeList.getNode(i).getProbesIndexes();
                }
                this.means = this.result.getMatrix("centroid-matrix");
                this.variances = this.result.getMatrix("cluster-variances");
                GeneralInfo generalInfo = new GeneralInfo();
                generalInfo.iterations = this.result.getParams().getInt("cycles") - 1;
                generalInfo.clusters = generalInfo.iterations + 1;
                generalInfo.time = l2;
                AlgorithmParameters algorithmParameters = algorithmData.getParams();
                generalInfo.function = iFramework.getDistanceMenu().getFunctionName(algorithmParameters.getInt("distance-function"));
                generalInfo.maxCycles = algorithmParameters.getInt("max-number-of-cycles");
                generalInfo.maxEpochsPerCycle = algorithmParameters.getInt("max-epochs-per-cycle");
                generalInfo.diversityCutoff = algorithmParameters.getFloat("end-training-diversity");
                generalInfo.epochStopCriteria = algorithmParameters.getFloat("epoch-improvement-cutoff");
                generalInfo.runToMaxCycles = algorithmParameters.getBoolean("run-to-max-cycles");
                generalInfo.migW = algorithmParameters.getFloat("mig_w");
                generalInfo.migP = algorithmParameters.getFloat("mig_p");
                generalInfo.migS = algorithmParameters.getFloat("mig_s");
                generalInfo.neighborhoodLevel = algorithmParameters.getInt("neighborhood-level");
                generalInfo.useCellDiversity = !algorithmParameters.getBoolean("use-cluster-variance");
                generalInfo.useCellVariability = algorithmParameters.getBoolean("use-cluster-variance");
                if (generalInfo.useCellVariability) {
                    generalInfo.pValue = algorithmParameters.getFloat("pValue");
                    generalInfo.computedVarCutoff = this.result.getParams().getFloat("computed-var-cutoff");
                }
                generalInfo.hcl_on_clusters = algorithmParameters.getBoolean("calc-cluster-hcl");
                generalInfo.hcl_on_samples_on_all_genes = algorithmParameters.getBoolean("calc-full-tree-hcl");
                generalInfo.hcl_genes_in_clusters = algorithmParameters.getBoolean("calculate-genes");
                generalInfo.hcl_samples_in_clusters = algorithmParameters.getBoolean("calculate-experiments");
                boolean bl = generalInfo.hcl = generalInfo.hcl_on_clusters || generalInfo.hcl_on_samples_on_all_genes;
                if (generalInfo.hcl) {
                    generalInfo.hcl_method = algorithmParameters.getInt("method-linkage");
                }
                this.loadSotaTreeData();
                defaultMutableTreeNode = this.createResultTree(cluster2, cluster3, generalInfo);
                Object var17_15 = null;
                if (this.algorithm == null) break block9;
            }
            catch (Throwable throwable) {
                block10: {
                    Object var17_16 = null;
                    if (this.algorithm != null) {
                        this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
                    }
                    if (this.progress == null) break block10;
                    this.progress.dispose();
                }
                throw throwable;
            }
            this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
        }
        if (this.progress != null) {
            this.progress.dispose();
        }
        return defaultMutableTreeNode;
    }

    private void loadSotaTreeData() {
        this.sotaTreeData = new SOTATreeData();
        this.sotaTreeData.nodeHeights = this.result.getMatrix("node-heights").getRowPackedCopy();
        this.sotaTreeData.leftChild = this.result.getIntArray("left-child");
        this.sotaTreeData.rightChild = this.result.getIntArray("right-child");
        this.sotaTreeData.nodePopulation = this.result.getIntArray("node-population");
        this.sotaTreeData.centroidMatrix = this.result.getMatrix("centroid-matrix");
        this.sotaTreeData.clusterDiversity = this.result.getMatrix("cluster-diversity");
        this.sotaTreeData.clusterPopulation = this.result.getIntArray("cluster-population");
        this.sotaTreeData.function = this.result.getParams().getInt("distance-function");
        this.sotaTreeData.factor = this.result.getParams().getFloat("factor");
        this.sotaTreeData.absolute = this.result.getParams().getBoolean("distance-absolute", true);
    }

    private DefaultMutableTreeNode createResultTree(Cluster cluster, Cluster cluster2, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.clusterGenes ? new DefaultMutableTreeNode("SOTA - genes") : new DefaultMutableTreeNode("SOTA - samples");
        this.addResultNodes(defaultMutableTreeNode, cluster, cluster2, generalInfo);
        return defaultMutableTreeNode;
    }

    private void addResultNodes(DefaultMutableTreeNode defaultMutableTreeNode, Cluster cluster, Cluster cluster2, GeneralInfo generalInfo) {
        SOTAGeneTreeViewer sOTAGeneTreeViewer = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        if (this.clusterGenes) {
            sOTAGeneTreeViewer = this.addSotaGeneViewer(defaultMutableTreeNode, cluster2);
            defaultMutableTreeNode2 = this.addExpressionImages(defaultMutableTreeNode);
            sOTAGeneTreeViewer.associateExpressionImageNode(defaultMutableTreeNode2);
        } else {
            SOTAExperimentTreeViewer sOTAExperimentTreeViewer = this.addSotaExperimentViewer(defaultMutableTreeNode, cluster2);
            defaultMutableTreeNode2 = this.addExpressionImages(defaultMutableTreeNode);
            sOTAExperimentTreeViewer.associateExpressionImageNode(defaultMutableTreeNode2);
        }
        this.addHierarchicalTrees(defaultMutableTreeNode, cluster, generalInfo);
        this.addCentroidViews(defaultMutableTreeNode);
        this.addTableViews(defaultMutableTreeNode);
        this.addDiversityViewer(defaultMutableTreeNode);
        this.addClusterInfo(defaultMutableTreeNode);
        this.addGeneralInfo(defaultMutableTreeNode, generalInfo);
    }

    private void addTableViews(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Table views");
        Object object = this.clusterGenes ? new ClusterTableViewer(this.experiment, this.clusters, this.frameData) : new ExperimentClusterTableViewer(this.experiment, this.clusters, this.frameData);
        for (int i = 0; i < this.clusters.length; ++i) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)object, (Object)new Integer(i))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private SOTAGeneTreeViewer addSotaGeneViewer(DefaultMutableTreeNode defaultMutableTreeNode, Cluster cluster) {
        SOTAGeneTreeViewer sOTAGeneTreeViewer = new SOTAGeneTreeViewer(this.experiment, this.sotaTreeData, cluster, this.clusters);
        if (sOTAGeneTreeViewer != null) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("SOTA Dendogram", (IViewer)sOTAGeneTreeViewer)));
        }
        return sOTAGeneTreeViewer;
    }

    private SOTAExperimentTreeViewer addSotaExperimentViewer(DefaultMutableTreeNode defaultMutableTreeNode, Cluster cluster) {
        SOTAExperimentTreeViewer sOTAExperimentTreeViewer = new SOTAExperimentTreeViewer(this.experiment, this.sotaTreeData, this.clusters);
        if (sOTAExperimentTreeViewer != null) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("SOTA Dendogram", (IViewer)sOTAExperimentTreeViewer)));
        }
        return sOTAExperimentTreeViewer;
    }

    private void addDiversityViewer(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (this.result != null) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("SOTA Diversity History", (IViewer)new SOTADiversityViewer(this.result.getMatrix("cycle-diversity")))));
        }
    }

    private DefaultMutableTreeNode addExpressionImages(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Expression Images");
        SOTAExperimentViewer sOTAExperimentViewer = this.clusterGenes ? new SOTAExperimentViewer(this.experiment, this.clusters, this.result.getMatrix("centroid-matrix"), this.result.getMatrix("cluster-diversity"), this.sotaTreeData) : new SOTAExperimentViewer(this.experiment, this.clusters, this.result.getMatrix("centroid-matrix"), this.result.getMatrix("cluster-diversity"), this.sotaTreeData, this.clusterGenes);
        for (int i = 0; i < this.clusters.length; ++i) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)sOTAExperimentViewer, (Object)new Integer(i))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        return defaultMutableTreeNode2;
    }

    private void addHierarchicalTrees(DefaultMutableTreeNode defaultMutableTreeNode, Cluster cluster, GeneralInfo generalInfo) {
        int n;
        if (!generalInfo.hcl) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Hierarchical Trees");
        NodeList nodeList = cluster.getNodeList();
        Object object = null;
        if (!this.clusterGenes) {
            object = new int[this.k][];
            for (n = 0; n < this.k; ++n) {
                object[n] = nodeList.getNode(n).getFeaturesIndexes();
            }
            if (generalInfo.hcl_samples_in_clusters) {
                object = this.getOrderedIndices(nodeList, (int[][])object, generalInfo.hcl_genes_in_clusters);
            }
        }
        for (n = 0; n < nodeList.getSize(); ++n) {
            if (this.clusterGenes) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(n + 1), this.createHCLViewer(nodeList.getNode(n), generalInfo, null))));
                continue;
            }
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(n + 1), this.createHCLViewer(nodeList.getNode(n), generalInfo, (int[][])object), (Object)new Integer(n))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private IViewer createHCLViewer(Node node, GeneralInfo generalInfo, int[][] nArray) {
        HCLTreeData hCLTreeData;
        HCLTreeData hCLTreeData2;
        HCLTreeData hCLTreeData3 = hCLTreeData2 = generalInfo.hcl_genes_in_clusters ? this.getResult(node, 0) : null;
        HCLTreeData hCLTreeData4 = generalInfo.hcl_samples_in_clusters ? this.getResult(node, generalInfo.hcl_genes_in_clusters ? 4 : 0) : (hCLTreeData = null);
        if (this.clusterGenes) {
            return new HCLViewer(this.experiment, node.getFeaturesIndexes(), hCLTreeData2, hCLTreeData);
        }
        return new HCLViewer(this.experiment, node.getFeaturesIndexes(), hCLTreeData2, hCLTreeData, nArray, true);
    }

    private HCLTreeData getResult(Node node, int n) {
        HCLTreeData hCLTreeData = new HCLTreeData();
        NodeValueList nodeValueList = node.getValues();
        hCLTreeData.child_1_array = (int[])nodeValueList.getNodeValue((int)n).value;
        hCLTreeData.child_2_array = (int[])nodeValueList.getNodeValue((int)(n + 1)).value;
        hCLTreeData.node_order = (int[])nodeValueList.getNodeValue((int)(n + 2)).value;
        hCLTreeData.height = (float[])nodeValueList.getNodeValue((int)(n + 3)).value;
        return hCLTreeData;
    }

    private void addClusterInfo(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Cluster Information");
        if (this.clusterGenes) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Genes in Clusters (#,%)", (IViewer)new SOTAInfoViewer(this.clusters, this.experiment.getNumberOfGenes()))));
        } else {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Samples in Clusters (#,%)", (IViewer)new SOTAInfoViewer(this.clusters, this.experiment.getNumberOfSamples(), false))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addCentroidViews(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Expression Graphs");
        if (this.clusterGenes) {
            SOTACentroidViewer sOTACentroidViewer = new SOTACentroidViewer(this.experiment, this.clusters);
            sOTACentroidViewer.setMeans(this.means.A);
            sOTACentroidViewer.setVariances(this.variances.A);
            for (int i = 0; i < this.clusters.length; ++i) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)sOTACentroidViewer, (Object)new CentroidUserObject(i, 0))));
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)sOTACentroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
            SOTACentroidsViewer sOTACentroidsViewer = new SOTACentroidsViewer(this.experiment, this.clusters);
            sOTACentroidsViewer.setMeans(this.means.A);
            sOTACentroidsViewer.setVariances(this.variances.A);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)sOTACentroidsViewer, (Object)new Integer(0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)sOTACentroidsViewer, (Object)new Integer(1))));
        } else {
            SOTAExperimentCentroidViewer sOTAExperimentCentroidViewer = new SOTAExperimentCentroidViewer(this.experiment, this.clusters);
            sOTAExperimentCentroidViewer.setMeans(this.means.A);
            sOTAExperimentCentroidViewer.setVariances(this.variances.A);
            for (int i = 0; i < this.clusters.length; ++i) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)sOTAExperimentCentroidViewer, (Object)new CentroidUserObject(i, 0))));
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)sOTAExperimentCentroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
            SOTAExperimentCentroidsViewer sOTAExperimentCentroidsViewer = new SOTAExperimentCentroidsViewer(this.experiment, this.clusters);
            sOTAExperimentCentroidsViewer.setMeans(this.means.A);
            sOTAExperimentCentroidsViewer.setVariances(this.variances.A);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)sOTAExperimentCentroidsViewer, (Object)new Integer(0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)sOTAExperimentCentroidsViewer, (Object)new Integer(1))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
    }

    private void addGeneralInfo(DefaultMutableTreeNode defaultMutableTreeNode, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("General Information");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Growth Termination Criteria");
        defaultMutableTreeNode3.add(new DefaultMutableTreeNode("Max. cycles: " + String.valueOf(generalInfo.maxCycles)));
        defaultMutableTreeNode3.add(new DefaultMutableTreeNode("Max. epochs/cycle: " + String.valueOf(generalInfo.maxEpochsPerCycle)));
        if (generalInfo.useCellDiversity) {
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode("Max. cell div: " + String.valueOf(generalInfo.diversityCutoff)));
        } else {
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode("Max. cell div: n/a (used variability and p value)"));
        }
        defaultMutableTreeNode3.add(new DefaultMutableTreeNode("Min. epoch error change: " + String.valueOf(generalInfo.epochStopCriteria)));
        defaultMutableTreeNode3.add(new DefaultMutableTreeNode("Run max. cycles (unrestricted): " + String.valueOf(generalInfo.runToMaxCycles)));
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode("Migration Parameters");
        defaultMutableTreeNode4.add(new DefaultMutableTreeNode("Winning cell mig. factor: " + String.valueOf(generalInfo.migW)));
        defaultMutableTreeNode4.add(new DefaultMutableTreeNode("Parent cell mig. factor: " + String.valueOf(generalInfo.migP)));
        defaultMutableTreeNode4.add(new DefaultMutableTreeNode("Sister cell mig. factor: " + String.valueOf(generalInfo.migS)));
        defaultMutableTreeNode4.add(new DefaultMutableTreeNode("Neighborhood level: " + String.valueOf(generalInfo.neighborhoodLevel)));
        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode("Cell Division Criteria");
        defaultMutableTreeNode5.add(new DefaultMutableTreeNode("Diversity division criteria: " + String.valueOf(generalInfo.useCellDiversity)));
        defaultMutableTreeNode5.add(new DefaultMutableTreeNode("Variability division criteria: " + String.valueOf(generalInfo.useCellVariability)));
        if (generalInfo.useCellVariability) {
            defaultMutableTreeNode5.add(new DefaultMutableTreeNode("Variablity pValue: " + String.valueOf(generalInfo.pValue)));
            defaultMutableTreeNode5.add(new DefaultMutableTreeNode("Computed Cell Var. Cutoff: " + String.valueOf(generalInfo.computedVarCutoff)));
        } else {
            defaultMutableTreeNode5.add(new DefaultMutableTreeNode("Variablity pValue: n/a"));
            defaultMutableTreeNode5.add(new DefaultMutableTreeNode("Computed cell var. cutoff: n/a"));
        }
        DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode("HCL Options");
        if (generalInfo.hcl_on_samples_on_all_genes || generalInfo.hcl_on_clusters) {
            defaultMutableTreeNode6.add(new DefaultMutableTreeNode("HCL on samples (over all genes): " + String.valueOf(generalInfo.hcl_on_samples_on_all_genes)));
            defaultMutableTreeNode6.add(new DefaultMutableTreeNode("HCL on samples in clusters: " + String.valueOf(generalInfo.hcl_samples_in_clusters)));
            defaultMutableTreeNode6.add(new DefaultMutableTreeNode("HCL on genes in clusters: " + String.valueOf(generalInfo.hcl_genes_in_clusters)));
            defaultMutableTreeNode6.add(new DefaultMutableTreeNode("Tree - " + generalInfo.getMethodName()));
        }
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode2.add(defaultMutableTreeNode4);
        defaultMutableTreeNode2.add(defaultMutableTreeNode5);
        if (generalInfo.hcl_on_samples_on_all_genes || generalInfo.hcl_on_clusters) {
            defaultMutableTreeNode2.add(defaultMutableTreeNode6);
        }
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("number of clusters: " + String.valueOf(generalInfo.clusters)));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Cycles run: " + String.valueOf(generalInfo.iterations)));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(generalInfo.function));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Time: " + String.valueOf(generalInfo.time) + " ms"));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private int[][] getOrderedIndices(NodeList nodeList, int[][] nArray, boolean bl) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i].length <= 0) continue;
            HCLTreeData hCLTreeData = this.getResult(nodeList.getNode(i), bl ? 4 : 0);
            nArray[i] = this.getSampleOrder(hCLTreeData, nArray[i]);
        }
        return nArray;
    }

    private int[] getSampleOrder(HCLTreeData hCLTreeData, int[] nArray) {
        return this.getLeafOrder(hCLTreeData.node_order, hCLTreeData.child_1_array, hCLTreeData.child_2_array, nArray);
    }

    private int[] getLeafOrder(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int[] nArray5 = new int[nArray.length];
        Arrays.fill(nArray5, -1);
        this.fillLeafOrder(nArray5, nArray2, nArray3, 0, nArray2.length - 2, nArray4);
        return nArray5;
    }

    private int fillLeafOrder(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2, int[] nArray4) {
        if (nArray2[n2] != -1) {
            n = this.fillLeafOrder(nArray, nArray2, nArray3, n, nArray2[n2], nArray4);
        }
        if (nArray3[n2] != -1) {
            n = this.fillLeafOrder(nArray, nArray2, nArray3, n, nArray3[n2], nArray4);
        } else {
            nArray[n] = nArray4 == null ? n2 : nArray4[n2];
            ++n;
        }
        return n;
    }

    private class GeneralInfo {
        public int clusters;
        public int iterations;
        public long time;
        public String function;
        public int maxCycles;
        public int maxEpochsPerCycle;
        public float diversityCutoff;
        public float epochStopCriteria;
        public boolean runToMaxCycles;
        public float migW;
        public float migP;
        public float migS;
        public int neighborhoodLevel;
        public boolean useCellDiversity;
        public boolean useCellVariability;
        public float pValue;
        public float computedVarCutoff;
        public boolean hcl;
        public int hcl_method;
        public boolean hcl_on_clusters;
        public boolean hcl_on_samples_on_all_genes;
        public boolean hcl_genes_in_clusters;
        public boolean hcl_samples_in_clusters;

        private GeneralInfo() {
        }

        public String getMethodName() {
            return this.hcl ? HCLGUI.GeneralInfo.getMethodName(this.hcl_method) : "no linkage";
        }
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent algorithmEvent) {
            switch (algorithmEvent.getId()) {
                case 1: {
                    SOTAGUI.this.progress.setUnits(algorithmEvent.getIntValue());
                    SOTAGUI.this.progress.setDescription(algorithmEvent.getDescription());
                    break;
                }
                case 2: {
                    SOTAGUI.this.progress.setValue(algorithmEvent.getIntValue());
                    SOTAGUI.this.progress.setDescription(algorithmEvent.getDescription());
                    break;
                }
                case 3: {
                    int n = algorithmEvent.getIntValue();
                    if (n == -1) {
                        SOTAGUI.this.monitor.dispose();
                        break;
                    }
                    if (n >= 245) break;
                    SOTAGUI.this.monitor.update(n);
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("cancel-command")) {
                SOTAGUI.this.algorithm.abort();
                SOTAGUI.this.progress.dispose();
                SOTAGUI.this.monitor.dispose();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            SOTAGUI.this.algorithm.abort();
            SOTAGUI.this.progress.dispose();
            SOTAGUI.this.monitor.dispose();
        }
    }
}

