/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.sota;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class SOTAConfigDialog
extends AlgorithmDialog {
    private int result;
    private JTextField zeroTextField;
    private JTextField minTextField;
    private JTextField maxTextField;
    private float zThr;
    private int minPixDist;
    private int maxPixDist;

    public SOTAConfigDialog(Frame frame, float f, int n, int n2) {
        super(frame, "Tree Configuration", true);
        this.zThr = f;
        this.minPixDist = n;
        this.maxPixDist = n2;
        Listener listener = new Listener();
        this.addWindowListener(listener);
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        jPanel.setBorder(new EmptyBorder(10, 5, 10, 0));
        jPanel.setBackground(Color.white);
        jPanel.add(new JLabel("Distance threshold"));
        jPanel.add(new JLabel("Minimum pixel distance"));
        jPanel.add(new JLabel("Maximum pixel distance"));
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1));
        jPanel2.setBorder(new EmptyBorder(10, 5, 10, 0));
        jPanel2.setBackground(Color.white);
        String string = String.valueOf(f);
        string = string.substring(0, Math.min(5, string.length()));
        this.zeroTextField = new JTextField(string, 4);
        jPanel2.add((Component)this.zeroTextField, "East");
        this.minTextField = new JTextField(String.valueOf(n), 4);
        jPanel2.add((Component)this.minTextField, "East");
        this.maxTextField = new JTextField(String.valueOf(n2), 4);
        jPanel2.add((Component)this.maxTextField, "East");
        JButton jButton = new JButton("OK");
        jButton.setActionCommand("ok-command");
        jButton.addActionListener(listener);
        jButton.setFocusPainted(false);
        JButton jButton2 = new JButton("Cancel");
        jButton2.setActionCommand("cancel-command");
        jButton2.addActionListener(listener);
        jButton2.setFocusPainted(false);
        JPanel jPanel3 = new JPanel(new GridLayout(0, 2));
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setForeground(Color.white);
        jPanel4.setBorder(BorderFactory.createLineBorder(Color.gray));
        JLabel jLabel = new JLabel(GUIFactory.getIcon("tigr_logo.gif"));
        jPanel4.setBackground(Color.white);
        jPanel4.add((Component)jPanel, "West");
        jPanel4.add((Component)jPanel2, "Center");
        jPanel4.add((Component)jLabel, "East");
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)jPanel4, "North");
        this.addContent(jPanel5);
        this.setActionListeners(listener);
        this.pack();
        this.setResizable(false);
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public float getZeroThreshold() {
        return Float.parseFloat(this.zeroTextField.getText());
    }

    public int getMinDistance() {
        return Integer.parseInt(this.minTextField.getText());
    }

    public int getMaxDistance() {
        return Integer.parseInt(this.maxTextField.getText());
    }

    public static void main(String[] stringArray) {
        SOTAConfigDialog sOTAConfigDialog = new SOTAConfigDialog(new Frame(), 2.0f, 3, 4);
        sOTAConfigDialog.show();
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                try {
                    Float.parseFloat(SOTAConfigDialog.this.zeroTextField.getText());
                    Integer.parseInt(SOTAConfigDialog.this.minTextField.getText());
                    Integer.parseInt(SOTAConfigDialog.this.maxTextField.getText());
                    SOTAConfigDialog.this.result = 0;
                    SOTAConfigDialog.this.dispose();
                }
                catch (Exception exception) {
                    SOTAConfigDialog.this.result = 2;
                }
            } else if (string.equals("cancel-command")) {
                SOTAConfigDialog.this.result = 2;
                SOTAConfigDialog.this.dispose();
            } else if (string.equals("reset-command")) {
                SOTAConfigDialog.this.zeroTextField.setText(String.valueOf(SOTAConfigDialog.this.zThr));
                SOTAConfigDialog.this.minTextField.setText(String.valueOf(SOTAConfigDialog.this.minPixDist));
                SOTAConfigDialog.this.maxTextField.setText(String.valueOf(SOTAConfigDialog.this.maxPixDist));
            } else if (string.equals("info-command")) {
                HelpWindow helpWindow = new HelpWindow(SOTAConfigDialog.this, "SOTA Tree Properties");
                if (helpWindow.getWindowContent()) {
                    helpWindow.setSize(450, 500);
                    helpWindow.setLocation();
                    helpWindow.show();
                } else {
                    helpWindow.dispose();
                }
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            SOTAConfigDialog.this.result = -1;
            SOTAConfigDialog.this.dispose();
        }
    }
}

