/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.sam;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class SAMScriptDeltaValueInitDialog
extends AlgorithmDialog {
    int result = 2;
    JTextField deltaField;
    JCheckBox deltaGraphCheckBox;
    JLabel deltaLabel;

    public SAMScriptDeltaValueInitDialog(JFrame jFrame) {
        super(jFrame, "SAM Script Delta Selection", true);
        Listener listener = new Listener();
        this.deltaLabel = new JLabel("Delta Value");
        this.deltaField = new JTextField("1.0", 5);
        this.deltaField.setPreferredSize(new Dimension(70, 20));
        this.deltaField.setSize(new Dimension(70, 20));
        this.deltaGraphCheckBox = new JCheckBox("Interact with SAM graph. (Delta Value Slider)", false);
        this.deltaGraphCheckBox.setOpaque(false);
        this.deltaGraphCheckBox.setFocusPainted(false);
        this.deltaGraphCheckBox.addItemListener(listener);
        ParameterPanel parameterPanel = new ParameterPanel("SAM Delta Value Selection");
        parameterPanel.setLayout(new GridBagLayout());
        parameterPanel.add((Component)this.deltaLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 3, new Insets(10, 0, 20, 20), 0, 0));
        parameterPanel.add((Component)this.deltaField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(10, 10, 20, 0), 0, 0));
        parameterPanel.add((Component)this.deltaGraphCheckBox, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 20, 0), 0, 0));
        this.addContent(parameterPanel);
        this.setActionListeners(listener);
        this.pack();
    }

    public float getDeltaValue() {
        String string = this.deltaField.getText();
        return Float.parseFloat(string);
    }

    public boolean interactWithGraph() {
        return this.deltaGraphCheckBox.isSelected();
    }

    private boolean validateValue(String string) {
        try {
            float f = Float.parseFloat(string);
            if (f < 0.0f) {
                JOptionPane.showMessageDialog(this, "Value must be greater than or equal to zero.", "Value Range Error", 0);
                this.deltaField.selectAll();
                this.deltaField.grabFocus();
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Value is not in a valid format.", "Value Format Error", 0);
            this.deltaField.selectAll();
            this.deltaField.grabFocus();
            return false;
        }
        catch (NullPointerException nullPointerException) {
            JOptionPane.showMessageDialog(this, "Null value entered.", "Null Value Error", 0);
            this.deltaField.selectAll();
            this.deltaField.grabFocus();
            return false;
        }
        return true;
    }

    private void resetControls() {
        this.deltaField.setText("1.0");
        this.deltaField.setEnabled(true);
        this.deltaLabel.setEnabled(true);
        this.deltaGraphCheckBox.setSelected(false);
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public static void main(String[] stringArray) {
        SAMScriptDeltaValueInitDialog sAMScriptDeltaValueInitDialog = new SAMScriptDeltaValueInitDialog(new JFrame());
        sAMScriptDeltaValueInitDialog.showModal();
    }

    private class Listener
    extends DialogListener
    implements ItemListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                if (!SAMScriptDeltaValueInitDialog.this.deltaGraphCheckBox.isSelected()) {
                    if (SAMScriptDeltaValueInitDialog.this.validateValue(SAMScriptDeltaValueInitDialog.this.deltaField.getText())) {
                        SAMScriptDeltaValueInitDialog.this.result = 0;
                        SAMScriptDeltaValueInitDialog.this.dispose();
                    }
                } else {
                    SAMScriptDeltaValueInitDialog.this.result = 0;
                    SAMScriptDeltaValueInitDialog.this.dispose();
                }
            } else if (string.equals("cancel-command")) {
                SAMScriptDeltaValueInitDialog.this.result = 2;
                SAMScriptDeltaValueInitDialog.this.dispose();
            } else {
                if (string.equals("reset-command")) {
                    SAMScriptDeltaValueInitDialog.this.resetControls();
                    SAMScriptDeltaValueInitDialog.this.result = 2;
                    return;
                }
                if (string.equals("info-command")) {
                    HelpWindow helpWindow = new HelpWindow(SAMScriptDeltaValueInitDialog.this, "SAM Script Delta Dialog");
                    SAMScriptDeltaValueInitDialog.this.result = 2;
                    if (helpWindow.getWindowContent()) {
                        helpWindow.setSize(450, 600);
                        helpWindow.setLocation();
                        helpWindow.show();
                        return;
                    }
                    helpWindow.setVisible(false);
                    helpWindow.dispose();
                    return;
                }
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            SAMScriptDeltaValueInitDialog.this.deltaLabel.setEnabled(!SAMScriptDeltaValueInitDialog.this.deltaGraphCheckBox.isSelected());
            SAMScriptDeltaValueInitDialog.this.deltaField.setEnabled(!SAMScriptDeltaValueInitDialog.this.deltaGraphCheckBox.isSelected());
        }

        public void windowClosing(WindowEvent windowEvent) {
            SAMScriptDeltaValueInitDialog.this.result = -1;
            SAMScriptDeltaValueInitDialog.this.dispose();
        }
    }
}

