/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.sam;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExpressionFileFilter;
import org.tigr.microarray.mev.cluster.gui.helpers.ExpressionFileView;

public class SAMExperimentViewer
extends ExperimentViewer {
    private JPopupMenu popup;
    private float[] dValues;
    private float[] rValues;
    private float[] foldChangeArray;
    private float[] qLowestFDR;
    private int studyDesign;
    private boolean calculateQLowestFDR;

    public SAMExperimentViewer(Experiment experiment, int[][] nArray, int n, float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, boolean bl) {
        super(experiment, nArray);
        Listener listener = new Listener();
        this.popup = this.createJPopupMenu(listener);
        this.studyDesign = n;
        this.dValues = fArray;
        this.rValues = fArray2;
        this.foldChangeArray = fArray3;
        this.qLowestFDR = fArray4;
        this.calculateQLowestFDR = bl;
        this.getContentComponent().addMouseListener(listener);
        this.getHeaderComponent().addMouseListener(listener);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Listener listener = new Listener();
        this.popup = this.createJPopupMenu(listener);
        this.getContentComponent().addMouseListener(listener);
        this.getHeaderComponent().addMouseListener(listener);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private JPopupMenu createJPopupMenu(Listener listener) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.addMenuItems(jPopupMenu, listener);
        return jPopupMenu;
    }

    private void onSaveClusters() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            this.saveClusters(frame);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(frame, "Can not save clusters!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    private void onSaveCluster() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            this.saveCluster(frame);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(frame, "Can not save cluster!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    private void onSetColor() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        Color color = JColorChooser.showDialog(frame, "Choose color", CentroidViewer.DEF_CLUSTER_COLOR);
        if (color != null) {
            this.setClusterColor(color);
        }
    }

    private void onSetDefaultColor() {
        this.setClusterColor(null);
    }

    public void saveClusters(Frame frame) throws Exception {
        frame = frame == null ? JOptionPane.getFrameForComponent((Component)((Object)this)) : frame;
        this.saveExperiment(frame, this.getExperiment(), this.getData(), this.getClusters());
    }

    public void saveCluster(Frame frame) throws Exception {
        frame = frame == null ? JOptionPane.getFrameForComponent((Component)((Object)this)) : frame;
        this.saveExperiment(frame, this.getExperiment(), this.getData(), this.getCluster());
    }

    public void saveExperiment(Frame frame, Experiment experiment, IData iData, int[] nArray) throws Exception {
        File file = SAMExperimentViewer.getFile(frame);
        if (file != null) {
            this.saveCluster(file, experiment, iData, nArray);
        }
    }

    public void saveExperiment(Frame frame, Experiment experiment, IData iData, int[][] nArray) throws Exception {
        File file = SAMExperimentViewer.getFile(frame);
        if (file != null) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == null || nArray[i].length == 0) continue;
                File file2 = new File(file.getPath() + "-" + String.valueOf(i + 1) + ".txt");
                this.saveCluster(file2, experiment, iData, nArray[i]);
            }
        }
    }

    private void saveCluster(File file, Experiment experiment, IData iData, int[] nArray) throws Exception {
        int n;
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
        String[] stringArray = iData.getFieldNames();
        printWriter.print("Original row");
        printWriter.print("\t");
        for (n = 0; n < stringArray.length; ++n) {
            printWriter.print(stringArray[n]);
            if (n >= stringArray.length - 1) continue;
            printWriter.print("\t");
        }
        printWriter.print("\t");
        printWriter.print("Score (d)");
        printWriter.print("\t");
        printWriter.print("Numerator (r)\t");
        printWriter.print("Denominator (s+s0)\t");
        if (this.studyDesign == 5 || this.studyDesign == 4) {
            printWriter.print("Fold Change");
        }
        if (this.calculateQLowestFDR) {
            printWriter.print("\t");
            printWriter.print("q-value (%)");
        }
        for (n = 0; n < experiment.getNumberOfSamples(); ++n) {
            printWriter.print("\t");
            printWriter.print(iData.getFullSampleName(experiment.getSampleIndex(n)));
        }
        printWriter.print("\n");
        for (n = 0; n < nArray.length; ++n) {
            int n2;
            printWriter.print(Integer.toString(experiment.getGeneIndexMappedToData(nArray[n]) + 1));
            printWriter.print("\t");
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                printWriter.print(iData.getElementAttribute(experiment.getGeneIndexMappedToData(nArray[n]), n2));
                if (n2 >= stringArray.length - 1) continue;
                printWriter.print("\t");
            }
            printWriter.print("\t");
            printWriter.print("" + this.dValues[nArray[n]]);
            printWriter.print("\t");
            printWriter.print("" + this.rValues[nArray[n]] + "\t");
            printWriter.print("" + this.rValues[nArray[n]] / this.dValues[nArray[n]] + "\t");
            if (this.studyDesign == 5 || this.studyDesign == 4) {
                printWriter.print("" + this.foldChangeArray[nArray[n]]);
            }
            if (this.calculateQLowestFDR) {
                printWriter.print("\t");
                printWriter.print("" + this.qLowestFDR[nArray[n]]);
            }
            for (n2 = 0; n2 < experiment.getNumberOfSamples(); ++n2) {
                printWriter.print("\t");
                printWriter.print(Float.toString(experiment.get(nArray[n], n2)));
            }
            printWriter.print("\n");
        }
        printWriter.flush();
        printWriter.close();
    }

    private static File getFile(Frame frame) {
        File file = null;
        JFileChooser jFileChooser = new JFileChooser(TMEV.getFile((String)"data/"));
        jFileChooser.addChoosableFileFilter((FileFilter)new ExpressionFileFilter());
        jFileChooser.setFileView((FileView)new ExpressionFileView());
        int n = jFileChooser.showSaveDialog(frame);
        if (n == 0) {
            file = jFileChooser.getSelectedFile();
        }
        return file;
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("save-cluster-cmd")) {
                SAMExperimentViewer.this.onSaveCluster();
            } else if (string.equals("save-all-clusters-cmd")) {
                SAMExperimentViewer.this.onSaveClusters();
            } else if (string.equals("set-def-color-cmd")) {
                SAMExperimentViewer.this.onSetDefaultColor();
            } else if (string.equals("store-cluster-cmd")) {
                SAMExperimentViewer.this.storeCluster();
            } else if (string.equals("launch-new-session-cmd")) {
                SAMExperimentViewer.this.launchNewSession();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger() || SAMExperimentViewer.this.getCluster() == null || SAMExperimentViewer.this.getCluster().length == 0) {
                return;
            }
            SAMExperimentViewer.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

