/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.rn;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.SampleSelectionPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class RelNetInitDialog
extends AlgorithmDialog {
    private int result;
    private JCheckBox usePermutationBox;
    private JTextField minThresholdField;
    private JTextField maxThresholdField;
    private JTextField entropyField;
    private JCheckBox useEntropyBox;
    private SampleSelectionPanel sampleSelectionPanel;

    public RelNetInitDialog(Frame frame) {
        super(frame, "RN: Relevance Networks", true);
        Listener listener = new Listener();
        this.addWindowListener(listener);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.sampleSelectionPanel = new SampleSelectionPanel(Color.white, UIManager.getColor("Label.foreground"), true, "Sample Selection");
        ParameterPanel parameterPanel = new ParameterPanel();
        parameterPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.usePermutationBox = new JCheckBox("Use Permutation Test");
        this.usePermutationBox.setFocusPainted(false);
        this.usePermutationBox.setBackground(Color.white);
        this.usePermutationBox.setForeground(UIManager.getColor("Label.foreground"));
        this.usePermutationBox.setActionCommand("permutation-command");
        this.usePermutationBox.addActionListener(listener);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets.bottom = 5;
        parameterPanel.add((Component)this.usePermutationBox, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets.bottom = 5;
        parameterPanel.add((Component)new JLabel("Min Threshold:"), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        parameterPanel.add((Component)new JLabel("Max Threshold:"), gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.useEntropyBox = new JCheckBox("Use Filter, %");
        this.useEntropyBox.setFocusPainted(false);
        this.useEntropyBox.setBackground(Color.white);
        this.useEntropyBox.setForeground(UIManager.getColor("Label.foreground"));
        this.useEntropyBox.setActionCommand("entropy-command");
        this.useEntropyBox.addActionListener(listener);
        parameterPanel.add((Component)this.useEntropyBox, gridBagConstraints);
        this.minThresholdField = new JTextField(String.valueOf(0.97f), 5);
        this.maxThresholdField = new JTextField(String.valueOf(1.0f), 5);
        this.entropyField = new JTextField("95", 5);
        this.entropyField.setEnabled(false);
        gridBagConstraints.insets = new Insets(0, 10, 5, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        parameterPanel.add((Component)this.minThresholdField, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        parameterPanel.add((Component)this.maxThresholdField, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        parameterPanel.add((Component)this.entropyField, gridBagConstraints);
        jPanel.add((Component)this.sampleSelectionPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)parameterPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setActionListeners(listener);
        this.addContent(jPanel);
        this.pack();
        this.setResizable(false);
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public boolean usePermutation() {
        return this.usePermutationBox.isSelected();
    }

    public float getMinThreshold() {
        return Float.parseFloat(this.minThresholdField.getText());
    }

    public float getMaxThreshold() {
        return Float.parseFloat(this.maxThresholdField.getText());
    }

    public boolean useEntropy() {
        return this.useEntropyBox.isSelected();
    }

    public float getEntropy() {
        if (this.useEntropy()) {
            return Float.parseFloat(this.entropyField.getText());
        }
        return 0.0f;
    }

    public boolean isClusterGenes() {
        return this.sampleSelectionPanel.isClusterGenesSelected();
    }

    private void resetControls() {
        this.sampleSelectionPanel.setClusterGenesSelected(true);
        this.useEntropyBox.setSelected(false);
        this.usePermutationBox.setSelected(false);
        this.entropyField.setText("95");
        this.entropyField.setEnabled(false);
        this.maxThresholdField.setText(String.valueOf(1.0f));
        this.minThresholdField.setText(String.valueOf(0.97f));
        this.minThresholdField.setEnabled(true);
    }

    private boolean validInput(float f, float f2, float f3) {
        boolean bl = true;
        if (!this.usePermutationBox.isSelected() && (f <= 0.0f || (double)f > 1.0)) {
            JOptionPane.showMessageDialog(this, "Min. Treshold must be > 0 and <= 1.0", "Input Error!", 0);
            this.minThresholdField.requestFocus();
            this.minThresholdField.selectAll();
            bl = false;
        } else if (f2 <= 0.0f || (double)f2 > 1.0) {
            JOptionPane.showMessageDialog(this, "Max. Treshold must be > 0 and <= 1.0", "Input Error!", 0);
            this.maxThresholdField.requestFocus();
            this.maxThresholdField.selectAll();
            bl = false;
        } else if (f2 <= f) {
            JOptionPane.showMessageDialog(this, "Max. threshold must be > Min. threshold", "Input Error!", 0);
            bl = false;
        } else if (this.useEntropy() && (f3 <= 0.0f || f3 > 100.0f)) {
            JOptionPane.showMessageDialog(this, "Entropy must be > 0 and <= 100", "Input Error!", 0);
            this.entropyField.requestFocus();
            this.entropyField.selectAll();
            bl = false;
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        RelNetInitDialog relNetInitDialog = new RelNetInitDialog(new JFrame());
        if (relNetInitDialog.showModal() == 0) {
            System.out.println("ok");
        }
        System.exit(0);
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block21: {
                String string = actionEvent.getActionCommand();
                if (string.equals("ok-command")) {
                    int n = 0;
                    float f = 0.0f;
                    try {
                        float f2 = Float.parseFloat(RelNetInitDialog.this.minThresholdField.getText());
                        ++n;
                        float f3 = Float.parseFloat(RelNetInitDialog.this.maxThresholdField.getText());
                        ++n;
                        if (RelNetInitDialog.this.useEntropy()) {
                            f = Float.parseFloat(RelNetInitDialog.this.entropyField.getText());
                            ++n;
                        }
                        if (RelNetInitDialog.this.validInput(f2, f3, f)) {
                            RelNetInitDialog.this.result = 0;
                            RelNetInitDialog.this.dispose();
                        }
                        break block21;
                    }
                    catch (NumberFormatException numberFormatException) {
                        JOptionPane.showMessageDialog(RelNetInitDialog.this, "Not a number: " + numberFormatException.getMessage(), "Input Error!", 0);
                        if (n == 0) {
                            RelNetInitDialog.this.minThresholdField.requestFocus();
                            RelNetInitDialog.this.minThresholdField.selectAll();
                        } else if (n == 1) {
                            RelNetInitDialog.this.maxThresholdField.requestFocus();
                            RelNetInitDialog.this.maxThresholdField.selectAll();
                        } else if (n == 2) {
                            RelNetInitDialog.this.entropyField.requestFocus();
                            RelNetInitDialog.this.entropyField.selectAll();
                        }
                        break block21;
                    }
                }
                if (string.equals("cancel-command")) {
                    RelNetInitDialog.this.result = 2;
                    RelNetInitDialog.this.dispose();
                } else if (string.equals("entropy-command")) {
                    RelNetInitDialog.this.entropyField.setEnabled(((AbstractButton)actionEvent.getSource()).isSelected());
                } else if (string.equals("permutation-command")) {
                    RelNetInitDialog.this.minThresholdField.setEnabled(!((AbstractButton)actionEvent.getSource()).isSelected());
                } else if (string.equals("reset-command")) {
                    RelNetInitDialog.this.resetControls();
                } else if (string.equals("info-command")) {
                    HelpWindow helpWindow = new HelpWindow(RelNetInitDialog.this, "RN Initialization Dialog");
                    if (helpWindow.getWindowContent()) {
                        helpWindow.setSize(450, 500);
                        helpWindow.setLocation();
                        helpWindow.show();
                    } else {
                        helpWindow.dispose();
                    }
                }
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            RelNetInitDialog.this.result = -1;
            RelNetInitDialog.this.dispose();
        }
    }
}

