/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ptm;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.tigr.graph.GraphCanvas;
import org.tigr.graph.GraphElement;
import org.tigr.graph.GraphLine;
import org.tigr.graph.GraphPoint;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.util.FloatMatrix;

public class PTMInitDialog
extends AlgorithmDialog {
    String[] SampleNames;
    Vector sampleNamesVector;
    Vector uniqueIDs;
    Vector clusters;
    Vector expClusters;
    Color[] clusterColors;
    Color[] expClusterColors;
    GeneSelector geneSelectPanel;
    GeneClusterSelector geneClusterSelectPanel;
    ExperimentSelector expSelectPanel;
    ExperimentClusterSelector clusterSelectPanel;
    SavedTemplateSelector templateSelectPanel;
    TemplatePanel tempPanel;
    ThresholdPanel thresh;
    FloatMatrix expMatrix;
    JCheckBox drawTreesBox;
    private JRadioButton sigOnly;
    private JRadioButton allClusters;
    JPanel drawTreesPane;
    JTabbedPane tabbedPane;
    JButton saveTemplateButton;
    Vector template = new Vector();
    FloatMatrix templateMatrix;
    boolean setTemplate = false;
    boolean clusterGenes = true;
    int numberOfExperiments;
    private boolean okPressed = false;

    public PTMInitDialog(JFrame jFrame, boolean bl, FloatMatrix floatMatrix, Vector vector, Vector vector2, Vector vector3, Vector vector4, Color[] colorArray, Color[] colorArray2) {
        super(jFrame, "PTM: Pavlidis Template Matching", bl);
        this.expMatrix = floatMatrix;
        this.numberOfExperiments = floatMatrix.getColumnDimension();
        this.uniqueIDs = vector;
        this.sampleNamesVector = vector2;
        this.clusters = vector3;
        this.clusterColors = colorArray;
        this.expClusters = vector4;
        this.expClusterColors = colorArray2;
        this.SampleNames = this.getSampleNames();
        this.setBounds(0, 0, 890, 700);
        this.setSize(890, 700);
        this.setDefaultCloseOperation(2);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        this.buildConstraints(gridBagConstraints, 0, 0, 2, 1, 0, 10);
        this.tabbedPane = new JTabbedPane();
        this.geneSelectPanel = new GeneSelector();
        this.geneClusterSelectPanel = new GeneClusterSelector();
        this.expSelectPanel = new ExperimentSelector();
        this.clusterSelectPanel = new ExperimentClusterSelector();
        this.templateSelectPanel = new SavedTemplateSelector();
        this.tabbedPane.addTab("Gene Templates", this.geneSelectPanel);
        this.tabbedPane.addTab("Gene Cluster Templates", this.geneClusterSelectPanel);
        this.tabbedPane.addTab("Sample Templates", this.expSelectPanel);
        this.tabbedPane.addTab("Sample Cluster Templates", this.clusterSelectPanel);
        this.tabbedPane.addTab("Select a Saved Template", this.templateSelectPanel);
        this.tabbedPane.setSelectedIndex(0);
        gridBagLayout.setConstraints(this.tabbedPane, gridBagConstraints);
        jPanel.add(this.tabbedPane);
        this.buildConstraints(gridBagConstraints, 0, 1, 2, 1, 0, 10);
        this.tempPanel = new TemplatePanel();
        this.tempPanel.setPreferredSize(new Dimension(80, 400));
        gridBagLayout.setConstraints(this.tempPanel, gridBagConstraints);
        jPanel.add(this.tempPanel);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = PTMInitDialog.this.tabbedPane.getSelectedIndex();
                if (n > 1) {
                    PTMInitDialog.this.tempPanel.setEnabled(false);
                    PTMInitDialog.this.tempPanel.setVisible(false);
                } else {
                    PTMInitDialog.this.tempPanel.setEnabled(true);
                    PTMInitDialog.this.tempPanel.setVisible(true);
                }
            }
        });
        this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 20, 0);
        this.thresh = new ThresholdPanel();
        gridBagLayout.setConstraints(this.thresh, gridBagConstraints);
        jPanel.add(this.thresh);
        this.buildConstraints(gridBagConstraints, 1, 2, 1, 1, 5, 0);
        this.drawTreesPane = new JPanel();
        this.drawTreesPane.setLayout(new GridBagLayout());
        this.drawTreesBox = new JCheckBox("Construct Hierarchical Trees for:");
        this.drawTreesBox.setFocusPainted(false);
        this.sigOnly = new JRadioButton("Matched genes only", true);
        this.allClusters = new JRadioButton("All clusters", false);
        this.sigOnly.setEnabled(false);
        this.allClusters.setEnabled(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.sigOnly);
        buttonGroup.add(this.allClusters);
        this.saveTemplateButton = new JButton("Save Current Template", GUIFactory.getIcon("save16.gif"));
        this.saveTemplateButton.setToolTipText("Saves template to file");
        this.saveTemplateButton.setFocusPainted(false);
        this.saveTemplateButton.setActionCommand("save-template-to-file-command");
        this.saveTemplateButton.setBorder(BorderFactory.createBevelBorder(0));
        this.saveTemplateButton.setMargin(new Insets(2, 50, 2, 5));
        this.saveTemplateButton.setPreferredSize(new Dimension(175, 30));
        this.saveTemplateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser;
                int n;
                if (actionEvent.getSource() == PTMInitDialog.this.saveTemplateButton && (n = (jFileChooser = new JFileChooser(TMEV.getFile((String)"data/"))).showSaveDialog(PTMInitDialog.this)) == 0) {
                    File file = jFileChooser.getSelectedFile();
                    try {
                        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file.getPath()));
                        if (PTMInitDialog.this.tabbedPane.getSelectedIndex() < 2) {
                            for (int i = 0; i < PTMInitDialog.this.tempPanel.tempScr.tempGrid.length; ++i) {
                                String string = PTMInitDialog.this.tempPanel.tempScr.tempGrid[i].templateField.getText();
                                float f = Float.parseFloat(string);
                                bufferedWriter.write(Float.toString(f) + "\n");
                            }
                        } else {
                            for (int i = 0; i < PTMInitDialog.this.template.size(); ++i) {
                                bufferedWriter.write(((Float)PTMInitDialog.this.template.elementAt(i)).toString() + "\n");
                            }
                        }
                        bufferedWriter.flush();
                        bufferedWriter.close();
                    }
                    catch (IOException iOException) {
                        System.out.println("Error: " + iOException.toString());
                    }
                }
            }
        });
        this.drawTreesBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 2) {
                    PTMInitDialog.this.sigOnly.setEnabled(false);
                    PTMInitDialog.this.allClusters.setEnabled(false);
                } else {
                    PTMInitDialog.this.sigOnly.setEnabled(true);
                    PTMInitDialog.this.allClusters.setEnabled(true);
                }
            }
        });
        this.drawTreesPane.add((Component)this.saveTemplateButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 30, 0, 20), 0, 0));
        this.drawTreesPane.add((Component)this.drawTreesBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 30, 0, 20), 0, 0));
        this.drawTreesPane.add((Component)this.sigOnly, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 30, 0, 20), 0, 0));
        this.drawTreesPane.add((Component)this.allClusters, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 30, 0, 20), 0, 0));
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.drawTreesPane, gridBagConstraints);
        this.buildConstraints(gridBagConstraints, 1, 2, 1, 1, 5, 0);
        gridBagLayout.setConstraints(this.drawTreesPane, gridBagConstraints);
        jPanel.add(this.drawTreesPane);
        this.addContent(jPanel);
        this.setActionListeners(new EventListener());
    }

    public void setVisible(boolean bl) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        super.setVisible(bl);
    }

    public boolean isGeneTemplate() {
        return this.clusterGenes;
    }

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    String[] getSampleNames() {
        String[] stringArray = new String[this.sampleNamesVector.size()];
        for (int i = 0; i < this.sampleNamesVector.size(); ++i) {
            stringArray[i] = (String)this.sampleNamesVector.get(i);
        }
        return stringArray;
    }

    Vector getMeanProfile(Vector vector) {
        Vector<Float> vector2 = new Vector<Float>();
        float[][] fArray = this.convertToFloatMatrix(vector);
        int n = 0;
        for (int i = 0; i < fArray[0].length; ++i) {
            float f = 0.0f;
            n = 0;
            for (int j = 0; j < fArray.length; ++j) {
                if (Float.isNaN(fArray[j][i])) continue;
                f += fArray[j][i];
                ++n;
            }
            float f2 = n > 0 ? f / (float)n : 0.0f;
            vector2.add(new Float(f2));
        }
        return vector2;
    }

    float[][] convertToFloatMatrix(Vector vector) {
        float[][] fArrayArray = new float[vector.size()][];
        for (int i = 0; i < vector.size(); ++i) {
            Vector vector2 = (Vector)((Vector)vector.get(i)).clone();
            fArrayArray[i] = new float[vector2.size()];
            for (int j = 0; j < vector2.size(); ++j) {
                fArrayArray[i][j] = ((Float)vector2.get(j)).floatValue();
            }
        }
        return fArrayArray;
    }

    private Vector getExperiment(int n) {
        Vector<Float> vector = new Vector<Float>();
        int n2 = this.expMatrix.getRowDimension();
        for (int i = 0; i < n2; ++i) {
            vector.add(new Float(this.expMatrix.get(i, n)));
        }
        return vector;
    }

    private float getMax(Vector vector) {
        float f = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < vector.size(); ++i) {
            float f2;
            if (Float.isNaN(((Float)vector.get(i)).floatValue()) || !((f2 = ((Float)vector.get(i)).floatValue()) > f)) continue;
            f = f2;
        }
        return f;
    }

    private float getMin(Vector vector) {
        float f = Float.MAX_VALUE;
        for (int i = 0; i < vector.size(); ++i) {
            float f2;
            if (Float.isNaN(((Float)vector.get(i)).floatValue()) || !((f2 = ((Float)vector.get(i)).floatValue()) < f)) continue;
            f = f2;
        }
        return f;
    }

    public Vector getTemplate() {
        Vector<Float> vector = new Vector<Float>();
        int n = this.tabbedPane.getSelectedIndex();
        if (n == 0 || n == 1 || n == 4 && this.tempPanel.isVisible()) {
            int n2 = this.expMatrix.getColumnDimension();
            for (int i = 0; i < n2; ++i) {
                String string = this.tempPanel.tempScr.tempGrid[i].templateField.getText();
                if (string.equals("NaN") || string.equals("NULL") || !this.tempPanel.tempScr.tempGrid[i].activeBox.isSelected()) {
                    vector.add(new Float(Float.NaN));
                    continue;
                }
                vector.add(new Float(string));
            }
            return vector;
        }
        return this.template;
    }

    public FloatMatrix convertTemplateVectorToFloatMatrix() {
        this.template = this.getTemplate();
        FloatMatrix floatMatrix = new FloatMatrix(1, this.template.size());
        for (int i = 0; i < this.template.size(); ++i) {
            floatMatrix.A[0][i] = ((Float)this.template.get(i)).floatValue();
        }
        return floatMatrix;
    }

    protected void fireOkButtonEvent() {
        this.templateMatrix = this.convertTemplateVectorToFloatMatrix();
        boolean bl = this.thresh.useAbsolute.isSelected();
        boolean bl2 = this.drawTreesBox.isSelected();
        boolean bl3 = this.thresh.chooseR.isSelected();
        String string = this.thresh.threshInputField.getText();
        double d = Double.parseDouble(string);
        Hashtable<String, Serializable> hashtable = new Hashtable<String, Serializable>();
        hashtable.put(new String("drawTrees"), new Boolean(bl2));
        hashtable.put(new String("useAbsolute"), new Boolean(bl));
        hashtable.put(new String("useR"), new Boolean(bl3));
        hashtable.put(new String("template"), this.getTemplate());
        hashtable.put(new String("thresholdR"), new Double(d));
    }

    public boolean isDrawTrees() {
        return this.drawTreesBox.isSelected();
    }

    public boolean drawSigTreesOnly() {
        return this.sigOnly.isSelected();
    }

    public boolean isUseAbsolute() {
        return this.thresh.useAbsolute.isSelected();
    }

    public boolean isUseR() {
        return this.thresh.chooseR.isSelected();
    }

    public FloatMatrix getTemplateMatrix() {
        return this.convertTemplateVectorToFloatMatrix();
    }

    public double getThresholdR() {
        return Double.parseDouble(this.thresh.threshInputField.getText());
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    private Vector getGene(int n) {
        Vector<Float> vector = new Vector<Float>();
        for (int i = 0; i < this.sampleNamesVector.size(); ++i) {
            vector.add(new Float(this.expMatrix.get(n, i)));
        }
        return vector;
    }

    public static void main(String[] stringArray) {
        int n;
        FloatMatrix floatMatrix = new FloatMatrix(100, 10);
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Color[] colorArray = null;
        for (n = 0; n < 100; ++n) {
            vector.add(String.valueOf(n));
        }
        for (n = 0; n < 10; ++n) {
            vector2.add("Exp " + String.valueOf(n));
        }
        PTMInitDialog pTMInitDialog = new PTMInitDialog(new JFrame(), true, floatMatrix, vector, vector2, new Vector(), new Vector(), colorArray, colorArray);
        pTMInitDialog.setVisible(true);
        System.exit(0);
    }

    static /* synthetic */ JButton access$900(PTMInitDialog pTMInitDialog) {
        return pTMInitDialog.okButton;
    }

    static /* synthetic */ JButton access$1800(PTMInitDialog pTMInitDialog) {
        return pTMInitDialog.okButton;
    }

    static /* synthetic */ JButton access$2100(PTMInitDialog pTMInitDialog) {
        return pTMInitDialog.okButton;
    }

    class TemplateElementGrid
    extends JPanel {
        JLabel exptName;
        JTextField templateField;
        JSlider templateSlider;
        JCheckBox activeBox;

        TemplateElementGrid(String string) {
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            this.setLayout(gridBagLayout);
            PTMInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 50, 10);
            this.exptName = new JLabel(string, 0);
            gridBagLayout.setConstraints(this.exptName, gridBagConstraints);
            this.add(this.exptName);
            PTMInitDialog.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 50, 0);
            this.activeBox = new JCheckBox();
            this.activeBox.setSelected(true);
            this.activeBox.addItemListener(new ItemListener(this){
                private final /* synthetic */ TemplateElementGrid this$1;
                {
                    this.this$1 = templateElementGrid;
                }

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 2) {
                        this.this$1.templateField.setBackground(Color.gray);
                        this.this$1.templateField.setEnabled(false);
                        this.this$1.templateSlider.setEnabled(false);
                    }
                    if (itemEvent.getStateChange() == 1) {
                        this.this$1.templateField.setBackground(Color.white);
                        this.this$1.templateField.setEnabled(true);
                        this.this$1.templateSlider.setEnabled(true);
                    }
                }
            });
            gridBagLayout.setConstraints(this.activeBox, gridBagConstraints);
            this.add(this.activeBox);
            PTMInitDialog.this.buildConstraints(gridBagConstraints, 0, 1, 2, 1, 0, 5);
            this.templateField = new JTextField("0.5", 4);
            this.templateField.addActionListener(new ActionListener(this){
                private final /* synthetic */ TemplateElementGrid this$1;
                {
                    this.this$1 = templateElementGrid;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource() == this.this$1.templateField) {
                        int n;
                        try {
                            String string = this.this$1.templateField.getText();
                            double d = Double.parseDouble(string);
                            n = (int)Math.floor(d * 100.0);
                            if (d > 1.0 || d < 0.0) {
                                n = 50;
                                this.this$1.templateField.setText("0.5");
                                JOptionPane.showMessageDialog(null, "Template values must be between 0 and 1 (inclusive)");
                            }
                        }
                        catch (Exception exception) {
                            this.this$1.templateField.setText("0.5");
                            n = 50;
                            JOptionPane.showMessageDialog(null, "Template values must be between 0 and 1 (inclusive)");
                        }
                        this.this$1.templateSlider.setValue(n);
                    }
                }
            });
            this.templateField.addFocusListener(new FocusListener(this){
                private final /* synthetic */ TemplateElementGrid this$1;
                {
                    this.this$1 = templateElementGrid;
                }

                public void focusLost(FocusEvent focusEvent) {
                    if (focusEvent.getSource() == this.this$1.templateField) {
                        int n;
                        try {
                            String string = this.this$1.templateField.getText();
                            double d = Double.parseDouble(string);
                            n = (int)Math.floor(d * 100.0);
                            if (d > 1.0 || d < 0.0) {
                                n = 50;
                                this.this$1.templateField.setText("0.5");
                                JOptionPane.showMessageDialog(null, "Template values must be between 0 and 1 (inclusive)");
                            }
                        }
                        catch (Exception exception) {
                            this.this$1.templateField.setText("0.5");
                            n = 50;
                            JOptionPane.showMessageDialog(null, "Input Format Error: Template values must be between 0 and 1 (inclusive)");
                        }
                        this.this$1.templateSlider.setValue(n);
                    }
                }

                public void focusGained(FocusEvent focusEvent) {
                }
            });
            gridBagLayout.setConstraints(this.templateField, gridBagConstraints);
            this.add(this.templateField);
            PTMInitDialog.this.buildConstraints(gridBagConstraints, 0, 2, 1, 2, 0, 85);
            this.templateSlider = new JSlider(1, 0, 100, 50);
            this.templateSlider.setMajorTickSpacing(20);
            this.templateSlider.setMinorTickSpacing(10);
            Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
            hashtable.put(new Integer(0), new JLabel("Min"));
            hashtable.put(new Integer(100), new JLabel("Max"));
            this.templateSlider.setLabelTable(hashtable);
            this.templateSlider.setPaintLabels(true);
            this.templateSlider.addChangeListener(new ChangeListener(this){
                private final /* synthetic */ TemplateElementGrid this$1;
                {
                    this.this$1 = templateElementGrid;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    JSlider jSlider = (JSlider)changeEvent.getSource();
                    if (!jSlider.getValueIsAdjusting()) {
                        int n = jSlider.getValue();
                        if (n == 100) {
                            this.this$1.templateField.setText("1.0");
                        } else if (n > 0 && n < 10) {
                            this.this$1.templateField.setText("0.0" + n);
                        } else {
                            this.this$1.templateField.setText("0." + n);
                        }
                    }
                }
            });
            gridBagLayout.setConstraints(this.templateSlider, gridBagConstraints);
            this.add(this.templateSlider);
        }

        public void reset() {
            this.templateSlider.setValue(50);
            this.templateField.setText("0.5");
        }
    }

    class GeneClusterSelector
    extends JPanel {
        JList clusterList;
        GraphCanvas profileDisplayPanel;
        JScrollPane listScrollPane;
        JButton selectButton;
        Vector clusterNames = new Vector();
        Vector geneDataInClusters;
        Vector averageClusterProfiles;
        JSplitPane clusterSplitPane;

        GeneClusterSelector() {
            Cloneable cloneable;
            Cloneable cloneable2;
            if (PTMInitDialog.this.clusters.size() == 0) {
                this.clusterNames.add("No clusters to show");
            } else {
                int n;
                for (n = 0; n < PTMInitDialog.this.clusters.size(); ++n) {
                    this.clusterNames.add("Cluster " + (n + 1));
                }
                this.geneDataInClusters = new Vector();
                this.averageClusterProfiles = new Vector();
                for (n = 0; n < PTMInitDialog.this.clusters.size(); ++n) {
                    cloneable2 = (Vector)PTMInitDialog.this.clusters.get(n);
                    for (int i = 0; i < ((Vector)cloneable2).size(); ++i) {
                        int n2 = (Integer)((Vector)cloneable2).get(i);
                        Vector vector = PTMInitDialog.this.getGene(n2);
                        ((Vector)cloneable2).set(i, vector);
                    }
                    this.geneDataInClusters.add(cloneable2);
                    cloneable = PTMInitDialog.this.getMeanProfile((Vector)cloneable2);
                    this.averageClusterProfiles.add(cloneable);
                }
            }
            GridBagLayout gridBagLayout = new GridBagLayout();
            cloneable2 = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            this.clusterList = new JList(this.clusterNames);
            this.clusterList.setSelectionMode(0);
            this.clusterList.setSelectedIndex(0);
            this.profileDisplayPanel = new GraphCanvas();
            this.profileDisplayPanel.setGraphBounds(0.0, (double)PTMInitDialog.this.sampleNamesVector.size(), -3.0, 3.0);
            this.profileDisplayPanel.setGraphSpacing(20, 20, 20, 20);
            this.profileDisplayPanel.setXAxisValue(0.0);
            this.profileDisplayPanel.setYAxisValue(0.0);
            this.clusterList.addListSelectionListener(new ListSelectionListener(this){
                private final /* synthetic */ GeneClusterSelector this$1;
                {
                    this.this$1 = geneClusterSelector;
                }

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    GeneClusterSelector.access$1900(this.this$1);
                }
            });
            this.listScrollPane = new JScrollPane(this.clusterList);
            this.clusterSplitPane = new JSplitPane(1, this.listScrollPane, (Component)this.profileDisplayPanel);
            this.clusterSplitPane.setOneTouchExpandable(true);
            this.clusterSplitPane.setDividerLocation(200);
            cloneable = new Dimension(100, 50);
            this.clusterList.setMinimumSize((Dimension)cloneable);
            this.profileDisplayPanel.setMinimumSize((Dimension)cloneable);
            PTMInitDialog.this.buildConstraints((GridBagConstraints)cloneable2, 0, 0, 1, 1, 1, 80);
            ((GridBagConstraints)cloneable2).fill = 1;
            gridBagLayout.setConstraints(this.clusterSplitPane, (GridBagConstraints)cloneable2);
            this.add(this.clusterSplitPane);
            PTMInitDialog.this.buildConstraints((GridBagConstraints)cloneable2, 0, 1, 1, 1, 0, 20);
            ((GridBagConstraints)cloneable2).fill = 0;
            this.selectButton = new JButton("Select highlighted cluster from above list to use its mean as template", GUIFactory.getIcon("select_check24.gif"));
            this.selectButton.setBorder(BorderFactory.createBevelBorder(0));
            this.selectButton.setMargin(new Insets(10, 10, 10, 10));
            this.selectButton.setPreferredSize(new Dimension(430, 30));
            this.selectButton.setFocusPainted(false);
            this.selectButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ GeneClusterSelector this$1;
                {
                    this.this$1 = geneClusterSelector;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (GeneClusterSelector.access$2000((GeneClusterSelector)this.this$1).clusters.size() == 0) {
                        JOptionPane.showMessageDialog(null, "No clusters to select");
                    } else {
                        int n;
                        float f;
                        int n2 = this.this$1.clusterList.getSelectedIndex();
                        Vector vector = (Vector)((Vector)this.this$1.averageClusterProfiles.get(n2)).clone();
                        float f2 = PTMInitDialog.access$500(GeneClusterSelector.access$2000(this.this$1), vector);
                        if (f2 - (f = PTMInitDialog.access$600(GeneClusterSelector.access$2000(this.this$1), vector)) == 0.0f) {
                            for (n = 0; n < vector.size(); ++n) {
                                vector.set(n, new Float(0.5));
                            }
                        } else {
                            for (n = 0; n < vector.size(); ++n) {
                                float f3 = (((Float)vector.get(n)).floatValue() - f) / (f2 - f);
                                vector.set(n, new Float(f3));
                            }
                        }
                        for (n = 0; n < GeneClusterSelector.access$2000((GeneClusterSelector)this.this$1).tempPanel.tempScr.tempGrid.length; ++n) {
                            GeneClusterSelector.access$2000((GeneClusterSelector)this.this$1).tempPanel.tempScr.tempGrid[n].templateSlider.setValue((int)Math.floor(((Float)vector.get(n)).floatValue() * 100.0f));
                            GeneClusterSelector.access$2000((GeneClusterSelector)this.this$1).tempPanel.tempScr.tempGrid[n].templateField.setText("" + ((Float)vector.get(n)).floatValue());
                        }
                        if (GeneClusterSelector.access$2000((GeneClusterSelector)this.this$1).setTemplate) {
                            for (n = 0; n < vector.size() - 1; ++n) {
                                if (Float.isNaN(((Float)vector.elementAt(n)).floatValue()) || Float.isNaN(((Float)vector.elementAt(n + 1)).floatValue())) continue;
                                GraphLine graphLine = new GraphLine((double)n, (double)((Float)vector.elementAt(n)).floatValue(), (double)(n + 1), (double)((Float)vector.elementAt(n + 1)).floatValue(), Color.green);
                                this.this$1.profileDisplayPanel.addGraphElement((GraphElement)graphLine);
                            }
                        }
                        GeneClusterSelector.access$2000((GeneClusterSelector)this.this$1).template = vector;
                        GeneClusterSelector.access$2000((GeneClusterSelector)this.this$1).setTemplate = true;
                        GeneClusterSelector.access$2000((GeneClusterSelector)this.this$1).clusterGenes = true;
                        PTMInitDialog.access$2100(GeneClusterSelector.access$2000(this.this$1)).setEnabled(true);
                    }
                }
            });
            gridBagLayout.setConstraints(this.selectButton, (GridBagConstraints)cloneable2);
            this.add(this.selectButton);
            this.refreshGraph();
        }

        private void refreshGraph() {
            Vector vector;
            int n;
            int n2 = this.clusterList.getSelectedIndex();
            if (PTMInitDialog.this.clusters.size() <= 0) {
                return;
            }
            Vector vector2 = (Vector)this.averageClusterProfiles.elementAt(n2);
            float f = Float.POSITIVE_INFINITY;
            float f2 = Float.NEGATIVE_INFINITY;
            this.profileDisplayPanel.removeAllGraphElements();
            Vector vector3 = (Vector)this.geneDataInClusters.get(n2);
            for (n = 0; n < vector3.size(); ++n) {
                int n3;
                vector = (Vector)vector3.get(n);
                f2 = Math.max(f2, PTMInitDialog.this.getMax(vector));
                f = Math.min(f, PTMInitDialog.this.getMin(vector));
                float f3 = Math.max(f2, Math.abs(f));
                this.profileDisplayPanel.setGraphBounds(0.0, (double)vector.size(), (double)(-f3), (double)f3);
                for (n3 = 0; n3 < vector.size(); ++n3) {
                }
                for (n3 = 0; n3 < vector.size() - 1; ++n3) {
                    if (Float.isNaN(((Float)vector.elementAt(n3)).floatValue()) || Float.isNaN(((Float)vector.elementAt(n3 + 1)).floatValue())) continue;
                    GraphLine graphLine = new GraphLine((double)n3, (double)((Float)vector.elementAt(n3)).floatValue(), (double)(n3 + 1), (double)((Float)vector.elementAt(n3 + 1)).floatValue(), PTMInitDialog.this.clusterColors[n2]);
                    this.profileDisplayPanel.addGraphElement((GraphElement)graphLine);
                }
            }
            for (n = 0; n < vector2.size(); ++n) {
                if (Float.isNaN(((Float)vector2.elementAt(n)).floatValue())) continue;
                vector = new GraphPoint((double)n, (double)((Float)vector2.elementAt(n)).floatValue(), Color.red, 5);
                this.profileDisplayPanel.addGraphElement((GraphElement)vector);
            }
            for (n = 0; n < vector2.size() - 1; ++n) {
                vector = new GraphLine((double)n, (double)((Float)vector2.elementAt(n)).floatValue(), (double)(n + 1), (double)((Float)vector2.elementAt(n + 1)).floatValue(), Color.blue);
                this.profileDisplayPanel.addGraphElement((GraphElement)vector);
            }
            this.profileDisplayPanel.repaint();
        }

        public void reset() {
            this.clusterList.setSelectedIndex(0);
            PTMInitDialog.this.setTemplate = false;
            this.refreshGraph();
        }

        static /* synthetic */ void access$1900(GeneClusterSelector geneClusterSelector) {
            geneClusterSelector.refreshGraph();
        }

        static /* synthetic */ PTMInitDialog access$2000(GeneClusterSelector geneClusterSelector) {
            return geneClusterSelector.PTMInitDialog.this;
        }
    }

    class GeneSelector
    extends JPanel {
        JList uniqueIDList;
        GraphCanvas profileDisplayPanel;
        JScrollPane listScrollPane;
        JButton selectButton;
        int maxIndex = -1;
        int minIndex = -1;
        JSplitPane uIDSplitPane;

        GeneSelector() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            this.uniqueIDList = new JList(PTMInitDialog.this.uniqueIDs);
            this.uniqueIDList.setSelectionMode(0);
            this.uniqueIDList.setSelectedIndex(0);
            this.profileDisplayPanel = new GraphCanvas();
            this.profileDisplayPanel.setGraphBounds(0.0, (double)PTMInitDialog.this.sampleNamesVector.size(), -3.0, 3.0);
            this.profileDisplayPanel.setGraphSpacing(20, 20, 20, 20);
            this.profileDisplayPanel.setXAxisValue(0.0);
            this.profileDisplayPanel.setYAxisValue(0.0);
            this.uniqueIDList.addListSelectionListener(new ListSelectionListener(this){
                private final /* synthetic */ GeneSelector this$1;
                {
                    this.this$1 = geneSelector;
                }

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    GeneSelector.access$1500(this.this$1);
                }
            });
            this.listScrollPane = new JScrollPane(this.uniqueIDList);
            this.uIDSplitPane = new JSplitPane(1, this.listScrollPane, (Component)this.profileDisplayPanel);
            this.uIDSplitPane.setOneTouchExpandable(true);
            this.uIDSplitPane.setDividerLocation(200);
            Dimension dimension = new Dimension(100, 50);
            this.uniqueIDList.setMinimumSize(dimension);
            this.profileDisplayPanel.setMinimumSize(dimension);
            PTMInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 1, 1);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 11;
            gridBagLayout.setConstraints(this.uIDSplitPane, gridBagConstraints);
            this.add(this.uIDSplitPane);
            PTMInitDialog.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 1, 0);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(10, 10, 10, 10);
            this.selectButton = new JButton("Select highlighted gene from above list to use as template", GUIFactory.getIcon("select_check24.gif"));
            this.selectButton.setBorder(BorderFactory.createBevelBorder(0));
            this.selectButton.setMargin(new Insets(10, 10, 10, 10));
            this.selectButton.setPreferredSize(new Dimension(400, 30));
            this.selectButton.setFocusPainted(false);
            this.selectButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ GeneSelector this$1;
                {
                    this.this$1 = geneSelector;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    int n;
                    float f;
                    int n2 = this.this$1.uniqueIDList.getSelectedIndex();
                    Vector vector = PTMInitDialog.access$1700(GeneSelector.access$1600(this.this$1), n2);
                    float f2 = PTMInitDialog.access$500(GeneSelector.access$1600(this.this$1), vector);
                    if (f2 - (f = PTMInitDialog.access$600(GeneSelector.access$1600(this.this$1), vector)) == 0.0f) {
                        for (n = 0; n < vector.size(); ++n) {
                            vector.set(n, new Float(0.5));
                        }
                    } else {
                        for (n = 0; n < vector.size(); ++n) {
                            float f3 = (((Float)vector.get(n)).floatValue() - f) / (f2 - f);
                            vector.set(n, new Float(f3));
                        }
                    }
                    for (n = 0; n < GeneSelector.access$1600((GeneSelector)this.this$1).tempPanel.tempScr.tempGrid.length; ++n) {
                        if (!Float.isNaN(((Float)vector.get(n)).floatValue())) {
                            GeneSelector.access$1600((GeneSelector)this.this$1).tempPanel.tempScr.tempGrid[n].activeBox.setSelected(true);
                            GeneSelector.access$1600((GeneSelector)this.this$1).tempPanel.tempScr.tempGrid[n].templateSlider.setEnabled(true);
                            GeneSelector.access$1600((GeneSelector)this.this$1).tempPanel.tempScr.tempGrid[n].templateSlider.setValue((int)Math.floor(((Float)vector.get(n)).floatValue() * 100.0f));
                            GeneSelector.access$1600((GeneSelector)this.this$1).tempPanel.tempScr.tempGrid[n].templateField.setEnabled(true);
                            GeneSelector.access$1600((GeneSelector)this.this$1).tempPanel.tempScr.tempGrid[n].templateField.setBackground(Color.white);
                            GeneSelector.access$1600((GeneSelector)this.this$1).tempPanel.tempScr.tempGrid[n].templateField.setText("" + ((Float)vector.get(n)).floatValue());
                            continue;
                        }
                        GeneSelector.access$1600((GeneSelector)this.this$1).tempPanel.tempScr.tempGrid[n].activeBox.setSelected(false);
                        GeneSelector.access$1600((GeneSelector)this.this$1).tempPanel.tempScr.tempGrid[n].templateSlider.setEnabled(false);
                        GeneSelector.access$1600((GeneSelector)this.this$1).tempPanel.tempScr.tempGrid[n].templateField.setText("NULL");
                        GeneSelector.access$1600((GeneSelector)this.this$1).tempPanel.tempScr.tempGrid[n].templateField.setBackground(Color.gray);
                        GeneSelector.access$1600((GeneSelector)this.this$1).tempPanel.tempScr.tempGrid[n].templateField.setEnabled(false);
                    }
                    GeneSelector.access$1600((GeneSelector)this.this$1).template = vector;
                    GeneSelector.access$1600((GeneSelector)this.this$1).setTemplate = true;
                    GeneSelector.access$1600((GeneSelector)this.this$1).clusterGenes = true;
                    PTMInitDialog.access$1800(GeneSelector.access$1600(this.this$1)).setEnabled(true);
                }
            });
            gridBagLayout.setConstraints(this.selectButton, gridBagConstraints);
            this.add(this.selectButton);
            this.refreshGraph();
        }

        private void refreshGraph() {
            GraphPoint graphPoint;
            int n;
            int n2 = this.uniqueIDList.getSelectedIndex();
            Vector vector = PTMInitDialog.this.getGene(n2);
            float f = PTMInitDialog.this.getMax(vector);
            float f2 = PTMInitDialog.this.getMin(vector);
            float f3 = Math.max(f, Math.abs(f2));
            this.profileDisplayPanel.removeAllGraphElements();
            this.profileDisplayPanel.setGraphBounds(0.0, (double)vector.size(), (double)(-f3), (double)f3);
            for (n = 0; n < vector.size(); ++n) {
                if (Float.isNaN(((Float)vector.elementAt(n)).floatValue())) continue;
                graphPoint = new GraphPoint((double)n, (double)((Float)vector.elementAt(n)).floatValue(), Color.red, 5);
                this.profileDisplayPanel.addGraphElement((GraphElement)graphPoint);
            }
            for (n = 0; n < vector.size() - 1; ++n) {
                if (Float.isNaN(((Float)vector.elementAt(n)).floatValue()) || Float.isNaN(((Float)vector.elementAt(n + 1)).floatValue())) continue;
                graphPoint = new GraphLine((double)n, (double)((Float)vector.elementAt(n)).floatValue(), (double)(n + 1), (double)((Float)vector.elementAt(n + 1)).floatValue(), Color.blue);
                this.profileDisplayPanel.addGraphElement((GraphElement)graphPoint);
            }
            this.profileDisplayPanel.repaint();
        }

        public void reset() {
            this.uniqueIDList.setSelectedIndex(0);
            PTMInitDialog.this.setTemplate = false;
            this.refreshGraph();
        }

        static /* synthetic */ void access$1500(GeneSelector geneSelector) {
            geneSelector.refreshGraph();
        }

        static /* synthetic */ PTMInitDialog access$1600(GeneSelector geneSelector) {
            return geneSelector.PTMInitDialog.this;
        }
    }

    protected class EventListener
    implements ActionListener {
        protected EventListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block14: {
                String string = actionEvent.getActionCommand();
                if (string.equals("ok-command")) {
                    try {
                        String string2 = PTMInitDialog.this.thresh.threshInputField.getText();
                        double d = Double.parseDouble(string2);
                        if (d > 1.0 || d < 0.0) {
                            JOptionPane.showMessageDialog(null, "Threshold R value must be between 0 and 1 (inclusive)");
                            PTMInitDialog.this.thresh.threshInputField.selectAll();
                            PTMInitDialog.this.thresh.threshInputField.requestFocus();
                            break block14;
                        }
                        PTMInitDialog.this.okPressed = true;
                        PTMInitDialog.this.fireOkButtonEvent();
                        PTMInitDialog.this.setVisible(false);
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(null, "Input Format Error: Requires value between 0 and 1 (inclusive)");
                        PTMInitDialog.this.thresh.threshInputField.selectAll();
                        PTMInitDialog.this.thresh.threshInputField.requestFocus();
                    }
                } else if (string.equals("reset-command")) {
                    PTMInitDialog.this.template = new Vector();
                    PTMInitDialog.this.expSelectPanel.reset();
                    PTMInitDialog.this.clusterSelectPanel.reset();
                    PTMInitDialog.this.geneSelectPanel.reset();
                    PTMInitDialog.this.geneClusterSelectPanel.reset();
                    PTMInitDialog.this.tempPanel.reset();
                    PTMInitDialog.this.templateSelectPanel.reset();
                    PTMInitDialog.this.thresh.useAbsolute.setSelected(false);
                    PTMInitDialog.this.thresh.chooseP.setSelected(true);
                    PTMInitDialog.this.thresh.threshInputField.setText("0.01");
                    PTMInitDialog.this.okPressed = false;
                } else if (string.equals("cancel-command")) {
                    PTMInitDialog.this.hide();
                    PTMInitDialog.this.dispose();
                } else if (string.equals("info-command")) {
                    HelpWindow helpWindow = new HelpWindow(PTMInitDialog.this, "PTM Initialization Dialog");
                    if (helpWindow.getWindowContent()) {
                        helpWindow.setSize(450, 650);
                        helpWindow.setLocation();
                        helpWindow.show();
                    } else {
                        helpWindow.setVisible(false);
                        helpWindow.dispose();
                    }
                } else if (string.equals("save-template-command")) {
                    // empty if block
                }
            }
        }
    }

    class TemplatePanel
    extends JPanel {
        TemplateScroller tempScr;

        TemplatePanel() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            this.setLayout(gridBagLayout);
            this.tempScr = new TemplateScroller();
            JScrollPane jScrollPane = this.tempScr.createTemplateScroller();
            PTMInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 95);
            gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
            this.add(jScrollPane);
            PTMInitDialog.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 100, 5);
            gridBagConstraints.fill = 0;
            this.setMaximumSize(new Dimension(600, 100));
            this.setSize(600, 100);
        }

        public void reset() {
            this.tempScr.reset();
        }

        class TemplateScroller
        extends JPanel {
            TemplateElementGrid[] tempGrid;

            TemplateScroller() {
                this.tempGrid = new TemplateElementGrid[((TemplatePanel)TemplatePanel.this).PTMInitDialog.this.SampleNames.length];
            }

            JScrollPane createTemplateScroller() {
                GridBagLayout gridBagLayout = new GridBagLayout();
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.fill = 1;
                this.setLayout(gridBagLayout);
                for (int i = 0; i < ((TemplatePanel)TemplatePanel.this).PTMInitDialog.this.SampleNames.length; ++i) {
                    this.tempGrid[i] = new TemplateElementGrid(((TemplatePanel)TemplatePanel.this).PTMInitDialog.this.SampleNames[i]);
                    PTMInitDialog.this.buildConstraints(gridBagConstraints, i, 0, 1, 1, 100, 100);
                    gridBagLayout.setConstraints(this.tempGrid[i], gridBagConstraints);
                    this.add(this.tempGrid[i]);
                }
                JScrollPane jScrollPane = new JScrollPane(this);
                jScrollPane.setHorizontalScrollBarPolicy(30);
                jScrollPane.setVerticalScrollBarPolicy(21);
                return jScrollPane;
            }

            public void reset() {
                for (int i = 0; i < this.tempGrid.length; ++i) {
                    this.tempGrid[i].reset();
                }
            }

            class TemplateElementGrid
            extends JPanel {
                JLabel exptName;
                JTextField templateField;
                JSlider templateSlider;
                JCheckBox activeBox;

                TemplateElementGrid(String string) {
                    GridBagLayout gridBagLayout = new GridBagLayout();
                    GridBagConstraints gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.fill = 1;
                    this.setLayout(gridBagLayout);
                    PTMInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 50, 10);
                    this.exptName = new JLabel(string, 0);
                    gridBagLayout.setConstraints(this.exptName, gridBagConstraints);
                    this.add(this.exptName);
                    PTMInitDialog.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 50, 0);
                    this.activeBox = new JCheckBox();
                    this.activeBox.setSelected(true);
                    this.activeBox.addItemListener(new ItemListener(this){
                        private final /* synthetic */ TemplateElementGrid this$3;
                        {
                            this.this$3 = templateElementGrid;
                        }

                        public void itemStateChanged(ItemEvent itemEvent) {
                            if (itemEvent.getStateChange() == 2) {
                                this.this$3.templateField.setBackground(Color.gray);
                                this.this$3.templateField.setEnabled(false);
                                this.this$3.templateSlider.setEnabled(false);
                            }
                            if (itemEvent.getStateChange() == 1) {
                                this.this$3.templateField.setBackground(Color.white);
                                this.this$3.templateField.setEnabled(true);
                                this.this$3.templateSlider.setEnabled(true);
                            }
                        }
                    });
                    gridBagLayout.setConstraints(this.activeBox, gridBagConstraints);
                    this.add(this.activeBox);
                    PTMInitDialog.this.buildConstraints(gridBagConstraints, 0, 1, 2, 1, 0, 5);
                    this.templateField = new JTextField("0.5", 4);
                    this.templateField.addActionListener(new ActionListener(this){
                        private final /* synthetic */ TemplateElementGrid this$3;
                        {
                            this.this$3 = templateElementGrid;
                        }

                        public void actionPerformed(ActionEvent actionEvent) {
                            if (actionEvent.getSource() == this.this$3.templateField) {
                                int n;
                                try {
                                    String string = this.this$3.templateField.getText();
                                    double d = Double.parseDouble(string);
                                    n = (int)Math.floor(d * 100.0);
                                    if (d > 1.0 || d < 0.0) {
                                        n = 50;
                                        this.this$3.templateField.setText("0.5");
                                        JOptionPane.showMessageDialog(null, "Template values must be between 0 and 1 (inclusive)");
                                    }
                                }
                                catch (Exception exception) {
                                    this.this$3.templateField.setText("0.5");
                                    n = 50;
                                    JOptionPane.showMessageDialog(null, "Input Format Error: Template values must be between 0 and 1 (inclusive)");
                                }
                                this.this$3.templateSlider.setValue(n);
                            }
                        }
                    });
                    this.templateField.addFocusListener(new FocusListener(this){
                        private final /* synthetic */ TemplateElementGrid this$3;
                        {
                            this.this$3 = templateElementGrid;
                        }

                        public void focusLost(FocusEvent focusEvent) {
                            if (focusEvent.getSource() == this.this$3.templateField) {
                                int n;
                                try {
                                    String string = this.this$3.templateField.getText();
                                    double d = Double.parseDouble(string);
                                    n = (int)Math.floor(d * 100.0);
                                    if (d > 1.0 || d < 0.0) {
                                        n = 50;
                                        this.this$3.templateField.setText("0.5");
                                        JOptionPane.showMessageDialog(null, "Template values must be between 0 and 1 (inclusive)");
                                    }
                                }
                                catch (Exception exception) {
                                    this.this$3.templateField.setText("0.5");
                                    n = 50;
                                    JOptionPane.showMessageDialog(null, "Template values must be between 0 and 1 (inclusive)");
                                }
                                this.this$3.templateSlider.setValue(n);
                            }
                        }

                        public void focusGained(FocusEvent focusEvent) {
                        }
                    });
                    gridBagLayout.setConstraints(this.templateField, gridBagConstraints);
                    this.add(this.templateField);
                    PTMInitDialog.this.buildConstraints(gridBagConstraints, 0, 2, 2, 1, 0, 85);
                    this.templateSlider = new JSlider(1, 0, 100, 50);
                    this.templateSlider.setPreferredSize(new Dimension(30, 50));
                    this.templateSlider.setMajorTickSpacing(20);
                    this.templateSlider.setMinorTickSpacing(10);
                    Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
                    hashtable.put(new Integer(0), new JLabel("Min"));
                    hashtable.put(new Integer(100), new JLabel("Max"));
                    this.templateSlider.setLabelTable(hashtable);
                    this.templateSlider.setPaintLabels(true);
                    this.templateSlider.addChangeListener(new ChangeListener(this){
                        private final /* synthetic */ TemplateElementGrid this$3;
                        {
                            this.this$3 = templateElementGrid;
                        }

                        public void stateChanged(ChangeEvent changeEvent) {
                            JSlider jSlider = (JSlider)changeEvent.getSource();
                            if (!jSlider.getValueIsAdjusting()) {
                                int n = jSlider.getValue();
                                if (n == 100) {
                                    this.this$3.templateField.setText("1.0");
                                } else if (n > 0 && n < 10) {
                                    this.this$3.templateField.setText("0.0" + n);
                                } else {
                                    this.this$3.templateField.setText("0." + n);
                                }
                            }
                        }
                    });
                    gridBagLayout.setConstraints(this.templateSlider, gridBagConstraints);
                    this.add(this.templateSlider);
                }

                public void reset() {
                    this.templateSlider.setValue(50);
                    this.templateField.setText("0.5");
                }
            }
        }
    }

    class ThresholdPanel
    extends JPanel {
        JLabel threshLabel1;
        JLabel threshLabel2;
        JTextField threshInputField;
        JRadioButton chooseR;
        JRadioButton chooseP;
        JCheckBox useAbsolute;
        JLabel inputLabel;

        ThresholdPanel() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(10, 30, 10, 0);
            this.setLayout(gridBagLayout);
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Threshold Parameters"));
            this.useAbsolute = new JCheckBox("Use Absolute R");
            this.useAbsolute.setFocusPainted(false);
            PTMInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 3, 1, 0, 0);
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.useAbsolute, gridBagConstraints);
            this.add(this.useAbsolute);
            gridBagConstraints.insets = new Insets(0, 30, 0, 0);
            ButtonGroup buttonGroup = new ButtonGroup();
            this.chooseR = new JRadioButton("Use Threshold R", false);
            this.chooseR.setFocusPainted(false);
            buttonGroup.add(this.chooseR);
            this.chooseP = new JRadioButton("Use Threshold p-Value", true);
            this.chooseP.setFocusPainted(false);
            buttonGroup.add(this.chooseP);
            PTMInitDialog.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 10, 0);
            gridBagLayout.setConstraints(this.chooseR, gridBagConstraints);
            this.add(this.chooseR);
            PTMInitDialog.this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 0, 0);
            gridBagLayout.setConstraints(this.chooseP, gridBagConstraints);
            this.add(this.chooseP);
            PTMInitDialog.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 80, 0);
            this.threshLabel1 = new JLabel("Enter magnitude of threshold R or p-Value (between 0 and 1 inclusive)");
            PTMInitDialog.this.buildConstraints(gridBagConstraints, 1, 1, 1, 1, 0, 0);
            this.threshLabel2 = new JLabel("at which selected profiles should be correlated to template");
            gridBagConstraints.insets = new Insets(15, 5, 0, 0);
            JPanel jPanel = new JPanel(new GridBagLayout());
            this.inputLabel = new JLabel("Enter p-value [0,1] :");
            this.inputLabel.setForeground(Color.black);
            this.inputLabel.setAlignmentX(1.0f);
            this.inputLabel.setSize(150, 40);
            this.inputLabel.setMinimumSize(new Dimension(150, 40));
            gridBagLayout.setConstraints(this.inputLabel, gridBagConstraints);
            jPanel.add((Component)this.inputLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.chooseR.addChangeListener(new ChangeListener(this){
                private final /* synthetic */ ThresholdPanel this$1;
                {
                    this.this$1 = thresholdPanel;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    if (this.this$1.chooseR.isSelected()) {
                        this.this$1.inputLabel.setText("Enter R [0,1] :");
                    } else {
                        this.this$1.inputLabel.setText("Enter p-value [0,1] :");
                    }
                }
            });
            this.threshInputField = new JTextField("", 7);
            this.threshInputField.addActionListener(new ActionListener(this){
                private final /* synthetic */ ThresholdPanel this$1;
                {
                    this.this$1 = thresholdPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource() == this.this$1.threshInputField) {
                        try {
                            String string = this.this$1.threshInputField.getText();
                            double d = Double.parseDouble(string);
                            if (d > 1.0 || d < 0.0) {
                                JOptionPane.showMessageDialog(null, "Threshold R value must be between 0 and 1 (inclusive)");
                                this.this$1.threshInputField.selectAll();
                                this.this$1.threshInputField.requestFocus();
                            }
                        }
                        catch (Exception exception) {
                            JOptionPane.showMessageDialog(null, "Input Format Error: Threshold R value must be between 0 and 1 (inclusive)");
                            this.this$1.threshInputField.selectAll();
                            this.this$1.threshInputField.requestFocus();
                        }
                    }
                }
            });
            jPanel.add((Component)this.threshInputField, new GridBagConstraints(1, 0, 1, 1, 5.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            PTMInitDialog.this.buildConstraints(gridBagConstraints, 1, 0, 1, 3, 10, 0);
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 1;
            gridBagLayout.setConstraints(jPanel, gridBagConstraints);
            this.add(jPanel);
        }
    }

    class SavedTemplateSelector
    extends JPanel {
        JList templateList;
        GraphCanvas profileDisplayPanel;
        JScrollPane listScrollPane;
        JButton selectButton;
        JButton loadButton;
        Vector templatesVector = new Vector();
        DefaultListModel listModel = new DefaultListModel();
        Vector templates;
        JSplitPane templateSplitPane;
        JPanel templateButtonPanel;
        boolean savedTemplateSelected;

        SavedTemplateSelector() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            this.templateList = new JList(this.listModel);
            this.templateList.setSelectionMode(0);
            this.templateList.setSelectedIndex(-1);
            this.profileDisplayPanel = new GraphCanvas();
            this.profileDisplayPanel.setGraphBounds(0.0, (double)PTMInitDialog.this.sampleNamesVector.size(), -3.0, 3.0);
            this.profileDisplayPanel.setGraphSpacing(20, 20, 20, 20);
            this.profileDisplayPanel.setXAxisValue(0.0);
            this.profileDisplayPanel.setYAxisValue(0.0);
            this.templateList.addListSelectionListener(new ListSelectionListener(this){
                private final /* synthetic */ SavedTemplateSelector this$1;
                {
                    this.this$1 = savedTemplateSelector;
                }

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (this.this$1.templatesVector.size() > 0) {
                        Vector vector = (Vector)this.this$1.templatesVector.elementAt(this.this$1.templateList.getSelectedIndex());
                        if (vector.size() == SavedTemplateSelector.access$1000((SavedTemplateSelector)this.this$1).numberOfExperiments) {
                            SavedTemplateSelector.access$1000((SavedTemplateSelector)this.this$1).tempPanel.setVisible(true);
                            SavedTemplateSelector.access$1000((SavedTemplateSelector)this.this$1).tempPanel.setEnabled(true);
                        } else {
                            SavedTemplateSelector.access$1000((SavedTemplateSelector)this.this$1).tempPanel.setVisible(false);
                            SavedTemplateSelector.access$1000((SavedTemplateSelector)this.this$1).tempPanel.setEnabled(false);
                        }
                    }
                    this.this$1.savedTemplateSelected = false;
                    SavedTemplateSelector.access$1100(this.this$1);
                }
            });
            this.listScrollPane = new JScrollPane(this.templateList);
            this.templateSplitPane = new JSplitPane(1, this.listScrollPane, (Component)this.profileDisplayPanel);
            this.templateSplitPane.setOneTouchExpandable(true);
            this.templateSplitPane.setDividerLocation(200);
            Dimension dimension = new Dimension(100, 50);
            this.templateList.setMinimumSize(dimension);
            this.profileDisplayPanel.setMinimumSize(dimension);
            this.templateSplitPane.setPreferredSize(new Dimension(700, 150));
            PTMInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 1, 1);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagLayout.setConstraints(this.templateSplitPane, gridBagConstraints);
            this.add(this.templateSplitPane);
            this.loadButton = new JButton("Load saved template", GUIFactory.getIcon("Open24.gif"));
            this.loadButton.setBorder(BorderFactory.createBevelBorder(0));
            this.loadButton.setMargin(new Insets(10, 10, 10, 10));
            this.loadButton.setFocusPainted(false);
            this.loadButton.setPreferredSize(new Dimension(200, 30));
            this.loadButton.addActionListener(new ActionListener(this, PTMInitDialog.this){
                private final /* synthetic */ PTMInitDialog val$this$0;
                private final /* synthetic */ SavedTemplateSelector this$1;
                {
                    this.this$1 = savedTemplateSelector;
                    this.val$this$0 = pTMInitDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser;
                    int n;
                    if (actionEvent.getSource() == this.this$1.loadButton && (n = (jFileChooser = new JFileChooser(TMEV.getFile((String)"data/"))).showOpenDialog(this.this$1)) == 0) {
                        File file = jFileChooser.getSelectedFile();
                        try {
                            BufferedReader bufferedReader = new BufferedReader(new FileReader(file.getPath()));
                            try {
                                String string;
                                int n2 = this.this$1.templatesVector.size();
                                Vector<Float> vector = new Vector<Float>();
                                while ((string = bufferedReader.readLine()) != null) {
                                    vector.add(new Float(string));
                                }
                                this.this$1.listModel.addElement(file.getName());
                                this.this$1.templatesVector.add(vector);
                                this.this$1.templateList.setSelectedIndex(this.this$1.templatesVector.size() - 1);
                                bufferedReader.close();
                                SavedTemplateSelector.access$1100(this.this$1);
                                this.this$1.profileDisplayPanel.setGraphBounds(0.0, (double)vector.size(), -3.0, 3.0);
                            }
                            catch (EOFException eOFException) {
                                bufferedReader.close();
                            }
                        }
                        catch (IOException iOException) {
                            System.out.println("Error: " + iOException.toString());
                            JOptionPane.showMessageDialog(null, iOException.toString());
                        }
                    }
                }
            });
            this.selectButton = new JButton("Select Displayed Template", GUIFactory.getIcon("select_check24.gif"));
            this.selectButton.setBorder(BorderFactory.createBevelBorder(0));
            this.selectButton.setMargin(new Insets(10, 10, 10, 10));
            this.selectButton.setFocusPainted(false);
            this.selectButton.setPreferredSize(new Dimension(200, 30));
            this.selectButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ SavedTemplateSelector this$1;
                {
                    this.this$1 = savedTemplateSelector;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.this$1.listModel.size() == 0) {
                        JOptionPane.showMessageDialog(null, "No templates to select");
                    } else {
                        int n;
                        float f;
                        this.this$1.savedTemplateSelected = true;
                        int n2 = this.this$1.templateList.getSelectedIndex();
                        Vector vector = (Vector)((Vector)this.this$1.templatesVector.get(n2)).clone();
                        float f2 = PTMInitDialog.access$500(SavedTemplateSelector.access$1000(this.this$1), vector);
                        if (f2 - (f = PTMInitDialog.access$600(SavedTemplateSelector.access$1000(this.this$1), vector)) == 0.0f) {
                            for (n = 0; n < vector.size(); ++n) {
                                vector.set(n, new Float(0.5));
                            }
                        } else {
                            for (n = 0; n < vector.size(); ++n) {
                                float f3 = (((Float)vector.get(n)).floatValue() - f) / (f2 - f);
                                vector.set(n, new Float(f3));
                            }
                        }
                        if (vector.size() == SavedTemplateSelector.access$1000((SavedTemplateSelector)this.this$1).numberOfExperiments) {
                            SavedTemplateSelector.access$1000((SavedTemplateSelector)this.this$1).clusterGenes = true;
                            for (n = 0; n < SavedTemplateSelector.access$1000((SavedTemplateSelector)this.this$1).tempPanel.tempScr.tempGrid.length; ++n) {
                                SavedTemplateSelector.access$1000((SavedTemplateSelector)this.this$1).tempPanel.tempScr.tempGrid[n].templateSlider.setValue((int)Math.floor(((Float)vector.get(n)).floatValue() * 100.0f));
                                SavedTemplateSelector.access$1000((SavedTemplateSelector)this.this$1).tempPanel.tempScr.tempGrid[n].templateField.setText("" + ((Float)vector.get(n)).floatValue());
                            }
                        } else {
                            SavedTemplateSelector.access$1000((SavedTemplateSelector)this.this$1).clusterGenes = false;
                            SavedTemplateSelector.access$1000((SavedTemplateSelector)this.this$1).template = vector;
                        }
                    }
                    SavedTemplateSelector.access$1100(this.this$1);
                }
            });
            gridBagLayout.setConstraints(this.selectButton, gridBagConstraints);
            this.add(this.selectButton);
            PTMInitDialog.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 0, 0);
            this.templateButtonPanel = new JPanel();
            this.templateButtonPanel.add(this.loadButton);
            this.templateButtonPanel.add(this.selectButton);
            gridBagLayout.setConstraints(this.templateButtonPanel, gridBagConstraints);
            this.add(this.templateButtonPanel);
            this.refreshGraph();
        }

        private void refreshGraph() {
            GraphPoint graphPoint;
            int n;
            float f = Float.POSITIVE_INFINITY;
            float f2 = Float.NEGATIVE_INFINITY;
            int n2 = this.templateList.getSelectedIndex();
            Color color = Color.blue;
            if (this.savedTemplateSelected) {
                color = Color.green;
            }
            if (n2 < 0) {
                return;
            }
            Vector vector = (Vector)((Vector)this.templatesVector.get(n2)).clone();
            f2 = Math.max(f2, PTMInitDialog.this.getMax(vector));
            f = Math.min(f, PTMInitDialog.this.getMin(vector));
            float f3 = Math.max(f2, Math.abs(f));
            this.profileDisplayPanel.setGraphBounds(0.0, (double)vector.size(), (double)(-f3), (double)f3);
            this.profileDisplayPanel.removeAllGraphElements();
            for (n = 0; n < vector.size(); ++n) {
                graphPoint = new GraphPoint((double)(n + 1), (double)((Float)vector.elementAt(n)).floatValue(), Color.red, 2);
                this.profileDisplayPanel.addGraphElement((GraphElement)graphPoint);
            }
            for (n = 0; n < vector.size() - 1; ++n) {
                graphPoint = new GraphLine((double)(n + 1), (double)((Float)vector.elementAt(n)).floatValue(), (double)(n + 2), (double)((Float)vector.elementAt(n + 1)).floatValue(), color);
                this.profileDisplayPanel.addGraphElement((GraphElement)graphPoint);
            }
            this.profileDisplayPanel.repaint();
        }

        public void reset() {
            this.savedTemplateSelected = false;
            this.refreshGraph();
        }

        static /* synthetic */ PTMInitDialog access$1000(SavedTemplateSelector savedTemplateSelector) {
            return savedTemplateSelector.PTMInitDialog.this;
        }

        static /* synthetic */ void access$1100(SavedTemplateSelector savedTemplateSelector) {
            savedTemplateSelector.refreshGraph();
        }
    }

    class ExperimentClusterSelector
    extends JPanel {
        JList clusterList;
        GraphCanvas profileDisplayPanel;
        JScrollPane listScrollPane;
        JButton selectButton;
        Vector clusterNames = new Vector();
        Vector expDataInClusters;
        Vector averageClusterProfiles;
        JSplitPane clusterSplitPane;

        ExperimentClusterSelector() {
            Cloneable cloneable;
            if (PTMInitDialog.this.expClusters.size() == 0) {
                this.clusterNames.add("No sample clusters to show");
            } else {
                int n;
                for (n = 0; n < PTMInitDialog.this.expClusters.size(); ++n) {
                    this.clusterNames.add("Exp. Cluster " + (n + 1));
                }
                this.expDataInClusters = new Vector();
                this.averageClusterProfiles = new Vector();
                for (int i = 0; i < PTMInitDialog.this.expClusters.size(); ++i) {
                    cloneable = (Vector)PTMInitDialog.this.expClusters.get(i);
                    Vector<Vector> vector = new Vector<Vector>();
                    for (int j = 0; j < cloneable.size(); ++j) {
                        n = (Integer)cloneable.get(j);
                        Vector vector2 = PTMInitDialog.this.getExperiment(n);
                        vector.add(vector2);
                    }
                    this.expDataInClusters.add(vector);
                    Vector vector3 = PTMInitDialog.this.getMeanProfile(vector);
                    this.averageClusterProfiles.add(vector3);
                }
            }
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            this.clusterList = new JList(this.clusterNames);
            this.clusterList.setSelectionMode(0);
            this.clusterList.setSelectedIndex(0);
            this.profileDisplayPanel = new GraphCanvas();
            this.profileDisplayPanel.setGraphBounds(0.0, (double)PTMInitDialog.this.sampleNamesVector.size(), -3.0, 3.0);
            this.profileDisplayPanel.setGraphSpacing(20, 20, 20, 20);
            this.profileDisplayPanel.setXAxisValue(0.0);
            this.profileDisplayPanel.setYAxisValue(0.0);
            this.clusterList.addListSelectionListener(new ListSelectionListener(this){
                private final /* synthetic */ ExperimentClusterSelector this$1;
                {
                    this.this$1 = experimentClusterSelector;
                }

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    ExperimentClusterSelector.access$700(this.this$1);
                }
            });
            this.listScrollPane = new JScrollPane(this.clusterList);
            this.clusterSplitPane = new JSplitPane(1, this.listScrollPane, (Component)this.profileDisplayPanel);
            this.clusterSplitPane.setOneTouchExpandable(true);
            this.clusterSplitPane.setDividerLocation(200);
            cloneable = new Dimension(100, 50);
            this.clusterList.setMinimumSize((Dimension)cloneable);
            this.profileDisplayPanel.setMinimumSize((Dimension)cloneable);
            PTMInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 1, 1);
            gridBagConstraints.fill = 1;
            gridBagLayout.setConstraints(this.clusterSplitPane, gridBagConstraints);
            this.add(this.clusterSplitPane);
            PTMInitDialog.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 0, 0);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(10, 0, 10, 0);
            this.selectButton = new JButton("Select highlighted cluster from above list to use its mean as template", GUIFactory.getIcon("select_check24.gif"));
            this.selectButton.setBorder(BorderFactory.createBevelBorder(0));
            this.selectButton.setMargin(new Insets(10, 10, 10, 10));
            this.selectButton.setPreferredSize(new Dimension(430, 30));
            this.selectButton.setFocusPainted(false);
            this.selectButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ ExperimentClusterSelector this$1;
                {
                    this.this$1 = experimentClusterSelector;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (ExperimentClusterSelector.access$800((ExperimentClusterSelector)this.this$1).expClusters.size() == 0) {
                        JOptionPane.showMessageDialog(null, "No sample clusters to select");
                    } else {
                        int n = this.this$1.clusterList.getSelectedIndex();
                        Vector vector = (Vector)ExperimentClusterSelector.access$800((ExperimentClusterSelector)this.this$1).expClusters.elementAt(n);
                        int[] nArray = new int[vector.size()];
                        for (int i = 0; i < nArray.length; ++i) {
                            nArray[i] = (Integer)vector.elementAt(i);
                        }
                        Vector vector2 = new Vector();
                        Vector<Vector> vector3 = new Vector<Vector>();
                        for (int i = 0; i < nArray.length; ++i) {
                            int n2;
                            float f;
                            vector2 = PTMInitDialog.access$400(ExperimentClusterSelector.access$800(this.this$1), nArray[i]);
                            float f2 = PTMInitDialog.access$500(ExperimentClusterSelector.access$800(this.this$1), vector2);
                            if (f2 - (f = PTMInitDialog.access$600(ExperimentClusterSelector.access$800(this.this$1), vector2)) == 0.0f) {
                                for (n2 = 0; n2 < vector2.size(); ++n2) {
                                    vector2.set(n2, new Float(0.5));
                                }
                            } else {
                                for (n2 = 0; n2 < vector2.size(); ++n2) {
                                    float f3 = (((Float)vector2.get(n2)).floatValue() - f) / (f2 - f);
                                    vector2.set(n2, new Float(f3));
                                }
                            }
                            vector3.add(vector2);
                        }
                        ExperimentClusterSelector.access$800((ExperimentClusterSelector)this.this$1).template = ExperimentClusterSelector.access$800(this.this$1).getMeanProfile(vector3);
                        ExperimentClusterSelector.access$800((ExperimentClusterSelector)this.this$1).setTemplate = true;
                        ExperimentClusterSelector.access$800((ExperimentClusterSelector)this.this$1).clusterGenes = false;
                        PTMInitDialog.access$900(ExperimentClusterSelector.access$800(this.this$1)).setEnabled(true);
                    }
                }
            });
            gridBagLayout.setConstraints(this.selectButton, gridBagConstraints);
            this.add(this.selectButton);
            this.refreshGraph();
        }

        private void refreshGraph() {
            GraphLine graphLine;
            int n;
            int n2 = this.clusterList.getSelectedIndex();
            if (PTMInitDialog.this.expClusters.size() <= 0) {
                return;
            }
            Vector vector = (Vector)this.averageClusterProfiles.elementAt(n2);
            float f = Float.POSITIVE_INFINITY;
            float f2 = Float.NEGATIVE_INFINITY;
            this.profileDisplayPanel.removeAllGraphElements();
            Vector vector2 = (Vector)this.expDataInClusters.get(n2);
            for (n = 0; n < vector2.size(); ++n) {
                Vector vector3 = (Vector)vector2.get(n);
                f2 = Math.max(f2, PTMInitDialog.this.getMax(vector3));
                f = Math.min(f, PTMInitDialog.this.getMin(vector3));
                float f3 = Math.max(f2, Math.abs(f));
                this.profileDisplayPanel.setGraphBounds(0.0, (double)vector3.size(), (double)(-f3), (double)f3);
                for (int i = 0; i < vector3.size() - 1; ++i) {
                    if (Float.isNaN(((Float)vector3.elementAt(i)).floatValue()) || Float.isNaN(((Float)vector3.elementAt(i + 1)).floatValue())) continue;
                    graphLine = new GraphLine((double)i, (double)((Float)vector3.elementAt(i)).floatValue(), (double)(i + 1), (double)((Float)vector3.elementAt(i + 1)).floatValue(), PTMInitDialog.this.expClusterColors[n2]);
                    this.profileDisplayPanel.addGraphElement((GraphElement)graphLine);
                }
            }
            for (n = 0; n < vector.size(); ++n) {
                if (Float.isNaN(((Float)vector.elementAt(n)).floatValue())) continue;
                GraphPoint graphPoint = new GraphPoint((double)n, (double)((Float)vector.elementAt(n)).floatValue(), Color.red, 5);
                this.profileDisplayPanel.addGraphElement((GraphElement)graphPoint);
            }
            for (n = 0; n < vector.size() - 1; ++n) {
                graphLine = new GraphLine((double)n, (double)((Float)vector.elementAt(n)).floatValue(), (double)(n + 1), (double)((Float)vector.elementAt(n + 1)).floatValue(), Color.blue);
                this.profileDisplayPanel.addGraphElement((GraphElement)graphLine);
            }
            if (PTMInitDialog.this.setTemplate) {
                for (n = 0; n < vector.size() - 1; ++n) {
                    if (Float.isNaN(((Float)vector.elementAt(n)).floatValue()) || Float.isNaN(((Float)vector.elementAt(n + 1)).floatValue())) continue;
                    graphLine = new GraphLine((double)n, (double)((Float)vector.elementAt(n)).floatValue(), (double)(n + 1), (double)((Float)vector.elementAt(n + 1)).floatValue(), Color.green);
                    this.profileDisplayPanel.addGraphElement((GraphElement)graphLine);
                }
            }
            this.profileDisplayPanel.repaint();
        }

        public void reset() {
            this.clusterList.setSelectedIndex(0);
            PTMInitDialog.this.setTemplate = false;
            this.refreshGraph();
        }

        static /* synthetic */ void access$700(ExperimentClusterSelector experimentClusterSelector) {
            experimentClusterSelector.refreshGraph();
        }

        static /* synthetic */ PTMInitDialog access$800(ExperimentClusterSelector experimentClusterSelector) {
            return experimentClusterSelector.PTMInitDialog.this;
        }
    }

    class ExperimentSelector
    extends JPanel {
        JList expList;
        GraphCanvas profileDisplayPanel;
        JScrollPane listScrollPane;
        JButton selectButton;
        int maxIndex = -1;
        int minIndex = -1;
        JSplitPane expSplitPane;

        ExperimentSelector() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            this.expList = new JList(PTMInitDialog.this.sampleNamesVector);
            this.expList.setSelectedIndex(0);
            this.profileDisplayPanel = new GraphCanvas();
            this.profileDisplayPanel.setGraphBounds(0.0, (double)PTMInitDialog.this.expMatrix.getRowDimension(), -3.0, 3.0);
            this.profileDisplayPanel.setGraphSpacing(20, 20, 20, 20);
            this.profileDisplayPanel.setXAxisValue(0.0);
            this.profileDisplayPanel.setYAxisValue(0.0);
            this.expList.addListSelectionListener(new ListSelectionListener(this){
                private final /* synthetic */ ExperimentSelector this$1;
                {
                    this.this$1 = experimentSelector;
                }

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    ExperimentSelector.access$200(this.this$1);
                }
            });
            this.listScrollPane = new JScrollPane(this.expList);
            this.expSplitPane = new JSplitPane(1, this.listScrollPane, (Component)this.profileDisplayPanel);
            this.expSplitPane.setOneTouchExpandable(true);
            this.expSplitPane.setDividerLocation(200);
            Dimension dimension = new Dimension(100, 50);
            this.expList.setMinimumSize(dimension);
            this.profileDisplayPanel.setMinimumSize(dimension);
            PTMInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 1, 1);
            gridBagConstraints.fill = 1;
            gridBagLayout.setConstraints(this.expSplitPane, gridBagConstraints);
            this.add(this.expSplitPane);
            PTMInitDialog.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 0, 0);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(10, 0, 10, 0);
            this.selectButton = new JButton("Select highlighted samples from above list to use as template", GUIFactory.getIcon("select_check24.gif"));
            this.selectButton.setBorder(BorderFactory.createBevelBorder(0));
            this.selectButton.setMargin(new Insets(10, 10, 10, 10));
            this.selectButton.setPreferredSize(new Dimension(400, 30));
            this.selectButton.setFocusPainted(false);
            this.selectButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ ExperimentSelector this$1;
                {
                    this.this$1 = experimentSelector;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    int[] nArray = this.this$1.expList.getSelectedIndices();
                    Vector vector = new Vector();
                    Vector<Vector> vector2 = new Vector<Vector>();
                    for (int i = 0; i < nArray.length; ++i) {
                        int n;
                        float f;
                        vector = PTMInitDialog.access$400(ExperimentSelector.access$300(this.this$1), nArray[i]);
                        float f2 = PTMInitDialog.access$500(ExperimentSelector.access$300(this.this$1), vector);
                        if (f2 - (f = PTMInitDialog.access$600(ExperimentSelector.access$300(this.this$1), vector)) == 0.0f) {
                            for (n = 0; n < vector.size(); ++n) {
                                vector.set(n, new Float(0.5));
                            }
                        } else {
                            for (n = 0; n < vector.size(); ++n) {
                                float f3 = (((Float)vector.get(n)).floatValue() - f) / (f2 - f);
                                vector.set(n, new Float(f3));
                            }
                        }
                        vector2.add(vector);
                    }
                    ExperimentSelector.access$300((ExperimentSelector)this.this$1).template = ExperimentSelector.access$300(this.this$1).getMeanProfile(vector2);
                    ExperimentSelector.access$300((ExperimentSelector)this.this$1).setTemplate = true;
                    ExperimentSelector.access$300((ExperimentSelector)this.this$1).clusterGenes = false;
                    ExperimentSelector.access$200(this.this$1);
                }
            });
            gridBagLayout.setConstraints(this.selectButton, gridBagConstraints);
            this.add(this.selectButton);
            this.refreshGraph();
        }

        private void refreshGraph() {
            Vector vector;
            int n;
            this.profileDisplayPanel.removeAllGraphElements();
            int[] nArray = this.expList.getSelectedIndices();
            Vector<Vector> vector2 = new Vector<Vector>();
            float f = Float.NEGATIVE_INFINITY;
            float f2 = Float.POSITIVE_INFINITY;
            for (n = 0; n < nArray.length; ++n) {
                GraphPoint graphPoint;
                int n2;
                vector = PTMInitDialog.this.getExperiment(nArray[n]);
                vector2.add(vector);
                f = Math.max(f, PTMInitDialog.this.getMax(vector));
                f2 = Math.min(f2, PTMInitDialog.this.getMin(vector));
                float f3 = Math.max(f, Math.abs(f2));
                this.profileDisplayPanel.setGraphBounds(0.0, (double)vector.size(), (double)(-f3), (double)f3);
                for (n2 = 0; n2 < vector.size(); ++n2) {
                    if (Float.isNaN(((Float)vector.elementAt(n2)).floatValue())) continue;
                    graphPoint = new GraphPoint((double)n2, (double)((Float)vector.elementAt(n2)).floatValue(), Color.red, 5);
                    this.profileDisplayPanel.addGraphElement((GraphElement)graphPoint);
                }
                for (n2 = 0; n2 < vector.size() - 1; ++n2) {
                    if (Float.isNaN(((Float)vector.elementAt(n2)).floatValue()) || Float.isNaN(((Float)vector.elementAt(n2 + 1)).floatValue())) continue;
                    graphPoint = new GraphLine((double)n2, (double)((Float)vector.elementAt(n2)).floatValue(), (double)(n2 + 1), (double)((Float)vector.elementAt(n2 + 1)).floatValue(), Color.blue);
                    this.profileDisplayPanel.addGraphElement((GraphElement)graphPoint);
                }
            }
            vector = PTMInitDialog.this.getMeanProfile(vector2);
            if (PTMInitDialog.this.setTemplate) {
                for (n = 0; n < vector.size() - 1; ++n) {
                    if (Float.isNaN(((Float)vector.elementAt(n)).floatValue()) || Float.isNaN(((Float)vector.elementAt(n + 1)).floatValue())) continue;
                    GraphLine graphLine = new GraphLine((double)n, (double)((Float)vector.elementAt(n)).floatValue(), (double)(n + 1), (double)((Float)vector.elementAt(n + 1)).floatValue(), Color.green);
                    this.profileDisplayPanel.addGraphElement((GraphElement)graphLine);
                }
            }
            this.profileDisplayPanel.repaint();
        }

        public void reset() {
            this.expList.setSelectedIndex(0);
            PTMInitDialog.this.setTemplate = false;
            this.refreshGraph();
        }

        static /* synthetic */ void access$200(ExperimentSelector experimentSelector) {
            experimentSelector.refreshGraph();
        }

        static /* synthetic */ PTMInitDialog access$300(ExperimentSelector experimentSelector) {
            return experimentSelector.PTMInitDialog.this;
        }
    }
}

