/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.pca;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;
import org.tigr.util.FloatMatrix;

public class PlotViewer
extends ViewerAdapter
implements Serializable {
    public static final long serialVersionUID = 202011040001L;
    private JComponent content;

    public PlotViewer(FloatMatrix floatMatrix) {
        this.content = this.createContent(floatMatrix);
    }

    public JComponent getContentComponent() {
        return this.content;
    }

    private JComponent createContent(FloatMatrix floatMatrix) {
        return new Plot(floatMatrix);
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    private class Plot
    extends JPanel {
        private static final int left = 40;
        private static final int top = 40;
        private FloatMatrix S;
        private Font font = new Font("monospaced", 1, 10);

        public Plot(FloatMatrix floatMatrix) {
            this.setBackground(Color.white);
            this.setFont(this.font);
            this.S = floatMatrix;
        }

        public void paint(Graphics graphics) {
            String string;
            int n;
            int n2;
            int n3;
            super.paint(graphics);
            int n4 = this.getWidth() - 80;
            int n5 = this.getHeight() - 80;
            if (n4 < 5 || n5 < 5) {
                return;
            }
            graphics.setColor(Color.black);
            graphics.drawRect(40, 40, n4, n5);
            double d = this.S.get(0, 0);
            if (Double.isNaN(d)) {
                return;
            }
            int n6 = 1;
            while (d >= 10.0) {
                d /= 10.0;
                n6 *= 10;
            }
            int n7 = (int)Math.round(d + 0.5) * n6;
            int n8 = (int)Math.round(d + 0.5);
            double d2 = (double)n5 / (double)n8;
            for (int i = 1; i < n8; ++i) {
                graphics.drawLine(40, 40 + (int)Math.round((double)i * d2), 45, 40 + (int)Math.round((double)i * d2));
            }
            double d3 = (double)n4 / ((double)this.S.getColumnDimension() - 1.0);
            for (int i = 1; i < this.S.getColumnDimension(); ++i) {
                graphics.drawLine(40 + (int)Math.round((double)i * d3), 40 + n5 - 5, 40 + (int)Math.round((double)i * d3), 40 + n5);
            }
            graphics.setColor(Color.magenta);
            double d4 = (double)n5 / (double)n7;
            int n9 = -((int)Math.round((double)this.S.get(0, 0) * d4));
            int n10 = 40 + n5;
            for (n3 = 1; n3 < this.S.getColumnDimension(); ++n3) {
                n2 = -((int)Math.round((double)this.S.get(n3, n3) * d4));
                graphics.drawLine(40 + (int)Math.round((double)(n3 - 1) * d3), n10 + n9, 40 + (int)Math.round((double)n3 * d3), n10 + n2);
                n9 = n2;
            }
            graphics.setColor(new Color(0, 0, 128));
            for (n3 = 0; n3 < this.S.getColumnDimension(); ++n3) {
                n2 = -((int)Math.round((double)this.S.get(n3, n3) * d4));
                graphics.fillOval(40 + (int)Math.round((double)n3 * d3) - 3, n10 + n2 - 3, 6, 6);
            }
            FontMetrics fontMetrics = graphics.getFontMetrics();
            for (n = 0; n <= n8; ++n) {
                string = String.valueOf(n7 - n6 * n);
                n3 = fontMetrics.stringWidth(string);
                graphics.drawString(string, 30 - n3, 40 + (int)Math.round((double)n * d2) + 5);
            }
            ((Graphics2D)graphics).rotate(-1.5707963267948966);
            for (n = 0; n < this.S.getColumnDimension(); ++n) {
                string = String.valueOf(n + 1);
                n3 = fontMetrics.stringWidth(string);
                graphics.drawString(string, -40 - n5 - 10 - n3, 45 + (int)Math.round((double)n * d3));
            }
            ((Graphics2D)graphics).rotate(1.5707963267948966);
        }
    }
}

