/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.pca;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.SampleSelectionPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class PCASelectionDialog
extends AlgorithmDialog {
    private int result = 2;
    private SampleSelectionPanel sampleSelectionPanel;
    JTextField numNeighborsField;

    public PCASelectionDialog(Frame frame) {
        super(frame, "PCA: Principal Components Analysis", true);
        this.setBounds(0, 0, 600, 200);
        this.setBackground(Color.white);
        this.setDefaultCloseOperation(2);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setBorder(new EtchedBorder());
        jPanel.setLayout(gridBagLayout);
        this.sampleSelectionPanel = new SampleSelectionPanel(Color.white, UIManager.getColor("Label.foreground"), true, "Sample Selection");
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 50);
        gridBagLayout.setConstraints(this.sampleSelectionPanel, gridBagConstraints);
        jPanel.add(this.sampleSelectionPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(Color.white);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        JLabel jLabel = new JLabel("Number for neighbors for KNN imputation :");
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 50, 100);
        gridBagLayout2.setConstraints(jLabel, gridBagConstraints);
        jPanel2.add(jLabel);
        this.numNeighborsField = new JTextField("10", 7);
        this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 50, 100);
        gridBagLayout2.setConstraints(this.numNeighborsField, gridBagConstraints);
        jPanel2.add(this.numNeighborsField);
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 0, 50);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        this.setActionListeners(new EventListener());
        this.addContent(jPanel);
        this.pack();
    }

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public boolean isClusterGenesSelected() {
        return this.sampleSelectionPanel.isClusterGenesSelected();
    }

    public void resetControls() {
        this.sampleSelectionPanel.setClusterGenesSelected(true);
    }

    public int getNumNeighbors() {
        return Integer.parseInt(this.numNeighborsField.getText());
    }

    public static void main(String[] stringArray) {
        PCASelectionDialog pCASelectionDialog = new PCASelectionDialog(new Frame());
        int n = pCASelectionDialog.showModal();
        System.out.println("result = " + n);
        System.exit(0);
    }

    protected class EventListener
    implements ActionListener {
        protected EventListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                try {
                    int n = PCASelectionDialog.this.getNumNeighbors();
                    if (n <= 0) {
                        JOptionPane.showMessageDialog(null, "Invalid number of neighbors", "Error", 0);
                        return;
                    }
                    PCASelectionDialog.this.result = 0;
                    PCASelectionDialog.this.dispose();
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(null, "Invalid number of neighbors", "Error", 0);
                    return;
                }
            } else if (string.equals("cancel-command")) {
                PCASelectionDialog.this.result = 2;
                PCASelectionDialog.this.dispose();
            } else if (string.equals("reset-command")) {
                PCASelectionDialog.this.resetControls();
            } else if (string.equals("info-command")) {
                HelpWindow helpWindow = new HelpWindow(PCASelectionDialog.this, "PCA Initialization Dialog");
                if (helpWindow.getWindowContent()) {
                    helpWindow.setSize(450, 350);
                    helpWindow.setLocation();
                    helpWindow.show();
                } else {
                    helpWindow.dispose();
                }
            }
        }
    }
}

