/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.knnc;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.HCLSelectionPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.microarray.mev.cluster.gui.impl.knnc.KNNClassificationEditor;

public class KNNCValidationFirstDialog
extends AlgorithmDialog {
    boolean okPressed = false;
    JRadioButton genesButton;
    JRadioButton expsButton;
    JRadioButton createNewTrgSetButton;
    JRadioButton useExistTrgSetButton;
    JCheckBox useCorrelFilterBox;
    JTextField pValueField;
    JTextField numClassesField;
    JTextField numNeighborsField;
    JTextField numPermsField;
    JLabel corrLabel;
    JLabel numPermsLabel;
    HCLSelectionPanel hclOpsPanel;
    IFramework framework;
    Experiment experiment;
    KNNClassificationEditor knnEditor;
    int numExps;
    int numGenes;

    public KNNCValidationFirstDialog(JFrame jFrame, boolean bl, IFramework iFramework) {
        super(jFrame, "KNN Validation", bl);
        this.okButton.setText("Next >");
        this.setBounds(0, 0, 550, 550);
        this.setBackground(Color.white);
        this.setDefaultCloseOperation(2);
        this.framework = iFramework;
        this.experiment = this.framework.getData().getExperiment();
        this.numExps = this.experiment.getNumberOfSamples();
        this.numGenes = this.experiment.getNumberOfGenes();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        this.useCorrelFilterBox = new JCheckBox("Use correlation filter", false);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(Color.white);
        jPanel2.setBorder(new TitledBorder("Classify genes or samples"));
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout2);
        this.genesButton = new JRadioButton("Classify genes", true);
        this.genesButton.setBackground(Color.white);
        this.expsButton = new JRadioButton("Classify samples", false);
        this.expsButton.setBackground(Color.white);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.genesButton);
        buttonGroup.add(this.expsButton);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 50, 100);
        gridBagLayout2.setConstraints(this.genesButton, gridBagConstraints);
        jPanel2.add(this.genesButton);
        this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 50, 0);
        gridBagLayout2.setConstraints(this.expsButton, gridBagConstraints);
        jPanel2.add(this.expsButton);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 10);
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        gridBagConstraints.fill = 0;
        JPanel jPanel3 = new JPanel();
        jPanel3.setBackground(Color.white);
        jPanel3.setBorder(new TitledBorder("Correlation filter"));
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        jPanel3.setLayout(gridBagLayout3);
        this.useCorrelFilterBox.setBackground(Color.white);
        this.corrLabel = new JLabel("          Cutoff p-value for correlation: ");
        this.corrLabel.setEnabled(false);
        this.numPermsLabel = new JLabel("          Number of permutations for correlation test: ");
        this.numPermsLabel.setEnabled(false);
        this.pValueField = new JTextField("0.01", 7);
        this.pValueField.setEnabled(false);
        this.pValueField.setBackground(Color.gray);
        this.numPermsField = new JTextField("1000", 7);
        this.numPermsField.setEnabled(false);
        this.numPermsField.setBackground(Color.gray);
        this.useCorrelFilterBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 2) {
                    KNNCValidationFirstDialog.this.corrLabel.setEnabled(false);
                    KNNCValidationFirstDialog.this.numPermsLabel.setEnabled(false);
                    KNNCValidationFirstDialog.this.pValueField.setEnabled(false);
                    KNNCValidationFirstDialog.this.pValueField.setBackground(Color.gray);
                    KNNCValidationFirstDialog.this.numPermsField.setEnabled(false);
                    KNNCValidationFirstDialog.this.numPermsField.setBackground(Color.gray);
                } else {
                    KNNCValidationFirstDialog.this.corrLabel.setEnabled(true);
                    KNNCValidationFirstDialog.this.numPermsLabel.setEnabled(true);
                    KNNCValidationFirstDialog.this.pValueField.setEnabled(true);
                    KNNCValidationFirstDialog.this.pValueField.setBackground(Color.white);
                    KNNCValidationFirstDialog.this.numPermsField.setEnabled(true);
                    KNNCValidationFirstDialog.this.numPermsField.setBackground(Color.white);
                }
            }
        });
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 34);
        gridBagLayout3.setConstraints(this.useCorrelFilterBox, gridBagConstraints);
        jPanel3.add(this.useCorrelFilterBox);
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 70, 33);
        gridBagLayout3.setConstraints(this.corrLabel, gridBagConstraints);
        jPanel3.add(this.corrLabel);
        this.buildConstraints(gridBagConstraints, 1, 1, 1, 1, 30, 0);
        gridBagLayout3.setConstraints(this.pValueField, gridBagConstraints);
        jPanel3.add(this.pValueField);
        this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 70, 33);
        gridBagLayout3.setConstraints(this.numPermsLabel, gridBagConstraints);
        jPanel3.add(this.numPermsLabel);
        this.buildConstraints(gridBagConstraints, 1, 2, 1, 1, 30, 0);
        gridBagLayout3.setConstraints(this.numPermsField, gridBagConstraints);
        jPanel3.add(this.numPermsField);
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 100, 25);
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel.add(jPanel3);
        gridBagConstraints.fill = 0;
        JPanel jPanel4 = new JPanel();
        jPanel4.setBackground(Color.white);
        jPanel4.setBorder(new TitledBorder("KNN classification parameters"));
        GridBagLayout gridBagLayout4 = new GridBagLayout();
        jPanel4.setLayout(gridBagLayout4);
        JLabel jLabel = new JLabel("          Number of classes");
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 50, 50);
        gridBagLayout4.setConstraints(jLabel, gridBagConstraints);
        jPanel4.add(jLabel);
        this.numClassesField = new JTextField("5", 7);
        this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 50, 0);
        gridBagLayout4.setConstraints(this.numClassesField, gridBagConstraints);
        jPanel4.add(this.numClassesField);
        JLabel jLabel2 = new JLabel("          Number of neighbors");
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 50, 50);
        gridBagLayout4.setConstraints(jLabel2, gridBagConstraints);
        jPanel4.add(jLabel2);
        this.numNeighborsField = new JTextField("3", 7);
        this.buildConstraints(gridBagConstraints, 1, 1, 1, 1, 50, 0);
        gridBagLayout4.setConstraints(this.numNeighborsField, gridBagConstraints);
        jPanel4.add(this.numNeighborsField);
        this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 100, 25);
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel.add(jPanel4);
        gridBagConstraints.fill = 0;
        JPanel jPanel5 = new JPanel();
        jPanel5.setBackground(Color.white);
        jPanel5.setBorder(new TitledBorder("Create / import training set"));
        GridBagLayout gridBagLayout5 = new GridBagLayout();
        jPanel5.setLayout(gridBagLayout5);
        this.createNewTrgSetButton = new JRadioButton("Create new training set from data", true);
        this.createNewTrgSetButton.setBackground(Color.white);
        this.useExistTrgSetButton = new JRadioButton("Use previously created training set from file", false);
        this.useExistTrgSetButton.setBackground(Color.white);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.createNewTrgSetButton);
        buttonGroup2.add(this.useExistTrgSetButton);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 50);
        gridBagConstraints.anchor = 10;
        gridBagLayout5.setConstraints(this.createNewTrgSetButton, gridBagConstraints);
        jPanel5.add(this.createNewTrgSetButton);
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 0, 50);
        gridBagLayout5.setConstraints(this.useExistTrgSetButton, gridBagConstraints);
        jPanel5.add(this.useExistTrgSetButton);
        this.buildConstraints(gridBagConstraints, 0, 3, 1, 1, 100, 30);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(jPanel5, gridBagConstraints);
        jPanel.add(jPanel5);
        gridBagConstraints.fill = 0;
        this.hclOpsPanel = new HCLSelectionPanel();
        this.buildConstraints(gridBagConstraints, 0, 4, 1, 1, 100, 10);
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(this.hclOpsPanel, gridBagConstraints);
        jPanel.add(this.hclOpsPanel);
        this.addContent(jPanel);
        EventListener eventListener = new EventListener();
        this.setActionListeners(eventListener);
        this.addWindowListener(eventListener);
    }

    public void setVisible(boolean bl) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        super.setVisible(bl);
    }

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public boolean drawTrees() {
        return this.hclOpsPanel.isHCLSelected();
    }

    public boolean classifyGenes() {
        return this.genesButton.isSelected();
    }

    public int getNumClasses() {
        String string = this.numClassesField.getText();
        return Integer.parseInt(string);
    }

    public boolean createNewTrgSet() {
        return this.createNewTrgSetButton.isSelected();
    }

    public boolean useCorrelFilter() {
        return this.useCorrelFilterBox.isSelected();
    }

    public double getCorrPValue() {
        return Double.parseDouble(this.pValueField.getText());
    }

    public int getNumPerms() {
        return Integer.parseInt(this.numPermsField.getText());
    }

    public int getNumNeighbors() {
        return Integer.parseInt(this.numNeighborsField.getText());
    }

    public class EventListener
    extends WindowAdapter
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                try {
                    int n;
                    if (KNNCValidationFirstDialog.this.useCorrelFilterBox.isSelected()) {
                        double d = new Double(KNNCValidationFirstDialog.this.pValueField.getText());
                        if (d < 0.0 || d > 1.0) {
                            JOptionPane.showMessageDialog(KNNCValidationFirstDialog.this, "Correlation p-value must be between 0 and 1", "Error!", 2);
                            return;
                        }
                        double d2 = new Double(KNNCValidationFirstDialog.this.numPermsField.getText());
                        if (d2 <= 0.0) {
                            JOptionPane.showMessageDialog(KNNCValidationFirstDialog.this, "Number of permutations must be > 0", "Error!", 2);
                            return;
                        }
                    }
                    if (((n = new Integer(KNNCValidationFirstDialog.this.numClassesField.getText()).intValue()) <= 0 || n >= KNNCValidationFirstDialog.this.numGenes) && KNNCValidationFirstDialog.this.genesButton.isSelected()) {
                        JOptionPane.showMessageDialog(KNNCValidationFirstDialog.this, "Number of classes must be > 0 and < " + KNNCValidationFirstDialog.this.numGenes, "Error!", 2);
                        return;
                    }
                    if ((n <= 0 || n >= KNNCValidationFirstDialog.this.numExps) && KNNCValidationFirstDialog.this.expsButton.isSelected()) {
                        JOptionPane.showMessageDialog(KNNCValidationFirstDialog.this, "Number of classes must be > 0 and < " + KNNCValidationFirstDialog.this.numExps, "Error!", 2);
                        return;
                    }
                    int n2 = new Integer(KNNCValidationFirstDialog.this.numNeighborsField.getText());
                    if (KNNCValidationFirstDialog.this.genesButton.isSelected()) {
                        if (n2 <= 0 || n2 > KNNCValidationFirstDialog.this.numGenes) {
                            JOptionPane.showMessageDialog(KNNCValidationFirstDialog.this, "Number of neighbors must be > 0 and <= " + KNNCValidationFirstDialog.this.numGenes, "Error!", 2);
                            return;
                        }
                    } else if (n2 <= 0 || n2 > KNNCValidationFirstDialog.this.numExps) {
                        JOptionPane.showMessageDialog(KNNCValidationFirstDialog.this, "Number of neighbors must be > 0 and <= " + KNNCValidationFirstDialog.this.numExps, "Error!", 2);
                        return;
                    }
                    KNNCValidationFirstDialog.this.okPressed = true;
                    KNNCValidationFirstDialog.this.dispose();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(KNNCValidationFirstDialog.this, "Invalid format for at least one parameter", "Error!", 2);
                }
            } else if (string.equals("reset-command")) {
                KNNCValidationFirstDialog.this.okPressed = false;
                KNNCValidationFirstDialog.this.genesButton.setSelected(true);
                KNNCValidationFirstDialog.this.expsButton.setSelected(false);
                KNNCValidationFirstDialog.this.useCorrelFilterBox.setSelected(false);
                KNNCValidationFirstDialog.this.pValueField.setText("0.01");
                KNNCValidationFirstDialog.this.numPermsField.setText("1000");
                KNNCValidationFirstDialog.this.numClassesField.setText("5");
                KNNCValidationFirstDialog.this.numNeighborsField.setText("3");
                KNNCValidationFirstDialog.this.hclOpsPanel.setHCLSelected(false);
            } else if (string.equals("cancel-command")) {
                KNNCValidationFirstDialog.this.okPressed = false;
                KNNCValidationFirstDialog.this.dispose();
            } else if (string.equals("info-command")) {
                HelpWindow helpWindow = new HelpWindow(KNNCValidationFirstDialog.this, "KNNC Validataion Parameter Selections");
                KNNCValidationFirstDialog.this.okPressed = false;
                if (helpWindow.getWindowContent()) {
                    helpWindow.setSize(450, 600);
                    helpWindow.setLocation();
                    helpWindow.show();
                    return;
                }
                helpWindow.setVisible(false);
                helpWindow.dispose();
                return;
            }
        }
    }
}

