/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.hcl;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLCluster;

public class HCLColorBar
extends JPanel
implements Serializable {
    public static final long serialVersionUID = 202006040001L;
    private static final int BAR_WIDTH = 10;
    private ArrayList clusters;
    private int featuresSize;
    private boolean isAntiAliasing = true;
    private int elementHeight = 5;

    public HCLColorBar(ArrayList arrayList, int n) {
        this.setBackground(Color.white);
        this.setFont(new Font("monospaced", 0, 20));
        this.clusters = arrayList;
        this.featuresSize = n;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.isAntiAliasing) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        int n = 10;
        int n2 = this.clusters.size();
        for (int i = 0; i < n2; ++i) {
            HCLCluster hCLCluster = (HCLCluster)this.clusters.get(i);
            int n3 = hCLCluster.firstElem * this.elementHeight + this.elementHeight / 2;
            int n4 = (hCLCluster.lastElem - hCLCluster.firstElem) * this.elementHeight;
            graphics.setColor(hCLCluster.color);
            graphics.fillRect(n, n3, n + 10, n4);
            if (hCLCluster.text == null) continue;
            graphics.drawString(hCLCluster.text, n + 10 + 10, n3 + n4 / 2 + 7);
        }
    }

    public void onSelected(IFramework iFramework) {
        IDisplayMenu iDisplayMenu = iFramework.getDisplayMenu();
        this.isAntiAliasing = iDisplayMenu.isAntiAliasing();
        this.setElementHeight(iDisplayMenu.getElementSize().height);
        this.updateSize();
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
        if (this.elementHeight == iDisplayMenu.getElementSize().height && this.isAntiAliasing == iDisplayMenu.isAntiAliasing()) {
            return;
        }
        this.isAntiAliasing = iDisplayMenu.isAntiAliasing();
        this.setElementHeight(iDisplayMenu.getElementSize().height);
        this.updateSize();
    }

    public void onClustersChanged(ArrayList arrayList) {
        this.clusters = arrayList;
        this.updateSize();
        this.repaint();
    }

    private void setElementHeight(int n) {
        this.elementHeight = n;
    }

    private void updateSize() {
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        int n = 30 + this.getMaxWidth(graphics2D);
        int n2 = this.elementHeight * this.featuresSize + 1;
        this.setSizes(n, n2);
    }

    private int getMaxWidth(Graphics2D graphics2D) {
        if (graphics2D == null || this.clusters == null) {
            return 0;
        }
        if (this.isAntiAliasing) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n = 0;
        int n2 = this.clusters.size();
        for (int i = 0; i < n2; ++i) {
            HCLCluster hCLCluster = (HCLCluster)this.clusters.get(i);
            if (hCLCluster == null) continue;
            String string = hCLCluster.text == null ? "" : hCLCluster.text;
            n = Math.max(n, fontMetrics.stringWidth(string));
        }
        return n;
    }

    private void setSizes(int n, int n2) {
        this.setSize(n, n2);
        this.setPreferredSize(new Dimension(n, n2));
    }
}

