/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gdm;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.util.QSort;

public class GDMResultSelectionDialog
extends AlgorithmDialog {
    private int result;
    private JList resultList;

    public GDMResultSelectionDialog(JFrame jFrame, Enumeration enumeration) {
        super(jFrame, "GDM Result Selection Dialog", true);
        Listener listener = new Listener();
        this.addWindowListener(listener);
        ParameterPanel parameterPanel = new ParameterPanel();
        parameterPanel.setLayout(new GridBagLayout());
        Vector vector = this.sortAndLoadResultVector(enumeration);
        this.resultList = new JList(vector);
        this.resultList.setVisibleRowCount(3);
        this.resultList.setSelectedIndex(0);
        JScrollPane jScrollPane = new JScrollPane(this.resultList);
        JLabel jLabel = new JLabel("Select Cluster Result: ");
        jLabel.setVerticalAlignment(1);
        parameterPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 30, 10), 0, 0));
        parameterPanel.add((Component)jScrollPane, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 30, 50), 0, 0));
        this.addContent(parameterPanel);
        this.setActionListeners(listener);
        this.pack();
    }

    public void resetControls() {
        this.resultList.setSelectedIndex(0);
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public String getSelectedResult() {
        return (String)this.resultList.getSelectedValue();
    }

    public static void main(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        vector.add("KMC - genes (6)");
        vector.add("TTEST");
        vector.add("SOTA Test");
        vector.add("SOTA - genes (1)");
        vector.add("QTC - genes (2)");
        GDMResultSelectionDialog gDMResultSelectionDialog = new GDMResultSelectionDialog(new JFrame(), vector.elements());
        gDMResultSelectionDialog.setDefaultCloseOperation(2);
        gDMResultSelectionDialog.showModal();
        System.out.println("Selected result: " + gDMResultSelectionDialog.getSelectedResult());
    }

    private Vector sortAndLoadResultVector(Enumeration enumeration) {
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        String[] stringArray = new String[vector.size()];
        float[] fArray = new float[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
            int n = stringArray[i].indexOf("(");
            if (n != -1) {
                try {
                    fArray[i] = Integer.parseInt(stringArray[i].substring(n + 1, stringArray[i].indexOf(")")));
                }
                catch (NumberFormatException numberFormatException) {
                    fArray[i] = 1000 + i;
                }
                continue;
            }
            fArray[i] = 1000 + i;
        }
        QSort qSort = new QSort(fArray);
        int[] nArray = qSort.getOrigIndx();
        vector = new Vector();
        for (int i = 0; i < nArray.length; ++i) {
            vector.add(stringArray[nArray[i]]);
        }
        return vector;
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                GDMResultSelectionDialog.this.result = 0;
                GDMResultSelectionDialog.this.dispose();
            } else if (string.equals("cancel-command")) {
                GDMResultSelectionDialog.this.result = 2;
                GDMResultSelectionDialog.this.dispose();
            } else if (string.equals("reset-command")) {
                GDMResultSelectionDialog.this.resetControls();
            } else if (string.equals("info-command")) {
                HelpWindow helpWindow = new HelpWindow(GDMResultSelectionDialog.this, "GDM Result Selection Dialog");
                if (helpWindow.getWindowContent()) {
                    helpWindow.setSize(450, 650);
                    helpWindow.setLocation();
                    helpWindow.show();
                } else {
                    helpWindow.setVisible(false);
                    helpWindow.dispose();
                }
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            GDMResultSelectionDialog.this.result = -1;
            GDMResultSelectionDialog.this.dispose();
        }
    }
}

