/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gdm;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.impl.gdm.GDMGeneGradientLabelPanel;

public class GDMGeneHeader
extends JPanel {
    private static final String GDM_VECTOR_STRING = "GDM Vector";
    private int[] indices;
    private int labelIndex;
    private Insets insets;
    private int num_genes;
    private boolean showClusters = true;
    private boolean hasColorBar = false;
    private boolean isColumnHeader;
    private IData expData;
    private int contentWidth;
    private int contentHeight;
    private int elementWidth;
    private int elementHeight;
    private int tracespace;
    private int maxGeneNameLength;
    private Experiment experiment;
    private boolean isAntiAliasing = false;
    private boolean isTracing = true;
    private final int OFFSET = 5;
    private final int MIN_LABEL_PANEL_SIZE = 1;
    private final int MAX_LABEL_PANEL_SIZE = 200;
    private static final int NOT_UPDATE_ANNOTATION_SIZE = -1;
    private int annotationSize;
    private GDMGeneGradientLabelPanel gdmGradientLabelPanel;
    private GDMColorBarPanel gdmColorBarPanel;
    private float minValue = 0.0f;
    private float maxValue = 1.0f;
    private final int RECT_HEIGHT = 10;
    private final int RECT_WIDTH = 200;
    private int maxColorScaleTextWidth = 0;
    private int maxColorScaleTextHeight = 0;
    private int probes;
    private int headerWidth;
    private int headerHeight;
    private int gradientPanelWidth;
    private int gradientPanelHeight;
    private int labelPanelWidth;
    private int labelPanelHeight;
    private int colorBarWidth;
    private int colorBarHeight;
    private DecimalFormat decFormat;
    private boolean sortByGeneProximity = true;
    private ActionListener matrixListener;
    private int currentIndex = 0;

    public GDMGeneHeader(Insets insets, int n, boolean bl, Experiment experiment, int n2, int n3, Dimension dimension, int n4, int n5, int[] nArray) {
        this.setLayout(new BorderLayout());
        this.insets = new Insets(0, 0, 0, 0);
        this.tracespace = n;
        this.experiment = experiment;
        this.elementWidth = dimension.width;
        this.elementHeight = dimension.height;
        this.isColumnHeader = bl;
        this.contentWidth = n2;
        this.contentHeight = n3;
        this.indices = nArray;
        this.probes = experiment.getNumberOfGenes();
        this.num_genes = n5;
        this.maxGeneNameLength = n4 * this.elementWidth;
        this.gdmGradientLabelPanel = new GDMGeneGradientLabelPanel(insets, n, bl, experiment, n2, n3, dimension, n4, n5, nArray);
        this.gdmColorBarPanel = new GDMColorBarPanel();
        this.setFontSize(this.elementWidth);
        if (this.isColumnHeader) {
            this.add((Component)this.gdmGradientLabelPanel, "North");
            if (this.hasColorBar) {
                this.add((Component)this.gdmColorBarPanel, "Center");
            }
        } else {
            this.add((Component)this.gdmGradientLabelPanel, "West");
            if (this.hasColorBar) {
                this.add((Component)this.gdmColorBarPanel, "Center");
            }
        }
        this.decFormat = new DecimalFormat();
        this.decFormat.setMaximumFractionDigits(3);
        this.decFormat.setMinimumFractionDigits(1);
        Listener listener = new Listener();
        this.gdmGradientLabelPanel.getLabelPanel().addMouseListener(listener);
        this.gdmGradientLabelPanel.getLabelPanel().addMouseMotionListener(listener);
        this.setBackground(Color.white);
        this.setOpaque(true);
    }

    public void setLabelIndex(int n) {
        this.labelIndex = n;
        this.gdmGradientLabelPanel.setLabelIndex(n);
    }

    public void setMatrixListener(ActionListener actionListener) {
        this.matrixListener = actionListener;
    }

    public void setSortByGeneProximity(boolean bl) {
        this.sortByGeneProximity = bl;
    }

    public void updateSize(int n) {
        this.updateMaxGeneNameLength();
        int n2 = this.getMaxGeneNameLength();
        int n3 = 0;
        if (n == -1) {
            if (n2 < 1) {
                this.setAnnotationSize(1);
            } else if (n2 > 200) {
                this.setAnnotationSize(200);
            } else {
                this.setAnnotationSize(n2);
            }
        } else {
            this.setAnnotationSize(n);
        }
        if (this.showClusters) {
            boolean bl = this.areProbesColored();
            if (bl && !this.hasColorBar) {
                this.add((Component)this.gdmColorBarPanel, "Center");
                this.validate();
            } else if (!bl && this.hasColorBar) {
                this.remove(this.gdmColorBarPanel);
                this.validate();
            }
            this.hasColorBar = bl;
        } else {
            this.hasColorBar = false;
        }
        if (this.isColumnHeader) {
            this.gradientPanelWidth = this.headerWidth = this.contentWidth + this.elementWidth / 2;
            this.labelPanelWidth = this.headerWidth;
            this.colorBarWidth = this.headerWidth;
            this.colorBarHeight = 0;
        } else {
            this.gradientPanelHeight = this.headerHeight = this.contentHeight + this.elementHeight / 2;
            this.labelPanelHeight = this.headerHeight;
            this.colorBarWidth = 0;
            this.colorBarHeight = this.headerHeight;
        }
        Graphics2D graphics2D = (Graphics2D)this.getColorScaleGraphics();
        int n4 = 0;
        if (graphics2D != null) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            this.maxColorScaleTextHeight = fontMetrics.getHeight();
            float f = (this.minValue + this.maxValue) / 2.0f;
            String string = this.decFormat.format(this.minValue);
            String string2 = this.decFormat.format(this.maxValue);
            String string3 = this.decFormat.format(f);
            int n5 = fontMetrics.stringWidth(string);
            int n6 = fontMetrics.stringWidth(string2);
            int n7 = fontMetrics.stringWidth(string3);
            this.maxColorScaleTextWidth = Math.max(Math.max(n5, n6), n7);
            n4 = fontMetrics.getHeight();
        }
        n3 = Math.max(this.maxColorScaleTextWidth, this.maxColorScaleTextHeight);
        if (this.isColumnHeader) {
            this.gradientPanelHeight = 10 + n4 + 10;
            this.labelPanelHeight = this.annotationSize + 10;
            this.colorBarHeight = this.hasColorBar ? 5 + (this.elementHeight >= 10 ? this.elementHeight : 10) : 0;
            this.headerHeight = this.gradientPanelHeight + this.labelPanelHeight + this.colorBarHeight + 4;
            this.setSize(this.headerWidth, this.headerHeight);
            this.setPreferredSize(new Dimension(this.headerWidth, this.headerHeight));
        } else {
            this.gradientPanelWidth = 10 + this.maxColorScaleTextWidth + 10;
            this.labelPanelWidth = this.annotationSize + 10;
            this.colorBarWidth = this.hasColorBar ? 5 + (this.elementWidth >= 10 ? this.elementWidth : 10) : 0;
            this.headerWidth = this.gradientPanelWidth + this.labelPanelWidth + this.colorBarWidth + 4;
            this.setSize(this.headerWidth, this.headerHeight);
            this.setPreferredSize(new Dimension(this.headerWidth, this.headerHeight));
        }
        this.gdmGradientLabelPanel.updateSize();
        this.gdmColorBarPanel.updateSize();
        this.validate();
    }

    private Graphics getColorScaleGraphics() {
        return this.gdmGradientLabelPanel.getColorScaleGraphics();
    }

    private void updateMaxGeneNameLength() {
        Graphics2D graphics2D = (Graphics2D)this.gdmGradientLabelPanel.getLabelPanelGraphics();
        if (graphics2D == null) {
            return;
        }
        if (this.isAntiAliasing) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        String string = "";
        int n = 0;
        int[] nArray = this.getIndices();
        for (int i = 0; i < this.num_genes; ++i) {
            if (nArray != null) {
                if (this.labelIndex >= 0) {
                    string = this.expData.getElementAttribute(this.experiment.getGeneIndexMappedToData(nArray[i]), this.labelIndex);
                }
            } else if (this.labelIndex >= 0) {
                string = this.expData.getElementAttribute(this.experiment.getGeneIndexMappedToData(i), this.labelIndex);
            }
            n = Math.max(n, fontMetrics.stringWidth(string));
        }
        this.maxGeneNameLength = n;
    }

    private int getMaxGeneNameLength() {
        return this.maxGeneNameLength;
    }

    public void setNumGenes(int n) {
        this.num_genes = n;
        this.gdmGradientLabelPanel.setNumGenes(n);
    }

    public void setIndices(int[] nArray) {
        this.indices = nArray;
        this.gdmGradientLabelPanel.setIndices(nArray);
    }

    public int[] getIndices() {
        return this.indices;
    }

    public void setPosColorImages(BufferedImage bufferedImage) {
        this.gdmGradientLabelPanel.setPosColorImages(bufferedImage);
        this.gdmGradientLabelPanel.repaint();
    }

    public JScrollBar getVerticalScrollBar() {
        return this.gdmGradientLabelPanel.getVerticalScrollBar();
    }

    public JScrollBar getHorizontalScrollBar() {
        return this.gdmGradientLabelPanel.getHorizontalScrollBar();
    }

    public void setLeftInset(int n) {
        this.insets.left = n;
        this.setLeftInset(n);
        this.gdmGradientLabelPanel.setLeftInset(n);
    }

    public void setTopInset(int n) {
        this.insets.top = n;
        this.gdmGradientLabelPanel.setTopInset(n);
    }

    public void setData(IData iData) {
        this.expData = iData;
        this.gdmGradientLabelPanel.setData(iData);
    }

    public void setAntiAliasing(boolean bl) {
        this.isAntiAliasing = bl;
        this.gdmGradientLabelPanel.setAntiAliasing(bl);
    }

    void setElementWidth(int n) {
        this.elementWidth = n;
        this.setFontSize(n);
        this.gdmGradientLabelPanel.setElementWidth(n);
    }

    void setElementHeight(int n) {
        this.elementHeight = n;
        this.setFontSize(n);
        this.gdmGradientLabelPanel.setElementHeight(n);
    }

    int getElementWidth() {
        return this.elementWidth;
    }

    void setAnnotationSize(int n) {
        this.annotationSize = n;
        this.gdmGradientLabelPanel.setAnnotationSize(n);
    }

    void setContentWidth(int n) {
        this.contentWidth = n;
        this.gdmGradientLabelPanel.setContentWidth(n);
    }

    void setContentHeight(int n) {
        this.contentHeight = n;
        this.gdmGradientLabelPanel.setContentHeight(n);
    }

    void setTracing(boolean bl) {
        this.isTracing = bl;
        this.gdmGradientLabelPanel.setTracing(bl);
    }

    private int getSpacing() {
        if (this.isTracing) {
            return this.tracespace;
        }
        return 0;
    }

    private void setFontSize(int n) {
        if (n > 12) {
            n = 12;
        }
        this.setFont(new Font("monospaced", 0, n));
    }

    public void setValues(float f, float f2) {
        this.minValue = f;
        this.maxValue = f2;
        this.gdmGradientLabelPanel.setValues(f, f2);
    }

    public boolean areProbesColored() {
        if (this.indices == null) {
            return false;
        }
        for (int i = 0; i < this.indices.length; ++i) {
            if (this.expData.getProbeColor(this.experiment.getGeneIndexMappedToData(this.indices[i])) == null) continue;
            return true;
        }
        return false;
    }

    private void fireGDMSortEvent(int n) {
        ActionEvent actionEvent = new ActionEvent(this, n, "sort-by-gene-proximity-cmd");
        if (this.matrixListener != null) {
            this.matrixListener.actionPerformed(actionEvent);
        }
    }

    private class GDMColorBarPanel
    extends JPanel {
        public GDMColorBarPanel() {
            this.setBackground(Color.white);
            this.setSize(0, 0);
            this.setPreferredSize(new Dimension(0, 0));
            this.setOpaque(true);
        }

        private void setFontSize(int n) {
            if (n > 12) {
                n = 12;
            }
            this.setFont(new Font("monospaced", 0, n));
        }

        public void updateSize() {
            this.setSize(GDMGeneHeader.this.colorBarWidth, GDMGeneHeader.this.colorBarHeight);
            this.setPreferredSize(new Dimension(GDMGeneHeader.this.colorBarWidth, GDMGeneHeader.this.colorBarHeight));
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (!GDMGeneHeader.this.hasColorBar) {
                return;
            }
            if (GDMGeneHeader.this.expData == null) {
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (GDMGeneHeader.this.isAntiAliasing) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            if (GDMGeneHeader.this.isColumnHeader) {
                this.drawColumnColorBar(graphics2D);
            } else {
                this.drawRowColorBar(graphics2D);
            }
        }

        private void drawRowColorBar(Graphics2D graphics2D) {
            Rectangle rectangle = graphics2D.getClipBounds();
            int n = this.getTopIndex(rectangle.y);
            int n2 = 0;
            n2 = this.getBottomIndex(rectangle.y + rectangle.height, GDMGeneHeader.this.num_genes);
            for (int i = n; i < n2; ++i) {
                this.fillRowColorRectAt(graphics2D, 2, i);
            }
        }

        private void fillRowColorRectAt(Graphics graphics, int n, int n2) {
            Color color = null;
            color = GDMGeneHeader.this.expData.getProbeColor(GDMGeneHeader.this.experiment.getGeneIndexMappedToData(GDMGeneHeader.this.indices[n2]));
            if (color == null) {
                color = Color.white;
            }
            graphics.setColor(color);
            graphics.fillRect(n, n2 * GDMGeneHeader.this.elementHeight, GDMGeneHeader.this.colorBarWidth - 5, GDMGeneHeader.this.elementHeight);
        }

        private void drawColumnColorBar(Graphics2D graphics2D) {
            Rectangle rectangle = graphics2D.getClipBounds();
            int n = this.getLeftIndex(rectangle.x);
            int n2 = 0;
            n2 = this.getRightIndex(rectangle.x + rectangle.width, GDMGeneHeader.this.num_genes);
            for (int i = n; i < n2; ++i) {
                this.fillColumnColorRectAt(graphics2D, i, 2);
            }
        }

        private void fillColumnColorRectAt(Graphics graphics, int n, int n2) {
            Color color = null;
            color = GDMGeneHeader.this.expData.getProbeColor(GDMGeneHeader.this.experiment.getGeneIndexMappedToData(GDMGeneHeader.this.indices[n]));
            if (color == null) {
                color = Color.white;
            }
            graphics.setColor(color);
            graphics.fillRect(n * GDMGeneHeader.this.elementWidth, n2, GDMGeneHeader.this.elementWidth, GDMGeneHeader.this.colorBarHeight - 5);
        }

        private int getTopIndex(int n) {
            if (n < 0) {
                return 0;
            }
            return n / GDMGeneHeader.this.elementHeight;
        }

        private int getLeftIndex(int n) {
            if (n < 0) {
                return 0;
            }
            return n / (GDMGeneHeader.this.elementWidth + GDMGeneHeader.this.getSpacing());
        }

        private int getRightIndex(int n, int n2) {
            if (n < 0) {
                return 0;
            }
            int n3 = n / (GDMGeneHeader.this.elementWidth + GDMGeneHeader.this.getSpacing()) + 1;
            return n3 > n2 ? n2 : n3;
        }

        private int getBottomIndex(int n, int n2) {
            if (n < 0) {
                return 0;
            }
            int n3 = n / GDMGeneHeader.this.elementHeight + 1;
            return n3 > n2 ? n2 : n3;
        }
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener,
    MouseMotionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (GDMGeneHeader.this.sortByGeneProximity) {
                int n = 0;
                n = GDMGeneHeader.this.isColumnHeader ? mouseEvent.getX() : mouseEvent.getY();
                int n2 = (n - ((GDMGeneHeader)GDMGeneHeader.this).insets.left) / GDMGeneHeader.this.elementWidth;
                GDMGeneHeader.this.fireGDMSortEvent(GDMGeneHeader.this.indices[n2]);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (GDMGeneHeader.this.sortByGeneProximity) {
                int n;
                Graphics2D graphics2D = (Graphics2D)GDMGeneHeader.this.gdmGradientLabelPanel.getLabelPanelGraphics();
                if (graphics2D == null) {
                    return;
                }
                int n2 = mouseEvent.getX();
                int n3 = mouseEvent.getY();
                if (GDMGeneHeader.this.isColumnHeader) {
                    n = n2 / GDMGeneHeader.this.elementWidth;
                    if (n >= GDMGeneHeader.this.num_genes) {
                        GDMGeneHeader.this.repaint();
                        return;
                    }
                    if (n != GDMGeneHeader.this.currentIndex) {
                        graphics2D.setColor(Color.white);
                        graphics2D.drawRect(GDMGeneHeader.this.currentIndex * GDMGeneHeader.this.elementWidth, 0, GDMGeneHeader.this.elementWidth, GDMGeneHeader.this.gdmGradientLabelPanel.getLabelPanel().getHeight() - 1);
                    }
                    graphics2D.setColor(Color.blue);
                    graphics2D.drawRect(n * GDMGeneHeader.this.elementWidth, 0, GDMGeneHeader.this.elementWidth, GDMGeneHeader.this.gdmGradientLabelPanel.getLabelPanel().getHeight() - 1);
                } else {
                    n = n3 / GDMGeneHeader.this.elementWidth;
                    if (n >= GDMGeneHeader.this.num_genes) {
                        GDMGeneHeader.this.repaint();
                        return;
                    }
                    if (n != GDMGeneHeader.this.currentIndex) {
                        graphics2D.setColor(Color.white);
                        graphics2D.drawRect(0, GDMGeneHeader.this.currentIndex * GDMGeneHeader.this.elementWidth, GDMGeneHeader.this.gdmGradientLabelPanel.getLabelPanel().getWidth() - 1, GDMGeneHeader.this.elementHeight);
                    }
                    graphics2D.setColor(Color.blue);
                    graphics2D.drawRect(0, n * GDMGeneHeader.this.elementWidth, GDMGeneHeader.this.gdmGradientLabelPanel.getLabelPanel().getWidth() - 1, GDMGeneHeader.this.elementHeight);
                }
                GDMGeneHeader.this.currentIndex = n;
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            GDMGeneHeader.this.repaint();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }
    }
}

