/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gdm;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GDMColorSelectionDialog
extends JDialog {
    private ButtonGroup chanelSelectionGroup;
    private JPanel channelSelectionPanel;
    private JRadioButton minColorButton;
    private JRadioButton maxColorButton;
    private JPanel actionButtonPanel;
    private JButton okButton;
    private JButton cancelButton;
    private JColorChooser colorChooser;
    private JPanel gradientPreviewPanel;
    private Color maxColor = Color.red;
    private Color minColor = Color.black;
    private PreviewPanel previewer;
    private int result = 0;

    public GDMColorSelectionDialog(Frame frame, boolean bl, BufferedImage bufferedImage) {
        super(frame, bl);
        this.setTitle("Gene Distance Matrix Color Scheme Selection");
        this.previewer = new PreviewPanel(bufferedImage);
        this.initComponents();
        this.maxColorButton.setFocusPainted(false);
        this.minColorButton.setFocusPainted(false);
        this.colorChooser.setPreviewPanel(new JPanel());
        this.gradientPreviewPanel.add((Component)this.previewer, "Center");
        this.colorChooser.getSelectionModel().addChangeListener(this.previewer);
        this.setSize(450, 465);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GDMColorSelectionDialog.this.result = 0;
                GDMColorSelectionDialog.this.setVisible(false);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GDMColorSelectionDialog.this.result = 2;
                GDMColorSelectionDialog.this.setVisible(false);
            }
        });
    }

    private void initComponents() {
        this.chanelSelectionGroup = new ButtonGroup();
        this.channelSelectionPanel = new JPanel();
        this.minColorButton = new JRadioButton();
        this.maxColorButton = new JRadioButton();
        this.actionButtonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.colorChooser = new JColorChooser();
        this.colorChooser.setPreviewPanel(this.previewer);
        this.gradientPreviewPanel = new JPanel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setModal(true);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GDMColorSelectionDialog.this.closeDialog(windowEvent);
            }
        });
        this.channelSelectionPanel.setLayout(new GridBagLayout());
        this.minColorButton.setSelected(true);
        this.minColorButton.setText("Select Minimum Distance Color");
        this.chanelSelectionGroup.add(this.minColorButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.channelSelectionPanel.add((Component)this.minColorButton, gridBagConstraints);
        this.maxColorButton.setText("Select Maximum Distance Color");
        this.chanelSelectionGroup.add(this.maxColorButton);
        gridBagConstraints = new GridBagConstraints();
        this.channelSelectionPanel.add((Component)this.maxColorButton, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.fill = 2;
        this.getContentPane().add((Component)this.channelSelectionPanel, gridBagConstraints2);
        this.actionButtonPanel.setLayout(new GridBagLayout());
        this.okButton.setText(" Apply Color Scheme");
        this.okButton.setFocusPainted(false);
        this.okButton.setSelected(true);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.insets = new Insets(10, 0, 10, 10);
        this.actionButtonPanel.add((Component)this.okButton, gridBagConstraints3);
        this.cancelButton.setText("Cancel");
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.insets = new Insets(10, 10, 10, 0);
        this.actionButtonPanel.add((Component)this.cancelButton, gridBagConstraints3);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.fill = 1;
        this.getContentPane().add((Component)this.actionButtonPanel, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.fill = 1;
        this.getContentPane().add((Component)this.colorChooser, gridBagConstraints2);
        this.gradientPreviewPanel.setLayout(new BorderLayout());
        this.gradientPreviewPanel.setBorder(new TitledBorder(new EtchedBorder(), "Gradient Preview"));
        this.gradientPreviewPanel.setPreferredSize(new Dimension(200, 70));
        this.gradientPreviewPanel.setMinimumSize(new Dimension(200, 70));
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.fill = 1;
        this.getContentPane().add((Component)this.gradientPreviewPanel, gridBagConstraints2);
        this.pack();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public BufferedImage getPositiveGradient() {
        return this.previewer.getPositiveGradient();
    }

    public class PreviewPanel
    extends JPanel
    implements ChangeListener {
        BufferedImage currentPosGradient;

        public PreviewPanel(BufferedImage bufferedImage) {
            this.currentPosGradient = bufferedImage;
            GDMColorSelectionDialog.this.maxColor = new Color(bufferedImage.getRGB(bufferedImage.getWidth() - 1, 0));
            GDMColorSelectionDialog.this.minColor = new Color(bufferedImage.getRGB(0, 0));
            super.setBorder(new TitledBorder(new EtchedBorder(1), "Gradient Preview"));
            this.setSize(200, 70);
            this.setPreferredSize(new Dimension(200, 70));
            this.setVisible(true);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Color color = GDMColorSelectionDialog.this.colorChooser.getColor();
            if (color == null) {
                return;
            }
            if (GDMColorSelectionDialog.this.maxColorButton.isSelected()) {
                GDMColorSelectionDialog.this.maxColor = color;
            } else if (GDMColorSelectionDialog.this.minColorButton.isSelected()) {
                GDMColorSelectionDialog.this.minColor = color;
            }
            this.setPositiveGradient(this.createGradientImage(GDMColorSelectionDialog.this.minColor, GDMColorSelectionDialog.this.maxColor));
            this.repaint();
        }

        public void refreshPreview() {
            this.setPositiveGradient(this.createGradientImage(GDMColorSelectionDialog.this.minColor, GDMColorSelectionDialog.this.maxColor));
            this.repaint();
        }

        public void paint(Graphics graphics) {
            super.paintComponent(graphics);
            graphics.drawImage(this.currentPosGradient, 0, 0, this.getWidth(), this.getHeight(), null);
        }

        private BufferedImage createGradientImage(Color color, Color color2) {
            BufferedImage bufferedImage = new BufferedImage(256, 1, 5);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color, 255.0f, 0.0f, color2);
            graphics2D.setPaint(gradientPaint);
            graphics2D.drawRect(0, 0, 255, 1);
            return bufferedImage;
        }

        public BufferedImage getPositiveGradient() {
            return this.currentPosGradient;
        }

        public void setPositiveGradient(BufferedImage bufferedImage) {
            this.currentPosGradient = bufferedImage;
        }
    }
}

