/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gdm;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import org.tigr.microarray.mev.cluster.clusterUtil.Cluster;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterRepository;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterBrowser;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class GDMClusterBrowserDialog
extends AlgorithmDialog {
    private int result = 2;
    ClusterBrowser browser;
    Font font = new Font("Dialog", 1, 12);
    EventListener listener = new EventListener();

    public GDMClusterBrowserDialog(ClusterRepository clusterRepository) {
        super(new JFrame(), "GDM Cluster Selection", true);
        this.addWindowListener(this.listener);
        this.browser = new ClusterBrowser(clusterRepository);
        this.addContent((Component)this.browser);
        this.setActionListeners(this.listener);
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public Cluster getSelectedCluster() {
        return this.browser.getSelectedCluster();
    }

    private void resetControls() {
    }

    private class EventListener
    extends DialogListener
    implements ItemListener {
        private EventListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                GDMClusterBrowserDialog.this.result = 0;
                GDMClusterBrowserDialog.this.dispose();
            } else if (string.equals("cancel-command")) {
                GDMClusterBrowserDialog.this.result = 2;
                GDMClusterBrowserDialog.this.dispose();
            } else {
                if (string.equals("reset-command")) {
                    GDMClusterBrowserDialog.this.resetControls();
                    GDMClusterBrowserDialog.this.result = 2;
                    return;
                }
                if (string.equals("info-command")) {
                    HelpWindow helpWindow = new HelpWindow(GDMClusterBrowserDialog.this, "GDM Cluster Browser Dialog");
                    GDMClusterBrowserDialog.this.result = 2;
                    if (helpWindow.getWindowContent()) {
                        helpWindow.setSize(450, 600);
                        helpWindow.setLocation();
                        helpWindow.show();
                    } else {
                        helpWindow.setVisible(false);
                        helpWindow.dispose();
                    }
                }
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            GDMClusterBrowserDialog.this.result = -1;
            GDMClusterBrowserDialog.this.dispose();
        }
    }
}

