/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gdm;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GDMBorderColorDialog
extends JDialog {
    private JPanel defaultBlackPanel;
    private JPanel actionButtonPanel;
    private JButton okButton;
    private JButton cancelButton;
    private JColorChooser colorChooser;
    private JPanel gradientPreviewPanel;
    private JCheckBox defaultBlackCheckBox;
    private Color borderColor;
    private PreviewPanel previewer;
    private boolean defaultBlackSet;
    private int result = 0;

    public GDMBorderColorDialog(Frame frame, boolean bl, Color color) {
        super(frame, bl);
        this.setTitle("Border Color Scheme Selection");
        this.borderColor = color;
        this.previewer = new PreviewPanel(color);
        this.initComponents();
        this.colorChooser.setPreviewPanel(new JPanel());
        this.gradientPreviewPanel.add((Component)this.previewer, "Center");
        this.colorChooser.getSelectionModel().addChangeListener(this.previewer);
        this.setSize(450, 465);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GDMBorderColorDialog.this.result = 0;
                GDMBorderColorDialog.this.setVisible(false);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GDMBorderColorDialog.this.result = 2;
                GDMBorderColorDialog.this.setVisible(false);
            }
        });
        boolean bl2 = this.borderColor == Color.black;
        this.defaultBlackCheckBox = new JCheckBox("Black - default", bl2);
        this.defaultBlackCheckBox.setFocusPainted(false);
        this.defaultBlackCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GDMBorderColorDialog.this.defaultBlackCheckBox.isSelected()) {
                    GDMBorderColorDialog.this.borderColor = Color.black;
                    GDMBorderColorDialog.this.previewer.setColorGradient(GDMBorderColorDialog.this.previewer.createGradientImage(GDMBorderColorDialog.this.borderColor, GDMBorderColorDialog.this.borderColor));
                    GDMBorderColorDialog.this.repaint();
                } else {
                    GDMBorderColorDialog.this.defaultBlackSet = false;
                }
            }
        });
        this.defaultBlackPanel.add((Component)this.defaultBlackCheckBox, new GridBagConstraints(0, 1, 2, 0, 0.0, 0.0, 10, 2, new Insets(0, 50, 0, 0), 0, 0));
        this.defaultBlackPanel.validate();
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    private void initComponents() {
        this.defaultBlackPanel = new JPanel();
        this.actionButtonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.colorChooser = new JColorChooser();
        this.colorChooser.setPreviewPanel(this.previewer);
        this.gradientPreviewPanel = new JPanel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setModal(true);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GDMBorderColorDialog.this.closeDialog(windowEvent);
            }
        });
        this.defaultBlackPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.defaultBlackPanel, gridBagConstraints);
        this.actionButtonPanel.setLayout(new GridBagLayout());
        this.okButton.setText(" Apply Color Scheme");
        this.okButton.setFocusPainted(false);
        this.okButton.setSelected(true);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.insets = new Insets(10, 0, 10, 10);
        this.actionButtonPanel.add((Component)this.okButton, gridBagConstraints2);
        this.cancelButton.setText("Cancel");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.insets = new Insets(10, 10, 10, 0);
        this.actionButtonPanel.add((Component)this.cancelButton, gridBagConstraints2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.actionButtonPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.colorChooser, gridBagConstraints);
        this.gradientPreviewPanel.setLayout(new BorderLayout());
        this.gradientPreviewPanel.setBorder(new TitledBorder(new EtchedBorder(), "Gradient Preview"));
        this.gradientPreviewPanel.setPreferredSize(new Dimension(200, 70));
        this.gradientPreviewPanel.setMinimumSize(new Dimension(200, 70));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.gradientPreviewPanel, gridBagConstraints);
        this.pack();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public class PreviewPanel
    extends JPanel
    implements ChangeListener {
        BufferedImage currentColorGradient;

        public PreviewPanel(Color color) {
            GDMBorderColorDialog.this.borderColor = color;
            this.currentColorGradient = this.createGradientImage(GDMBorderColorDialog.this.borderColor, GDMBorderColorDialog.this.borderColor);
            super.setBorder(new TitledBorder(new EtchedBorder(1), "Gradient Preview"));
            this.setSize(200, 70);
            this.setPreferredSize(new Dimension(200, 70));
            this.setVisible(true);
        }

        void setColorGradient(BufferedImage bufferedImage) {
            this.currentColorGradient = bufferedImage;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Color color = GDMBorderColorDialog.this.colorChooser.getColor();
            if (color == null || GDMBorderColorDialog.this.borderColor == Color.black && GDMBorderColorDialog.this.defaultBlackSet) {
                return;
            }
            if (GDMBorderColorDialog.this.defaultBlackSet) {
                GDMBorderColorDialog.this.borderColor = Color.black;
            } else {
                GDMBorderColorDialog.this.borderColor = color;
            }
            this.setColorGradient(this.createGradientImage(GDMBorderColorDialog.this.borderColor, GDMBorderColorDialog.this.borderColor));
            this.repaint();
        }

        public void paint(Graphics graphics) {
            super.paintComponent(graphics);
            graphics.drawImage(this.currentColorGradient, 0, 0, this.getWidth() / 2, this.getHeight(), null);
            graphics.drawImage(this.currentColorGradient, this.getWidth() / 2, 0, this.getWidth() / 2, this.getHeight(), null);
        }

        private BufferedImage createGradientImage(Color color, Color color2) {
            BufferedImage bufferedImage = new BufferedImage(256, 1, 5);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color, 255.0f, 0.0f, color2);
            graphics2D.setPaint(gradientPaint);
            graphics2D.drawRect(0, 0, 255, 1);
            return bufferedImage;
        }
    }
}

