/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.fom;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.fom.CastFOMViewerA;
import org.tigr.microarray.mev.cluster.gui.impl.fom.CastFOMViewerB;
import org.tigr.microarray.mev.cluster.gui.impl.fom.FOMInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.fom.KFOMViewer;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;
import org.tigr.util.FloatMatrix;

public class FOMGUI
implements IClusterGUI,
IScriptGUI {
    private Algorithm algorithm;
    private Progress progress;
    private boolean clusterGenes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework iFramework) throws AlgorithmException {
        DefaultMutableTreeNode defaultMutableTreeNode;
        block15: {
            GeneralInfo generalInfo;
            Object object;
            float[] fArray;
            Listener listener;
            float f;
            block13: {
                DefaultMutableTreeNode defaultMutableTreeNode2;
                block14: {
                    FOMInitDialog fOMInitDialog = new FOMInitDialog((JFrame)iFramework.getFrame(), true);
                    fOMInitDialog.setVisible(true);
                    if (!fOMInitDialog.isOkPressed()) {
                        return null;
                    }
                    int n = fOMInitDialog.getFOMIterations();
                    int n2 = fOMInitDialog.getMethod();
                    f = fOMInitDialog.getInterval();
                    int n3 = fOMInitDialog.getIterations();
                    int n4 = fOMInitDialog.getKMCIterations();
                    boolean bl = fOMInitDialog.isAverage();
                    boolean bl2 = fOMInitDialog.useMeans();
                    this.clusterGenes = fOMInitDialog.isClusterGenes();
                    Experiment experiment = iFramework.getData().getExperiment();
                    listener = new Listener();
                    try {
                        this.algorithm = iFramework.getAlgorithmFactory().getAlgorithm("FOM");
                        this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
                        int n5 = experiment.getNumberOfGenes();
                        this.progress = new Progress(iFramework.getFrame(), "Calculating FOM values", listener);
                        this.progress.show();
                        AlgorithmData algorithmData = new AlgorithmData();
                        FloatMatrix floatMatrix = experiment.getMatrix();
                        if (!this.clusterGenes) {
                            floatMatrix = floatMatrix.transpose();
                        }
                        algorithmData.addMatrix("experiment", floatMatrix);
                        algorithmData.addParam("distance-factor", String.valueOf(1.0f));
                        IDistanceMenu iDistanceMenu = iFramework.getDistanceMenu();
                        algorithmData.addParam("distance-absolute", String.valueOf(iDistanceMenu.isAbsoluteDistance()));
                        int n6 = iDistanceMenu.getDistanceFunction();
                        if (n6 == 0) {
                            n6 = 4;
                        }
                        algorithmData.addParam("distance-function", String.valueOf(n6));
                        if (n2 != 2) {
                            n = 1;
                        }
                        algorithmData.addParam("fom-iterations", String.valueOf(n));
                        algorithmData.addParam("method", String.valueOf(n2));
                        algorithmData.addParam("cluster-genes", String.valueOf(this.clusterGenes));
                        algorithmData.addParam("number-of-clusters", String.valueOf(n3));
                        algorithmData.addParam("interval", String.valueOf(f));
                        algorithmData.addParam("iterations", String.valueOf(n4));
                        algorithmData.addParam("average", String.valueOf(bl));
                        algorithmData.addParam("calculate-means", String.valueOf(bl2));
                        long l = System.currentTimeMillis();
                        AlgorithmData algorithmData2 = this.algorithm.execute(algorithmData);
                        long l2 = System.currentTimeMillis() - l;
                        fArray = null;
                        if (n2 != 2 && (object = algorithmData2.getMatrix("fom-values")) != null) {
                            fArray = object.A[0];
                        }
                        object = algorithmData2.getIntArray("numOfCastClusters");
                        generalInfo = new GeneralInfo();
                        generalInfo.fomIterations = n;
                        generalInfo.average = bl;
                        generalInfo.function = iDistanceMenu.getFunctionName(n6);
                        generalInfo.interval = f;
                        generalInfo.iterations = n4;
                        generalInfo.method = n2;
                        if (n2 == 2) {
                            generalInfo.kMeansOrKMedians = bl2 ? "Calculated Means" : "Calculated Medians";
                        }
                        generalInfo.time = l2;
                        if (n2 != 2) break block13;
                        FloatMatrix floatMatrix2 = algorithmData2.getMatrix("fom-matrix");
                        float[] fArray2 = this.getMeans(floatMatrix2);
                        float[] fArray3 = null;
                        if (floatMatrix2 != null && floatMatrix2.getRowDimension() > 1) {
                            fArray3 = this.getVariances(floatMatrix2, fArray2);
                        }
                        defaultMutableTreeNode2 = this.createResultTree(fArray2, fArray3, floatMatrix2.A, generalInfo, f, (int[])object);
                        Object var30_28 = null;
                        if (this.algorithm == null) break block14;
                    }
                    catch (Throwable throwable) {
                        block16: {
                            Object var30_30 = null;
                            if (this.algorithm != null) {
                                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
                            }
                            if (this.progress == null) break block16;
                            this.progress.dispose();
                        }
                        throw throwable;
                    }
                    this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
                }
                if (this.progress != null) {
                    this.progress.dispose();
                }
                return defaultMutableTreeNode2;
            }
            defaultMutableTreeNode = this.createResultTree(fArray, null, null, generalInfo, f, (int[])object);
            Object var30_29 = null;
            if (this.algorithm == null) break block15;
            this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
        }
        if (this.progress != null) {
            this.progress.dispose();
        }
        return defaultMutableTreeNode;
    }

    public AlgorithmData getScriptParameters(IFramework iFramework) {
        FOMInitDialog fOMInitDialog = new FOMInitDialog((JFrame)iFramework.getFrame(), true);
        fOMInitDialog.setVisible(true);
        if (!fOMInitDialog.isOkPressed()) {
            return null;
        }
        int n = fOMInitDialog.getFOMIterations();
        int n2 = fOMInitDialog.getMethod();
        float f = fOMInitDialog.getInterval();
        int n3 = fOMInitDialog.getIterations();
        int n4 = fOMInitDialog.getKMCIterations();
        boolean bl = fOMInitDialog.isAverage();
        boolean bl2 = fOMInitDialog.useMeans();
        this.clusterGenes = fOMInitDialog.isClusterGenes();
        Experiment experiment = iFramework.getData().getExperiment();
        int n5 = experiment.getNumberOfGenes();
        AlgorithmData algorithmData = new AlgorithmData();
        algorithmData.addParam("distance-factor", String.valueOf(1.0f));
        IDistanceMenu iDistanceMenu = iFramework.getDistanceMenu();
        algorithmData.addParam("distance-absolute", String.valueOf(iDistanceMenu.isAbsoluteDistance()));
        int n6 = iDistanceMenu.getDistanceFunction();
        if (n6 == 0) {
            n6 = 4;
        }
        algorithmData.addParam("distance-function", String.valueOf(n6));
        if (n2 != 2) {
            n = 1;
        }
        algorithmData.addParam("fom-iterations", String.valueOf(n));
        algorithmData.addParam("method", String.valueOf(n2));
        algorithmData.addParam("cluster-genes", String.valueOf(this.clusterGenes));
        algorithmData.addParam("number-of-clusters", String.valueOf(n3));
        algorithmData.addParam("interval", String.valueOf(f));
        algorithmData.addParam("iterations", String.valueOf(n4));
        algorithmData.addParam("average", String.valueOf(bl));
        algorithmData.addParam("calculate-means", String.valueOf(bl2));
        algorithmData.addParam("name", "FOM");
        algorithmData.addParam("alg-type", "cluster");
        algorithmData.addParam("output-class", "single-output");
        String[] stringArray = new String[]{"FOM Result"};
        algorithmData.addStringArray("output-nodes", stringArray);
        return algorithmData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode executeScript(IFramework iFramework, AlgorithmData algorithmData, Experiment experiment) throws AlgorithmException {
        DefaultMutableTreeNode defaultMutableTreeNode;
        block13: {
            GeneralInfo generalInfo;
            Object object;
            float[] fArray;
            Listener listener;
            float f;
            block11: {
                DefaultMutableTreeNode defaultMutableTreeNode2;
                block12: {
                    AlgorithmParameters algorithmParameters = algorithmData.getParams();
                    this.clusterGenes = algorithmParameters.getBoolean("cluster-genes");
                    int n = algorithmParameters.getInt("method");
                    f = algorithmParameters.getFloat("interval");
                    boolean bl = true;
                    if (n == 2) {
                        bl = algorithmParameters.getBoolean("calculate-means");
                    }
                    listener = new Listener();
                    try {
                        this.algorithm = iFramework.getAlgorithmFactory().getAlgorithm("FOM");
                        this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
                        int n2 = experiment.getNumberOfGenes();
                        this.progress = new Progress(iFramework.getFrame(), "Calculating FOM values", listener);
                        this.progress.show();
                        AlgorithmData algorithmData2 = new AlgorithmData();
                        FloatMatrix floatMatrix = experiment.getMatrix();
                        if (!this.clusterGenes) {
                            floatMatrix = floatMatrix.transpose();
                        }
                        algorithmData.addMatrix("experiment", floatMatrix);
                        long l = System.currentTimeMillis();
                        AlgorithmData algorithmData3 = this.algorithm.execute(algorithmData);
                        long l2 = System.currentTimeMillis() - l;
                        fArray = null;
                        if (n != 2 && (object = algorithmData3.getMatrix("fom-values")) != null) {
                            fArray = object.A[0];
                        }
                        object = algorithmData3.getIntArray("numOfCastClusters");
                        generalInfo = new GeneralInfo();
                        generalInfo.fomIterations = algorithmParameters.getInt("fom-iterations");
                        generalInfo.average = algorithmParameters.getBoolean("average");
                        int n3 = algorithmParameters.getInt("distance-function");
                        generalInfo.function = iFramework.getDistanceMenu().getFunctionName(n3);
                        generalInfo.interval = algorithmParameters.getFloat("interval");
                        generalInfo.iterations = algorithmParameters.getInt("iterations");
                        generalInfo.method = n;
                        if (n == 2) {
                            generalInfo.kMeansOrKMedians = bl ? "Calculated Means" : "Calculated Medians";
                        }
                        generalInfo.time = l2;
                        if (n != 2) break block11;
                        FloatMatrix floatMatrix2 = algorithmData3.getMatrix("fom-matrix");
                        float[] fArray2 = this.getMeans(floatMatrix2);
                        float[] fArray3 = null;
                        if (floatMatrix2 != null && floatMatrix2.getRowDimension() > 1) {
                            fArray3 = this.getVariances(floatMatrix2, fArray2);
                        }
                        defaultMutableTreeNode2 = this.createResultTree(fArray2, fArray3, floatMatrix2.A, generalInfo, f, (int[])object);
                        Object var26_24 = null;
                        if (this.algorithm == null) break block12;
                    }
                    catch (Throwable throwable) {
                        block14: {
                            Object var26_26 = null;
                            if (this.algorithm != null) {
                                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
                            }
                            if (this.progress == null) break block14;
                            this.progress.dispose();
                        }
                        throw throwable;
                    }
                    this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
                }
                if (this.progress != null) {
                    this.progress.dispose();
                }
                return defaultMutableTreeNode2;
            }
            defaultMutableTreeNode = this.createResultTree(fArray, null, null, generalInfo, f, (int[])object);
            Object var26_25 = null;
            if (this.algorithm == null) break block13;
            this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
        }
        if (this.progress != null) {
            this.progress.dispose();
        }
        return defaultMutableTreeNode;
    }

    private DefaultMutableTreeNode createResultTree(float[] fArray, float[] fArray2, float[][] fArray3, GeneralInfo generalInfo, float f, int[] nArray) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.clusterGenes ? new DefaultMutableTreeNode("FOM - genes") : new DefaultMutableTreeNode("FOM - samples");
        this.addResultNodes(defaultMutableTreeNode, fArray, fArray2, fArray3, generalInfo, f, nArray);
        return defaultMutableTreeNode;
    }

    private void addResultNodes(DefaultMutableTreeNode defaultMutableTreeNode, float[] fArray, float[] fArray2, float[][] fArray3, GeneralInfo generalInfo, float f, int[] nArray) {
        this.addGraphViewer(defaultMutableTreeNode, fArray, fArray2, fArray3, generalInfo, f, nArray);
        this.addGeneralInfo(defaultMutableTreeNode, generalInfo);
    }

    private void addGraphViewer(DefaultMutableTreeNode defaultMutableTreeNode, float[] fArray, float[] fArray2, float[][] fArray3, GeneralInfo generalInfo, float f, int[] nArray) {
        ViewerAdapter viewerAdapter = null;
        if (generalInfo.method == 2) {
            viewerAdapter = new KFOMViewer(fArray, fArray2);
            if (fArray2 != null && fArray3 != null) {
                ((KFOMViewer)viewerAdapter).setFOMIterationValues(fArray3);
            }
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("Graph - FOM value vs. # of Clusters", (IViewer)viewerAdapter)));
        } else {
            viewerAdapter = new CastFOMViewerA(fArray, f, nArray);
            CastFOMViewerB castFOMViewerB = new CastFOMViewerB(fArray, f, nArray);
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("Graph - FOM value vs. Threshold", (IViewer)viewerAdapter)));
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("Graph - FOM value vs. # of Clusters", (IViewer)castFOMViewerB)));
        }
    }

    private void addGeneralInfo(DefaultMutableTreeNode defaultMutableTreeNode, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("General Information");
        if (generalInfo.method == 1) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Method: " + generalInfo.getMethod()));
        }
        if (generalInfo.method == 2) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Method: " + generalInfo.getMethod() + " : " + generalInfo.kMeansOrKMedians));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("FOM Iterations: " + String.valueOf(generalInfo.fomIterations)));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Max KMC Iterations: " + String.valueOf(generalInfo.iterations)));
        } else {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Interval: " + String.valueOf(generalInfo.interval)));
        }
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Average: " + String.valueOf(generalInfo.average)));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Time: " + String.valueOf(generalInfo.time) + " ms"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(generalInfo.function));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private float[] getMeans(FloatMatrix floatMatrix) {
        int n = floatMatrix.getColumnDimension();
        int n2 = floatMatrix.getRowDimension();
        float[] fArray = new float[n];
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < n; ++i) {
            f2 = 0.0f;
            f = 0.0f;
            for (int j = 0; j < n2; ++j) {
                float f3 = floatMatrix.get(j, i);
                if (Float.isNaN(f3)) continue;
                f += f3;
                f2 += 1.0f;
            }
            fArray[i] = f2 > 0.0f ? f / f2 : Float.NaN;
        }
        return fArray;
    }

    private float[] getVariances(FloatMatrix floatMatrix, float[] fArray) {
        int n = floatMatrix.getRowDimension();
        int n2 = floatMatrix.getColumnDimension();
        float[] fArray2 = new float[n2];
        if (n == 1) {
            return fArray2;
        }
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n3 = i;
                fArray2[n3] = (float)((double)fArray2[n3] + Math.pow(floatMatrix.A[j][i] - fArray[i], 2.0));
            }
            fArray2[i] = (float)Math.sqrt(fArray2[i] / (float)(n - 1));
        }
        return fArray2;
    }

    private class GeneralInfo {
        public int method;
        public String kMeansOrKMedians;
        public float interval;
        public int iterations;
        public boolean average;
        public long time;
        public String function;
        public int fomIterations;

        private GeneralInfo() {
        }

        public String getMethod() {
            return this.method == 1 ? "CAST" : "KMC";
        }
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent algorithmEvent) {
            switch (algorithmEvent.getId()) {
                case 1: {
                    FOMGUI.this.progress.setUnits(algorithmEvent.getIntValue());
                    FOMGUI.this.progress.setDescription(algorithmEvent.getDescription());
                    break;
                }
                case 2: {
                    FOMGUI.this.progress.setValue(algorithmEvent.getIntValue());
                    FOMGUI.this.progress.setDescription(algorithmEvent.getDescription());
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("cancel-command")) {
                FOMGUI.this.algorithm.abort();
                FOMGUI.this.progress.dispose();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            FOMGUI.this.algorithm.abort();
            FOMGUI.this.progress.dispose();
        }
    }
}

