/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.fom;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.fom.FOMGraph;

public class CastFOMContentComponentA
extends JPanel
implements Serializable {
    public static final long serialVersionUID = 202003020001L;
    private FOMGraph fomGraphA;
    private FOMGraph fomGraphB;
    private float[] fom_values;
    float interval;

    public CastFOMContentComponentA(float[] fArray, float f, int[] nArray) {
        this.setLayout(new GridBagLayout());
        this.fom_values = fArray;
        this.interval = f;
        this.fomGraphA = new FOMGraph(fArray, null, "FOM value vs. Threshold", "Threshold", "Adjusted FOM", false);
        this.fomGraphA.setItems(this.createXThresholdItems(fArray.length), this.createYItems(fArray));
        this.fomGraphA.setMaxYValue((float)Math.ceil(this.getMaxValue(fArray)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.9;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.fomGraphA, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.1;
        this.add((Component)this.createValuesList(fArray), gridBagConstraints);
    }

    public BufferedImage getImageA() {
        return this.fomGraphA.getImage();
    }

    public BufferedImage getImageB() {
        return this.fomGraphB.getImage();
    }

    private JComponent createValuesList(float[] fArray) {
        Object object;
        String[] stringArray = new String[fArray.length];
        float f = this.interval;
        for (int i = 0; i < fArray.length; ++i) {
            object = "0.";
            int n = (int)Math.floor(f * 100.0f);
            if (n < 10) {
                object = (String)object + "0";
            }
            object = (String)object + n;
            if (n >= 100) {
                object = "1.00";
            }
            f += this.interval;
            stringArray[i] = (String)object + "---->" + String.valueOf((float)Math.round(fArray[i] * 1000.0f) / 1000.0f);
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        object = new JScrollPane(new JList<String>(stringArray));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)object, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.0;
        JButton jButton = new JButton("Details");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CastFOMContentComponentA.this.onDetails();
            }
        });
        jPanel.add((Component)jButton, gridBagConstraints);
        return jPanel;
    }

    private void onDetails() {
        JFrame jFrame = new JFrame("Details");
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        StringBuffer stringBuffer = new StringBuffer();
        float f = this.interval;
        for (int i = 0; i < this.fom_values.length; ++i) {
            String string = "0.";
            int n = (int)Math.floor(f * 100.0f);
            if (n < 10) {
                string = string + "0";
            }
            string = string + n;
            if (n >= 100) {
                string = "1.00";
            }
            f += this.interval;
            stringBuffer.append(string + "\t" + String.valueOf((float)Math.round(this.fom_values[i] * 1000.0f) / 1000.0f) + "\n");
        }
        jTextArea.setText(stringBuffer.toString());
        jTextArea.setCaretPosition(0);
        jFrame.getContentPane().add(jScrollPane);
        jFrame.setSize(200, 200);
        Dimension dimension = jFrame.getToolkit().getScreenSize();
        jFrame.setLocation(dimension.width / 2 - jFrame.getSize().width / 2, dimension.height / 2 - jFrame.getSize().height / 2);
        jFrame.setVisible(true);
    }

    public void onSelected(IFramework iFramework) {
        this.fomGraphA.setAntiAliasing(iFramework.getDisplayMenu().isAntiAliasing());
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
        this.fomGraphA.setAntiAliasing(iDisplayMenu.isAntiAliasing());
    }

    private String[] createXItems(int n) {
        String[] stringArray = new String[n];
        for (int i = 0; i < stringArray.length; ++i) {
            if ((i + 1) % 5 != 0 && i != 0 && i != stringArray.length - 1) continue;
            stringArray[i] = String.valueOf(i + 1);
        }
        return stringArray;
    }

    private String[] createXThresholdItems(int n) {
        String[] stringArray = new String[n];
        float f = this.interval;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = "0.";
            int n2 = (int)Math.floor(f * 100.0f);
            if (n2 < 10) {
                string = string + "0";
            }
            string = string + n2;
            if (n2 >= 100) {
                string = "1.00";
            }
            stringArray[i] = string;
            f += this.interval;
        }
        return stringArray;
    }

    private float getMaxValue(float[] fArray) {
        float f = -3.4028235E38f;
        for (int i = 0; i < fArray.length; ++i) {
            f = Math.max(f, fArray[i]);
        }
        return f;
    }

    private String[] createYItems(float[] fArray) {
        int n = (int)Math.ceil(this.getMaxValue(fArray)) + 1;
        String[] stringArray = new String[n];
        for (int i = 0; i < stringArray.length; ++i) {
            if (i % 2 != 0 && i != stringArray.length - 1) continue;
            stringArray[i] = String.valueOf(i);
        }
        return stringArray;
    }
}

