/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.dialogs.normalization;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class LinRegNormInitDialog
extends AlgorithmDialog {
    private JComboBox sdComboBox;
    JRadioButton blockButton;
    JRadioButton globalButton;
    private int result = 2;
    private final String[] SD_VALUES = new String[]{"+/-0.50 SD", "+/-1.00 SD", "+/-1.50 SD", "+/-1.96 SD", "+/-2.00 SD", "+/-2.50 SD", "+/-3.00 SD"};

    public LinRegNormInitDialog() {
        super(new JFrame(), "Iterative Linear Regression", true);
        this.blockButton = new JRadioButton("Block Mode", true);
        this.blockButton.setFocusPainted(false);
        this.blockButton.setBackground(Color.white);
        this.blockButton.setHorizontalAlignment(0);
        this.globalButton = new JRadioButton("Global Mode");
        this.globalButton.setFocusPainted(false);
        this.globalButton.setBackground(Color.white);
        this.globalButton.setHorizontalAlignment(0);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.blockButton);
        buttonGroup.add(this.globalButton);
        this.sdComboBox = new JComboBox<String>(this.SD_VALUES);
        this.sdComboBox.setEditable(false);
        this.sdComboBox.setSelectedIndex(4);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(Color.white);
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Normalization Parameters"));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBackground(Color.white);
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Normalization Mode"));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBackground(Color.white);
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Standard Deviation Range"));
        jPanel2.add((Component)this.blockButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(15, 0, 15, 0), 0, 0));
        jPanel2.add((Component)this.globalButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(15, 0, 15, 0), 0, 0));
        jPanel3.add((Component)this.sdComboBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(20, 0, 20, 0), 0, 0));
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jPanel3, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addContent(jPanel);
        this.setActionListeners(new Listener());
        this.setSize(new Dimension(450, 350));
        this.setResizable(false);
        this.pack();
    }

    public float getSD() {
        float f = 0.0f;
        String string = (String)this.sdComboBox.getSelectedItem();
        string = string.substring(3, 7);
        try {
            f = Float.parseFloat(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f;
    }

    public String getMode() {
        if (this.blockButton.isSelected()) {
            return "block";
        }
        return "global";
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        this.dispose();
        return this.result;
    }

    public static void main(String[] stringArray) {
        LinRegNormInitDialog linRegNormInitDialog = new LinRegNormInitDialog();
        linRegNormInitDialog.showModal();
        System.exit(0);
    }

    public class Listener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                LinRegNormInitDialog.this.result = 0;
                LinRegNormInitDialog.this.dispose();
            } else if (string.equals("reset-command")) {
                LinRegNormInitDialog.this.blockButton.setSelected(true);
                LinRegNormInitDialog.this.sdComboBox.setSelectedIndex(4);
            } else if (string.equals("cancel-command")) {
                LinRegNormInitDialog.this.result = 2;
                LinRegNormInitDialog.this.dispose();
            } else if (string.equals("info-command")) {
                HelpWindow helpWindow = new HelpWindow(LinRegNormInitDialog.this, "Linear Regression Initialization Dialog");
                if (helpWindow.getWindowContent()) {
                    helpWindow.setSize(450, 550);
                    helpWindow.setLocation();
                    helpWindow.show();
                } else {
                    helpWindow.setVisible(false);
                    helpWindow.dispose();
                }
            }
        }
    }
}

