/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.dam;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EtchedBorder;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;

public class DAMSecondDialog
extends AlgorithmDialog {
    boolean okPressed = false;
    JRadioButton stopButton;
    JRadioButton continueButton;

    public DAMSecondDialog(JFrame jFrame, boolean bl) {
        super(jFrame, "DAM classify - continue with analysis?", bl);
        this.setBounds(0, 0, 500, 200);
        this.setBackground(Color.white);
        this.setDefaultCloseOperation(2);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setBorder(new EtchedBorder());
        jPanel.setLayout(gridBagLayout);
        this.stopButton = new JRadioButton("Stop here, don't classify", true);
        this.stopButton.setBackground(Color.white);
        this.continueButton = new JRadioButton("Proceed with classification", false);
        this.continueButton.setBackground(Color.white);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.stopButton);
        buttonGroup.add(this.continueButton);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 50);
        gridBagLayout.setConstraints(this.stopButton, gridBagConstraints);
        jPanel.add(this.stopButton);
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 0, 50);
        gridBagLayout.setConstraints(this.continueButton, gridBagConstraints);
        jPanel.add(this.continueButton);
        this.addContent(jPanel);
        EventListener eventListener = new EventListener();
        this.setActionListeners(eventListener);
        this.addWindowListener(eventListener);
    }

    public void setVisible(boolean bl) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        super.setVisible(bl);
    }

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public boolean proceed() {
        return this.continueButton.isSelected();
    }

    public class EventListener
    extends WindowAdapter
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                DAMSecondDialog.this.okPressed = true;
                DAMSecondDialog.this.dispose();
            } else if (string.equals("reset-command")) {
                DAMSecondDialog.this.okPressed = false;
                DAMSecondDialog.this.stopButton.setSelected(true);
                DAMSecondDialog.this.continueButton.setSelected(false);
            } else if (string.equals("cancel-command")) {
                DAMSecondDialog.this.okPressed = false;
                DAMSecondDialog.this.dispose();
            } else if (string.equals("info-command")) {
                // empty if block
            }
        }
    }
}

