/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.dam;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;
import org.tigr.microarray.mev.cluster.gui.impl.dam.Content3D;
import org.tigr.microarray.mev.cluster.gui.impl.dam.DAMResultConfigDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dam.DAMSelectionAreaDialog;
import org.tigr.util.FloatMatrix;

public class DAM3DViewer
extends ViewerAdapter {
    private static final String RESET_CMD = "reset-cmd";
    private static final String OPTIONS_CMD = "options-cmd";
    private static final String SELECTION_AREA_CMD = "select-cmd";
    private static final String SAVE_CMD = "save-cmd";
    private static final String SHOW_SELECTION_CMD = "show-selection-cmd";
    private static final String HIDE_SELECTION_BOX_CMD = "hide-selection-box-cmd";
    private static final String SHOW_SPHERES_CMD = "show-spheres-cmd";
    private static final String SHOW_TEXT_CMD = "show-text-cmd";
    private static final String WHITE_CMD = "white-cmd";
    private static final String STORE_CLUSTER_CMD = "store-cluster-cmd";
    private static final String LAUNCH_NEW_SESSION_CMD = "launch-new-session-cmd";
    private IData data;
    private Experiment experiment;
    private Content3D content;
    private JPopupMenu popup;
    private Frame frame;
    private boolean geneViewer;
    private IFramework framework;

    public DAM3DViewer(Frame frame, int n, FloatMatrix floatMatrix, Experiment experiment, boolean bl) {
        this.frame = frame;
        this.experiment = experiment;
        this.geneViewer = bl;
        this.content = this.createContent(n, floatMatrix, experiment, bl);
        this.popup = this.createJPopupMenu();
    }

    public void onSelected(IFramework iFramework) {
        this.framework = iFramework;
        this.data = iFramework.getData();
        this.content.setData(this.data);
        this.content.updateScene();
    }

    public void onDataChanged(IData iData) {
        this.data = iData;
        this.content.setData(iData);
        this.content.updateScene();
    }

    public JComponent getContentComponent() {
        return this.content;
    }

    public BufferedImage getImage() {
        return this.content.createImage();
    }

    private Content3D createContent(int n, FloatMatrix floatMatrix, Experiment experiment, boolean bl) {
        return new Content3D(n, floatMatrix, experiment, bl);
    }

    public JPopupMenu getJPopupMenu() {
        return this.popup;
    }

    private JPopupMenu createJPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.addMenuItems(jPopupMenu);
        return jPopupMenu;
    }

    private void addMenuItems(JPopupMenu jPopupMenu) {
        Listener listener = new Listener();
        JMenuItem jMenuItem = new JMenuItem("Reset", GUIFactory.getIcon("refresh16.gif"));
        jMenuItem.setActionCommand(RESET_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Options...", GUIFactory.getIcon("edit16.gif"));
        jMenuItem.setActionCommand(OPTIONS_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Selection area...", GUIFactory.getIcon("edit16.gif"));
        jMenuItem.setEnabled(false);
        jMenuItem.setActionCommand(SELECTION_AREA_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Store cluster...", GUIFactory.getIcon("new16.gif"));
        jMenuItem.setEnabled(false);
        jMenuItem.setActionCommand(STORE_CLUSTER_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Launch new session", GUIFactory.getIcon("launch_new_mav.gif"));
        jMenuItem.setEnabled(false);
        jMenuItem.setActionCommand(LAUNCH_NEW_SESSION_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save cluster...", GUIFactory.getIcon("save16.gif"));
        jMenuItem.setEnabled(false);
        jMenuItem.setActionCommand(SAVE_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JCheckBoxMenuItem("Show selection area");
        jMenuItem.setActionCommand(SHOW_SELECTION_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JCheckBoxMenuItem("Hide selection box");
        jMenuItem.setEnabled(false);
        jMenuItem.setActionCommand(HIDE_SELECTION_BOX_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JCheckBoxMenuItem("Show spheres");
        jMenuItem.setActionCommand(SHOW_SPHERES_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JCheckBoxMenuItem("Show text");
        jMenuItem.setEnabled(true);
        jMenuItem.setActionCommand(SHOW_TEXT_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JCheckBoxMenuItem("White background");
        jMenuItem.setActionCommand(WHITE_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
    }

    private JMenuItem getJMenuItem(String string) {
        Component[] componentArray = this.popup.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JMenuItem) || !((JMenuItem)componentArray[i]).getActionCommand().equals(string)) continue;
            return (JMenuItem)componentArray[i];
        }
        return null;
    }

    private void setEnableMenuItem(String string, boolean bl) {
        JMenuItem jMenuItem = this.getJMenuItem(string);
        if (jMenuItem == null) {
            return;
        }
        jMenuItem.setEnabled(bl);
    }

    private void onReset() {
        this.content.reset();
    }

    private void onOptions() {
        DAMResultConfigDialog dAMResultConfigDialog = new DAMResultConfigDialog(this.frame, this.content.getPointSize(), this.content.getSelectedPointSize(), this.content.getScaleAxisX(), this.content.getScaleAxisY(), this.content.getScaleAxisZ());
        if (dAMResultConfigDialog.showModal() == 0) {
            this.content.setPointSize(dAMResultConfigDialog.getPointSize());
            this.content.setSelectedPointSize(dAMResultConfigDialog.getSelectedPointSize());
            this.content.setScale(dAMResultConfigDialog.getScaleAxisX(), dAMResultConfigDialog.getScaleAxisY(), dAMResultConfigDialog.getScaleAxisZ());
            this.content.updateScene();
        }
    }

    private void onSelectionArea() {
        DAMSelectionAreaDialog dAMSelectionAreaDialog = new DAMSelectionAreaDialog(this.frame, this.content.getPositionX(), this.content.getPositionY(), this.content.getPositionZ(), this.content.getSizeX(), this.content.getSizeY(), this.content.getSizeZ());
        if (dAMSelectionAreaDialog.showModal() == 0) {
            this.content.setBoxPosition(dAMSelectionAreaDialog.getPositionX(), dAMSelectionAreaDialog.getPositionY(), dAMSelectionAreaDialog.getPositionZ());
            this.content.setBoxSize(dAMSelectionAreaDialog.getSizeX(), dAMSelectionAreaDialog.getSizeY(), dAMSelectionAreaDialog.getSizeZ());
            this.content.updateScene();
        }
    }

    private void onSave() {
        try {
            if (this.geneViewer) {
                ExperimentUtil.saveExperiment((Frame)this.frame, (Experiment)this.experiment, (IData)this.data, (int[])this.content.getSelectedGenes());
            } else {
                ExperimentUtil.saveExperimentCluster((Frame)this.frame, (Experiment)this.experiment, (IData)this.data, (int[])this.content.getSelectedGenes());
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.frame, "Can not save matrix!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    private void storeCluster() {
        if (this.geneViewer) {
            this.framework.storeCluster(this.content.getSelectedGenes(), this.experiment, 0);
        } else {
            this.framework.storeCluster(this.content.getSelectedGenes(), this.experiment, 1);
        }
        this.content.setSelection(false);
        this.onHideSelection();
        this.onDataChanged(this.data);
        this.content.updateScene();
    }

    private void launchNewSession() {
        if (this.geneViewer) {
            this.framework.launchNewMAV(this.content.getSelectedGenes(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 0);
        } else {
            this.framework.launchNewMAV(this.content.getSelectedGenes(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 1);
        }
    }

    private void onShowSelection() {
        JMenuItem jMenuItem = this.getJMenuItem(SHOW_SELECTION_CMD);
        JMenuItem jMenuItem2 = this.getJMenuItem(HIDE_SELECTION_BOX_CMD);
        JMenuItem jMenuItem3 = this.getJMenuItem(SELECTION_AREA_CMD);
        JMenuItem jMenuItem4 = this.getJMenuItem(SAVE_CMD);
        JMenuItem jMenuItem5 = this.getJMenuItem(STORE_CLUSTER_CMD);
        JMenuItem jMenuItem6 = this.getJMenuItem(LAUNCH_NEW_SESSION_CMD);
        if (jMenuItem.isSelected()) {
            this.content.setSelection(true);
            this.content.setSelectionBox(!jMenuItem2.isSelected());
            jMenuItem3.setEnabled(true);
            jMenuItem4.setEnabled(true);
            jMenuItem2.setEnabled(true);
            jMenuItem5.setEnabled(true);
            jMenuItem6.setEnabled(true);
        } else {
            this.content.setSelection(false);
            this.content.setSelectionBox(false);
            jMenuItem3.setEnabled(false);
            jMenuItem4.setEnabled(false);
            jMenuItem2.setEnabled(false);
            jMenuItem5.setEnabled(false);
            jMenuItem6.setEnabled(false);
        }
        this.content.updateScene();
    }

    private void onHideSelection() {
        this.content.setSelectionBox(!this.content.isSelectionBox());
        this.content.updateScene();
    }

    private void onShowSphere() {
        this.content.setShowSpheres(!this.content.isShowSpheres());
        this.content.updateScene();
        JMenuItem jMenuItem = this.getJMenuItem(SHOW_SPHERES_CMD);
        JMenuItem jMenuItem2 = this.getJMenuItem(SHOW_TEXT_CMD);
        if (jMenuItem.isSelected()) {
            this.content.setShowSpheres(true);
            this.content.setShowText(jMenuItem2.isSelected());
            jMenuItem2.setEnabled(true);
        } else {
            this.content.setShowSpheres(false);
            this.content.setShowText(false);
            jMenuItem2.setEnabled(true);
        }
        this.content.updateScene();
    }

    private void onShowText() {
        this.content.setShowText(!this.content.isShowText());
        this.content.updateScene();
    }

    private void onWhiteBackground() {
        this.content.setWhiteBackround(!this.content.isWhiteBackground());
        this.content.updateScene();
    }

    private class Listener
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(DAM3DViewer.RESET_CMD)) {
                DAM3DViewer.this.onReset();
            } else if (string.equals(DAM3DViewer.OPTIONS_CMD)) {
                DAM3DViewer.this.onOptions();
            } else if (string.equals(DAM3DViewer.SELECTION_AREA_CMD)) {
                DAM3DViewer.this.onSelectionArea();
            } else if (string.equals(DAM3DViewer.SAVE_CMD)) {
                DAM3DViewer.this.onSave();
            } else if (string.equals(DAM3DViewer.SHOW_SELECTION_CMD)) {
                DAM3DViewer.this.onShowSelection();
            } else if (string.equals(DAM3DViewer.HIDE_SELECTION_BOX_CMD)) {
                DAM3DViewer.this.onHideSelection();
            } else if (string.equals(DAM3DViewer.SHOW_SPHERES_CMD)) {
                DAM3DViewer.this.onShowSphere();
            } else if (string.equals(DAM3DViewer.SHOW_TEXT_CMD)) {
                DAM3DViewer.this.onShowText();
            } else if (string.equals(DAM3DViewer.WHITE_CMD)) {
                DAM3DViewer.this.onWhiteBackground();
            } else if (string.equals(DAM3DViewer.STORE_CLUSTER_CMD)) {
                DAM3DViewer.this.storeCluster();
            } else if (string.equals(DAM3DViewer.LAUNCH_NEW_SESSION_CMD)) {
                DAM3DViewer.this.launchNewSession();
            }
        }
    }
}

