/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.coa;

import com.sun.j3d.utils.geometry.Box;
import com.sun.j3d.utils.geometry.Cone;
import com.sun.j3d.utils.geometry.Cylinder;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.picking.behaviors.PickRotateBehavior;
import com.sun.j3d.utils.picking.behaviors.PickTranslateBehavior;
import com.sun.j3d.utils.picking.behaviors.PickZoomBehavior;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.Geometry;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PointArray;
import javax.media.j3d.PointAttributes;
import javax.media.j3d.PointLight;
import javax.media.j3d.Screen3D;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Text3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.swing.JPanel;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.impl.pca.OpenBehavior;
import org.tigr.util.FloatMatrix;

public class COAContent3D
extends JPanel {
    private IData data;
    private int geneOrExpt;
    private int xAxis;
    private int yAxis;
    private int zAxis;
    private int geneLabelIndex;
    private FloatMatrix U;
    private FloatMatrix geneUMatrix;
    private FloatMatrix exptUMatrix;
    private FloatMatrix scaledGeneUMatrix;
    private FloatMatrix scaledExptUMatrix;
    private Experiment experiment;
    private SimpleUniverse universe;
    private Canvas3D onScreenCanvas;
    private Canvas3D offScreenCanvas;
    private BranchGroup scene;
    private TransformGroup spinGroup;
    private boolean whiteBackground = false;
    private boolean selection = false;
    private boolean selectionBox = false;
    private boolean showSpheres = false;
    private boolean showText = false;
    private boolean showGeneTextFromBoth = false;
    private boolean showExptTextFromBoth = false;
    private float scaleAxisX = 3.0f;
    private float scaleAxisY = 3.0f;
    private float scaleAxisZ = 3.0f;
    private float boxSizeX = 5.0f;
    private float boxSizeY = 5.0f;
    private float boxSizeZ = 5.0f;
    private float boxPositionX = 0.0f;
    private float boxPositionY = 0.0f;
    private float boxPositionZ = 0.0f;
    private float pointSize = 1.0f;
    private float selectedPointSize = 1.0f;
    private Color3f blackColor = new Color3f(0.0f, 0.0f, 0.0f);
    private Color3f whiteColor = new Color3f(1.0f, 1.0f, 1.0f);

    public COAContent3D(FloatMatrix floatMatrix, Experiment experiment, int n) {
        this.geneOrExpt = n;
        this.U = floatMatrix;
        this.experiment = experiment;
        this.initScales(floatMatrix);
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(10, 10));
        GraphicsConfiguration graphicsConfiguration = SimpleUniverse.getPreferredConfiguration();
        this.onScreenCanvas = new Canvas3D(graphicsConfiguration);
        this.universe = new SimpleUniverse(this.onScreenCanvas);
        this.universe.getViewingPlatform().setNominalViewingTransform();
        this.boxSizeX = this.scaleAxisX / 5.0f;
        this.boxSizeY = this.scaleAxisY / 5.0f;
        this.boxSizeZ = this.scaleAxisZ / 5.0f;
        this.offScreenCanvas = new Canvas3D(graphicsConfiguration, true);
        Screen3D screen3D = this.onScreenCanvas.getScreen3D();
        Screen3D screen3D2 = this.offScreenCanvas.getScreen3D();
        screen3D2.setSize(screen3D.getSize());
        screen3D2.setPhysicalScreenWidth(screen3D.getPhysicalScreenWidth());
        screen3D2.setPhysicalScreenHeight(screen3D.getPhysicalScreenHeight());
        this.universe.getViewer().getView().addCanvas3D(this.offScreenCanvas);
        this.add((Component)this.onScreenCanvas, "Center");
    }

    public COAContent3D(FloatMatrix floatMatrix, Experiment experiment, int n, int n2, int n3, int n4) {
        this.geneOrExpt = n;
        this.xAxis = n2;
        this.yAxis = n3;
        this.zAxis = n4;
        this.U = floatMatrix;
        this.experiment = experiment;
        this.initScales(floatMatrix);
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(10, 10));
        GraphicsConfiguration graphicsConfiguration = SimpleUniverse.getPreferredConfiguration();
        this.onScreenCanvas = new Canvas3D(graphicsConfiguration);
        this.universe = new SimpleUniverse(this.onScreenCanvas);
        this.universe.getViewingPlatform().setNominalViewingTransform();
        this.boxSizeX = this.scaleAxisX / 5.0f;
        this.boxSizeY = this.scaleAxisY / 5.0f;
        this.boxSizeZ = this.scaleAxisZ / 5.0f;
        this.offScreenCanvas = new Canvas3D(graphicsConfiguration, true);
        Screen3D screen3D = this.onScreenCanvas.getScreen3D();
        Screen3D screen3D2 = this.offScreenCanvas.getScreen3D();
        screen3D2.setSize(screen3D.getSize());
        screen3D2.setPhysicalScreenWidth(screen3D.getPhysicalScreenWidth());
        screen3D2.setPhysicalScreenHeight(screen3D.getPhysicalScreenHeight());
        this.universe.getViewer().getView().addCanvas3D(this.offScreenCanvas);
        this.add((Component)this.onScreenCanvas, "Center");
    }

    public COAContent3D(FloatMatrix floatMatrix, FloatMatrix floatMatrix2, Experiment experiment, int n) {
        this.geneUMatrix = floatMatrix;
        this.exptUMatrix = floatMatrix2;
        this.scaledGeneUMatrix = (FloatMatrix)floatMatrix.clone();
        this.scaledExptUMatrix = (FloatMatrix)floatMatrix2.clone();
        this.U = this.combineMatrices(this.scaledGeneUMatrix, this.scaledExptUMatrix);
        this.geneOrExpt = n;
        this.experiment = experiment;
        this.initScales(this.U);
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(10, 10));
        GraphicsConfiguration graphicsConfiguration = SimpleUniverse.getPreferredConfiguration();
        this.onScreenCanvas = new Canvas3D(graphicsConfiguration);
        this.universe = new SimpleUniverse(this.onScreenCanvas);
        this.universe.getViewingPlatform().setNominalViewingTransform();
        this.boxSizeX = this.scaleAxisX / 5.0f;
        this.boxSizeY = this.scaleAxisY / 5.0f;
        this.boxSizeZ = this.scaleAxisZ / 5.0f;
        this.offScreenCanvas = new Canvas3D(graphicsConfiguration, true);
        Screen3D screen3D = this.onScreenCanvas.getScreen3D();
        Screen3D screen3D2 = this.offScreenCanvas.getScreen3D();
        screen3D2.setSize(screen3D.getSize());
        screen3D2.setPhysicalScreenWidth(screen3D.getPhysicalScreenWidth());
        screen3D2.setPhysicalScreenHeight(screen3D.getPhysicalScreenHeight());
        this.universe.getViewer().getView().addCanvas3D(this.offScreenCanvas);
        this.add((Component)this.onScreenCanvas, "Center");
    }

    public COAContent3D(FloatMatrix floatMatrix, FloatMatrix floatMatrix2, Experiment experiment, int n, int n2, int n3, int n4) {
        this.geneUMatrix = floatMatrix;
        this.exptUMatrix = floatMatrix2;
        this.scaledGeneUMatrix = (FloatMatrix)floatMatrix.clone();
        this.scaledExptUMatrix = (FloatMatrix)floatMatrix2.clone();
        this.U = this.combineMatrices(this.scaledGeneUMatrix, this.scaledExptUMatrix);
        this.geneOrExpt = n;
        this.xAxis = n2;
        this.yAxis = n3;
        this.zAxis = n4;
        this.experiment = experiment;
        this.initScales(this.U);
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(10, 10));
        GraphicsConfiguration graphicsConfiguration = SimpleUniverse.getPreferredConfiguration();
        this.onScreenCanvas = new Canvas3D(graphicsConfiguration);
        this.universe = new SimpleUniverse(this.onScreenCanvas);
        this.universe.getViewingPlatform().setNominalViewingTransform();
        this.boxSizeX = this.scaleAxisX / 5.0f;
        this.boxSizeY = this.scaleAxisY / 5.0f;
        this.boxSizeZ = this.scaleAxisZ / 5.0f;
        this.offScreenCanvas = new Canvas3D(graphicsConfiguration, true);
        Screen3D screen3D = this.onScreenCanvas.getScreen3D();
        Screen3D screen3D2 = this.offScreenCanvas.getScreen3D();
        screen3D2.setSize(screen3D.getSize());
        screen3D2.setPhysicalScreenWidth(screen3D.getPhysicalScreenWidth());
        screen3D2.setPhysicalScreenHeight(screen3D.getPhysicalScreenHeight());
        this.universe.getViewer().getView().addCanvas3D(this.offScreenCanvas);
        this.add((Component)this.onScreenCanvas, "Center");
    }

    public void setData(IData iData) {
        this.data = iData;
    }

    public float getPositionX() {
        return this.boxPositionX;
    }

    public float getPositionY() {
        return this.boxPositionY;
    }

    public float getPositionZ() {
        return this.boxPositionZ;
    }

    public void setGeneLabelIndex(int n) {
        this.geneLabelIndex = n;
    }

    public float getSizeX() {
        return this.boxSizeX;
    }

    public float getSizeY() {
        return this.boxSizeY;
    }

    public float getSizeZ() {
        return this.boxSizeZ;
    }

    public void setBoxPosition(float f, float f2, float f3) {
        this.boxPositionX = f;
        this.boxPositionY = f2;
        this.boxPositionZ = f3;
    }

    public void setBoxSize(float f, float f2, float f3) {
        this.boxSizeX = f;
        this.boxSizeY = f2;
        this.boxSizeZ = f3;
    }

    public float getSelectedPointSize() {
        return this.selectedPointSize;
    }

    public void setSelectedPointSize(float f) {
        this.selectedPointSize = f;
    }

    public float getPointSize() {
        return this.pointSize;
    }

    private float getPointSize(boolean bl) {
        return bl ? this.getSelectedPointSize() : this.getPointSize();
    }

    public void setPointSize(float f) {
        this.pointSize = f;
    }

    public float getScaleAxisX() {
        return this.scaleAxisX;
    }

    public float getScaleAxisY() {
        return this.scaleAxisY;
    }

    public float getScaleAxisZ() {
        return this.scaleAxisZ;
    }

    public void setScale(float f, float f2, float f3) {
        this.scaleAxisX = f;
        this.scaleAxisY = f2;
        this.scaleAxisZ = f3;
    }

    public float getMaxValue() {
        return Math.max(this.scaleAxisX, Math.max(this.scaleAxisY, this.scaleAxisZ));
    }

    public void setWhiteBackround(boolean bl) {
        this.whiteBackground = bl;
    }

    public boolean isWhiteBackground() {
        return this.whiteBackground;
    }

    public void setSelection(boolean bl) {
        this.selection = bl;
    }

    public boolean isSelection() {
        return this.selection;
    }

    public void setSelectionBox(boolean bl) {
        this.selectionBox = bl;
    }

    public boolean isSelectionBox() {
        return this.selectionBox;
    }

    public void setShowSpheres(boolean bl) {
        this.showSpheres = bl;
    }

    public boolean isShowSpheres() {
        return this.showSpheres;
    }

    public void setShowText(boolean bl) {
        this.showText = bl;
    }

    public void setShowGeneTextFromBoth(boolean bl) {
        this.showGeneTextFromBoth = bl;
    }

    public void setShowExptTextFromBoth(boolean bl) {
        this.showExptTextFromBoth = bl;
    }

    public boolean isShowText() {
        return this.showText;
    }

    public boolean isShowGeneTextFromBoth() {
        return this.showGeneTextFromBoth;
    }

    public boolean isShowExptTextFromBoth() {
        return this.showExptTextFromBoth;
    }

    public BufferedImage createImage() {
        ImageComponent2D imageComponent2D = new ImageComponent2D(1, GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(this.onScreenCanvas.getWidth(), this.onScreenCanvas.getHeight()));
        this.offScreenCanvas.setOffScreenLocation(this.onScreenCanvas.getLocationOnScreen());
        this.offScreenCanvas.setOffScreenBuffer(imageComponent2D);
        this.offScreenCanvas.renderOffScreenBuffer();
        this.offScreenCanvas.waitForOffScreenRendering();
        BufferedImage bufferedImage = this.offScreenCanvas.getOffScreenBuffer().getImage();
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 5);
        bufferedImage2.setData(bufferedImage.getData());
        return bufferedImage2;
    }

    public void reset() {
        this.spinGroup.setTransform(new Transform3D());
    }

    protected void updateScene() {
        Transform3D transform3D = new Transform3D();
        if (this.scene != null) {
            this.spinGroup.getTransform(transform3D);
            this.scene.detach();
        }
        this.scene = this.createSceneGraph(this.onScreenCanvas, transform3D);
        this.universe.addBranchGraph(this.scene);
    }

    private void initScales(FloatMatrix floatMatrix) {
        int n;
        float f = 0.0f;
        int n2 = n = floatMatrix.getRowDimension();
        while (--n2 >= 0) {
            f = Math.max(f, Math.max(Math.max(Math.abs(floatMatrix.get(n2, this.xAxis)), Math.abs(floatMatrix.get(n2, this.yAxis))), Math.abs(floatMatrix.get(n2, this.zAxis))));
        }
        this.setScale(f, f, f);
    }

    private FloatMatrix combineMatrices(FloatMatrix floatMatrix, FloatMatrix floatMatrix2) {
        int n;
        int n2;
        FloatMatrix floatMatrix3 = new FloatMatrix(floatMatrix.getRowDimension() + floatMatrix2.getRowDimension(), floatMatrix.getColumnDimension());
        for (n2 = 0; n2 < floatMatrix.getRowDimension(); ++n2) {
            for (n = 0; n < floatMatrix.getColumnDimension(); ++n) {
                floatMatrix3.A[n2][n] = floatMatrix.A[n2][n];
            }
        }
        n2 = floatMatrix.getRowDimension();
        for (n = 0; n < floatMatrix2.getRowDimension(); ++n) {
            for (int i = 0; i < floatMatrix2.getColumnDimension(); ++i) {
                floatMatrix3.A[n2 + n][i] = floatMatrix2.A[n][i];
            }
        }
        return floatMatrix3;
    }

    private void scaleMatrices(FloatMatrix floatMatrix, FloatMatrix floatMatrix2) {
        float f = 0.0f;
        float f2 = 0.0f;
        int n = floatMatrix.getRowDimension();
        int n2 = floatMatrix2.getRowDimension();
        int n3 = n;
        while (--n3 >= 0) {
            f = Math.max(f, Math.max(Math.max(Math.abs(floatMatrix.get(n3, this.xAxis)), Math.abs(floatMatrix.get(n3, this.yAxis))), Math.abs(floatMatrix.get(n3, this.zAxis))));
        }
        n3 = n2;
        while (--n3 >= 0) {
            f = Math.max(f, Math.max(Math.max(Math.abs(floatMatrix.get(n3, this.xAxis)), Math.abs(floatMatrix.get(n3, this.yAxis))), Math.abs(floatMatrix.get(n3, this.zAxis))));
        }
        float f3 = Math.max(f, f2);
        if (f == f2) {
            this.scaledGeneUMatrix = (FloatMatrix)this.geneUMatrix.clone();
            this.scaledExptUMatrix = (FloatMatrix)this.exptUMatrix.clone();
        } else if (f > f2) {
            this.scaledGeneUMatrix = (FloatMatrix)this.geneUMatrix.clone();
            float f4 = f / f2;
            this.scaledExptUMatrix = this.exptUMatrix.times(f4);
        } else {
            this.scaledExptUMatrix = (FloatMatrix)this.exptUMatrix.clone();
            float f5 = f2 / f;
            this.scaledGeneUMatrix = this.geneUMatrix.times(f5);
        }
    }

    private void initScales(FloatMatrix floatMatrix, FloatMatrix floatMatrix2) {
        float f = 0.0f;
        float f2 = 0.0f;
        int n = floatMatrix.getRowDimension();
        int n2 = floatMatrix2.getRowDimension();
        int n3 = n;
        while (--n3 >= 0) {
            f = Math.max(f, Math.max(Math.max(Math.abs(floatMatrix.get(n3, this.xAxis)), Math.abs(floatMatrix.get(n3, this.yAxis))), Math.abs(floatMatrix.get(n3, this.zAxis))));
        }
        n3 = n2;
        while (--n3 >= 0) {
            f2 = Math.max(f2, Math.max(Math.max(Math.abs(floatMatrix2.get(n3, this.xAxis)), Math.abs(floatMatrix2.get(n3, this.yAxis))), Math.abs(floatMatrix2.get(n3, this.zAxis))));
        }
        float f3 = Math.max(f, f2);
        this.setScale(f3, f3, f3);
    }

    private BranchGroup createSceneGraph(Canvas3D canvas3D) {
        return this.createSceneGraph(canvas3D, null);
    }

    private BranchGroup createSceneGraph(Canvas3D canvas3D, Transform3D transform3D) {
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.setCapability(17);
        BoundingSphere boundingSphere = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        this.spinGroup = this.createCoordinateSystem(boundingSphere);
        if (transform3D != null) {
            this.spinGroup.setTransform(transform3D);
        }
        TransformGroup transformGroup = this.createScaleTransformGroup(boundingSphere);
        transformGroup.addChild((Node)this.spinGroup);
        branchGroup.addChild((Node)transformGroup);
        PickRotateBehavior pickRotateBehavior = new PickRotateBehavior(branchGroup, canvas3D, (Bounds)boundingSphere);
        branchGroup.addChild((Node)pickRotateBehavior);
        PickZoomBehavior pickZoomBehavior = new PickZoomBehavior(branchGroup, canvas3D, (Bounds)boundingSphere);
        branchGroup.addChild((Node)pickZoomBehavior);
        PickTranslateBehavior pickTranslateBehavior = new PickTranslateBehavior(branchGroup, canvas3D, (Bounds)boundingSphere);
        branchGroup.addChild((Node)pickTranslateBehavior);
        branchGroup.compile();
        return branchGroup;
    }

    private TransformGroup createScaleTransformGroup(BoundingSphere boundingSphere) {
        Transform3D transform3D = new Transform3D();
        transform3D.setScale(0.22);
        TransformGroup transformGroup = new TransformGroup(transform3D);
        Color3f color3f = this.isWhiteBackground() ? this.whiteColor : this.blackColor;
        Background background = new Background(color3f);
        background.setApplicationBounds((Bounds)boundingSphere);
        transformGroup.addChild((Node)background);
        transformGroup.addChild((Node)this.createAmbientLight(boundingSphere));
        transformGroup.addChild((Node)this.createLight(boundingSphere, new Vector3d(0.0, 0.0, 3.0)));
        transformGroup.addChild((Node)this.createLight(boundingSphere, new Vector3d(0.0, 0.0, 10.0)));
        return transformGroup;
    }

    private TransformGroup createCoordinateSystem(BoundingSphere boundingSphere) {
        Object object;
        TransformGroup transformGroup = new TransformGroup();
        transformGroup.setCapability(18);
        transformGroup.setCapability(17);
        transformGroup.setCapability(1);
        transformGroup.addChild((Node)this.createXAxis());
        transformGroup.addChild((Node)this.createYAxis());
        transformGroup.addChild((Node)this.createZAxis());
        if (this.isShowSpheres()) {
            transformGroup.addChild((Node)this.createSpheres());
        } else if (this.getPointSize() > 0.0f) {
            object = this.createUsualPoints();
            if (object != null) {
                for (int i = 0; i < ((Shape3D[])object).length; ++i) {
                    transformGroup.addChild((Node)object[i]);
                }
            }
            if (this.geneOrExpt == 1 || this.geneOrExpt == 2) {
                Shape3D shape3D = this.createSelectedPoints();
                if (shape3D != null) {
                    transformGroup.addChild((Node)shape3D);
                }
            } else {
                Shape3D[] shape3DArray = this.createSelectedPointsFromBoth();
                if (shape3DArray != null) {
                    for (int i = 0; i < shape3DArray.length; ++i) {
                        transformGroup.addChild((Node)shape3DArray[i]);
                    }
                }
            }
        }
        if (this.isSelectionBox()) {
            transformGroup.addChild((Node)this.createSelectionBox());
        }
        if (this.geneOrExpt == 3) {
            if (this.isShowGeneTextFromBoth()) {
                transformGroup.addChild((Node)this.createGeneTextFromBoth());
            }
            if (this.isShowExptTextFromBoth()) {
                transformGroup.addChild((Node)this.createSampleTextFromBoth());
            }
        } else if (this.isShowText()) {
            transformGroup.addChild((Node)this.createText());
        }
        object = new OpenBehavior(transformGroup);
        object.setSchedulingBounds((Bounds)boundingSphere);
        transformGroup.addChild((Node)object);
        return transformGroup;
    }

    private TransformGroup createLight(BoundingSphere boundingSphere, Vector3d vector3d) {
        Transform3D transform3D = new Transform3D();
        transform3D.set(vector3d);
        TransformGroup transformGroup = new TransformGroup(transform3D);
        transformGroup.setCapability(18);
        transformGroup.setCapability(17);
        transformGroup.setCapability(1);
        ColoringAttributes coloringAttributes = new ColoringAttributes();
        Color3f color3f = new Color3f(1.0f, 1.0f, 1.0f);
        coloringAttributes.setColor(color3f);
        Appearance appearance = new Appearance();
        appearance.setColoringAttributes(coloringAttributes);
        transformGroup.addChild((Node)new Sphere(0.01f, 1, 15, appearance));
        PointLight pointLight = new PointLight(color3f, new Point3f(0.0f, 0.0f, 0.0f), new Point3f(1.0f, 0.0f, 0.0f));
        pointLight.setInfluencingBounds((Bounds)boundingSphere);
        transformGroup.addChild((Node)pointLight);
        return transformGroup;
    }

    private AmbientLight createAmbientLight(BoundingSphere boundingSphere) {
        AmbientLight ambientLight = new AmbientLight(new Color3f(0.2f, 0.2f, 0.2f));
        ambientLight.setInfluencingBounds((Bounds)boundingSphere);
        return ambientLight;
    }

    private Cone createCone() {
        return new Cone(0.05f, 0.2f);
    }

    private Cylinder createCylinder(Color3f color3f) {
        Material material = new Material(color3f, this.blackColor, color3f, this.whiteColor, 100.0f);
        if (this.isWhiteBackground()) {
            material.setEmissiveColor(new Color3f(0.0f, 0.0f, 1.0f));
        }
        Appearance appearance = new Appearance();
        appearance.setLineAttributes(new LineAttributes(10.0f, 0, true));
        appearance.setMaterial(material);
        return new Cylinder(0.025f, 6.0f, appearance);
    }

    private TransformGroup createSelectionBox() {
        Material material = new Material(new Color3f(0.5f, 0.5f, 0.5f), this.blackColor, new Color3f(0.5f, 0.5f, 0.5f), this.blackColor, 100.0f);
        material.setLightingEnable(true);
        Appearance appearance = new Appearance();
        TransparencyAttributes transparencyAttributes = new TransparencyAttributes();
        transparencyAttributes.setTransparency(0.5f);
        transparencyAttributes.setTransparencyMode(2);
        appearance.setTransparencyAttributes(transparencyAttributes);
        appearance.setMaterial(material);
        Transform3D transform3D = new Transform3D();
        float f = 3.0f / this.scaleAxisX;
        float f2 = 3.0f / this.scaleAxisY;
        float f3 = 3.0f / this.scaleAxisZ;
        Vector3f vector3f = new Vector3f(this.boxPositionX * f, this.boxPositionY * f2, this.boxPositionZ * f3);
        transform3D.set(vector3f);
        TransformGroup transformGroup = new TransformGroup(transform3D);
        transformGroup.addChild((Node)new Box(this.boxSizeX * f / 2.0f, this.boxSizeY * f2 / 2.0f, this.boxSizeZ * f3 / 2.0f, appearance));
        return transformGroup;
    }

    private boolean isPointSelected(float f, float f2, float f3) {
        float f4 = this.boxPositionX - this.boxSizeX / 2.0f;
        float f5 = this.boxPositionX + this.boxSizeX / 2.0f;
        float f6 = this.boxPositionY - this.boxSizeY / 2.0f;
        float f7 = this.boxPositionY + this.boxSizeY / 2.0f;
        float f8 = this.boxPositionZ - this.boxSizeZ / 2.0f;
        float f9 = this.boxPositionZ + this.boxSizeZ / 2.0f;
        return f >= f4 && f <= f5 && f2 >= f6 && f2 <= f7 && f3 >= f8 && f3 <= f9;
    }

    protected int[] getSelectedGenes() {
        int[] nArray = new int[this.getPointsCount(true)];
        int n = 0;
        for (int i = 0; i < this.U.getRowDimension(); ++i) {
            if (!this.isPointSelected(this.U.get(i, this.xAxis), this.U.get(i, this.yAxis), this.U.get(i, this.zAxis))) continue;
            if (this.geneOrExpt == 1) {
                nArray[n] = this.experiment.getGeneIndexMappedToData(i);
            } else if (this.geneOrExpt == 2) {
                nArray[n] = this.experiment.getSampleIndex(i);
            }
            ++n;
        }
        return nArray;
    }

    protected int[] getSelectedGenesFromBoth() {
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < this.geneUMatrix.getRowDimension(); ++i) {
            if (!this.isPointSelected(this.U.get(i, this.xAxis), this.U.get(i, this.yAxis), this.U.get(i, this.zAxis))) continue;
            vector.add(new Integer(this.experiment.getGeneIndexMappedToData(i)));
        }
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            nArray[i] = (Integer)vector.get(i);
        }
        return nArray;
    }

    protected int[] getSelectedExptsFromBoth() {
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = this.geneUMatrix.getRowDimension(); i < this.U.getRowDimension(); ++i) {
            if (!this.isPointSelected(this.U.get(i, this.xAxis), this.U.get(i, this.yAxis), this.U.get(i, this.zAxis))) continue;
            vector.add(new Integer(this.experiment.getSampleIndex(i - this.geneUMatrix.getRowDimension())));
        }
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            nArray[i] = (Integer)vector.get(i);
        }
        return nArray;
    }

    private int getPointsCount(boolean bl) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.U.getRowDimension(); ++i) {
            if (this.isPointSelected(this.U.get(i, this.xAxis), this.U.get(i, this.yAxis), this.U.get(i, this.zAxis))) {
                ++n2;
                continue;
            }
            ++n;
        }
        return bl ? n2 : n;
    }

    private int getUsualPointsCount() {
        if (this.isSelection()) {
            return this.getPointsCount(false);
        }
        return this.U.getRowDimension();
    }

    private Shape3D createSelectedPoints() {
        if (!this.isSelection()) {
            return null;
        }
        int n = this.getPointsCount(true);
        if (n < 1) {
            return null;
        }
        Color3f color3f = new Color3f(1.0f, 0.3f, 1.0f);
        Material material = new Material(color3f, color3f, color3f, color3f, 100.0f);
        material.setLightingEnable(true);
        Appearance appearance = new Appearance();
        appearance.setPointAttributes(new PointAttributes(this.getSelectedPointSize(), false));
        appearance.setMaterial(material);
        PointArray pointArray = new PointArray(n, 7);
        float f = 3.0f / this.scaleAxisX;
        float f2 = 3.0f / this.scaleAxisY;
        float f3 = 3.0f / this.scaleAxisZ;
        int n2 = 0;
        for (int i = 0; i < this.U.getRowDimension(); ++i) {
            float f4;
            float f5;
            float f6 = this.U.get(i, this.xAxis);
            if (!this.isPointSelected(f6, f5 = this.U.get(i, this.yAxis), f4 = this.U.get(i, this.zAxis))) continue;
            pointArray.setCoordinate(n2, new Point3f(f6 * f, f5 * f2, f4 * f3));
            ++n2;
        }
        Shape3D shape3D = new Shape3D();
        shape3D.setAppearance(appearance);
        shape3D.setGeometry((Geometry)pointArray);
        return shape3D;
    }

    private Shape3D[] createSelectedPointsFromBoth() {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        Appearance appearance;
        Material material;
        Color3f color3f;
        if (!this.isSelection()) {
            return null;
        }
        int n = this.getPointsCount(true);
        if (n < 1) {
            return null;
        }
        Shape3D[] shape3DArray = new Shape3D[2];
        boolean bl = true;
        if (bl) {
            color3f = new Color3f(1.0f, 0.3f, 1.0f);
            material = new Material(color3f, color3f, color3f, color3f, 100.0f);
            material.setLightingEnable(true);
            appearance = new Appearance();
            appearance.setPointAttributes(new PointAttributes(this.getSelectedPointSize(), false));
            appearance.setMaterial(material);
            PointArray pointArray = new PointArray(n, 7);
            float f6 = 3.0f / this.scaleAxisX;
            f5 = 3.0f / this.scaleAxisY;
            f4 = 3.0f / this.scaleAxisZ;
            int n2 = 0;
            for (int i = 0; i < this.geneUMatrix.getRowDimension(); ++i) {
                f3 = this.U.get(i, this.xAxis);
                if (!this.isPointSelected(f3, f2 = this.U.get(i, this.yAxis), f = this.U.get(i, this.zAxis))) continue;
                pointArray.setCoordinate(n2, new Point3f(f3 * f6, f2 * f5, f * f4));
                ++n2;
            }
            Shape3D shape3D = new Shape3D();
            shape3D.setAppearance(appearance);
            shape3D.setGeometry((Geometry)pointArray);
            shape3DArray[0] = shape3D;
        }
        if (!(bl = false)) {
            color3f = new Color3f(1.0f, 0.3f, 1.0f);
            material = new Material(color3f, color3f, color3f, color3f, 100.0f);
            material.setLightingEnable(true);
            appearance = new Appearance();
            float f7 = this.getSelectedPointSize();
            if (f7 < 5.0f) {
                f7 = 5.0f;
            }
            appearance.setPointAttributes(new PointAttributes(f7, false));
            appearance.setMaterial(material);
            PointArray pointArray = new PointArray(n, 7);
            f5 = 3.0f / this.scaleAxisX;
            f4 = 3.0f / this.scaleAxisY;
            f3 = 3.0f / this.scaleAxisZ;
            int n3 = 0;
            for (int i = this.geneUMatrix.getRowDimension(); i < this.U.getRowDimension(); ++i) {
                float f8;
                f2 = this.U.get(i, this.xAxis);
                if (!this.isPointSelected(f2, f = this.U.get(i, this.yAxis), f8 = this.U.get(i, this.zAxis))) continue;
                pointArray.setCoordinate(n3, new Point3f(f2 * f5, f * f4, f8 * f3));
                ++n3;
            }
            Shape3D shape3D = new Shape3D();
            shape3D.setAppearance(appearance);
            shape3D.setGeometry((Geometry)pointArray);
            shape3DArray[1] = shape3D;
        }
        return shape3DArray;
    }

    private Appearance createPointAppearance(Color3f color3f) {
        Material material = new Material(color3f, color3f, color3f, color3f, 100.0f);
        material.setLightingEnable(true);
        Appearance appearance = new Appearance();
        appearance.setPointAttributes(new PointAttributes(this.getPointSize(), false));
        appearance.setMaterial(material);
        return appearance;
    }

    private Appearance createPointAppearance(Color3f color3f, float f) {
        Material material = new Material(color3f, color3f, color3f, color3f, 100.0f);
        material.setLightingEnable(true);
        Appearance appearance = new Appearance();
        appearance.setPointAttributes(new PointAttributes(f, false));
        appearance.setMaterial(material);
        return appearance;
    }

    private Shape3D[] createUsualPoints() {
        Shape3D[] shape3DArray = new Shape3D[1];
        Shape3D[] shape3DArray2 = new Shape3D[1];
        Shape3D[] shape3DArray3 = new Shape3D[1];
        if (this.geneOrExpt == 1 || this.geneOrExpt == 2) {
            int n;
            Color3f color3f;
            int n2;
            int n3 = this.getUsualPointsCount();
            if (n3 < 1) {
                return null;
            }
            int n4 = this.geneOrExpt == 1 ? this.data.getColoredProbesCount(-1) : this.data.getColoredExperimentsCount(-1);
            int n5 = n4 == 0 ? 0 : 1;
            Color[] colorArray = new Color[1];
            if (this.geneOrExpt == 1) {
                colorArray = this.data.getColors();
            } else if (this.geneOrExpt == 2) {
                colorArray = this.data.getExperimentColors();
            }
            PointArray[] pointArrayArray = new PointArray[colorArray.length + n5];
            Appearance[] appearanceArray = new Appearance[colorArray.length + n5];
            int[] nArray = new int[colorArray.length + n5];
            if (n4 > 0) {
                appearanceArray[0] = this.createPointAppearance(this.isWhiteBackground() ? this.blackColor : this.whiteColor);
                pointArrayArray[0] = new PointArray(n4, 7);
                nArray[0] = 0;
            }
            if (this.geneOrExpt == 1) {
                for (n2 = 0; n2 < colorArray.length; ++n2) {
                    color3f = new Color3f(colorArray[n2]);
                    appearanceArray[n2 + n5] = this.createPointAppearance(color3f);
                    pointArrayArray[n2 + n5] = new PointArray(this.data.getColoredProbesCount(n2), 7);
                    nArray[n2 + n5] = 0;
                }
            } else if (this.geneOrExpt == 2) {
                for (n2 = 0; n2 < colorArray.length; ++n2) {
                    color3f = new Color3f(colorArray[n2]);
                    appearanceArray[n2 + n5] = this.createPointAppearance(color3f);
                    pointArrayArray[n2 + n5] = new PointArray(this.data.getColoredExperimentsCount(n2), 7);
                    nArray[n2 + n5] = 0;
                }
            }
            float f = 3.0f / this.scaleAxisX;
            float f2 = 3.0f / this.scaleAxisY;
            float f3 = 3.0f / this.scaleAxisZ;
            int n6 = 0;
            for (n = 0; n < this.U.getRowDimension(); ++n) {
                float f4 = this.U.get(n, this.xAxis);
                float f5 = this.U.get(n, this.yAxis);
                float f6 = this.U.get(n, this.zAxis);
                if (this.isSelection() && this.isPointSelected(f4, f5, f6)) continue;
                if (this.geneOrExpt == 1) {
                    n6 = this.data.getProbeColorIndex(this.experiment.getGeneIndexMappedToData(n)) + n5;
                } else if (this.geneOrExpt == 2) {
                    n6 = this.data.getExperimentColorIndex(n) + n5;
                }
                pointArrayArray[n6].setCoordinate(nArray[n6], new Point3f(f4 * f, f5 * f2, f6 * f3));
                int n7 = n6;
                nArray[n7] = nArray[n7] + 1;
            }
            shape3DArray = new Shape3D[pointArrayArray.length];
            for (n = 0; n < shape3DArray.length; ++n) {
                shape3DArray[n] = new Shape3D();
                shape3DArray[n].setAppearance(appearanceArray[n]);
                shape3DArray[n].setGeometry((Geometry)pointArrayArray[n]);
            }
        } else {
            float f;
            float f7;
            float f8;
            int n;
            int n8;
            float f9;
            float f10;
            float f11;
            Color3f color3f;
            int[] nArray;
            Appearance[] appearanceArray;
            PointArray[] pointArrayArray;
            Color[] colorArray;
            int n9;
            int n10;
            int n11 = this.getUsualPointsCount();
            if (n11 < 1) {
                return null;
            }
            boolean bl = true;
            if (bl) {
                n10 = this.data.getColoredProbesCount(-1);
                n9 = n10 == 0 ? 0 : 1;
                colorArray = this.data.getColors();
                pointArrayArray = new PointArray[colorArray.length + n9];
                appearanceArray = new Appearance[colorArray.length + n9];
                nArray = new int[colorArray.length + n9];
                if (n10 > 0) {
                    appearanceArray[0] = this.createPointAppearance(this.isWhiteBackground() ? this.blackColor : this.whiteColor);
                    pointArrayArray[0] = new PointArray(n10, 7);
                    nArray[0] = 0;
                }
                for (int i = 0; i < colorArray.length; ++i) {
                    color3f = new Color3f(colorArray[i]);
                    appearanceArray[i + n9] = this.createPointAppearance(color3f);
                    pointArrayArray[i + n9] = new PointArray(this.data.getColoredProbesCount(i), 7);
                    nArray[i + n9] = 0;
                }
                f11 = 3.0f / this.scaleAxisX;
                f10 = 3.0f / this.scaleAxisY;
                f9 = 3.0f / this.scaleAxisZ;
                n8 = 0;
                for (n = 0; n < this.scaledGeneUMatrix.getRowDimension(); ++n) {
                    f8 = this.scaledGeneUMatrix.get(n, this.xAxis);
                    f7 = this.scaledGeneUMatrix.get(n, this.yAxis);
                    f = this.scaledGeneUMatrix.get(n, this.zAxis);
                    if (this.isSelection() && this.isPointSelected(f8, f7, f)) continue;
                    n8 = this.data.getProbeColorIndex(this.experiment.getGeneIndexMappedToData(n)) + n9;
                    pointArrayArray[n8].setCoordinate(nArray[n8], new Point3f(f8 * f11, f7 * f10, f * f9));
                    int n12 = n8;
                    nArray[n12] = nArray[n12] + 1;
                }
                shape3DArray2 = new Shape3D[pointArrayArray.length];
                for (n = 0; n < shape3DArray2.length; ++n) {
                    shape3DArray2[n] = new Shape3D();
                    shape3DArray2[n].setAppearance(appearanceArray[n]);
                    shape3DArray2[n].setGeometry((Geometry)pointArrayArray[n]);
                }
            }
            if (!(bl = false)) {
                n10 = this.data.getColoredExperimentsCount(-1);
                n9 = n10 == 0 ? 0 : 1;
                colorArray = this.data.getExperimentColors();
                pointArrayArray = new PointArray[colorArray.length + n9];
                appearanceArray = new Appearance[colorArray.length + n9];
                nArray = new int[colorArray.length + n9];
                if (n10 > 0) {
                    appearanceArray[0] = this.getPointSize() < 10.0f ? this.createPointAppearance(this.isWhiteBackground() ? this.blackColor : this.whiteColor, 10.0f) : this.createPointAppearance(this.isWhiteBackground() ? this.blackColor : this.whiteColor);
                    pointArrayArray[0] = new PointArray(n10, 7);
                    nArray[0] = 0;
                }
                for (int i = 0; i < colorArray.length; ++i) {
                    color3f = new Color3f(colorArray[i]);
                    appearanceArray[i + n9] = this.getPointSize() < 10.0f ? this.createPointAppearance(color3f, 10.0f) : this.createPointAppearance(color3f);
                    pointArrayArray[i + n9] = new PointArray(this.data.getColoredExperimentsCount(i), 7);
                    nArray[i + n9] = 0;
                }
                f11 = 3.0f / this.scaleAxisX;
                f10 = 3.0f / this.scaleAxisY;
                f9 = 3.0f / this.scaleAxisZ;
                n8 = 0;
                for (n = 0; n < this.scaledExptUMatrix.getRowDimension(); ++n) {
                    f8 = this.scaledExptUMatrix.get(n, this.xAxis);
                    f7 = this.scaledExptUMatrix.get(n, this.yAxis);
                    f = this.scaledExptUMatrix.get(n, this.zAxis);
                    if (this.isSelection() && this.isPointSelected(f8, f7, f)) continue;
                    n8 = this.data.getExperimentColorIndex(n) + n9;
                    pointArrayArray[n8].setCoordinate(nArray[n8], new Point3f(f8 * f11, f7 * f10, f * f9));
                    int n13 = n8;
                    nArray[n13] = nArray[n13] + 1;
                }
                shape3DArray3 = new Shape3D[pointArrayArray.length];
                for (n = 0; n < shape3DArray3.length; ++n) {
                    shape3DArray3[n] = new Shape3D();
                    shape3DArray3[n].setAppearance(appearanceArray[n]);
                    shape3DArray3[n].setGeometry((Geometry)pointArrayArray[n]);
                }
            }
            shape3DArray = new Shape3D[shape3DArray2.length + shape3DArray3.length];
            for (n10 = 0; n10 < shape3DArray2.length; ++n10) {
                shape3DArray[n10] = shape3DArray2[n10];
            }
            for (n10 = 0; n10 < shape3DArray3.length; ++n10) {
                shape3DArray[shape3DArray2.length + n10] = shape3DArray3[n10];
            }
        }
        return shape3DArray;
    }

    private Shape3D[] createUsualPointsOld() {
        int n;
        Color3f color3f;
        int n2;
        int n3 = this.getUsualPointsCount();
        if (n3 < 1) {
            return null;
        }
        int n4 = this.geneOrExpt == 1 ? this.data.getColoredProbesCount(-1) : (this.geneOrExpt == 2 ? this.data.getColoredExperimentsCount(-1) : this.data.getColoredProbesCount(-1) + this.data.getColoredExperimentsCount(-1));
        System.out.println("unColoredCount = " + n4);
        int n5 = n4 == 0 ? 0 : 1;
        int n6 = this.data.getColoredProbesCount(-1) == 0 ? 0 : 1;
        int n7 = this.data.getColoredExperimentsCount(-1) == 0 ? 0 : 1;
        Color[] colorArray = new Color[1];
        Color[] colorArray2 = new Color[1];
        Color[] colorArray3 = new Color[1];
        int[] nArray = new int[1];
        if (this.geneOrExpt == 1) {
            colorArray = this.data.getColors();
        } else if (this.geneOrExpt == 2) {
            colorArray = this.data.getExperimentColors();
        } else if (this.geneOrExpt == 3) {
            int n8;
            colorArray2 = this.data.getColors();
            colorArray3 = this.data.getExperimentColors();
            System.out.println("geneColors.length = " + colorArray2.length + ", exptColors.length = " + colorArray3.length + ", colors.length = " + colorArray.length + ", bothColorCounts.length = " + nArray.length);
            colorArray = new Color[colorArray2.length + colorArray3.length];
            for (n8 = 0; n8 < colorArray2.length; ++n8) {
                colorArray[n8] = colorArray2[n8];
            }
            for (n8 = 0; n8 < colorArray3.length; ++n8) {
                colorArray[colorArray2.length + n8] = colorArray3[n8];
            }
        }
        PointArray[] pointArrayArray = new PointArray[colorArray.length + n5];
        Appearance[] appearanceArray = new Appearance[colorArray.length + n5];
        int[] nArray2 = new int[colorArray.length + n5];
        int[] nArray3 = new int[colorArray.length + n5];
        if (this.geneOrExpt == 3) {
            pointArrayArray = new PointArray[colorArray.length + n6 + n7];
            appearanceArray = new Appearance[colorArray.length + n6 + n7];
            nArray2 = new int[colorArray.length + n6 + n7];
            nArray3 = new int[colorArray.length + n6 + n7];
        }
        if (this.geneOrExpt == 1 || this.geneOrExpt == 2) {
            if (n4 > 0) {
                appearanceArray[0] = this.createPointAppearance(this.isWhiteBackground() ? this.blackColor : this.whiteColor);
                pointArrayArray[0] = new PointArray(n4, 7);
                nArray2[0] = 0;
                nArray3[0] = 0;
            }
        } else {
            if (this.data.getColoredProbesCount(-1) > 0) {
                appearanceArray[0] = this.createPointAppearance(this.isWhiteBackground() ? this.blackColor : this.whiteColor);
                pointArrayArray[0] = new PointArray(this.data.getColoredProbesCount(-1), 7);
                nArray2[0] = 0;
                nArray3[0] = 0;
            }
            if (this.data.getColoredExperimentsCount(-1) > 0) {
                appearanceArray[colorArray2.length + n6] = this.createPointAppearance(this.isWhiteBackground() ? this.blackColor : this.whiteColor);
                pointArrayArray[colorArray2.length + n6] = new PointArray(this.data.getColoredExperimentsCount(-1), 7);
                nArray2[colorArray2.length + n6] = 0;
                nArray3[colorArray2.length + n6] = 0;
            }
        }
        if (this.geneOrExpt == 1) {
            for (n2 = 0; n2 < colorArray.length; ++n2) {
                color3f = new Color3f(colorArray[n2]);
                appearanceArray[n2 + n5] = this.createPointAppearance(color3f);
                pointArrayArray[n2 + n5] = new PointArray(this.data.getColoredProbesCount(n2), 7);
                nArray2[n2 + n5] = 0;
            }
        } else if (this.geneOrExpt == 2) {
            for (n2 = 0; n2 < colorArray.length; ++n2) {
                color3f = new Color3f(colorArray[n2]);
                appearanceArray[n2 + n5] = this.createPointAppearance(color3f);
                pointArrayArray[n2 + n5] = new PointArray(this.data.getColoredExperimentsCount(n2), 7);
                nArray2[n2 + n5] = 0;
            }
        } else if (this.geneOrExpt == 3) {
            System.out.println("colors.length = " + colorArray.length);
            for (n2 = 0; n2 < colorArray2.length; ++n2) {
                color3f = new Color3f(colorArray[n2]);
                appearanceArray[n2 + n6] = this.createPointAppearance(color3f);
                pointArrayArray[n2 + n6] = new PointArray(this.data.getColoredProbesCount(n2), 7);
                nArray2[n2 + n6] = 0;
            }
            for (n2 = 0; n2 < colorArray3.length; ++n2) {
                color3f = new Color3f(colorArray[colorArray2.length + n2]);
                appearanceArray[colorArray2.length + n6 + n2 + n7] = this.createPointAppearance(color3f);
                pointArrayArray[colorArray2.length + n6 + n2 + n7] = new PointArray(this.data.getColoredExperimentsCount(n2), 7);
                nArray2[colorArray2.length + n6 + n2 + n7] = 0;
                nArray3[colorArray2.length + n6 + n2 + n7] = 0;
            }
        }
        float f = 3.0f / this.scaleAxisX;
        float f2 = 3.0f / this.scaleAxisY;
        float f3 = 3.0f / this.scaleAxisZ;
        int n9 = 0;
        System.out.println("U.getRowDimension() = " + this.U.getRowDimension());
        for (int i = 0; i < this.U.getRowDimension(); ++i) {
            float f4 = this.U.get(i, this.xAxis);
            float f5 = this.U.get(i, this.yAxis);
            float f6 = this.U.get(i, this.zAxis);
            if (this.isSelection() && this.isPointSelected(f4, f5, f6)) continue;
            if (this.geneOrExpt == 1) {
                n9 = this.data.getProbeColorIndex(this.experiment.getGeneIndexMappedToData(i)) + n5;
                System.out.println("i = " + i + ", index = " + n9 + ", counters[index] = " + nArray2[n9]);
                pointArrayArray[n9].setCoordinate(nArray2[n9], new Point3f(f4 * f, f5 * f2, f6 * f3));
                int n10 = n9;
                nArray2[n10] = nArray2[n10] + 1;
                continue;
            }
            if (this.geneOrExpt == 2) {
                n9 = this.data.getExperimentColorIndex(i) + n5;
                System.out.println("i = " + i + ", index = " + n9 + ", counters[index] = " + nArray2[n9]);
                pointArrayArray[n9].setCoordinate(nArray2[n9], new Point3f(f4 * f, f5 * f2, f6 * f3));
                int n11 = n9;
                nArray2[n11] = nArray2[n11] + 1;
                continue;
            }
            if (this.geneOrExpt != 3) continue;
            if (i < this.geneUMatrix.getRowDimension()) {
                n9 = this.data.getProbeColorIndex(this.experiment.getGeneIndexMappedToData(i)) + n6;
                System.out.println("i < geneUMatrix.getRowDimension(): i = " + i + ", index = " + n9 + ", counters[index] = " + nArray2[n9]);
                pointArrayArray[n9].setCoordinate(nArray2[n9], new Point3f(f4 * f, f5 * f2, f6 * f3));
                int n12 = n9;
                nArray2[n12] = nArray2[n12] + 1;
                continue;
            }
            n = this.data.getExperimentColorIndex(i - this.geneUMatrix.getRowDimension()) + n7;
            n9 = n == 0 ? 0 : this.data.getExperimentColorIndex(i - this.geneUMatrix.getRowDimension()) + n7 + this.data.getColors().length;
            System.out.println("i >= geneUMatrix.getRowDimension(): i = " + i + ", index = " + n9 + ", exptCounters[index] = " + nArray3[n9]);
            pointArrayArray[n9].setCoordinate(nArray3[n9], new Point3f(f4 * f, f5 * f2, f6 * f3));
            int n13 = n9;
            nArray3[n13] = nArray3[n13] + 1;
        }
        Shape3D[] shape3DArray = new Shape3D[pointArrayArray.length];
        for (n = 0; n < shape3DArray.length; ++n) {
            shape3DArray[n] = new Shape3D();
            shape3DArray[n].setAppearance(appearanceArray[n]);
            shape3DArray[n].setGeometry((Geometry)pointArrayArray[n]);
        }
        System.out.println("Reached end of createUsualPoints");
        return shape3DArray;
    }

    private Appearance createSphereAppearance(Color3f color3f) {
        Material material = new Material(color3f, this.blackColor, color3f, this.whiteColor, 100.0f);
        material.setLightingEnable(true);
        Appearance appearance = new Appearance();
        appearance.setMaterial(material);
        return appearance;
    }

    private TransformGroup createSpheres() {
        TransformGroup transformGroup = new TransformGroup();
        float f = 3.0f / this.scaleAxisX;
        float f2 = 3.0f / this.scaleAxisY;
        float f3 = 3.0f / this.scaleAxisZ;
        Color3f color3f = this.isWhiteBackground() ? this.blackColor : this.whiteColor;
        Appearance appearance = this.createSphereAppearance(color3f);
        Color3f color3f2 = this.isSelection() ? new Color3f(1.0f, 0.3f, 1.0f) : color3f;
        Appearance appearance2 = this.createSphereAppearance(color3f2);
        for (int i = 0; i < this.U.getRowDimension(); ++i) {
            boolean bl;
            float f4 = this.U.get(i, this.xAxis);
            float f5 = this.U.get(i, this.yAxis);
            float f6 = this.U.get(i, this.zAxis);
            Transform3D transform3D = new Transform3D();
            Vector3d vector3d = new Vector3d((double)(f4 * f), (double)(f5 * f2), (double)(f6 * f3));
            transform3D.set(vector3d);
            TransformGroup transformGroup2 = new TransformGroup(transform3D);
            boolean bl2 = bl = this.isSelection() && this.isPointSelected(f4, f5, f6);
            if (this.geneOrExpt == 1) {
                if (this.data.getProbeColor(this.experiment.getGeneIndexMappedToData(i)) == null) {
                    transformGroup2.addChild((Node)new Sphere(this.getPointSize(bl) / 20.0f, bl ? appearance2 : appearance));
                } else {
                    transformGroup2.addChild((Node)new Sphere(this.getPointSize(bl) / 20.0f, bl ? appearance2 : this.createSphereAppearance(new Color3f(this.data.getProbeColor(this.experiment.getGeneIndexMappedToData(i))))));
                }
            } else if (this.geneOrExpt == 2) {
                if (this.data.getExperimentColor(i) == null) {
                    transformGroup2.addChild((Node)new Sphere(this.getPointSize(bl) / 20.0f, bl ? appearance2 : appearance));
                } else {
                    transformGroup2.addChild((Node)new Sphere(this.getPointSize(bl) / 20.0f, bl ? appearance2 : this.createSphereAppearance(new Color3f(this.data.getExperimentColor(i)))));
                }
            } else if (this.geneOrExpt == 3) {
                if (i < this.geneUMatrix.getRowDimension()) {
                    if (this.data.getProbeColor(this.experiment.getGeneIndexMappedToData(i)) == null) {
                        transformGroup2.addChild((Node)new Sphere(this.getPointSize(bl) / 20.0f, bl ? appearance2 : appearance));
                    } else {
                        transformGroup2.addChild((Node)new Sphere(this.getPointSize(bl) / 20.0f, bl ? appearance2 : this.createSphereAppearance(new Color3f(this.data.getProbeColor(this.experiment.getGeneIndexMappedToData(i))))));
                    }
                } else if (this.data.getExperimentColor(i - this.geneUMatrix.getRowDimension()) == null) {
                    transformGroup2.addChild((Node)new Sphere(2.0f * this.getPointSize(bl) / 20.0f, bl ? appearance2 : appearance));
                } else {
                    transformGroup2.addChild((Node)new Sphere(2.0f * this.getPointSize(bl) / 20.0f, bl ? appearance2 : this.createSphereAppearance(new Color3f(this.data.getExperimentColor(i - this.geneUMatrix.getRowDimension())))));
                }
            }
            transformGroup.addChild((Node)transformGroup2);
        }
        return transformGroup;
    }

    private TransformGroup createText() {
        TransformGroup transformGroup = new TransformGroup();
        float f = 3.0f / this.scaleAxisX;
        float f2 = 3.0f / this.scaleAxisY;
        float f3 = 3.0f / this.scaleAxisZ;
        Font3D font3D = new Font3D(new Font("TestFont", 1, Math.round(this.getPointSize(false))), new FontExtrusion());
        Font font = font3D.getFont();
        FontMetrics fontMetrics = this.onScreenCanvas.getFontMetrics(font);
        int n = fontMetrics.getAscent();
        Color3f color3f = !this.whiteBackground ? new Color3f(1.0f, 1.0f, 1.0f) : new Color3f(0.0f, 0.0f, 0.0f);
        Material material = !this.whiteBackground ? new Material(color3f, this.whiteColor, color3f, this.whiteColor, 100.0f) : new Material(color3f, this.blackColor, color3f, this.blackColor, 100.0f);
        material.setLightingEnable(true);
        Appearance appearance = new Appearance();
        appearance.setMaterial(material);
        Transform3D transform3D = new Transform3D();
        transform3D.setScale(0.1);
        for (int i = 0; i < this.U.getRowDimension(); ++i) {
            float f4 = this.U.get(i, this.xAxis);
            float f5 = this.U.get(i, this.yAxis);
            float f6 = this.U.get(i, this.zAxis);
            TransformGroup transformGroup2 = new TransformGroup(transform3D);
            String string = "";
            if (this.geneOrExpt == 1) {
                string = this.data.getElementAttribute(this.experiment.getGeneIndexMappedToData(i), this.geneLabelIndex);
            } else if (this.geneOrExpt == 2) {
                string = this.data.getSampleName(this.experiment.getSampleIndex(i));
            } else if (this.geneOrExpt == 3) {
                string = i < this.geneUMatrix.getRowDimension() ? this.data.getElementAttribute(this.experiment.getGeneIndexMappedToData(i), this.geneLabelIndex) : this.data.getSampleName(this.experiment.getSampleIndex(i - this.geneUMatrix.getRowDimension()));
            }
            Text3D text3D = new Text3D(font3D, string, new Point3f(f4 * f * 10.0f + this.getPointSize(this.isPointSelected(f4, f5, f6)), f5 * f2 * 10.0f - (float)n / 2.0f, f6 * f3 * 10.0f));
            Shape3D shape3D = new Shape3D();
            shape3D.setGeometry((Geometry)text3D);
            shape3D.setAppearance(appearance);
            transformGroup2.addChild((Node)shape3D);
            transformGroup.addChild((Node)transformGroup2);
        }
        return transformGroup;
    }

    private TransformGroup createGeneTextFromBoth() {
        TransformGroup transformGroup = new TransformGroup();
        float f = 3.0f / this.scaleAxisX;
        float f2 = 3.0f / this.scaleAxisY;
        float f3 = 3.0f / this.scaleAxisZ;
        Font3D font3D = new Font3D(new Font("TestFont", 1, Math.round(this.getPointSize(false))), new FontExtrusion());
        Font font = font3D.getFont();
        FontMetrics fontMetrics = this.onScreenCanvas.getFontMetrics(font);
        int n = fontMetrics.getAscent();
        Color3f color3f = !this.whiteBackground ? new Color3f(1.0f, 1.0f, 1.0f) : new Color3f(0.0f, 0.0f, 0.0f);
        Material material = !this.whiteBackground ? new Material(color3f, this.whiteColor, color3f, this.whiteColor, 100.0f) : new Material(color3f, this.blackColor, color3f, this.blackColor, 100.0f);
        material.setLightingEnable(true);
        Appearance appearance = new Appearance();
        appearance.setMaterial(material);
        Transform3D transform3D = new Transform3D();
        transform3D.setScale(0.1);
        for (int i = 0; i < this.geneUMatrix.getRowDimension(); ++i) {
            float f4 = this.U.get(i, this.xAxis);
            float f5 = this.U.get(i, this.yAxis);
            float f6 = this.U.get(i, this.zAxis);
            TransformGroup transformGroup2 = new TransformGroup(transform3D);
            String string = "";
            if (this.geneOrExpt == 3) {
                string = this.data.getElementAttribute(this.experiment.getGeneIndexMappedToData(i), this.geneLabelIndex);
            }
            Text3D text3D = new Text3D(font3D, string, new Point3f(f4 * f * 10.0f + this.getPointSize(this.isPointSelected(f4, f5, f6)), f5 * f2 * 10.0f - (float)n / 2.0f, f6 * f3 * 10.0f));
            Shape3D shape3D = new Shape3D();
            shape3D.setGeometry((Geometry)text3D);
            shape3D.setAppearance(appearance);
            transformGroup2.addChild((Node)shape3D);
            transformGroup.addChild((Node)transformGroup2);
        }
        return transformGroup;
    }

    private TransformGroup createSampleTextFromBoth() {
        TransformGroup transformGroup = new TransformGroup();
        float f = 3.0f / this.scaleAxisX;
        float f2 = 3.0f / this.scaleAxisY;
        float f3 = 3.0f / this.scaleAxisZ;
        Font3D font3D = new Font3D(new Font("TestFont", 1, Math.round(this.getPointSize(false))), new FontExtrusion());
        Font font = font3D.getFont();
        FontMetrics fontMetrics = this.onScreenCanvas.getFontMetrics(font);
        int n = fontMetrics.getAscent();
        Color3f color3f = !this.whiteBackground ? new Color3f(1.0f, 1.0f, 1.0f) : new Color3f(0.0f, 0.0f, 0.0f);
        Material material = !this.whiteBackground ? new Material(color3f, this.whiteColor, color3f, this.whiteColor, 100.0f) : new Material(color3f, this.blackColor, color3f, this.blackColor, 100.0f);
        material.setLightingEnable(true);
        Appearance appearance = new Appearance();
        appearance.setMaterial(material);
        Transform3D transform3D = new Transform3D();
        transform3D.setScale(0.1);
        for (int i = this.geneUMatrix.getRowDimension(); i < this.U.getRowDimension(); ++i) {
            float f4 = this.U.get(i, this.xAxis);
            float f5 = this.U.get(i, this.yAxis);
            float f6 = this.U.get(i, this.zAxis);
            TransformGroup transformGroup2 = new TransformGroup(transform3D);
            String string = "";
            if (this.geneOrExpt == 3) {
                string = this.data.getSampleName(this.experiment.getSampleIndex(i - this.geneUMatrix.getRowDimension()));
            }
            Text3D text3D = new Text3D(font3D, string, new Point3f(f4 * f * 10.0f + this.getPointSize(this.isPointSelected(f4, f5, f6)), f5 * f2 * 10.0f - (float)n / 2.0f, f6 * f3 * 10.0f));
            Shape3D shape3D = new Shape3D();
            shape3D.setGeometry((Geometry)text3D);
            shape3D.setAppearance(appearance);
            transformGroup2.addChild((Node)shape3D);
            transformGroup.addChild((Node)transformGroup2);
        }
        return transformGroup;
    }

    private Shape3D createTextShape3D(String string) {
        Material material;
        Font3D font3D = new Font3D(new Font("TestFont", 1, 1), new FontExtrusion());
        Text3D text3D = new Text3D(font3D, string);
        Shape3D shape3D = new Shape3D();
        shape3D.setGeometry((Geometry)text3D);
        if (!this.whiteBackground) {
            Color3f color3f = new Color3f(0.5f, 0.5f, 0.5f);
            material = new Material(color3f, this.blackColor, color3f, this.whiteColor, 100.0f);
        } else {
            Color3f color3f = new Color3f(0.0f, 0.0f, 0.0f);
            material = new Material(color3f, this.blackColor, color3f, this.blackColor, 100.0f);
        }
        material.setLightingEnable(true);
        Appearance appearance = new Appearance();
        appearance.setMaterial(material);
        shape3D.setAppearance(appearance);
        return shape3D;
    }

    private TransformGroup createXAxis() {
        Transform3D transform3D = new Transform3D();
        transform3D.rotZ(-1.5707963267948966);
        Transform3D transform3D2 = new Transform3D();
        transform3D2.rotZ(1.5707963267948966);
        if (!this.whiteBackground) {
            return this.createAxis("" + (this.xAxis + 1), new Color3f(0.5f, 0.5f, 0.5f), transform3D, transform3D2);
        }
        return this.createAxis("" + (this.xAxis + 1), new Color3f(0.0f, 0.0f, 0.0f), transform3D, transform3D2);
    }

    private TransformGroup createYAxis() {
        if (!this.whiteBackground) {
            return this.createAxis("" + (this.yAxis + 1), new Color3f(0.3f, 0.3f, 1.0f), null, null);
        }
        return this.createAxis("" + (this.yAxis + 1), new Color3f(0.0f, 0.0f, 0.0f), null, null);
    }

    private TransformGroup createZAxis() {
        Transform3D transform3D = new Transform3D();
        transform3D.rotX(-1.5707963267948966);
        Transform3D transform3D2 = new Transform3D();
        transform3D2.rotY(1.5707963267948966);
        transform3D.mul(transform3D2);
        Transform3D transform3D3 = new Transform3D();
        transform3D3.rotZ(1.5707963267948966);
        if (!this.whiteBackground) {
            return this.createAxis("" + (this.zAxis + 1), new Color3f(1.0f, 0.3f, 1.0f), transform3D, transform3D3);
        }
        return this.createAxis("" + (this.zAxis + 1), new Color3f(0.0f, 0.0f, 0.0f), transform3D, transform3D3);
    }

    private TransformGroup createAxis(String string, Color3f color3f, Transform3D transform3D, Transform3D transform3D2) {
        TransformGroup transformGroup = new TransformGroup();
        if (transform3D != null) {
            transformGroup.setTransform(transform3D);
        }
        transformGroup.addChild((Node)this.createCylinder(color3f));
        Transform3D transform3D3 = new Transform3D();
        transform3D3.set(new Vector3d(0.0, 3.1, 0.0));
        TransformGroup transformGroup2 = new TransformGroup(transform3D3);
        transformGroup2.addChild((Node)this.createCone());
        Transform3D transform3D4 = new Transform3D();
        transform3D4.set(new Vector3d(0.0, -3.1, 0.0));
        Transform3D transform3D5 = new Transform3D();
        transform3D5.rotX(Math.PI);
        transform3D4.mul(transform3D5);
        TransformGroup transformGroup3 = new TransformGroup(transform3D4);
        transformGroup3.addChild((Node)this.createCone());
        Transform3D transform3D6 = new Transform3D();
        transform3D6.set(0.22, new Vector3d(0.25, 2.75, -0.0125));
        TransformGroup transformGroup4 = new TransformGroup(transform3D6);
        TransformGroup transformGroup5 = new TransformGroup();
        if (transform3D2 != null) {
            transformGroup5.setTransform(transform3D2);
        }
        Shape3D shape3D = this.createTextShape3D(string);
        transformGroup5.addChild((Node)shape3D);
        transformGroup4.addChild((Node)transformGroup5);
        transformGroup.addChild((Node)transformGroup4);
        transformGroup.addChild((Node)transformGroup2);
        transformGroup.addChild((Node)transformGroup3);
        return transformGroup;
    }
}

