/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.coa;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;
import org.tigr.microarray.mev.cluster.gui.impl.coa.COAContent3D;
import org.tigr.microarray.mev.cluster.gui.impl.coa.COAResultConfigDialog;
import org.tigr.microarray.mev.cluster.gui.impl.coa.COASelectionAreaDialog;
import org.tigr.util.FloatMatrix;

public class COA3DViewer
extends ViewerAdapter
implements Serializable {
    public static final long serialVersionUID = 202022040001L;
    private static final String RESET_CMD = "reset-cmd";
    private static final String OPTIONS_CMD = "options-cmd";
    private static final String SELECTION_AREA_CMD = "select-cmd";
    private static final String SAVE_CMD = "save-cmd";
    private static final String SAVE_GENE_CLUSTER_CMD = "save-genes-cmd";
    private static final String SAVE_EXPT_CLUSTER_CMD = "save-expts-cmd";
    private static final String SHOW_SELECTION_CMD = "show-selection-cmd";
    private static final String HIDE_SELECTION_BOX_CMD = "hide-selection-box-cmd";
    private static final String SHOW_SPHERES_CMD = "show-spheres-cmd";
    private static final String SHOW_TEXT_CMD = "show-text-cmd";
    private static final String SHOW_GENE_TEXT_FROM_BOTH_CMD = "show-gene-test-from-both-cmd";
    private static final String SHOW_EXPT_TEXT_FROM_BOTH_CMD = "show-expt-test-from-both-cmd";
    private static final String WHITE_CMD = "white-cmd";
    private static final String STORE_CLUSTER_CMD = "store-cluster-cmd";
    private static final String STORE_GENE_CLUSTER_CMD = "store-gene-cluster-cmd";
    private static final String STORE_EXPT_CLUSTER_CMD = "store-expt-cluster-cmd";
    private static final String LAUNCH_NEW_SESSION_CMD = "launch-new-session-cmd";
    private static final String LAUNCH_NEW_GENE_SESSION_CMD = "launch-new-gene-session-cmd";
    private static final String LAUNCH_NEW_EXPT_SESSION_CMD = "launch-new-expt-session-cmd";
    private IData data;
    private Experiment experiment;
    private COAContent3D content;
    private JPopupMenu popup;
    private JPopupMenu popup2;
    private Frame frame;
    private int geneOrExpt;
    private int xAxis;
    private int yAxis;
    private int zAxis;
    private int labelIndex = -1;
    private IFramework framework;
    private FloatMatrix geneUMatrix;
    private FloatMatrix exptUMatrix;
    private FloatMatrix U;
    private COASelectionAreaDialog dlg;

    public COA3DViewer(Frame frame, FloatMatrix floatMatrix, Experiment experiment, int n) {
        this.frame = frame;
        this.experiment = experiment;
        this.geneOrExpt = n;
        this.U = floatMatrix;
        this.content = this.createContent(floatMatrix, experiment, n);
        this.dlg = new COASelectionAreaDialog(this.content, frame, this.content.getPositionX(), this.content.getPositionY(), this.content.getPositionZ(), this.content.getSizeX(), this.content.getSizeY(), this.content.getSizeZ(), this.content.getMaxValue());
        this.popup = this.createJPopupMenu();
        Listener listener = new Listener();
        this.popup2 = this.createJPopupMenu(listener);
        this.getContentComponent().addMouseListener(listener);
    }

    public COA3DViewer(Frame frame, FloatMatrix floatMatrix, Experiment experiment, int n, int n2, int n3, int n4) {
        this.frame = frame;
        this.experiment = experiment;
        this.geneOrExpt = n;
        this.U = floatMatrix;
        this.xAxis = n2;
        this.yAxis = n3;
        this.zAxis = n4;
        this.content = this.createContent(floatMatrix, experiment, n, n2, n3, n4);
        this.dlg = new COASelectionAreaDialog(this.content, frame, this.content.getPositionX(), this.content.getPositionY(), this.content.getPositionZ(), this.content.getSizeX(), this.content.getSizeY(), this.content.getSizeZ(), this.content.getMaxValue());
        this.popup = this.createJPopupMenu();
        Listener listener = new Listener();
        this.popup2 = this.createJPopupMenu(listener);
        this.getContentComponent().addMouseListener(listener);
    }

    public COA3DViewer(Frame frame, FloatMatrix floatMatrix, FloatMatrix floatMatrix2, Experiment experiment, int n) {
        this.frame = frame;
        this.experiment = experiment;
        this.geneOrExpt = n;
        this.geneUMatrix = floatMatrix;
        this.exptUMatrix = floatMatrix2;
        this.content = this.createContent(floatMatrix, floatMatrix2, experiment, n);
        this.dlg = new COASelectionAreaDialog(this.content, frame, this.content.getPositionX(), this.content.getPositionY(), this.content.getPositionZ(), this.content.getSizeX(), this.content.getSizeY(), this.content.getSizeZ(), this.content.getMaxValue());
        this.popup = this.createJPopupMenu();
        Listener listener = new Listener();
        this.popup2 = this.createJPopupMenu(listener);
        this.getContentComponent().addMouseListener(listener);
    }

    public COA3DViewer(Frame frame, FloatMatrix floatMatrix, FloatMatrix floatMatrix2, Experiment experiment, int n, int n2, int n3, int n4) {
        this.frame = frame;
        this.experiment = experiment;
        this.geneOrExpt = n;
        this.geneUMatrix = floatMatrix;
        this.exptUMatrix = floatMatrix2;
        this.xAxis = n2;
        this.yAxis = n3;
        this.zAxis = n4;
        this.content = this.createContent(floatMatrix, floatMatrix2, experiment, n, n2, n3, n4);
        this.dlg = new COASelectionAreaDialog(this.content, frame, this.content.getPositionX(), this.content.getPositionY(), this.content.getPositionZ(), this.content.getSizeX(), this.content.getSizeY(), this.content.getSizeZ(), this.content.getMaxValue());
        this.popup = this.createJPopupMenu();
        Listener listener = new Listener();
        this.popup2 = this.createJPopupMenu(listener);
        this.getContentComponent().addMouseListener(listener);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.experiment);
        objectOutputStream.writeInt(this.geneOrExpt);
        if (this.geneOrExpt == 3) {
            objectOutputStream.writeObject(this.geneUMatrix);
            objectOutputStream.writeObject(this.exptUMatrix);
        } else {
            objectOutputStream.writeObject(this.U);
        }
        objectOutputStream.writeInt(this.xAxis);
        objectOutputStream.writeInt(this.yAxis);
        objectOutputStream.writeInt(this.zAxis);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.experiment = (Experiment)objectInputStream.readObject();
        this.geneOrExpt = objectInputStream.readInt();
        if (this.geneOrExpt == 3) {
            this.geneUMatrix = (FloatMatrix)objectInputStream.readObject();
            this.exptUMatrix = (FloatMatrix)objectInputStream.readObject();
            this.xAxis = objectInputStream.readInt();
            this.yAxis = objectInputStream.readInt();
            this.zAxis = objectInputStream.readInt();
            this.content = this.createContent(this.geneUMatrix, this.exptUMatrix, this.experiment, this.geneOrExpt, this.xAxis, this.yAxis, this.zAxis);
            this.dlg = new COASelectionAreaDialog(this.content, this.frame, this.content.getPositionX(), this.content.getPositionY(), this.content.getPositionZ(), this.content.getSizeX(), this.content.getSizeY(), this.content.getSizeZ(), this.content.getMaxValue());
        } else {
            this.U = (FloatMatrix)objectInputStream.readObject();
            this.xAxis = objectInputStream.readInt();
            this.yAxis = objectInputStream.readInt();
            this.zAxis = objectInputStream.readInt();
            this.content = this.createContent(this.U, this.experiment, this.geneOrExpt, this.xAxis, this.yAxis, this.zAxis);
            this.dlg = new COASelectionAreaDialog(this.content, this.frame, this.content.getPositionX(), this.content.getPositionY(), this.content.getPositionZ(), this.content.getSizeX(), this.content.getSizeY(), this.content.getSizeZ(), this.content.getMaxValue());
        }
    }

    public void onSelected(IFramework iFramework) {
        this.framework = iFramework;
        this.frame = iFramework.getFrame();
        this.data = iFramework.getData();
        IDisplayMenu iDisplayMenu = iFramework.getDisplayMenu();
        this.labelIndex = iDisplayMenu.getLabelIndex();
        this.content.setData(this.data);
        this.content.setGeneLabelIndex(this.labelIndex);
        this.onMenuChanged(iDisplayMenu);
        this.content.updateScene();
        if (this.popup == null) {
            this.popup = this.createJPopupMenu();
            DefaultMutableTreeNode defaultMutableTreeNode = iFramework.getCurrentNode();
            if (defaultMutableTreeNode != null && defaultMutableTreeNode.getUserObject() instanceof LeafInfo) {
                LeafInfo leafInfo = (LeafInfo)defaultMutableTreeNode.getUserObject();
                leafInfo.setPopupMenu(this.popup);
            }
        }
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
        this.labelIndex = iDisplayMenu.getLabelIndex();
        this.content.setGeneLabelIndex(this.labelIndex);
        this.content.updateScene();
    }

    public void onDataChanged(IData iData) {
        this.data = iData;
        this.content.setData(iData);
        this.content.updateScene();
    }

    public JComponent getContentComponent() {
        return this.content;
    }

    public BufferedImage getImage() {
        return this.content.createImage();
    }

    private COAContent3D createContent(FloatMatrix floatMatrix, Experiment experiment, int n) {
        return new COAContent3D(floatMatrix, experiment, n);
    }

    private COAContent3D createContent(FloatMatrix floatMatrix, FloatMatrix floatMatrix2, Experiment experiment, int n) {
        return new COAContent3D(floatMatrix, floatMatrix2, experiment, n);
    }

    private COAContent3D createContent(FloatMatrix floatMatrix, Experiment experiment, int n, int n2, int n3, int n4) {
        return new COAContent3D(floatMatrix, experiment, n, n2, this.yAxis, n4);
    }

    private COAContent3D createContent(FloatMatrix floatMatrix, FloatMatrix floatMatrix2, Experiment experiment, int n, int n2, int n3, int n4) {
        return new COAContent3D(floatMatrix, floatMatrix2, experiment, n, n2, this.yAxis, n4);
    }

    public JPopupMenu getJPopupMenu() {
        return this.popup;
    }

    private JPopupMenu createJPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.addMenuItems(jPopupMenu);
        return jPopupMenu;
    }

    private JPopupMenu createJPopupMenu(Listener listener) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.addMenuItems(jPopupMenu, listener);
        return jPopupMenu;
    }

    private void addMenuItems(JPopupMenu jPopupMenu) {
        Listener listener = new Listener();
        JMenuItem jMenuItem = new JMenuItem("Reset", GUIFactory.getIcon("refresh16.gif"));
        jMenuItem.setActionCommand(RESET_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Options...", GUIFactory.getIcon("edit16.gif"));
        jMenuItem.setActionCommand(OPTIONS_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Selection area...", GUIFactory.getIcon("edit16.gif"));
        jMenuItem.setEnabled(false);
        jMenuItem.setActionCommand(SELECTION_AREA_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        if (this.geneOrExpt == 3) {
            jMenuItem = new JMenuItem("Store gene cluster...", GUIFactory.getIcon("new16.gif"));
            jMenuItem.setEnabled(false);
            jMenuItem.setActionCommand(STORE_GENE_CLUSTER_CMD);
            jMenuItem.addActionListener(listener);
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Launch new session with selected genes", GUIFactory.getIcon("launch_new_mav.gif"));
            jMenuItem.setEnabled(false);
            jMenuItem.setActionCommand(LAUNCH_NEW_GENE_SESSION_CMD);
            jMenuItem.addActionListener(listener);
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Save gene cluster...", GUIFactory.getIcon("save16.gif"));
            jMenuItem.setEnabled(false);
            jMenuItem.setActionCommand(SAVE_GENE_CLUSTER_CMD);
            jMenuItem.addActionListener(listener);
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JCheckBoxMenuItem("Show gene text");
            jMenuItem.setEnabled(true);
            jMenuItem.setActionCommand(SHOW_GENE_TEXT_FROM_BOTH_CMD);
            jMenuItem.addActionListener(listener);
            jPopupMenu.add(jMenuItem);
            jPopupMenu.addSeparator();
            jMenuItem = new JMenuItem("Store sample cluster...", GUIFactory.getIcon("new16.gif"));
            jMenuItem.setEnabled(false);
            jMenuItem.setActionCommand(STORE_EXPT_CLUSTER_CMD);
            jMenuItem.addActionListener(listener);
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Launch new session with selected samples", GUIFactory.getIcon("launch_new_mav.gif"));
            jMenuItem.setEnabled(false);
            jMenuItem.setActionCommand(LAUNCH_NEW_EXPT_SESSION_CMD);
            jMenuItem.addActionListener(listener);
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Save sample cluster...", GUIFactory.getIcon("save16.gif"));
            jMenuItem.setEnabled(false);
            jMenuItem.setActionCommand(SAVE_EXPT_CLUSTER_CMD);
            jMenuItem.addActionListener(listener);
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JCheckBoxMenuItem("Show sample text");
            jMenuItem.setEnabled(true);
            jMenuItem.setActionCommand(SHOW_EXPT_TEXT_FROM_BOTH_CMD);
            jMenuItem.addActionListener(listener);
            jPopupMenu.add(jMenuItem);
            jPopupMenu.addSeparator();
        } else {
            jMenuItem = new JMenuItem("Store cluster...", GUIFactory.getIcon("new16.gif"));
            jMenuItem.setEnabled(false);
            jMenuItem.setActionCommand(STORE_CLUSTER_CMD);
            jMenuItem.addActionListener(listener);
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Launch new session", GUIFactory.getIcon("launch_new_mav.gif"));
            jMenuItem.setEnabled(false);
            jMenuItem.setActionCommand(LAUNCH_NEW_SESSION_CMD);
            jMenuItem.addActionListener(listener);
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Save cluster...", GUIFactory.getIcon("save16.gif"));
            jMenuItem.setEnabled(false);
            jMenuItem.setActionCommand(SAVE_CMD);
            jMenuItem.addActionListener(listener);
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JCheckBoxMenuItem("Show text");
            jMenuItem.setEnabled(true);
            jMenuItem.setActionCommand(SHOW_TEXT_CMD);
            jMenuItem.addActionListener(listener);
            jPopupMenu.add(jMenuItem);
            jPopupMenu.addSeparator();
        }
        jMenuItem = new JCheckBoxMenuItem("Show selection area");
        jMenuItem.setActionCommand(SHOW_SELECTION_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JCheckBoxMenuItem("Hide selection box");
        jMenuItem.setEnabled(false);
        jMenuItem.setActionCommand(HIDE_SELECTION_BOX_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JCheckBoxMenuItem("Show spheres");
        jMenuItem.setActionCommand(SHOW_SPHERES_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JCheckBoxMenuItem("White background");
        jMenuItem.setActionCommand(WHITE_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
    }

    private void addMenuItems(JPopupMenu jPopupMenu, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem("Reset", GUIFactory.getIcon("refresh16.gif"));
        jMenuItem.setActionCommand(RESET_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Options...", GUIFactory.getIcon("edit16.gif"));
        jMenuItem.setActionCommand(OPTIONS_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Selection area...", GUIFactory.getIcon("edit16.gif"));
        jMenuItem.setEnabled(false);
        jMenuItem.setActionCommand(SELECTION_AREA_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        if (this.geneOrExpt == 3) {
            jMenuItem = new JMenuItem("Store gene cluster...", GUIFactory.getIcon("new16.gif"));
            jMenuItem.setEnabled(false);
            jMenuItem.setActionCommand(STORE_GENE_CLUSTER_CMD);
            jMenuItem.addActionListener(actionListener);
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Launch new session with selected genes", GUIFactory.getIcon("launch_new_mav.gif"));
            jMenuItem.setEnabled(false);
            jMenuItem.setActionCommand(LAUNCH_NEW_GENE_SESSION_CMD);
            jMenuItem.addActionListener(actionListener);
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Save gene cluster...", GUIFactory.getIcon("save16.gif"));
            jMenuItem.setEnabled(false);
            jMenuItem.setActionCommand(SAVE_GENE_CLUSTER_CMD);
            jMenuItem.addActionListener(actionListener);
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JCheckBoxMenuItem("Show gene text");
            jMenuItem.setEnabled(true);
            jMenuItem.setActionCommand(SHOW_GENE_TEXT_FROM_BOTH_CMD);
            jMenuItem.addActionListener(actionListener);
            jPopupMenu.add(jMenuItem);
            jPopupMenu.addSeparator();
            jMenuItem = new JMenuItem("Store sample cluster...", GUIFactory.getIcon("new16.gif"));
            jMenuItem.setEnabled(false);
            jMenuItem.setActionCommand(STORE_EXPT_CLUSTER_CMD);
            jMenuItem.addActionListener(actionListener);
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Launch new session with selected samples", GUIFactory.getIcon("launch_new_mav.gif"));
            jMenuItem.setEnabled(false);
            jMenuItem.setActionCommand(LAUNCH_NEW_EXPT_SESSION_CMD);
            jMenuItem.addActionListener(actionListener);
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Save sample cluster...", GUIFactory.getIcon("save16.gif"));
            jMenuItem.setEnabled(false);
            jMenuItem.setActionCommand(SAVE_EXPT_CLUSTER_CMD);
            jMenuItem.addActionListener(actionListener);
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JCheckBoxMenuItem("Show sample text");
            jMenuItem.setEnabled(true);
            jMenuItem.setActionCommand(SHOW_EXPT_TEXT_FROM_BOTH_CMD);
            jMenuItem.addActionListener(actionListener);
            jPopupMenu.add(jMenuItem);
            jPopupMenu.addSeparator();
        } else {
            jMenuItem = new JMenuItem("Store cluster...", GUIFactory.getIcon("new16.gif"));
            jMenuItem.setEnabled(false);
            jMenuItem.setActionCommand(STORE_CLUSTER_CMD);
            jMenuItem.addActionListener(actionListener);
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Launch new session", GUIFactory.getIcon("launch_new_mav.gif"));
            jMenuItem.setEnabled(false);
            jMenuItem.setActionCommand(LAUNCH_NEW_SESSION_CMD);
            jMenuItem.addActionListener(actionListener);
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Save cluster...", GUIFactory.getIcon("save16.gif"));
            jMenuItem.setEnabled(false);
            jMenuItem.setActionCommand(SAVE_CMD);
            jMenuItem.addActionListener(actionListener);
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JCheckBoxMenuItem("Show text");
            jMenuItem.setEnabled(true);
            jMenuItem.setActionCommand(SHOW_TEXT_CMD);
            jMenuItem.addActionListener(actionListener);
            jPopupMenu.add(jMenuItem);
            jPopupMenu.addSeparator();
        }
        jMenuItem = new JCheckBoxMenuItem("Show selection area");
        jMenuItem.setActionCommand(SHOW_SELECTION_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JCheckBoxMenuItem("Hide selection box");
        jMenuItem.setEnabled(false);
        jMenuItem.setActionCommand(HIDE_SELECTION_BOX_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JCheckBoxMenuItem("Show spheres");
        jMenuItem.setActionCommand(SHOW_SPHERES_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JCheckBoxMenuItem("White background");
        jMenuItem.setActionCommand(WHITE_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
    }

    private JMenuItem getJMenuItem(String string) {
        Component[] componentArray = this.popup.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JMenuItem) || !((JMenuItem)componentArray[i]).getActionCommand().equals(string)) continue;
            return (JMenuItem)componentArray[i];
        }
        return null;
    }

    private void setEnableMenuItem(String string, boolean bl) {
        JMenuItem jMenuItem = this.getJMenuItem(string);
        if (jMenuItem == null) {
            return;
        }
        jMenuItem.setEnabled(bl);
    }

    private void onReset() {
        this.content.reset();
    }

    private void onOptions() {
        COAResultConfigDialog cOAResultConfigDialog = new COAResultConfigDialog(this.frame, this.content.getPointSize(), this.content.getSelectedPointSize(), this.content.getScaleAxisX(), this.content.getScaleAxisY(), this.content.getScaleAxisZ());
        if (cOAResultConfigDialog.showModal() == 0) {
            this.content.setPointSize(cOAResultConfigDialog.getPointSize());
            this.content.setSelectedPointSize(cOAResultConfigDialog.getSelectedPointSize());
            this.content.setScale(cOAResultConfigDialog.getScaleAxisX(), cOAResultConfigDialog.getScaleAxisY(), cOAResultConfigDialog.getScaleAxisZ());
            this.content.updateScene();
        }
    }

    private void onSelectionArea() {
        if (this.dlg.showModal() == 0) {
            this.content.setBoxPosition(this.dlg.getPositionX(), this.dlg.getPositionY(), this.dlg.getPositionZ());
            this.content.setBoxSize(this.dlg.getSizeX(), this.dlg.getSizeY(), this.dlg.getSizeZ());
            this.content.updateScene();
        }
    }

    private void onSave() {
        try {
            if (this.geneOrExpt == 1) {
                ExperimentUtil.saveExperiment((Frame)this.frame, (Experiment)this.experiment, (IData)this.data, (int[])this.content.getSelectedGenes());
            } else if (this.geneOrExpt == 2) {
                ExperimentUtil.saveExperimentCluster((Frame)this.frame, (Experiment)this.experiment, (IData)this.data, (int[])this.content.getSelectedGenes());
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.frame, "Can not save matrix!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    private void onSaveGenesFromBoth() {
        try {
            ExperimentUtil.saveExperiment((Frame)this.frame, (Experiment)this.experiment, (IData)this.data, (int[])this.content.getSelectedGenesFromBoth());
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.frame, "Can not save matrix!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    private void onSaveExptsFromBoth() {
        try {
            ExperimentUtil.saveExperimentCluster((Frame)this.frame, (Experiment)this.experiment, (IData)this.data, (int[])this.content.getSelectedExptsFromBoth());
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.frame, "Can not save matrix!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    private void storeCluster() {
        if (this.geneOrExpt == 1) {
            this.framework.storeSubCluster(this.content.getSelectedGenes(), this.experiment, 0);
        } else if (this.geneOrExpt == 2) {
            this.framework.storeSubCluster(this.content.getSelectedGenes(), this.experiment, 1);
        }
        this.content.setSelection(false);
        this.onDataChanged(this.data);
        this.content.updateScene();
    }

    private void storeGeneClusterFromBoth() {
        this.framework.storeSubCluster(this.content.getSelectedGenesFromBoth(), this.experiment, 0);
        this.content.setSelection(false);
        this.onDataChanged(this.data);
        this.content.updateScene();
    }

    private void storeExptClusterFromBoth() {
        this.framework.storeSubCluster(this.content.getSelectedExptsFromBoth(), this.experiment, 1);
        this.content.setSelection(false);
        this.onDataChanged(this.data);
        this.content.updateScene();
    }

    private void launchNewSession() {
        if (this.geneOrExpt == 1) {
            this.framework.launchNewMAV(this.content.getSelectedGenes(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 0);
        } else if (this.geneOrExpt == 2) {
            this.framework.launchNewMAV(this.content.getSelectedGenes(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 1);
        }
    }

    private void launchNewGeneSessionFromBoth() {
        this.framework.launchNewMAV(this.content.getSelectedGenesFromBoth(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 0);
    }

    private void launchNewExptSessionFromBoth() {
        this.framework.launchNewMAV(this.content.getSelectedExptsFromBoth(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 1);
    }

    private void onShowSelection() {
        JMenuItem jMenuItem = this.getJMenuItem(SHOW_SELECTION_CMD);
        JMenuItem jMenuItem2 = this.getJMenuItem(HIDE_SELECTION_BOX_CMD);
        JMenuItem jMenuItem3 = this.getJMenuItem(SELECTION_AREA_CMD);
        if (this.geneOrExpt == 1 || this.geneOrExpt == 2) {
            JMenuItem jMenuItem4 = this.getJMenuItem(SAVE_CMD);
            JMenuItem jMenuItem5 = this.getJMenuItem(STORE_CLUSTER_CMD);
            JMenuItem jMenuItem6 = this.getJMenuItem(LAUNCH_NEW_SESSION_CMD);
            if (jMenuItem.isSelected()) {
                this.content.setSelection(true);
                this.content.setSelectionBox(!jMenuItem2.isSelected());
                jMenuItem3.setEnabled(true);
                jMenuItem4.setEnabled(true);
                jMenuItem2.setEnabled(true);
                jMenuItem5.setEnabled(true);
                jMenuItem6.setEnabled(true);
            } else {
                this.content.setSelection(false);
                this.content.setSelectionBox(false);
                jMenuItem3.setEnabled(false);
                jMenuItem4.setEnabled(false);
                jMenuItem2.setEnabled(false);
                jMenuItem5.setEnabled(false);
                jMenuItem6.setEnabled(false);
            }
        } else {
            JMenuItem jMenuItem7 = this.getJMenuItem(SAVE_GENE_CLUSTER_CMD);
            JMenuItem jMenuItem8 = this.getJMenuItem(STORE_GENE_CLUSTER_CMD);
            JMenuItem jMenuItem9 = this.getJMenuItem(LAUNCH_NEW_GENE_SESSION_CMD);
            JMenuItem jMenuItem10 = this.getJMenuItem(SAVE_EXPT_CLUSTER_CMD);
            JMenuItem jMenuItem11 = this.getJMenuItem(STORE_EXPT_CLUSTER_CMD);
            JMenuItem jMenuItem12 = this.getJMenuItem(LAUNCH_NEW_EXPT_SESSION_CMD);
            if (jMenuItem.isSelected()) {
                this.content.setSelection(true);
                this.content.setSelectionBox(!jMenuItem2.isSelected());
                jMenuItem3.setEnabled(true);
                jMenuItem7.setEnabled(true);
                jMenuItem10.setEnabled(true);
                jMenuItem2.setEnabled(true);
                jMenuItem8.setEnabled(true);
                jMenuItem11.setEnabled(true);
                jMenuItem9.setEnabled(true);
                jMenuItem12.setEnabled(true);
            } else {
                this.content.setSelection(false);
                this.content.setSelectionBox(false);
                jMenuItem3.setEnabled(false);
                jMenuItem7.setEnabled(false);
                jMenuItem10.setEnabled(false);
                jMenuItem2.setEnabled(false);
                jMenuItem8.setEnabled(false);
                jMenuItem11.setEnabled(false);
                jMenuItem9.setEnabled(false);
                jMenuItem12.setEnabled(false);
            }
        }
        this.content.updateScene();
    }

    private void onHideSelection() {
        this.content.setSelectionBox(!this.content.isSelectionBox());
        this.content.updateScene();
    }

    private void onShowSphere() {
        this.content.setShowSpheres(!this.content.isShowSpheres());
        this.content.updateScene();
        if (this.geneOrExpt == 1 || this.geneOrExpt == 2) {
            JMenuItem jMenuItem = this.getJMenuItem(SHOW_SPHERES_CMD);
            JMenuItem jMenuItem2 = this.getJMenuItem(SHOW_TEXT_CMD);
            if (jMenuItem.isSelected()) {
                this.content.setShowSpheres(true);
                this.content.setShowText(jMenuItem2.isSelected());
                jMenuItem2.setEnabled(true);
            } else {
                this.content.setShowSpheres(false);
                this.content.setShowText(jMenuItem2.isSelected());
                jMenuItem2.setEnabled(true);
            }
        } else {
            JMenuItem jMenuItem = this.getJMenuItem(SHOW_SPHERES_CMD);
            JMenuItem jMenuItem3 = this.getJMenuItem(SHOW_GENE_TEXT_FROM_BOTH_CMD);
            JMenuItem jMenuItem4 = this.getJMenuItem(SHOW_EXPT_TEXT_FROM_BOTH_CMD);
            if (jMenuItem.isSelected()) {
                this.content.setShowSpheres(true);
                this.content.setShowGeneTextFromBoth(jMenuItem3.isSelected());
                jMenuItem3.setEnabled(true);
                this.content.setShowExptTextFromBoth(jMenuItem4.isSelected());
                jMenuItem4.setEnabled(true);
            } else {
                this.content.setShowSpheres(false);
                this.content.setShowGeneTextFromBoth(jMenuItem3.isSelected());
                jMenuItem3.setEnabled(true);
                this.content.setShowExptTextFromBoth(jMenuItem4.isSelected());
                jMenuItem4.setEnabled(true);
            }
        }
        this.content.updateScene();
    }

    private void onShowText() {
        this.content.setShowText(!this.content.isShowText());
        this.content.updateScene();
    }

    private void onShowGeneTextFromBoth() {
        this.content.setShowGeneTextFromBoth(!this.content.isShowGeneTextFromBoth());
        this.content.updateScene();
    }

    private void onShowExptTextFromBoth() {
        this.content.setShowExptTextFromBoth(!this.content.isShowExptTextFromBoth());
        this.content.updateScene();
    }

    private void onWhiteBackground() {
        this.content.setWhiteBackround(!this.content.isWhiteBackground());
        this.content.updateScene();
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(COA3DViewer.RESET_CMD)) {
                COA3DViewer.this.onReset();
            } else if (string.equals(COA3DViewer.OPTIONS_CMD)) {
                COA3DViewer.this.onOptions();
            } else if (string.equals(COA3DViewer.SELECTION_AREA_CMD)) {
                COA3DViewer.this.onSelectionArea();
            } else if (string.equals(COA3DViewer.SAVE_GENE_CLUSTER_CMD)) {
                COA3DViewer.this.onSaveGenesFromBoth();
            } else if (string.equals(COA3DViewer.SAVE_EXPT_CLUSTER_CMD)) {
                COA3DViewer.this.onSaveExptsFromBoth();
            } else if (string.equals(COA3DViewer.SAVE_CMD)) {
                COA3DViewer.this.onSave();
            } else if (string.equals(COA3DViewer.SHOW_SELECTION_CMD)) {
                COA3DViewer.this.onShowSelection();
            } else if (string.equals(COA3DViewer.HIDE_SELECTION_BOX_CMD)) {
                COA3DViewer.this.onHideSelection();
            } else if (string.equals(COA3DViewer.SHOW_SPHERES_CMD)) {
                COA3DViewer.this.onShowSphere();
            } else if (string.equals(COA3DViewer.SHOW_TEXT_CMD)) {
                COA3DViewer.this.onShowText();
            } else if (string.equals(COA3DViewer.SHOW_GENE_TEXT_FROM_BOTH_CMD)) {
                COA3DViewer.this.onShowGeneTextFromBoth();
            } else if (string.equals(COA3DViewer.SHOW_EXPT_TEXT_FROM_BOTH_CMD)) {
                COA3DViewer.this.onShowExptTextFromBoth();
            } else if (string.equals(COA3DViewer.WHITE_CMD)) {
                COA3DViewer.this.onWhiteBackground();
            } else if (string.equals(COA3DViewer.STORE_CLUSTER_CMD)) {
                COA3DViewer.this.storeCluster();
            } else if (string.equals(COA3DViewer.STORE_GENE_CLUSTER_CMD)) {
                COA3DViewer.this.storeGeneClusterFromBoth();
            } else if (string.equals(COA3DViewer.STORE_EXPT_CLUSTER_CMD)) {
                COA3DViewer.this.storeExptClusterFromBoth();
            } else if (string.equals(COA3DViewer.LAUNCH_NEW_SESSION_CMD)) {
                COA3DViewer.this.launchNewSession();
            } else if (string.equals(COA3DViewer.LAUNCH_NEW_GENE_SESSION_CMD)) {
                COA3DViewer.this.launchNewGeneSessionFromBoth();
            } else if (string.equals(COA3DViewer.LAUNCH_NEW_EXPT_SESSION_CMD)) {
                COA3DViewer.this.launchNewExptSessionFromBoth();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger()) {
                return;
            }
            COA3DViewer.this.popup2.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

